package com.icetech.park.service.parkvip.impl;

import com.icetech.park.dao.parkvip.VipEquitiesMapper;
import com.icetech.cloudcenter.domain.parkvip.VipEquities;
import com.icetech.park.service.parkvip.VipEquitiesService;
import com.icetech.db.mybatis.base.service.impl.BaseServiceImpl;
import org.springframework.stereotype.Service;

import java.io.Serializable;

/**
 * 会员权益 服务实现类
 *
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wangzhiwei
 * @version 1.0 @date 2021-12-23
 */
@Service
public class VipEquitiesServiceImpl extends BaseServiceImpl<VipEquitiesMapper, VipEquities> implements VipEquitiesService {

    /**
     * Description: 根据ID查询 会员权益对象信息 <br>
     * Version1.0 2021-12-23 by wangzhiwei创建
     *
     * @param id 对象id
     * @return VipEquities
     */
    @Override
    public VipEquities getVipEquitiesById (Serializable id) {
        return getById(id);
    }

    /**
     * Description: 新增  会员权益对象信息 <br>
     * Version1.0 2021-12-23 by wangzhiwei创建
     *
     * @param entity 对象信息
     * @return Boolean 返回新增后主键
     */
    @Override
    public Boolean addVipEquities (VipEquities entity) {
        return save(entity);
    }

    /**
     * Description: 修改 会员权益对象信息 <br>
     * Version1.0 2021-12-23 by wangzhiwei创建
     *
     * @param entity 对象信息
     * @return Boolean 返回更新后的结果
     */
    @Override
    public Boolean modifyVipEquities (VipEquities entity) {
        return updateById(entity);
    }

    /**
     * Description: 删除  会员权益对象信息 <br>
     * Version1.0 2021-12-23 by wangzhiwei创建
     *
     * @param id 对象id
     * @return Boolean 返回更新后的结果
     */
    @Override
    public Boolean removeVipEquitiesById (Long id) {
        return removeById(id);
    }

}
