package com.icetech.park.service.parkvip.impl;

import com.icetech.park.dao.parkvip.VipEquitiesCountMapper;
import com.icetech.cloudcenter.domain.parkvip.VipEquitiesCount;
import com.icetech.park.service.parkvip.VipEquitiesCountService;
import com.icetech.db.mybatis.base.service.impl.BaseServiceImpl;
import org.springframework.stereotype.Service;

/**
 * 会员开通记录 服务实现类
 *
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wangzhiwei
 * @version 1.0 @date 2021-12-23
 */
@Service
public class VipEquitiesCountServiceImpl extends BaseServiceImpl<VipEquitiesCountMapper, VipEquitiesCount> implements VipEquitiesCountService {

    /**
     * Description: 根据ID查询 会员开通记录对象信息 <br>
     * Version1.0 2021-12-23 by wangzhiwei创建
     *
     * @param id 对象id
     * @return VipEquitiesCount
     */
    @Override
    public VipEquitiesCount getVipEquitiesCountById (Long id) {
        return getById(id);
    }

    /**
     * Description: 新增  会员开通记录对象信息 <br>
     * Version1.0 2021-12-23 by wangzhiwei创建
     *
     * @param entity 对象信息
     * @return Boolean 返回新增后主键
     */
    @Override
    public Boolean addVipEquitiesCount (VipEquitiesCount entity) {
        return save(entity);
    }

    /**
     * Description: 修改 会员开通记录对象信息 <br>
     * Version1.0 2021-12-23 by wangzhiwei创建
     *
     * @param entity 对象信息
     * @return Boolean 返回更新后的结果
     */
    @Override
    public Boolean modifyVipEquitiesCount (VipEquitiesCount entity) {
        return updateById(entity);
    }

    /**
     * Description: 删除  会员开通记录对象信息 <br>
     * Version1.0 2021-12-23 by wangzhiwei创建
     *
     * @param id 对象id
     * @return Boolean 返回更新后的结果
     */
    @Override
    public Boolean removeVipEquitiesCountById (Long id) {
        return removeById(id);
    }

}
