package com.icetech.park.service.parkvip.impl;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.icetech.park.dao.parkvip.ParkVipUserMapper;
import com.icetech.cloudcenter.domain.parkvip.ParkVipUser;
import com.icetech.park.service.parkvip.ParkVipUserService;
import com.icetech.common.constants.SqlConstant;
import com.icetech.db.mybatis.base.service.impl.BaseServiceImpl;
import org.springframework.stereotype.Service;

/**
 * 车场会员授权用户 服务实现类
 *
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wangzhiwei
 * @version 1.0 @date 2021-12-23
 */
@Service
public class ParkVipUserServiceImpl extends BaseServiceImpl<ParkVipUserMapper, ParkVipUser> implements ParkVipUserService {

    /**
     * Description: 根据ID查询 车场会员授权用户对象信息 <br>
     * Version1.0 2021-12-23 by wangzhiwei创建
     *
     * @param id 对象id
     * @return ParkVipUser
     */
    @Override
    public ParkVipUser getParkVipUserById (Long id) {
        return getById(id);
    }

    /**
     *
     * @param parkVipUser
     * @return
     */
    @Override
    public ParkVipUser getOneByEntity (ParkVipUser parkVipUser){
        return getOne(Wrappers.lambdaQuery(parkVipUser).last(SqlConstant.LIMIT_ONE));
    }

    /**
     * Description: 新增  车场会员授权用户对象信息 <br>
     * Version1.0 2021-12-23 by wangzhiwei创建
     *
     * @param entity 对象信息
     * @return Boolean 返回新增后主键
     */
    @Override
    public Boolean addParkVipUser (ParkVipUser entity) {
        return save(entity);
    }

    /**
     * Description: 修改 车场会员授权用户对象信息 <br>
     * Version1.0 2021-12-23 by wangzhiwei创建
     *
     * @param entity 对象信息
     * @return Boolean 返回更新后的结果
     */
    @Override
    public Boolean modifyParkVipUser (ParkVipUser entity) {
        return updateById(entity);
    }

    /**
     * Description: 删除  车场会员授权用户对象信息 <br>
     * Version1.0 2021-12-23 by wangzhiwei创建
     *
     * @param id 对象id
     * @return Boolean 返回更新后的结果
     */
    @Override
    public Boolean removeParkVipUserById (Long id) {
        return removeById(id);
    }

}
