package com.icetech.park.service.parkvip.impl;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.park.dao.parkvip.ParkVipMapper;
import com.icetech.park.domain.entity.park.Park;
import com.icetech.cloudcenter.domain.parkvip.ParkVip;
import com.icetech.park.service.parkvip.ParkVipService;
import com.icetech.common.constants.SqlConstant;
import com.icetech.db.mybatis.base.service.impl.BaseServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.io.Serializable;

/**
 * 车场会员 服务实现类
 *
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wangzhiwei
 * @version 1.0 @date 2021-12-23
 */
@Service
public class ParkVipServiceImpl extends BaseServiceImpl<ParkVipMapper, ParkVip> implements ParkVipService {

    @Autowired
    private ParkService parkService;
    /**
     * Description: 根据ID查询 车场会员对象信息 <br>
     * Version1.0 2021-12-23 by wangzhiwei创建
     *
     * @param id 对象id
     * @return ParkVip
     */
    @Override
    public ParkVip getParkVipById (Long id) {
        return getById(id);
    }

    @Override
    public ParkVip getParkVipByParkId(Serializable parkId) {
        return getOne(Wrappers.lambdaQuery(ParkVip.class).eq(ParkVip::getParkId, parkId).last(SqlConstant.LIMIT_ONE));
    }

    @Override
    public ParkVip getParkVipByParkCode(String parkCode) {
        Park park = parkService.findByParkCode(parkCode).getData();
        return getParkVipByParkId(park.getId());
    }

    /**
     * Description: 新增  车场会员对象信息 <br>
     * Version1.0 2021-12-23 by wangzhiwei创建
     *
     * @param entity 对象信息
     * @return Boolean 返回新增后主键
     */
    @Override
    public Boolean addParkVip (ParkVip entity) {
        return save(entity);
    }

    /**
     * Description: 修改 车场会员对象信息 <br>
     * Version1.0 2021-12-23 by wangzhiwei创建
     *
     * @param entity 对象信息
     * @return Boolean 返回更新后的结果
     */
    @Override
    public Boolean modifyParkVip (ParkVip entity) {
        return updateById(entity);
    }

    /**
     * Description: 删除  车场会员对象信息 <br>
     * Version1.0 2021-12-23 by wangzhiwei创建
     *
     * @param id 对象id
     * @return Boolean 返回更新后的结果
     */
    @Override
    public Boolean removeParkVipById (Long id) {
        return removeById(id);
    }

}
