package com.icetech.park.service.parkvip.impl;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.icetech.park.dao.parkvip.CallSipMapper;
import com.icetech.cloudcenter.domain.parkvip.CallSip;
import com.icetech.park.service.parkvip.CallSipService;
import com.icetech.third.utils.RedisUtils;
import com.icetech.common.constants.SqlConstant;
import com.icetech.common.utils.UUIDTools;
import com.icetech.db.mybatis.base.service.impl.BaseServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Objects;

/**
 * sip号 服务实现类
 *
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wangzhiwei
 * @version 1.0 @date 2022-01-14
 */
@Service
public class CallSipServiceImpl extends BaseServiceImpl<CallSipMapper, CallSip> implements CallSipService {
    private static final String LOCK_KEY = "LOCK:SIP:";

    @Autowired
    private RedisUtils redisUtils;

    /**
     * Description: 根据ID查询 sip号对象信息 <br>
     * Version1.0 2022-01-14 by wangzhiwei创建
     *
     * @param id 对象id
     * @return CallSip
     */
    @Override
    public CallSip getCallSipById (Long id) {
        return getById(id);
    }

    /**
     * Description: 新增  sip号对象信息 <br>
     * Version1.0 2022-01-14 by wangzhiwei创建
     *
     * @param entity 对象信息
     * @return Boolean 返回新增后主键
     */
    @Override
    public Boolean addCallSip (CallSip entity) {
        return save(entity);
    }

    /**
     * Description: 修改 sip号对象信息 <br>
     * Version1.0 2022-01-14 by wangzhiwei创建
     *
     * @param entity 对象信息
     * @return Boolean 返回更新后的结果
     */
    @Override
    public Boolean modifyCallSip (CallSip entity) {
        return updateById(entity);
    }

    /**
     * Description: 删除  sip号对象信息 <br>
     * Version1.0 2022-01-14 by wangzhiwei创建
     *
     * @param id 对象id
     * @return Boolean 返回更新后的结果
     */
    @Override
    public Boolean removeCallSipById (Long id) {
        return removeById(id);
    }


    @Override
    public String getSip() {
        String requestId = UUIDTools.getUuid();
        try {
            if (redisUtils.tryGetDistributedLock(LOCK_KEY,requestId)) {
                CallSip callSip = getOne(Wrappers.lambdaQuery(CallSip.class).eq(CallSip::getStatus, 1).orderByAsc(CallSip::getSip).last(SqlConstant.LIMIT_ONE));
                if (Objects.isNull(callSip)) {
                    log.warn("-------------[SIP池用尽]-------------");
                    return null;
                }
                //更新
                callSip.setStatus(0);
                updateById(callSip);
                return callSip.getSip();
            }
        }catch (Exception e){

        }finally {
            redisUtils.releaseDistributedLock(LOCK_KEY,requestId);
        }
        log.warn("-------------[热线号码池获取失败]-------------");
        return "";
    }

    @Override
    public void receiveSip(String sip) {
        CallSip callSip = getOne(Wrappers.lambdaQuery(CallSip.class).eq(CallSip::getSip, sip).last(SqlConstant.LIMIT_ONE));
        if (Objects.nonNull(callSip)){
           //更新sip
            callSip.setStatus(1);
            updateById(callSip);
        }
    }

}
