package com.icetech.park.service.parkvip.impl;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.google.common.collect.Lists;
import com.icetech.park.dao.parkvip.CallPhoneNumMapper;
import com.icetech.cloudcenter.domain.parkvip.CallPhoneNum;
import com.icetech.park.service.parkvip.CallPhoneNumService;
import com.icetech.third.utils.RedisUtils;
import com.icetech.common.constants.SqlConstant;
import com.icetech.common.utils.UUIDTools;
import com.icetech.db.mybatis.base.service.impl.BaseServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Objects;

/**
 * 热线号码表 服务实现类
 *
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wangzhiwei
 * @version 1.0 @date 2021-12-23
 */
@Service
public class CallPhoneNumServiceImpl extends BaseServiceImpl<CallPhoneNumMapper, CallPhoneNum> implements CallPhoneNumService {
    private static final String LOCK_KEY = "LOCK:CALL";

    @Autowired
    private RedisUtils redisUtils;
    /**
     * Description: 根据ID查询 热线号码表对象信息 <br>
     * Version1.0 2021-12-23 by wangzhiwei创建
     *
     * @param id 对象id
     * @return CallPhoneNum
     */
    @Override
    public CallPhoneNum getCallPhoneNumById (Long id) {
        return getById(id);
    }

    /**
     * Description: 新增  热线号码表对象信息 <br>
     * Version1.0 2021-12-23 by wangzhiwei创建
     *
     * @param entity 对象信息
     * @return Boolean 返回新增后主键
     */
    @Override
    public Boolean addCallPhoneNum (CallPhoneNum entity) {
        return save(entity);
    }

    /**
     * Description: 修改 热线号码表对象信息 <br>
     * Version1.0 2021-12-23 by wangzhiwei创建
     *
     * @param entity 对象信息
     * @return Boolean 返回更新后的结果
     */
    @Override
    public Boolean modifyCallPhoneNum (CallPhoneNum entity) {
        return updateById(entity);
    }

    /**
     * Description: 删除  热线号码表对象信息 <br>
     * Version1.0 2021-12-23 by wangzhiwei创建
     *
     * @param id 对象id
     * @return Boolean 返回更新后的结果
     */
    @Override
    public Boolean removeCallPhoneNumById (Long id) {
        return removeById(id);
    }

    @Override
    public String getPhoneNum() {
        String requestId = UUIDTools.getUuid();
        try {
            if (redisUtils.tryGetDistributedLock(LOCK_KEY,requestId)){
                CallPhoneNum phoneNum = getOne(Wrappers.lambdaQuery(CallPhoneNum.class).eq(CallPhoneNum::getStatus, 1).orderByAsc(CallPhoneNum::getPhoneNum).last(SqlConstant.LIMIT_ONE));
                if (Objects.isNull(phoneNum)){
                    log.warn("-------------[热线号码池用尽]-------------");
                    return "";
                }
                //更新
                phoneNum.setStatus(0);
                updateById(phoneNum);
                return phoneNum.getPhoneNum();
            }
            log.warn("-------------[热线号码池获取失败]-------------");
        }catch (Exception e){

        }finally {
            redisUtils.releaseDistributedLock(LOCK_KEY,requestId);
        }
        return "";
    }

    @Override
    public Boolean initPhoneNum() {
        DateTime date = DateUtil.date();
        List<CallPhoneNum> callPhoneNums = Lists.newArrayList();
        for (int i = 1021;i<2000;i++){
            CallPhoneNum callPhoneNum = new CallPhoneNum();
            callPhoneNum.setPhoneNum(i+"");
            callPhoneNum.setStatus(1);
            callPhoneNum.setCreateTime(date);
            callPhoneNums.add(callPhoneNum);
        }
        return saveBatch(callPhoneNums);
    }


}
