package com.icetech.park.service.parkvip;

import com.icetech.cloudcenter.domain.parkvip.Vip;
import com.icetech.db.mybatis.base.service.IBaseService;

/**
 * vip信息 服务类
 *
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wangzhiwei
 * @version 1.0 @date 2021-12-23
 */
public interface VipService extends IBaseService<Vip> {

    /**
     * Description: 根据ID查询 vip信息对象信息 <br>
     * Version1.0 2021-12-23 by wangzhiwei创建
     *
     * @param id 对象id
     * @return Vip
     */
    Vip getVipById (Long id);

    /**
     * Description: 新增  vip信息对象信息 <br>
     * Version1.0 2021-12-23 by wangzhiwei创建
     *
     * @param entity 对象信息
     * @return Boolean 返回新增后主键
     */
    Boolean addVip (Vip entity);

    /**
     * Description: 修改 vip信息对象信息 <br>
     * Version1.0 2021-12-23 by wangzhiwei创建
     *
     * @param entity 对象信息
     * @return Boolean 返回更新后的结果
     */
    Boolean modifyVip (Vip entity);

    /**
     * Description: 删除  vip信息对象信息 <br>
     * Version1.0 2021-12-23 by wangzhiwei创建
     *
     * @param id 对象id
     * @return Boolean 返回更新后的结果
     */
    Boolean removeVipById (Long id);
}
