package com.icetech.park.service.parkvip;

import com.icetech.cloudcenter.domain.parkvip.VipProductRule;
import com.icetech.db.mybatis.base.service.IBaseService;

/**
 * 会员套餐规则 服务类
 *
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wangzhiwei
 * @version 1.0 @date 2021-12-23
 */
public interface VipProductRuleService extends IBaseService<VipProductRule> {

    /**
     * Description: 根据ID查询 会员套餐规则对象信息 <br>
     * Version1.0 2021-12-23 by wangzhiwei创建
     *
     * @param id 对象id
     * @return VipProductRule
     */
    VipProductRule getVipProductRuleById (Long id);

    /**
     * Description: 新增  会员套餐规则对象信息 <br>
     * Version1.0 2021-12-23 by wangzhiwei创建
     *
     * @param entity 对象信息
     * @return Boolean 返回新增后主键
     */
    Boolean addVipProductRule (VipProductRule entity);

    /**
     * Description: 修改 会员套餐规则对象信息 <br>
     * Version1.0 2021-12-23 by wangzhiwei创建
     *
     * @param entity 对象信息
     * @return Boolean 返回更新后的结果
     */
    Boolean modifyVipProductRule (VipProductRule entity);

    /**
     * Description: 删除  会员套餐规则对象信息 <br>
     * Version1.0 2021-12-23 by wangzhiwei创建
     *
     * @param id 对象id
     * @return Boolean 返回更新后的结果
     */
    Boolean removeVipProductRuleById (Long id);
}
