package com.icetech.park.service.parkvip;

import com.icetech.cloudcenter.domain.parkvip.VipEquities;
import com.icetech.db.mybatis.base.service.IBaseService;

import java.io.Serializable;

/**
 * 会员权益 服务类
 *
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wangzhiwei
 * @version 1.0 @date 2021-12-23
 */
public interface VipEquitiesService extends IBaseService<VipEquities> {

    /**
     * Description: 根据ID查询 会员权益对象信息 <br>
     * Version1.0 2021-12-23 by wangzhiwei创建
     *
     * @param id 对象id
     * @return VipEquities
     */
    VipEquities getVipEquitiesById (Serializable id);

    /**
     * Description: 新增  会员权益对象信息 <br>
     * Version1.0 2021-12-23 by wangzhiwei创建
     *
     * @param entity 对象信息
     * @return Boolean 返回新增后主键
     */
    Boolean addVipEquities (VipEquities entity);

    /**
     * Description: 修改 会员权益对象信息 <br>
     * Version1.0 2021-12-23 by wangzhiwei创建
     *
     * @param entity 对象信息
     * @return Boolean 返回更新后的结果
     */
    Boolean modifyVipEquities (VipEquities entity);

    /**
     * Description: 删除  会员权益对象信息 <br>
     * Version1.0 2021-12-23 by wangzhiwei创建
     *
     * @param id 对象id
     * @return Boolean 返回更新后的结果
     */
    Boolean removeVipEquitiesById (Long id);
}
