package com.icetech.park.service.parkvip;

import com.icetech.cloudcenter.domain.parkvip.VipEquitiesCount;
import com.icetech.db.mybatis.base.service.IBaseService;

/**
 * 会员开通记录 服务类
 *
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wangzhiwei
 * @version 1.0 @date 2021-12-23
 */
public interface VipEquitiesCountService extends IBaseService<VipEquitiesCount> {

    /**
     * Description: 根据ID查询 会员开通记录对象信息 <br>
     * Version1.0 2021-12-23 by wangzhiwei创建
     *
     * @param id 对象id
     * @return VipEquitiesCount
     */
    VipEquitiesCount getVipEquitiesCountById (Long id);

    /**
     * Description: 新增  会员开通记录对象信息 <br>
     * Version1.0 2021-12-23 by wangzhiwei创建
     *
     * @param entity 对象信息
     * @return Boolean 返回新增后主键
     */
    Boolean addVipEquitiesCount (VipEquitiesCount entity);

    /**
     * Description: 修改 会员开通记录对象信息 <br>
     * Version1.0 2021-12-23 by wangzhiwei创建
     *
     * @param entity 对象信息
     * @return Boolean 返回更新后的结果
     */
    Boolean modifyVipEquitiesCount (VipEquitiesCount entity);

    /**
     * Description: 删除  会员开通记录对象信息 <br>
     * Version1.0 2021-12-23 by wangzhiwei创建
     *
     * @param id 对象id
     * @return Boolean 返回更新后的结果
     */
    Boolean removeVipEquitiesCountById (Long id);
}
