package com.icetech.park.service.parkvip;

import com.icetech.cloudcenter.domain.parkvip.VipBuyerRecord;
import com.icetech.db.mybatis.base.service.IBaseService;

/**
 * 会员开通记录 服务类
 *
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wangzhiwei
 * @version 1.0 @date 2021-12-23
 */
public interface VipBuyerRecordService extends IBaseService<VipBuyerRecord> {

    /**
     * Description: 根据ID查询 会员开通记录对象信息 <br>
     * Version1.0 2021-12-23 by wangzhiwei创建
     *
     * @param id 对象id
     * @return VipBuyerRecord
     */
    VipBuyerRecord getVipBuyerRecordById (Long id);

    /**
     * Description: 新增  会员开通记录对象信息 <br>
     * Version1.0 2021-12-23 by wangzhiwei创建
     *
     * @param entity 对象信息
     * @return Boolean 返回新增后主键
     */
    Boolean addVipBuyerRecord (VipBuyerRecord entity);

    /**
     * Description: 修改 会员开通记录对象信息 <br>
     * Version1.0 2021-12-23 by wangzhiwei创建
     *
     * @param entity 对象信息
     * @return Boolean 返回更新后的结果
     */
    Boolean modifyVipBuyerRecord (VipBuyerRecord entity);

    /**
     * Description: 删除  会员开通记录对象信息 <br>
     * Version1.0 2021-12-23 by wangzhiwei创建
     *
     * @param id 对象id
     * @return Boolean 返回更新后的结果
     */
    Boolean removeVipBuyerRecordById (Long id);

    /**
     * 根据交易流水号查询
     * @param tradeNo
     * @return
     */
    VipBuyerRecord getByTradeNo(String tradeNo);
}
