package com.icetech.park.service.parkvip;

import com.icetech.cloudcenter.domain.parkvip.ParkVip;
import com.icetech.cloudcenter.domain.parkvip.ParkVipUser;
import com.icetech.db.mybatis.base.service.IBaseService;

/**
 * 车场会员授权用户 服务类
 *
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wangzhiwei
 * @version 1.0 @date 2021-12-23
 */
public interface ParkVipUserService extends IBaseService<ParkVipUser> {

    /**
     * Description: 根据ID查询 车场会员授权用户对象信息 <br>
     * Version1.0 2021-12-23 by wangzhiwei创建
     *
     * @param id 对象id
     * @return ParkVipUser
     */
    ParkVipUser getParkVipUserById (Long id);

    /**
     *
     * @param parkVipUser
     * @return
     */
    ParkVipUser getOneByEntity (ParkVipUser parkVipUser);

    /**
     * Description: 新增  车场会员授权用户对象信息 <br>
     * Version1.0 2021-12-23 by wangzhiwei创建
     *
     * @param entity 对象信息
     * @return Boolean 返回新增后主键
     */
    Boolean addParkVipUser (ParkVipUser entity);

    /**
     * Description: 修改 车场会员授权用户对象信息 <br>
     * Version1.0 2021-12-23 by wangzhiwei创建
     *
     * @param entity 对象信息
     * @return Boolean 返回更新后的结果
     */
    Boolean modifyParkVipUser (ParkVipUser entity);

    /**
     * Description: 删除  车场会员授权用户对象信息 <br>
     * Version1.0 2021-12-23 by wangzhiwei创建
     *
     * @param id 对象id
     * @return Boolean 返回更新后的结果
     */
    Boolean removeParkVipUserById (Long id);
}
