package com.icetech.park.service.parkvip;

import com.icetech.cloudcenter.domain.parkvip.ParkVip;
import com.icetech.db.mybatis.base.service.IBaseService;

import java.io.Serializable;

/**
 * 车场会员 服务类
 *
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wangzhiwei
 * @version 1.0 @date 2021-12-23
 */
public interface ParkVipService extends IBaseService<ParkVip> {

    /**
     * Description: 根据ID查询 车场会员对象信息 <br>
     * Version1.0 2021-12-23 by wangzhiwei创建
     *
     * @param id 对象id
     * @return ParkVip
     */
    ParkVip getParkVipById (Long id);

    /**
     * 根据车场id查询
     * @param parkId
     * @return
     */
    ParkVip getParkVipByParkId (Serializable parkId);

    /**
     * 根据车场i编码查询
     * @param parkCode
     * @return
     */
    ParkVip getParkVipByParkCode (String parkCode);

    /**
     * Description: 新增  车场会员对象信息 <br>
     * Version1.0 2021-12-23 by wangzhiwei创建
     *
     * @param entity 对象信息
     * @return Boolean 返回新增后主键
     */
    Boolean addParkVip (ParkVip entity);

    /**
     * Description: 修改 车场会员对象信息 <br>
     * Version1.0 2021-12-23 by wangzhiwei创建
     *
     * @param entity 对象信息
     * @return Boolean 返回更新后的结果
     */
    Boolean modifyParkVip (ParkVip entity);

    /**
     * Description: 删除  车场会员对象信息 <br>
     * Version1.0 2021-12-23 by wangzhiwei创建
     *
     * @param id 对象id
     * @return Boolean 返回更新后的结果
     */
    Boolean removeParkVipById (Long id);
}
