package com.icetech.park.service.parkvip;

import com.icetech.cloudcenter.domain.parkvip.CallSip;
import com.icetech.db.mybatis.base.service.IBaseService;

/**
 * sip号 服务类
 *
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wangzhiwei
 * @version 1.0 @date 2022-01-14
 */
public interface CallSipService extends IBaseService<CallSip> {

    /**
     * Description: 根据ID查询 sip号对象信息 <br>
     * Version1.0 2022-01-14 by wangzhiwei创建
     *
     * @param id 对象id
     * @return CallSip
     */
    CallSip getCallSipById (Long id);

    /**
     * Description: 新增  sip号对象信息 <br>
     * Version1.0 2022-01-14 by wangzhiwei创建
     *
     * @param entity 对象信息
     * @return Boolean 返回新增后主键
     */
    Boolean addCallSip (CallSip entity);

    /**
     * Description: 修改 sip号对象信息 <br>
     * Version1.0 2022-01-14 by wangzhiwei创建
     *
     * @param entity 对象信息
     * @return Boolean 返回更新后的结果
     */
    Boolean modifyCallSip (CallSip entity);

    /**
     * Description: 删除  sip号对象信息 <br>
     * Version1.0 2022-01-14 by wangzhiwei创建
     *
     * @param id 对象id
     * @return Boolean 返回更新后的结果
     */
    Boolean removeCallSipById (Long id);

    /**
     * 获取可用的sip
     * @return
     */
    String getSip();

    /**
     * sip回收
     * @return
     */
    void receiveSip(String sip);
}
