package com.icetech.park.service.parkvip;

import com.icetech.cloudcenter.domain.parkvip.CallPhoneNum;
import com.icetech.db.mybatis.base.service.IBaseService;

/**
 * 热线号码表 服务类
 *
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wangzhiwei
 * @version 1.0 @date 2021-12-23
 */
public interface CallPhoneNumService extends IBaseService<CallPhoneNum> {

    /**
     * Description: 根据ID查询 热线号码表对象信息 <br>
     * Version1.0 2021-12-23 by wangzhiwei创建
     *
     * @param id 对象id
     * @return CallPhoneNum
     */
    CallPhoneNum getCallPhoneNumById (Long id);

    /**
     * Description: 新增  热线号码表对象信息 <br>
     * Version1.0 2021-12-23 by wangzhiwei创建
     *
     * @param entity 对象信息
     * @return Boolean 返回新增后主键
     */
    Boolean addCallPhoneNum (CallPhoneNum entity);

    /**
     * Description: 修改 热线号码表对象信息 <br>
     * Version1.0 2021-12-23 by wangzhiwei创建
     *
     * @param entity 对象信息
     * @return Boolean 返回更新后的结果
     */
    Boolean modifyCallPhoneNum (CallPhoneNum entity);

    /**
     * Description: 删除  热线号码表对象信息 <br>
     * Version1.0 2021-12-23 by wangzhiwei创建
     *
     * @param id 对象id
     * @return Boolean 返回更新后的结果
     */
    Boolean removeCallPhoneNumById (Long id);

    /**
     * 随机获取有效的热线电话,并失效
     * @return
     */
    String getPhoneNum();

    /**
     * 初始化数据
     * @return
     */
    Boolean initPhoneNum();
}
