package com.icetech.park.service.park.impl;

import cn.hutool.core.date.DateUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.util.StringUtil;
import com.google.common.collect.Lists;
import com.icetech.basics.dao.park.ParkConfigDao;
import com.icetech.basics.dao.park.ParkDao;
import com.icetech.basics.domain.entity.park.ParkConfig;
import com.icetech.basics.domain.request.ParkVisitBatchDeleteParam;
import com.icetech.cloudcenter.api.IBatchDownSendService;
import com.icetech.cloudcenter.api.discount.MerchantDiscountService;
import com.icetech.cloudcenter.api.discount.MerchantUserService;
import com.icetech.cloudcenter.api.order.OrderDiscountService;
import com.icetech.cloudcenter.api.order.OrderService;
import com.icetech.cloudcenter.api.park.ParkDeviceService;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.cloudcenter.api.park.ParkVisitService;
import com.icetech.cloudcenter.api.third.SendInfoService;
import com.icetech.cloudcenter.domain.constants.ParkVisitMoreType;
import com.icetech.cloudcenter.domain.constants.RedisConstants;
import com.icetech.cloudcenter.domain.enumeration.DownServiceEnum;
import com.icetech.cloudcenter.domain.enumeration.PncVersionEnum;
import com.icetech.cloudcenter.domain.response.MerchantDiscountDto;
import com.icetech.cloudcenter.domain.response.ParkVisitDto;
import com.icetech.common.constants.CodeConstants;
import com.icetech.common.constants.PlateTypeEnum;
import com.icetech.common.domain.SendRequest;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.utils.StringUtils;
import com.icetech.order.domain.entity.OrderDiscount;
import com.icetech.order.domain.entity.OrderInfo;
import com.icetech.park.dao.park.ParkVisitDao;
import com.icetech.park.domain.dto.VisitQueryDto;
import com.icetech.park.domain.entity.ParkVisituser;
import com.icetech.park.domain.entity.park.Park;
import com.icetech.park.domain.entity.park.ParkVisit;
import com.icetech.park.service.visit.ParkVisituserService;
import com.icetech.third.domain.entity.third.SendInfo;
import com.icetech.third.utils.RedisUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;

import static com.icetech.common.utils.CodeTools.GenerateDiscountNo;

@Slf4j
@Service("parkVisitService")
public class ParkVisitServiceImpl implements ParkVisitService {
    @Autowired
    private ParkService parkService;
    @Autowired
    private ParkVisitDao parkVisitDao;
    @Autowired
    private ParkConfigDao parkConfigDao;

    @Autowired
    private SendInfoService sendInfoService;

    @Autowired
    private IBatchDownSendService batchDownSendService;
    @Autowired
    private RedisUtils redisUtils;
    @Autowired
    private ParkDeviceService parkDeviceService;

    @Autowired
    private OrderService orderService;

    @Autowired
    private MerchantDiscountService merchantDiscountService;

    @Autowired
    private OrderDiscountService orderDiscountService;

    @Autowired
    private MerchantUserService merchantUserService;

    @Autowired
    private ParkVisituserService parkVisituserService;

    public static final Integer CHECK_STATUS = 2;

    @Override
    public ObjectResponse selectVisitByid(Long vId) {
        ParkVisit parkVisit = parkVisitDao.selectvisitById(vId);
        if (Objects.isNull(parkVisit)) {
            return ObjectResponse.failed(CodeConstants.ERROR_404, "访客车辆信息不存在");
        }
        ParkVisitDto parkVisitDto = new ParkVisitDto();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        parkVisitDto.setVisitNum(parkVisit.getVisitNum());
        parkVisitDto.setId(parkVisit.getId());
        Park park = parkService.findByParkId(Long.valueOf(parkVisit.getParkId())).getData();
        if (park != null) {
            parkVisitDto.setParkCode(park.getParkCode());
            parkVisitDto.setParkName(park.getParkName());
        }
        parkVisitDto.setPlateNums(parkVisit.getPlateNums());
        parkVisitDto.setVisitStatus(parkVisit.getVisitStatus());
        parkVisitDto.setVisitPhone(parkVisit.getVisitPhone());
        parkVisitDto.setVisitName(parkVisit.getVisitName());
        parkVisitDto.setMasterName(parkVisit.getMasterName());
        parkVisitDto.setMasterNum(parkVisit.getMasterNum());
        parkVisitDto.setReason(parkVisit.getReason());
        parkVisitDto.setCheckReason(parkVisit.getCheckReason());
        parkVisitDto.setCheckStatus(parkVisit.getCheckStatus());
        parkVisitDto.setStartTime(simpleDateFormat.format(parkVisit.getStartTime()));
        parkVisitDto.setEndTime(simpleDateFormat.format(parkVisit.getEndTime()));
        parkVisitDto.setInoutMore(parkVisit.getInoutMore());
        parkVisitDto.setInoutNum(parkVisit.getInoutNum());
        return ObjectResponse.success(parkVisitDto);
    }

    @Override
    public ObjectResponse<ParkVisit> checkVisitPlate(Long parkId, String plateNum) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        ParkVisit parkVisit = parkVisitDao.selectVisitByParkidPlate(parkId, plateNum, simpleDateFormat.format(new Date()));
        if(parkVisit != null){
            if(parkVisit.getInoutMore() == 0){
                if(StringUtil.isNotEmpty(parkVisit.getOrderNum())){//已经入场过
                    return ObjectResponse.failed(CodeConstants.ERROR_404);
                }
            }
            return ObjectResponse.success(parkVisit);
        }
        return ObjectResponse.failed(CodeConstants.ERROR_404);
    }

    @Override
    public ObjectResponse<List<ParkVisitDto>> getMpVisit(String parkCode, Integer userId,Integer pageNo, Integer pageSize) {
        PageHelper.startPage(pageNo, pageSize);
        List<ParkVisit> parkVisits = parkVisitDao.selectVisitRecords(userId);
        //封装返回数据
        List<ParkVisitDto> list = Lists.newArrayList();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        for (ParkVisit parkVisit : parkVisits){
            ParkVisitDto parkVisitDto = new ParkVisitDto();
            parkVisitDto.setVisitNum(parkVisit.getVisitNum());
            Park park = parkService.findByParkId(Long.valueOf(parkVisit.getParkId())).getData();
            if(park != null){
                parkVisitDto.setParkCode(park.getParkCode());
                parkVisitDto.setParkName(park.getParkName());
            }
            parkVisitDto.setCheckReason(parkVisit.getCheckReason());
            parkVisitDto.setPlateNums(parkVisit.getPlateNums());
            parkVisitDto.setStartTime(simpleDateFormat.format(parkVisit.getStartTime()));
            parkVisitDto.setEndTime(simpleDateFormat.format(parkVisit.getEndTime()));
            parkVisitDto.setVisitPhone(parkVisit.getVisitPhone());
            parkVisitDto.setVisitName(parkVisit.getVisitName());
            parkVisitDto.setMasterName(parkVisit.getMasterName());
            parkVisitDto.setMasterNum(parkVisit.getMasterNum());
            parkVisitDto.setMasterPhone(parkVisit.getMasterPhone());
            parkVisitDto.setReason(parkVisit.getReason());
            parkVisitDto.setVisitStatus(parkVisit.getVisitStatus());
            parkVisitDto.setCheckStatus(parkVisit.getCheckStatus());
            list.add(parkVisitDto);
        }
        return  ObjectResponse.success(list);
    }


    @Override
    public ObjectResponse<com.icetech.common.domain.Page<ParkVisitDto>> getMpVisitV2(Long accountId, VisitQueryDto visitVo) {
        Page<ParkVisit> parkVisitPage =  PageHelper.startPage(visitVo.getPageNo(), visitVo.getPageSize()).doSelectPage(()->{
            parkVisitDao.selectVisitRecordsV2(Math.toIntExact(accountId),visitVo.getCheckStatus(),visitVo.getVisitStatus(),visitVo.getFrom());
        });
        //封装返回数据
        List<ParkVisitDto> list = Lists.newArrayList();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        for (ParkVisit parkVisit : parkVisitPage.getResult()){
            ParkVisitDto parkVisitDto = new ParkVisitDto();
            parkVisitDto.setVisitNum(parkVisit.getVisitNum());
            Park park = parkService.findByParkId(Long.valueOf(parkVisit.getParkId())).getData();
            if(park != null){
                parkVisitDto.setParkCode(park.getParkCode());
                parkVisitDto.setParkName(park.getParkName());
            }
            parkVisitDto.setCheckReason(parkVisit.getCheckReason());
            parkVisitDto.setPlateNums(parkVisit.getPlateNums());
            parkVisitDto.setStartTime(simpleDateFormat.format(parkVisit.getStartTime()));
            parkVisitDto.setEndTime(simpleDateFormat.format(parkVisit.getEndTime()));
            parkVisitDto.setVisitPhone(parkVisit.getVisitPhone());
            parkVisitDto.setVisitName(parkVisit.getVisitName());
            parkVisitDto.setMasterName(parkVisit.getMasterName());
            parkVisitDto.setMasterNum(parkVisit.getMasterNum());
            parkVisitDto.setMasterPhone(parkVisit.getMasterPhone());
            parkVisitDto.setReason(parkVisit.getReason());
            parkVisitDto.setFrom(parkVisit.getFrom());
            parkVisitDto.setVisitStatus(parkVisit.getVisitStatus());
            parkVisitDto.setCheckStatus(parkVisit.getCheckStatus());
            parkVisitDto.setEnterTime(parkVisit.getEnterTime());
            parkVisitDto.setExitTime(parkVisit.getExitTime());
            parkVisitDto.setEditer(parkVisit.getEditer());

            list.add(parkVisitDto);
        }

        return ObjectResponse.success(com.icetech.common.domain.Page.instance(parkVisitPage.getPages(), parkVisitPage.getTotal(), list));
    }

    @Override
    public ObjectResponse countMpVisit(String parkCode, Integer userId) {
        int count = parkVisitDao.countVisitRecords(userId);
        Map<String, Object> map = new HashMap<>();
        map.put("count", count);
        return ObjectResponse.success(map);
    }

    @Override
    public ObjectResponse<ParkVisitDto> getMpVisitByVisitNum(String visitNum) {
        ParkVisit parkVisit = parkVisitDao.selectByVisitNum(visitNum);
        ParkVisitDto parkVisitDto = null;
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        if(parkVisit != null){
            parkVisitDto = new ParkVisitDto();
            parkVisitDto.setId(parkVisit.getId());
            parkVisitDto.setPlateNums(parkVisit.getPlateNums());
            parkVisitDto.setVisitNum(parkVisit.getVisitNum());
            parkVisitDto.setStartTime(simpleDateFormat.format(parkVisit.getStartTime()));
            parkVisitDto.setEndTime(simpleDateFormat.format(parkVisit.getEndTime()));
            parkVisitDto.setVisitName(parkVisit.getVisitName());
            parkVisitDto.setVisitPhone(parkVisit.getVisitPhone());
            parkVisitDto.setMasterName(parkVisit.getMasterName());
            parkVisitDto.setMasterPhone(parkVisit.getMasterPhone());
            parkVisitDto.setMasterNum(parkVisit.getMasterNum());
            parkVisitDto.setCheckReason(parkVisit.getCheckReason());
            parkVisitDto.setReason(parkVisit.getReason());
            Park park = parkService.findByParkId(Long.valueOf(parkVisit.getParkId())).getData();
            if(park != null){
                parkVisitDto.setParkCode(park.getParkCode());
                parkVisitDto.setParkName(park.getParkName());
            }
            parkVisitDto.setCheckStatus(parkVisit.getCheckStatus());
            parkVisitDto.setVisitStatus(parkVisit.getVisitStatus());
            parkVisitDto.setEnterTime(parkVisit.getEnterTime());
            parkVisitDto.setExitTime(parkVisit.getExitTime());
            parkVisitDto.setEditer(parkVisit.getEditer());
            parkVisitDto.setFrom(parkVisit.getFrom());
            parkVisitDto.setInoutMore(parkVisit.getInoutMore());
            parkVisitDto.setInoutNum(parkVisit.getInoutNum());
            parkVisitDto.setCreateTime(parkVisit.getCreateTime());
            parkVisitDto.setIsAuto(parkVisit.getIsAuto());
        }
        return ObjectResponse.success(parkVisitDto);
    }


    @Override
    @Transactional(rollbackFor = Exception.class)
    public ObjectResponse<Void> addGuoKongParkVisit(ParkVisit parkVisit) {
        parkVisit.setVisitNum(System.currentTimeMillis()/1000+""+(int)((Math.random()*9+1)*10000));
        parkVisit.setCreateTime(new Date());
        parkVisit.setCheckStatus(parkVisit.getIsAuto() == 2 ? 2 : 1);
        parkVisit.setVisitStatus(1);
        parkVisitDao.insert(parkVisit);
        // 下发访客
        if (CHECK_STATUS.equals(parkVisit.getCheckStatus())) {
            SendInfo sendInfo = new SendInfo();
            sendInfo.setParkId(Long.valueOf(parkVisit.getParkId()));
            sendInfo.setLevel(2);
            sendInfo.setServiceType(DownServiceEnum.车辆预约.getServiceType());
            sendInfo.setInclude("1");
            sendInfo.setServiceId(parkVisit.getId());
            sendInfo.setSendNum(0);
            sendInfo.setNextFireTime(0);
            sendInfoService.insert(sendInfo);
        }
        //在场车辆设置为访客车辆
        ObjectResponse<OrderInfo> inPark = orderService.findInParkId(parkVisit.getPlateNums(), parkVisit.getParkId().longValue());
        if (ObjectResponse.isSuccess(inPark)){
            OrderInfo orderInfo = inPark.getData();
            orderInfo.setType(PlateTypeEnum.访客车辆.getType());
            orderService.updateOrderInfo(orderInfo);
            parkVisit.setVisitStatus(2);
            if (ParkVisitMoreType.ONE.getType().equals(parkVisit.getInoutMore())) {
                parkVisit.setInoutNum(0);
            }
            if (parkVisit.getIsDiscount() != null && parkVisit.getIsDiscount() ==1) {
                // 通过商家优惠id获取优惠信息
                ObjectResponse<MerchantDiscountDto> discountObj = merchantDiscountService.findMerchantDiscountById(Long.valueOf(parkVisit.getMerchantDisId()));
                if (ObjectResponse.isSuccess(discountObj)) {
                    MerchantDiscountDto merchantDiscountDto = discountObj.getData();
                    BigDecimal deductMoney = merchantDiscountDto.getDeductMoney() == null ? BigDecimal.ZERO :  merchantDiscountDto.getDeductMoney();
                    OrderDiscount addOrderDis = new OrderDiscount();
                    addOrderDis.setMerchantDisId(Long.valueOf(merchantDiscountDto.getId()));
                    addOrderDis.setDiscountNo(GenerateDiscountNo());
                    addOrderDis.setParkId(Long.valueOf(parkVisit.getParkId()));
                    addOrderDis.setType(merchantDiscountDto.getType());
                    addOrderDis.setMerchantId(Long.valueOf(merchantDiscountDto.getMerchantId()));
                    addOrderDis.setAmount(merchantDiscountDto.getAmount());
                    addOrderDis.setFrom(1);
                    addOrderDis.setOrderNum(orderInfo.getOrderNum());
                    addOrderDis.setPlateNum(orderInfo.getPlateNum());
                    addOrderDis.setDiscountName(merchantDiscountDto.getName());
                    addOrderDis.setDeductMoney(merchantDiscountDto.getDeductMoney().doubleValue());
                    addOrderDis.setSendTime(new Date());
                    addOrderDis.setStatus(0);
                    addOrderDis.setUseTime(new Date());
                    // 添加优惠
                    ObjectResponse<Long> addDiscount = orderDiscountService.addDiscount(addOrderDis);
                    if (ObjectResponse.isSuccess(addDiscount)) {
                        parkVisit.setSendFlag(1);
                        log.info("[访客车优惠]添加成功,返回的id:{}", addDiscount.getData());
                    }
                    // 扣减余额
                    merchantUserService.subMerchantMoney(merchantDiscountDto.getMerchantId(), deductMoney);
                }
            }
            parkVisit.setOrderNum(orderInfo.getOrderNum());
            parkVisit.setEnterTime(Math.toIntExact(orderInfo.getEnterTime()));
            parkVisitDao.updateVisit(parkVisit);
        }
        return ObjectResponse.success();
    }

    @Override
    public ObjectResponse<ParkVisit> getGuoKongParkVisitByParkIdAndPlateNum(Integer parkId, String plateNum) {
        ParkVisit visit = parkVisitDao.selectVisitByParkIdAndPlate(parkId, plateNum);
        return ObjectResponse.success(visit);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public ObjectResponse<Void> deleteVisit(Long id, String loginName) {
        ParkVisit parkVisit = parkVisitDao.selectvisitById(id);
        if (parkVisit == null) {
            return ObjectResponse.failed("1000", "访客信息不存在");
        }
        if (parkVisit.getDeleteFlag()) {
            return ObjectResponse.success();
        }
        parkVisit.setDeleteFlag(Boolean.TRUE);
        parkVisitDao.updateVisit(parkVisit);
        SendInfo sendInfo = new SendInfo(parkVisit.getParkId().longValue(), parkVisit.getId(),
                DownServiceEnum.车辆预约.getServiceType());
        sendInfoService.insert(sendInfo);
        // 异步发送相机
        SendRequest sendRequest = new SendRequest();
        sendRequest.setServiceId(sendInfo.getServiceId());
        sendRequest.setParkId(sendInfo.getParkId());
        sendRequest.setTaskId(sendInfo.getId());
        sendRequest.setServiceType(sendInfo.getServiceType());
        batchDownSendService.execute(Collections.singletonList(sendRequest));
        if (StringUtils.isNotBlank(parkVisit.getOrderNum())) {
            ObjectResponse<OrderInfo> orderInfoObj = orderService.findByOrderNum(parkVisit.getOrderNum());
            if (ObjectResponse.isSuccess(orderInfoObj)) {
                OrderInfo orderInfo = orderInfoObj.getData();
                orderInfo.setType(1);
                if (orderInfo.getServiceStatus() == 1) {
                    // 取消优惠
                    ObjectResponse<OrderDiscount> orderDiscountObj = orderDiscountService.findOneByPlateNum(Long.valueOf(parkVisit.getParkId()), parkVisit.getVisitNum());
                    if (ObjectResponse.isSuccess(orderDiscountObj)) {
                        OrderDiscount orderDiscount = orderDiscountObj.getData();
                        orderDiscountService.cancelDiscount(orderDiscount.getId(), orderDiscount.getParkId());
                    }
                }
                orderService.updateOrderInfo(orderInfo);
            }
        }
        return ObjectResponse.success();
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public ObjectResponse<Void> addMpVisit(ParkVisit parkVisit) {
        //获取车场配置
        ParkConfig parkConfig = parkConfigDao.selectByParkId(parkVisit.getParkId());
        if (parkConfig.getIsAuto() == null) {
            parkConfig.setIsAuto(CHECK_STATUS);
        }
        if(StringUtils.isEmpty(parkVisit.getVisitNum())){
            parkVisit.setVisitNum(System.currentTimeMillis()/1000+""+(int)((Math.random()*9+1)*10000));
            parkVisit.setCheckStatus(parkConfig.getIsAuto() == 2 ? 2 : 1);
            parkVisit.setFrom(2);
            parkVisit.setInoutMore(2);
            parkVisit.setIsAuto(1);
            parkVisit.setVisitStatus(1);
            //todo 当前端云默认为多次
            if (parkConfig.getDataCollection() == 2){
                //端网云根据配置读取
                parkVisit.setInoutMore(ParkVisitMoreType.CUSTOM.getType());
                parkVisit.setInoutNum(parkConfig.getVisitInoutNum()==null?Integer.valueOf(1):parkConfig.getVisitInoutNum());
            }else {
                parkVisit.setInoutMore(ParkVisitMoreType.MANY.getType());
            }
            parkVisit.setCreateTime(new Date());
            parkVisitDao.insert(parkVisit);
            log.info("公众号预约成功插入的id{}",parkVisit.getId());
            if (CHECK_STATUS.equals(parkVisit.getCheckStatus())) {
                SendInfo sendInfo = new SendInfo();
                sendInfo.setParkId(parkConfig.getParkId());
                sendInfo.setLevel(2);
                sendInfo.setServiceType(DownServiceEnum.车辆预约.getServiceType());
                sendInfo.setInclude("1");
                sendInfo.setServiceId(parkVisit.getId());
                sendInfo.setSendNum(0);
                sendInfo.setNextFireTime(0);
                sendInfoService.insert(sendInfo);
            }
        }else {
            ParkVisit parkVisitOld = parkVisitDao.selectByVisitNum(parkVisit.getVisitNum());
            parkVisitOld.setStartTime(parkVisit.getStartTime());
            parkVisitOld.setEndTime(parkVisit.getEndTime());
            parkVisitOld.setVisitName(parkVisit.getVisitName());
            parkVisitOld.setVisitPhone(parkVisit.getVisitPhone());
            parkVisitOld.setMasterPhone(parkVisit.getMasterPhone());
            parkVisitOld.setMasterName(parkVisit.getMasterName());
            parkVisitOld.setMasterNum(parkVisit.getMasterNum());
            parkVisitOld.setReason(parkVisit.getReason());
            parkVisitDao.updateVisit(parkVisitOld);
        }

        //在场车辆设置为访客车辆
        ObjectResponse<OrderInfo> inPark = orderService.findInParkId(parkVisit.getPlateNums(), parkVisit.getParkId().longValue());
        if (ObjectResponse.isSuccess(inPark)){
            OrderInfo orderInfo = inPark.getData();
            orderInfo.setType(PlateTypeEnum.访客车辆.getType());
            orderService.updateOrderInfo(orderInfo);
            parkVisit.setVisitStatus(2);
            if (ParkVisitMoreType.ONE.getType().equals(parkVisit.getInoutMore())) {
                parkVisit.setInoutNum(0);
            }
            parkVisit.setOrderNum(orderInfo.getOrderNum());
            parkVisit.setEnterTime(Math.toIntExact(orderInfo.getEnterTime()));
            parkVisitDao.updateVisit(parkVisit);
        }
        return ObjectResponse.success();
    }

    @Override
    public ObjectResponse addMpVisitByOhter(ParkVisit parkVisit) {
        if (!ObjectUtils.isEmpty(parkVisit)) {
            parkVisit.setCreateTime(new Date());
            parkVisitDao.insert(parkVisit);
        }
        return ObjectResponse.success();
    }

    @Override
    public ObjectResponse updateMpVisitByOhter(ParkVisit parkVisit) {
        if (!ObjectUtils.isEmpty(parkVisit)) {
            parkVisit.setUpdateTime(new Date());
            parkVisitDao.updateVisit(parkVisit);
        }
        return ObjectResponse.success();
    }

    @Override
    public ObjectResponse<List<String>> findVisitNumOtherByDate(Long parkId, Integer from, String startTime,Integer checkStatus) {
        List<String> stringList = parkVisitDao.selectVisitOtherByDate(parkId,from,startTime,checkStatus);
        return ObjectResponse.success(stringList);
    }

    @Override
    public ObjectResponse<Void> deleteVisitBatch(List<Long> parkIds, ParkVisitBatchDeleteParam parkVisitBatchDeleteParam) {
        if (Objects.isNull(parkVisitBatchDeleteParam) || CollectionUtils.isEmpty(parkVisitBatchDeleteParam.getVisitIds())) {
            return ObjectResponse.failed(CodeConstants.ERROR_404);
        }
        // 校验车场相机是否都在线
        ObjectResponse<ParkConfig> parkConfigResp = parkService.getParkConfig(parkVisitBatchDeleteParam.getParkCode());
        ParkConfig parkConfig = parkConfigResp.getData();
        if (parkConfig.getDataCollection() == 2) {
            String version = redisUtils.hGet(RedisConstants.PNC_VERSION, String.valueOf(parkConfig.getParkId()), String.class);
            if (version != null && PncVersionEnum.getIndex(version) < PncVersionEnum.版本6.getIndex()) {
                return ObjectResponse.failed(CodeConstants.ERROR, "计费系统版本不支持");
            }
        }
        ObjectResponse<Boolean> allOnline = parkDeviceService.isAllOnline(parkConfig.getParkId(), 1, parkConfig.getDataCollection());
        if (!ObjectResponse.isSuccess(allOnline) || !allOnline.getData()) {
            return ObjectResponse.failed(CodeConstants.ERROR, "相机不在线");
        }
        List<ParkVisit> lists = parkVisitDao.findAllByIds(parkVisitBatchDeleteParam.getVisitIds(), Boolean.FALSE);
        if (CollectionUtils.isEmpty(lists)) {
            return ObjectResponse.failed(CodeConstants.ERROR_404);
        }
        List<Long> visitIds =
                lists.stream().filter(t -> parkIds.contains(-1L) || parkIds.contains(t.getParkId().longValue())).filter(t -> (parkVisitBatchDeleteParam.getIsOnsiteCar() != 0 || t.getVisitStatus() != 2)).map(ParkVisit::getId).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(visitIds)) {
            return ObjectResponse.failed(CodeConstants.ERROR_404);
        }
        // 批量更新访客数据
        LambdaUpdateWrapper<ParkVisit> wrapper = Wrappers.lambdaUpdate(ParkVisit.class).eq(ParkVisit::getDeleteFlag, Boolean.FALSE).in(ParkVisit::getId, visitIds);
        ParkVisit update = new ParkVisit();
        update.setDeleteFlag(Boolean.TRUE);
        parkVisitDao.update(update, wrapper);
        // 批量增加 sendInfo 数据
        List<SendInfo> sendInfoList = lists.stream().filter(t -> visitIds.contains(t.getId())).map(t -> new SendInfo(t.getParkId().longValue(), t.getId(),
                DownServiceEnum.车辆预约.getServiceType())).collect(Collectors.toList());
        sendInfoService.batchInsert(sendInfoList);

        //更新在场 车辆
        List<String> orderNums =
                lists.stream().filter(t ->  t.getVisitStatus() == 2).filter(t-> visitIds.contains(t.getId())).map(ParkVisit::getOrderNum).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(orderNums)) {
            orderService.updateOrderType(orderNums, 1);
        }
        // 异步发送相机
        List<SendRequest> sendRequestList = sendInfoList.stream().map(t -> {
            SendRequest sendRequest = new SendRequest();
            sendRequest.setServiceId(t.getServiceId());
            sendRequest.setParkId(t.getParkId());
            sendRequest.setTaskId(t.getId());
            sendRequest.setServiceType(t.getServiceType());
            return sendRequest;
        }).collect(Collectors.toList());
        batchDownSendService.execute(sendRequestList);
        return ObjectResponse.success();
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public ObjectResponse addMpVisits(List<ParkVisit> parkVisits, Integer userId) {
        // 获取访客次数,并校验次数是否够用
        ParkVisituser parkVisitUser = parkVisituserService.getParkVisituserByUserId(userId);
        if (parkVisitUser == null) {
            return ObjectResponse.failed("1000", "未获取到访客次数");
        }
        if (parkVisitUser.getNowNums() <= 0) {
            return ObjectResponse.failed("1000", "访客次数不够请联系管理员");
        }
        ParkVisit visit = parkVisits.get(0);
        long days = DateUtil.betweenDay(visit.getStartTime(), visit.getEndTime(), Boolean.TRUE);
        if (days > parkVisitUser.getMonthMaxDay()) {
            return ObjectResponse.failed("1000", "预约时间最大可以选择" + parkVisitUser.getMonthMaxDay() + "天");
        }
        List<SendInfo> sendInfos = new ArrayList<>(parkVisits.size());

        // 添加访客记录
        for (ParkVisit parkVisit : parkVisits) {
            //在场车辆设置为访客车辆
            ObjectResponse<OrderInfo> inPark = orderService.findInParkId(parkVisit.getPlateNums(), Long.valueOf(parkVisit.getParkId()));
            if (ObjectResponse.isSuccess(inPark)){
                OrderInfo orderInfo = inPark.getData();
                orderInfo.setType(PlateTypeEnum.访客车辆.getType());
                orderService.updateOrderInfo(orderInfo);
                parkVisit.setVisitStatus(2);
                if (ParkVisitMoreType.ONE.getType().equals(parkVisit.getInoutMore())) {
                    parkVisit.setInoutNum(0);
                }
                parkVisit.setOrderNum(orderInfo.getOrderNum());
                parkVisit.setEnterTime(Math.toIntExact(orderInfo.getEnterTime()));
                parkVisitDao.updateVisit(parkVisit);
            }

            parkVisitDao.insert(parkVisit);
            SendInfo sendInfo = new SendInfo();
            sendInfo.setParkId(Long.valueOf(parkVisit.getParkId()));
            sendInfo.setLevel(2);
            sendInfo.setServiceType(DownServiceEnum.车辆预约.getServiceType());
            sendInfo.setInclude("1");
            sendInfo.setServiceId(parkVisit.getId());
            sendInfo.setSendNum(0);
            sendInfo.setNextFireTime(0);
            sendInfos.add(sendInfo);
        }
        // 下发数据
        sendInfoService.batchInsert(sendInfos);
        // 访客次数减1;已发送次数+1
        parkVisitUser.setNowNums(parkVisitUser.getNowNums() - 1);
        parkVisitUser.setSendNums(parkVisitUser.getSendNums() + 1);
        parkVisituserService.updateById(parkVisitUser);
        return ObjectResponse.success();
    }

    @Override
    public com.icetech.common.domain.Page<ParkVisit> haiDaPage(List<Integer> parkIds, String plateNum, Integer pageNo, Integer pageSize, List<Integer> visitStatus, String startTime, String endTime) {
        IPage<ParkVisit> page = new com.baomidou.mybatisplus.extension.plugins.pagination.Page<>();
        page.setCurrent(pageNo);
        page.setSize(pageSize);
        LambdaQueryWrapper<ParkVisit> queryWrapper = Wrappers.lambdaQuery(ParkVisit.class);
        queryWrapper.eq(ParkVisit::getFrom, 7);
        queryWrapper.in(ParkVisit::getParkId, parkIds);
        queryWrapper.orderByDesc(ParkVisit::getId);
        if (org.apache.commons.collections4.CollectionUtils.isNotEmpty(visitStatus)) {
            queryWrapper.in(ParkVisit::getVisitStatus, visitStatus);
        }
        if (org.apache.commons.lang3.StringUtils.isNotEmpty(startTime)) {
            queryWrapper.ge(ParkVisit::getStartTime, startTime);
        }
        if (org.apache.commons.lang3.StringUtils.isNotEmpty(endTime)) {
            queryWrapper.le(ParkVisit::getEndTime, endTime);
        }
        if (org.apache.commons.lang3.StringUtils.isNotEmpty(plateNum)) {
            queryWrapper.eq(ParkVisit::getPlateNums, plateNum);
        }
        IPage<ParkVisit> parkVisitPage = parkVisitDao.selectPage(page, queryWrapper);
        return com.icetech.common.domain.Page.instance(Math.toIntExact(parkVisitPage.getPages()), parkVisitPage.getTotal(), parkVisitPage.getRecords());
    }

    @Override
    public com.icetech.common.domain.Page<ParkVisit> guoKongPage(Integer mpUserId, String plateNum, Integer pageNo, Integer pageSize, List<Integer> visitStatus, String startTime, String endTime) {
        IPage<ParkVisit> page = new com.baomidou.mybatisplus.extension.plugins.pagination.Page<>();
        page.setCurrent(pageNo);
        page.setSize(pageSize);
        LambdaQueryWrapper<ParkVisit> queryWrapper = Wrappers.lambdaQuery(ParkVisit.class);
        queryWrapper.eq(ParkVisit::getFrom, 8);
        queryWrapper.eq(ParkVisit::getDeleteFlag, Boolean.FALSE);
        queryWrapper.eq(ParkVisit::getMpUserId, mpUserId);
        queryWrapper.orderByDesc(ParkVisit::getId);
        if (org.apache.commons.collections4.CollectionUtils.isNotEmpty(visitStatus)) {
            queryWrapper.in(ParkVisit::getVisitStatus, visitStatus);
        }
        if (org.apache.commons.lang3.StringUtils.isNotEmpty(startTime)) {
            queryWrapper.ge(ParkVisit::getStartTime, startTime);
        }
        if (org.apache.commons.lang3.StringUtils.isNotEmpty(endTime)) {
            queryWrapper.le(ParkVisit::getEndTime, endTime);
        }
        if (org.apache.commons.lang3.StringUtils.isNotEmpty(plateNum)) {
            queryWrapper.eq(ParkVisit::getPlateNums, plateNum);
        }
        IPage<ParkVisit> parkVisitPage = parkVisitDao.selectPage(page, queryWrapper);
        return com.icetech.common.domain.Page.instance(Math.toIntExact(parkVisitPage.getPages()), parkVisitPage.getTotal(), parkVisitPage.getRecords());
    }

    @Override
    public Integer getTotalNum(List<Integer> parkIds) {
        return parkVisitDao.haiDaCount(parkIds);
    }

    @Override
    public ObjectResponse<String> addShiJiaZhuangVisit(ParkVisit parkVisit) {
        String visitNum = "";
        //获取车场配置
        ParkConfig parkConfig = parkConfigDao.selectByParkId(parkVisit.getParkId());
        if (parkConfig.getIsAuto() == null) {
            parkConfig.setIsAuto(CHECK_STATUS);
        }
        if(StringUtils.isEmpty(parkVisit.getVisitNum())){
            parkVisit.setVisitNum(System.currentTimeMillis()/1000+""+(int)((Math.random()*9+1)*10000));
            visitNum = parkVisit.getVisitNum();
            parkVisit.setCheckStatus(parkConfig.getIsAuto() == 2 ? 2 : 1);
            parkVisit.setFrom(2);
            parkVisit.setInoutMore(2);
            parkVisit.setIsAuto(1);
            parkVisit.setVisitStatus(1);
            //todo 当前端云默认为多次
            if (parkConfig.getDataCollection() == 2){
                //端网云根据配置读取
                parkVisit.setInoutMore(ParkVisitMoreType.CUSTOM.getType());
                parkVisit.setInoutNum(parkConfig.getVisitInoutNum()==null?Integer.valueOf(1):parkConfig.getVisitInoutNum());
            }else {
                parkVisit.setInoutMore(ParkVisitMoreType.MANY.getType());
            }
            parkVisit.setCreateTime(new Date());
            parkVisitDao.insert(parkVisit);
            log.info("公众号预约成功插入的id{}",parkVisit.getId());
            if (CHECK_STATUS.equals(parkVisit.getCheckStatus())) {
                SendInfo sendInfo = new SendInfo();
                sendInfo.setParkId(parkConfig.getParkId());
                sendInfo.setLevel(2);
                sendInfo.setServiceType(DownServiceEnum.车辆预约.getServiceType());
                sendInfo.setInclude("1");
                sendInfo.setServiceId(parkVisit.getId());
                sendInfo.setSendNum(0);
                sendInfo.setNextFireTime(0);
                sendInfoService.insert(sendInfo);
            }
        }else {
            ParkVisit parkVisitOld = parkVisitDao.selectByVisitNum(parkVisit.getVisitNum());
            parkVisitOld.setStartTime(parkVisit.getStartTime());
            parkVisitOld.setEndTime(parkVisit.getEndTime());
            parkVisitOld.setVisitName(parkVisit.getVisitName());
            parkVisitOld.setVisitPhone(parkVisit.getVisitPhone());
            parkVisitOld.setMasterPhone(parkVisit.getMasterPhone());
            parkVisitOld.setMasterName(parkVisit.getMasterName());
            parkVisitOld.setMasterNum(parkVisit.getMasterNum());
            parkVisitOld.setReason(parkVisit.getReason());
            parkVisitDao.updateVisit(parkVisitOld);
        }

        //在场车辆设置为访客车辆
        ObjectResponse<OrderInfo> inPark = orderService.findInParkId(parkVisit.getPlateNums(), parkVisit.getParkId().longValue());
        if (ObjectResponse.isSuccess(inPark)){
            OrderInfo orderInfo = inPark.getData();
            orderInfo.setType(PlateTypeEnum.访客车辆.getType());
            orderService.updateOrderInfo(orderInfo);
            parkVisit.setVisitStatus(2);
            if (ParkVisitMoreType.ONE.getType().equals(parkVisit.getInoutMore())) {
                parkVisit.setInoutNum(0);
            }
            parkVisit.setOrderNum(orderInfo.getOrderNum());
            parkVisit.setEnterTime(Math.toIntExact(orderInfo.getEnterTime()));
            parkVisitDao.updateVisit(parkVisit);
        }
        return ObjectResponse.success(visitNum);
    }

    @Override
    public ObjectResponse<List<ParkVisit>> getParkVisitList(Long parkId, Date date) {
        List<ParkVisit> visits = parkVisitDao.selectParkVisitList(parkId, date);
        if (CollectionUtils.isEmpty(visits)) {
            return ObjectResponse.failed(CodeConstants.ERROR_404);
        }
        return ObjectResponse.success(visits);
    }
}
