package com.icetech.park.service.park.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.icetech.cloudcenter.domain.park.query.ParkTrusteeshipRecordParam;
import com.icetech.cloudcenter.domain.response.OrderPayResultVo;
import com.icetech.common.domain.Page;
import com.icetech.db.mybatis.base.service.impl.BaseServiceImpl;
import com.icetech.park.dao.ParkTrusteeshipRecordMapper;
import com.icetech.park.domain.entity.ParkTrusteeshipRecord;
import com.icetech.park.service.park.ParkTrusteeshipRecordService;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.List;
import java.util.Objects;

/**
 * 车场托管缴费记录 服务实现类
 *
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wgy
 * @version 1.0 @date 2023-06-28
 */
@Service
public class ParkTrusteeshipRecordServiceImpl extends BaseServiceImpl<ParkTrusteeshipRecordMapper, ParkTrusteeshipRecord> implements ParkTrusteeshipRecordService {

    /**
     * Description: 根据ID查询 车场托管缴费记录对象信息 <br>
     * Version1.0 2023-06-28 by wgy创建
     *
     * @param id 对象id
     * @return ParkTrusteeshipRecord
     */
    @Override
    public ParkTrusteeshipRecord getParkTrusteeshipRecordById (Long id) {
        return getById(id);
    }

    /**
     * Description: 新增  车场托管缴费记录对象信息 <br>
     * Version1.0 2023-06-28 by wgy创建
     *
     * @param entity 对象信息
     * @return Boolean 返回新增后主键
     */
    @Override
    public Boolean addParkTrusteeshipRecord (ParkTrusteeshipRecord entity) {
        return save(entity);
    }

    /**
     * Description: 修改 车场托管缴费记录对象信息 <br>
     * Version1.0 2023-06-28 by wgy创建
     *
     * @param entity 对象信息
     * @return Boolean 返回更新后的结果
     */
    @Override
    public Boolean modifyParkTrusteeshipRecord (ParkTrusteeshipRecord entity) {
        return updateById(entity);
    }

    /**
     * Description: 删除  车场托管缴费记录对象信息 <br>
     * Version1.0 2023-06-28 by wgy创建
     *
     * @param id 对象id
     * @return Boolean 返回更新后的结果
     */
    @Override
    public Boolean removeParkTrusteeshipRecordById (Long id) {
        return removeById(id);
    }

    @Override
    public Page<ParkTrusteeshipRecord> searchParkTrusteeshipRecord(ParkTrusteeshipRecordParam parkTrusteeshipRecordParam) {
        com.baomidou.mybatisplus.extension.plugins.pagination.Page<ParkTrusteeshipRecord> page = page(getWrapper(parkTrusteeshipRecordParam), parkTrusteeshipRecordParam.getPageNo(),
                parkTrusteeshipRecordParam.getPageSize());
        return Page.instance((int) page.getPages(), page.getTotal(), page.getRecords());
    }

    @Override
    public BigDecimal totalPayAmount(ParkTrusteeshipRecordParam parkTrusteeshipRecordParam) {
        LambdaQueryWrapper<ParkTrusteeshipRecord> wrapper = getWrapper(parkTrusteeshipRecordParam);
        wrapper.select(ParkTrusteeshipRecord::getPayAmount);
        List<ParkTrusteeshipRecord> recordList = list(wrapper);
        if (CollectionUtils.isNotEmpty(recordList)) {
            return recordList.stream().map(ParkTrusteeshipRecord::getPayAmount)
                    .reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        return BigDecimal.ZERO;
    }

    private LambdaQueryWrapper<ParkTrusteeshipRecord> getWrapper(ParkTrusteeshipRecordParam parkTrusteeshipRecordParam) {
        LambdaQueryWrapper<ParkTrusteeshipRecord> wrapper = Wrappers.lambdaQuery(ParkTrusteeshipRecord.class);
        wrapper.in(CollectionUtils.isNotEmpty(parkTrusteeshipRecordParam.getParkIds()), ParkTrusteeshipRecord::getParkId, parkTrusteeshipRecordParam.getParkIds());
        wrapper.in(CollectionUtils.isNotEmpty(parkTrusteeshipRecordParam.getInstitutionIds()), ParkTrusteeshipRecord::getInstitutionId,
                parkTrusteeshipRecordParam.getInstitutionIds());
        if (StringUtils.isNotEmpty(parkTrusteeshipRecordParam.getOperateStartTime()) && StringUtils.isNotEmpty(parkTrusteeshipRecordParam.getOperateEndTime())) {
            wrapper.ge(ParkTrusteeshipRecord::getCreateTime, parkTrusteeshipRecordParam.getOperateStartTime());
            wrapper.le(ParkTrusteeshipRecord::getCreateTime, parkTrusteeshipRecordParam.getOperateEndTime());
        }
        wrapper.in(CollectionUtils.isNotEmpty(parkTrusteeshipRecordParam.getTrusteeshipModels()), ParkTrusteeshipRecord::getTrusteeshipModel,
                parkTrusteeshipRecordParam.getTrusteeshipModels());
        wrapper.in(CollectionUtils.isNotEmpty(parkTrusteeshipRecordParam.getPayTypes()), ParkTrusteeshipRecord::getPayType,
                parkTrusteeshipRecordParam.getPayTypes());
        wrapper.orderByDesc(ParkTrusteeshipRecord::getId);
        return wrapper;
    }
}
