package com.icetech.park.service.park.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.stream.Collectors;

import com.icetech.basics.dao.park.ParkRegionDao;
import com.icetech.basics.domain.entity.park.ParkRegion;
import com.icetech.db.mybatis.base.service.impl.BaseServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Service;

@Slf4j
@Service("parkRegionService")
public class ParkRegionServiceImpl extends BaseServiceImpl<ParkRegionDao, ParkRegion> {
    public boolean updateStatusByIds(Collection<Long> regionId, int status) {
        if (CollectionUtils.isEmpty(regionId)) return false;
        Collection<ParkRegion> regions = regionId.stream().map(id -> new ParkRegion().setId(id).setStatus(status))
                .collect(Collectors.toCollection(() -> new ArrayList<>(regionId.size())));
        return updateBatchById(regions);
    }
}
