package com.icetech.park.service.park.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.icetech.common.domain.Page;
import com.icetech.db.mybatis.base.service.impl.BaseServiceImpl;
import com.icetech.park.dao.park.ParkRecoverySettleMapper;
import com.icetech.park.domain.entity.park.ParkRecoverySettle;
import com.icetech.park.domain.request.ParkRecoverySettleQuery;
import com.icetech.park.service.park.ParkRecoverySettleService;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.List;

/**
 * 车场欠费追缴月度结算 服务实现类
 *
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wgy
 * @version 1.0 @date 2023-07-20
 */
@Service
public class ParkRecoverySettleServiceImpl extends BaseServiceImpl<ParkRecoverySettleMapper, ParkRecoverySettle> implements ParkRecoverySettleService {

    /**
     * Description: 根据ID查询 车场欠费追缴月度结算对象信息 <br>
     * Version1.0 2023-07-20 by wgy创建
     *
     * @param id 对象id
     * @return ParkRecoverySettle
     */
    @Override
    public ParkRecoverySettle getParkRecoverySettleById (Long id) {
        return getById(id);
    }

    /**
     * Description: 新增  车场欠费追缴月度结算对象信息 <br>
     * Version1.0 2023-07-20 by wgy创建
     *
     * @param entity 对象信息
     * @return Boolean 返回新增后主键
     */
    @Override
    public Boolean addParkRecoverySettle (ParkRecoverySettle entity) {
        return save(entity);
    }

    /**
     * Description: 修改 车场欠费追缴月度结算对象信息 <br>
     * Version1.0 2023-07-20 by wgy创建
     *
     * @param entity 对象信息
     * @return Boolean 返回更新后的结果
     */
    @Override
    public Boolean modifyParkRecoverySettle (ParkRecoverySettle entity) {
        return updateById(entity);
    }

    /**
     * Description: 删除  车场欠费追缴月度结算对象信息 <br>
     * Version1.0 2023-07-20 by wgy创建
     *
     * @param id 对象id
     * @return Boolean 返回更新后的结果
     */
    @Override
    public Boolean removeParkRecoverySettleById (Long id) {
        return removeById(id);
    }

    @Override
    public Page<ParkRecoverySettle> getParkRecoverySettlePage(ParkRecoverySettleQuery parkRecoverySettleQuery, List<Long> parkIds) {
        com.baomidou.mybatisplus.extension.plugins.pagination.Page<ParkRecoverySettle> page = page(getWrapper(parkRecoverySettleQuery, parkIds),
                parkRecoverySettleQuery.getPageNo(), parkRecoverySettleQuery.getPageSize());
        return Page.instance((int) page.getPages(), page.getTotal(), page.getRecords());
    }

    @Override
    public ParkRecoverySettle totalMoney(ParkRecoverySettleQuery parkRecoverySettleQuery, List<Long> parkIds) {
        LambdaQueryWrapper<ParkRecoverySettle> wrapper = getWrapper(parkRecoverySettleQuery, parkIds);
        wrapper.select(ParkRecoverySettle::getRecoveryMoney, ParkRecoverySettle::getCommission);
        List<ParkRecoverySettle> recordList = list(wrapper);
        ParkRecoverySettle parkRecoverySettle = new ParkRecoverySettle();
        if (CollectionUtils.isNotEmpty(recordList)) {
            parkRecoverySettle.setRecoveryMoney(recordList.stream().map(ParkRecoverySettle::getRecoveryMoney)
                    .reduce(BigDecimal.ZERO, BigDecimal::add));
            parkRecoverySettle.setCommission(recordList.stream().map(ParkRecoverySettle::getCommission)
                    .reduce(BigDecimal.ZERO, BigDecimal::add));
        }
        return parkRecoverySettle;
    }

    @Override
    public ParkRecoverySettle getParkRecoverySettleByNo(String orderNum) {
        return getOne(Wrappers.lambdaQuery(ParkRecoverySettle.class).eq(ParkRecoverySettle::getOrderNum, orderNum));
    }

    @Override
    public ParkRecoverySettle getParkRecoverySettleByParKMonth(Long parkId, String settleMonth) {
        return getOne(Wrappers.lambdaQuery(ParkRecoverySettle.class).eq(ParkRecoverySettle::getParkId, parkId).eq(ParkRecoverySettle::getSettleMonth, settleMonth));
    }

    private LambdaQueryWrapper<ParkRecoverySettle> getWrapper(ParkRecoverySettleQuery parkRecoverySettleQuery, List<Long> parkIds) {
        LambdaQueryWrapper<ParkRecoverySettle> wrapper = Wrappers.lambdaQuery(ParkRecoverySettle.class);
        wrapper.in(CollectionUtils.isNotEmpty(parkRecoverySettleQuery.getParkId()), ParkRecoverySettle::getParkId, parkRecoverySettleQuery.getParkId());
        wrapper.in(CollectionUtils.isNotEmpty(parkRecoverySettleQuery.getInstitutionId()), ParkRecoverySettle::getInstitutionId, parkRecoverySettleQuery.getInstitutionId());
        wrapper.between(StringUtils.isNotBlank(parkRecoverySettleQuery.getStartMonth()) && StringUtils.isNotBlank(parkRecoverySettleQuery.getEndMonth()),
                ParkRecoverySettle::getSettleMonth, parkRecoverySettleQuery.getStartMonth(), parkRecoverySettleQuery.getEndMonth());
        wrapper.in(!parkIds.contains(-1L), ParkRecoverySettle::getParkId, parkIds);
        wrapper.orderByDesc(ParkRecoverySettle::getId);
        return wrapper;
    }
}
