package com.icetech.park.service.park.impl;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.icetech.basics.constants.CommonConsts;
import com.icetech.basics.domain.entity.park.ParkConfig;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.common.constants.CommonConstants;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.db.mybatis.base.service.impl.BaseServiceImpl;
import com.icetech.park.dao.park.ParkRecoveryMapper;
import com.icetech.park.domain.entity.park.Park;
import com.icetech.park.domain.entity.park.ParkRecovery;
import com.icetech.park.domain.vo.ParkRecoveryVo;
import com.icetech.park.service.park.ParkRecoveryService;
import lombok.RequiredArgsConstructor;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Service;

import java.util.*;
import java.util.stream.Collectors;

/**
 * 车场欠费追缴 服务实现类
 *
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wgy
 * @version 1.0 @date 2023-07-20
 */
@Service
@RequiredArgsConstructor
public class ParkRecoveryServiceImpl extends BaseServiceImpl<ParkRecoveryMapper, ParkRecovery> implements ParkRecoveryService {

    private final ParkService parkService;

    /**
     * Description: 根据ID查询 车场欠费追缴对象信息 <br>
     * Version1.0 2023-07-20 by wgy创建
     *
     * @param id 对象id
     * @return ParkRecovery
     */
    @Override
    public ParkRecovery getParkRecoveryById (Long id) {
        return getById(id);
    }

    /**
     * Description: 新增  车场欠费追缴对象信息 <br>
     * Version1.0 2023-07-20 by wgy创建
     *
     * @param entity 对象信息
     * @return Boolean 返回新增后主键
     */
    @Override
    public Boolean addParkRecovery (ParkRecovery entity) {
        return save(entity);
    }

    /**
     * Description: 修改 车场欠费追缴对象信息 <br>
     * Version1.0 2023-07-20 by wgy创建
     *
     * @param entity 对象信息
     * @return Boolean 返回更新后的结果
     */
    @Override
    public Boolean modifyParkRecovery (ParkRecovery entity) {
        return updateById(entity);
    }

    /**
     * Description: 删除  车场欠费追缴对象信息 <br>
     * Version1.0 2023-07-20 by wgy创建
     *
     * @param id 对象id
     * @return Boolean 返回更新后的结果
     */
    @Override
    public Boolean removeParkRecoveryById (Long id) {
        return removeById(id);
    }

    @Override
    public ParkRecoveryVo getParkRecoveryByParkId(Long parkId) {
//        return getOne(Wrappers.lambdaQuery(ParkRecovery.class).eq(ParkRecovery::getParkId, parkId));
        return buildVirtualRecovery(parkId);
    }

    @Override
    public List<ParkRecoveryVo> getParkRecoveryByParkIds(List<Long> parkIds) {
//        return list(Wrappers.lambdaQuery(ParkRecovery.class).in(CollectionUtils.isNotEmpty(parkIds) && !parkIds.contains(-1L),ParkRecovery::getParkId, parkIds));
        return buildVirtualRecoveryVo(parkIds);
    }

    @Override
    public List<ParkRecoveryVo> getOpenParkRecoveryByParkIds(List<Long> parkIds) {
//        String todayDate = DateTools.getFormat(DateTools.DF_, new Date());
//        return list(Wrappers.lambdaQuery(ParkRecovery.class)
//                .in(CollectionUtils.isNotEmpty(parkIds) && !parkIds.contains(-1L), ParkRecovery::getParkId, parkIds)
//                .le(ParkRecovery::getStartTime, todayDate)
//                .ge(ParkRecovery::getEndTime, todayDate));
        return buildVirtualRecoveryVo(parkIds);
    }


    @Override
    public List<ParkRecoveryVo> getBaseParkName(String name, Collection<Long> parkIds, Integer limit) {
//        ObjectResponse<List<BasePark>> baseParkName = parkService.getBaseParkName(name, parkIds, limit);
//        if (CollectionUtils.isEmpty(baseParkName.getData())) {
//            return Lists.newArrayList();
//        }
//        List<Long> queryParkIds = baseParkName.getData().stream().map(BasePark::getId).collect(Collectors.toList());
//        List<ParkRecovery> parkRecoveryByParkIds = getParkRecoveryByParkIds(queryParkIds);
//        Map<Long, ParkRecovery> parkRecoveryMap = new HashMap<>();
//        if (CollectionUtils.isNotEmpty(parkRecoveryByParkIds)) {
//            parkRecoveryMap = parkRecoveryByParkIds.stream().collect(Collectors.toMap(ParkRecovery::getParkId, Function.identity(), (a, b) -> a));
//        }
//        Map<Long, ParkRecovery> finalParkRecoveryMap = parkRecoveryMap;
//        return baseParkName.getData().stream().map(t-> {
//            ParkRecoveryVo parkRecoveryVo = new ParkRecoveryVo();
//            parkRecoveryVo.setParkName(t.getParkName());
//            parkRecoveryVo.setParkId(t.getId());
//            if (finalParkRecoveryMap.containsKey(t.getId())) {
//                ParkRecovery parkRecovery = finalParkRecoveryMap.get(t.getId());
//                BeanUtils.copyProperties(parkRecovery, parkRecoveryVo);
//                Date d = new Date();
//                if (DateUtil.compare(d, DateUtil.parse(parkRecovery.getStartTime())) >= 0 && DateUtil.compare(d,
//                        DateUtil.offsetDay(DateUtil.parse(parkRecovery.getEndTime()), 1)) < 0) {
//                    parkRecoveryVo.setRecoveryStatus(2);
//                } else {
//                    parkRecoveryVo.setRecoveryStatus(3);
//                }
//            } else {
//                parkRecoveryVo.setRecoveryStatus(1);
//            }
//            return parkRecoveryVo;
//        }).collect(Collectors.toList());
        return buildVirtualRecoveryVo(new ArrayList<>(parkIds));
    }

    @Override
    public Integer getOpenedCount(List<Long> parkIds) {
        return count(Wrappers.lambdaQuery(ParkRecovery.class).in(CollectionUtils.isNotEmpty(parkIds) && !parkIds.contains(-1L), ParkRecovery::getParkId,
                parkIds));
    }

    private ParkRecoveryVo buildVirtualRecovery(Long parkId) {
        List<ParkRecoveryVo> recoveries = buildVirtualRecoveryVo(Collections.singletonList(parkId));
        if (CollectionUtils.isEmpty(recoveries)) return null;
        return recoveries.get(0);
    }

    private List<ParkRecoveryVo> buildVirtualRecoveryVo(List<Long> parkIds) {
        List<Park> parks = parkIds.contains(-1L) ? parkService.fidAll() : parkService.findByParkIds(parkIds);
        if (CollectionUtils.isEmpty(parks)) return Collections.emptyList();
        parkIds = parks.stream().map(Park::getId).collect(Collectors.toList());
        ObjectResponse<Map<Long, ParkConfig>> configMapResp = parkService.getParkConfigs(parkIds);
        if (!ObjectResponse.isSuccess(configMapResp)) return Collections.emptyList();

        Map<Long, ParkConfig> configMap = configMapResp.getData();
        List<ParkRecoveryVo> recoveries = new ArrayList<>(parks.size());
        for (Park park : parks) {
            ParkConfig config = configMap.get(park.getId());
            if (config == null) continue;
            if (!CommonConsts.YES.equals(config.getIsEnableRecovery())) continue;
            ParkRecoveryVo recovery = new ParkRecoveryVo();
            recovery.setId(park.getId().intValue());
            recovery.setParkId(park.getId());
            recovery.setInstitutionId(park.getInstitutionId());
            recovery.setApplyType(2);
            recovery.setStartTime("2000-01-01");
            recovery.setEndTime("2999-12-32");
            recovery.setStatus(1);
            recovery.setCreateTime(park.getCreateTime());
            recovery.setUpdateTime(park.getUpdateTime());
            recovery.setOperator(park.getAdder());

            recovery.setParkName(park.getParkName());
            recovery.setRecoveryStatus(2);
            recovery.setEnableRecovery(CommonConsts.YES.equals(config.getIsEnableRecovery()));
            recovery.setOnlyRecoverySelf(CommonConsts.YES.equals(config.getOnlyRecoverySelf()));
            recovery.setAllowRecoveryRoad(CommonConsts.YES.equals(config.getAllowRecoveryRoad()));

            recoveries.add(recovery);
        }
        return recoveries;
    }

    private List<ParkRecovery> buildVirtualRecovery(List<Long> parkIds) {
        List<ParkRecoveryVo> recoveries = buildVirtualRecoveryVo(parkIds);
        if (CollectionUtils.isEmpty(recoveries)) return Collections.emptyList();
        return new ArrayList<>(recoveries);
    }
}
