package com.icetech.park.service.park.impl;

import com.icetech.common.constants.DiscountTypeEnum;
import com.icetech.fee.dao.merchant.ParkMerchantDao;
import com.icetech.fee.domain.entity.merchant.ParkMerchant;
import com.icetech.order.domain.entity.OrderDiscount;
import com.icetech.park.service.park.ParkMerchantService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Objects;

@Slf4j
@Service
public class ParkMerchantServiceImpl implements ParkMerchantService {

    @Resource
    private ParkMerchantDao parkMerchantDao;

    @Override
    public boolean releasePlace(OrderDiscount orderDiscount) {
        try {
            if (orderDiscount.getMerchantId() == null || orderDiscount.getFrom().equals(2)) {
                return Boolean.TRUE;
            }
            //查询车辆的优惠类型
            Integer type = orderDiscount.getType();
            if (DiscountTypeEnum.按天优免.getType().equals(type)) {
                return Boolean.TRUE;
            }

            ParkMerchant parkMerchant = new ParkMerchant();
            parkMerchant.setId(Math.toIntExact(orderDiscount.getMerchantId()));
            parkMerchant = parkMerchantDao.selectById(parkMerchant);
            Integer spaceNum = parkMerchant.getSpaceNum();
            if (Objects.isNull(spaceNum)) {
                return true;
            }
            spaceNum++;
            parkMerchant.setSpaceNum(spaceNum);
            log.info("当前商户[{}]释放后车位数[{}]", parkMerchant.getName(), parkMerchant.getSpaceNum());
            parkMerchantDao.update(parkMerchant);

            return true;
        } catch (Exception e) {
            log.error("[释放空车位]处理失败: {}. orderDiscount[{}]", e.getMessage(), orderDiscount, e);
            return false;
        }
    }

}
