package com.icetech.park.service.park.impl;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.icetech.park.dao.park.ParkGuideDao;
import com.icetech.park.domain.entity.park.ParkGuide;
import com.icetech.db.mybatis.base.service.impl.BaseServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

@Slf4j
@Service
public class ParkGuideServiceImpl extends BaseServiceImpl<ParkGuideDao, ParkGuide> {
    public ParkGuide selectByParkId(long parkId) {
        return getBaseMapper().selectLimitOne(Wrappers.lambdaQuery(ParkGuide.class).eq(ParkGuide::getParkId, parkId));
    }

    public int updateByParkId(ParkGuide guide) {
        Long parkId = guide.getParkId();
        guide.setId(null);
        guide.setParkId(null);
        return getBaseMapper().update(guide, Wrappers.lambdaQuery(ParkGuide.class).eq(ParkGuide::getParkId, parkId));
    }
}
