package com.icetech.park.service.park.impl;

import com.baomidou.mybatisplus.core.enums.SqlMethod;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.icetech.basics.dao.park.ParkRegionDao;
import com.icetech.basics.domain.entity.park.ParkRegion;
import com.icetech.cloudcenter.api.park.ParkFreeSpaceService;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.park.dao.park.ParkFreespaceDao;
import com.icetech.park.domain.entity.park.Park;
import com.icetech.park.domain.entity.park.ParkFreespace;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.db.mybatis.base.service.impl.BaseServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.ibatis.binding.MapperMethod;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

@Slf4j
@Service("parkFreeSpaceService")
public class ParkFreeSpaceServiceImpl extends BaseServiceImpl<ParkFreespaceDao, ParkFreespace> implements ParkFreeSpaceService {

    @Resource
    private ParkRegionDao parkRegionDao;
    @Resource
    private ParkService parkService;
    @Override
    public ObjectResponse<ParkFreespace> getSpaceByPark(long parkId) {
        ParkFreespace space = getBaseMapper().selectLimitOne(Wrappers.lambdaQuery(ParkFreespace.class).eq(ParkFreespace::getParkId, parkId));
        return ObjectResponse.returnNotFoundIfNull(space);
    }

    @Override
    public ObjectResponse<Map<Long, ParkFreespace>> getSpacesByPark(Collection<Long> parkIds) {
        List<ParkFreespace> spaces = getBaseMapper().selectList(Wrappers.lambdaQuery(ParkFreespace.class).in(ParkFreespace::getParkId, parkIds));
        if (CollectionUtils.isEmpty(spaces)) {
            return ObjectResponse.returnNotFoundIfNull(null);
        }
        return ObjectResponse.success(spaces.stream().collect(Collectors.toMap(space -> space.getParkId().longValue(), Function.identity(), (older, newer) -> newer)));
    }

    @Override
    public boolean insertFreeSpace(ParkFreespace space) {
        return save(space);
    }

    @Override
    public boolean updateByPark(ParkFreespace space) {
        space.setId(null);
        Long parkId = space.getParkId();
        return update(space, Wrappers.lambdaQuery(ParkFreespace.class).eq(ParkFreespace::getParkId, parkId));
    }

    @Override
    public int addFreeSpaceByPark(long parkId, int num) {
        return getBaseMapper().addFreeSpaceByPark(parkId, num);
    }

    @Override
    public int addFreeSpaceByParks(Map<Long, Integer> parkMap) {
        return getBaseMapper().addFreeSpaceByParkMap(parkMap);
    }

    @Override
    public boolean updateBatchByParkId(Collection<ParkFreespace> list) {
        String sqlStatement = getSqlStatement(SqlMethod.UPDATE);
        return executeBatch(list, DEFAULT_BATCH_SIZE, (sqlSession, entity) -> {
            MapperMethod.ParamMap<Object> param = new MapperMethod.ParamMap<>();
            param.put(Constants.ENTITY, entity);
            param.put(Constants.WRAPPER,
                    Wrappers.lambdaUpdate(entityClass)
                            .setSql("`free_space` = (case" +
                                    "            when `real_free_space` < 0 then 0" +
                                    "            when `real_free_space` > `total_num` then `total_num`" +
                                    "            else `real_free_space`" +
                                    "        end)")
                            .eq(ParkFreespace::getParkId, entity.getParkId())
                            .ne(ParkFreespace::getRealFreeSpace, entity.getRealFreeSpace())
            );
            sqlSession.update(sqlStatement, param);
        });
    }

    @Override
    public int updateFreeSpace(Long parkId) {
        return getBaseMapper().updateFreeSpace(parkId);
    }

    private boolean isInteriorPark(Long parkId) {
        ObjectResponse<Park> parkObjectResponse = parkService.findByParkId(parkId);
        if (ObjectResponse.isSuccess(parkObjectResponse)) {
            Park park = parkObjectResponse.getData();
            return Integer.valueOf(1).equals(park.getIsInterior());
        }
        return false;
    }
}
