package com.icetech.park.service.park.impl;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.park.dao.park.ParkAdvertMapper;
import com.icetech.park.domain.entity.park.Park;
import com.icetech.park.domain.entity.park.ParkAdvert;
import com.icetech.park.service.park.ParkAdvertService;
import com.icetech.common.constants.SqlConstant;
import com.icetech.db.mybatis.base.service.impl.BaseServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Objects;

/**
 * 车场广告管理 服务实现类
 *
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wanggang
 * @version 1.0 @date 2021-09-02
 */
@Service
public class ParkAdvertServiceImpl extends BaseServiceImpl<ParkAdvertMapper, ParkAdvert> implements ParkAdvertService {

    @Autowired
    private ParkService parkService;

    /**
     * Description: 根据ID查询 车场广告管理对象信息 <br>
     * Version1.0 2021-09-02 by wanggang创建
     *
     * @param id 对象id
     * @return ParkAdvert
     */
    @Override
    public ParkAdvert getParkAdvertById (Long id) {
        return getById(id);
    }

    /**
     * Description: 新增  车场广告管理对象信息 <br>
     * Version1.0 2021-09-02 by wanggang创建
     *
     * @param entity 对象信息
     * @return Boolean 返回新增后主键
     */
    @Override
    public Boolean addParkAdvert (ParkAdvert entity) {
        return save(entity);
    }

    /**
     * Description: 修改 车场广告管理对象信息 <br>
     * Version1.0 2021-09-02 by wanggang创建
     *
     * @param entity 对象信息
     * @return Boolean 返回更新后的结果
     */
    @Override
    public Boolean modifyParkAdvert (ParkAdvert entity) {
        return updateById(entity);
    }

    /**
     * Description: 删除  车场广告管理对象信息 <br>
     * Version1.0 2021-09-02 by wanggang创建
     *
     * @param id 对象id
     * @return Boolean 返回更新后的结果
     */
    @Override
    public Boolean removeParkAdvertById (Long id) {
        return removeById(id);
    }

    @Override
    public ParkAdvert getByParkId(Integer parkId) {
        ParkAdvert query = new ParkAdvert();
        query.setParkId(parkId);
        return getOne(Wrappers.lambdaQuery(query).last(SqlConstant.LIMIT_ONE));
    }

    @Override
    public ParkAdvert getByParkCode(String parkCode) {
        Park park = parkService.findByParkCode(parkCode).getData();
        if (Objects.isNull(park)){
            return null;
        }
        ParkAdvert query = new ParkAdvert();
        query.setParkId(Math.toIntExact(park.getId()));
        return getOne(Wrappers.lambdaQuery(query).last(SqlConstant.LIMIT_ONE));
    }

}
