package com.icetech.park.service.park.impl;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.icetech.park.dao.park.ChannelRuleExtendMapper;
import com.icetech.park.domain.entity.park.ChannelRuleExtend;
import com.icetech.park.service.park.ChannelRuleExtendService;
import com.icetech.db.mybatis.base.service.impl.BaseServiceImpl;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 通道权限扩展表(分时段专用) 服务实现类
 *
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author fangct
 * @version 1.0 @date 2022-12-02
 */
@Service
public class ChannelRuleExtendServiceImpl extends BaseServiceImpl<ChannelRuleExtendMapper, ChannelRuleExtend> implements ChannelRuleExtendService {

    @Override
    public List<ChannelRuleExtend> getChannelRuleExtendsByChannelId(Long channelId) {
        return list(Wrappers.lambdaQuery(ChannelRuleExtend.class)
                .eq(ChannelRuleExtend::getChannelId, channelId)
                .eq(ChannelRuleExtend::getStatus, 0));
    }
}
