package com.icetech.park.service.park;


import com.icetech.cloudcenter.domain.park.query.ParkTrusteeshipParam;
import com.icetech.common.domain.Page;
import com.icetech.db.mybatis.base.service.IBaseService;
import com.icetech.park.domain.entity.ParkTrusteeship;

import java.util.Date;
import java.util.List;

/**
 * 车场托管 服务类
 *
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wgy
 * @version 1.0 @date 2023-06-28
 */
public interface ParkTrusteeshipService extends IBaseService<ParkTrusteeship> {

    /**
     * Description: 根据ID查询 车场托管对象信息 <br>
     * Version1.0 2023-06-28 by wgy创建
     *
     * @param id 对象id
     * @return ParkTrusteeship
     */
    ParkTrusteeship getParkTrusteeshipById (Long id);

    /**
     * Description: 新增  车场托管对象信息 <br>
     * Version1.0 2023-06-28 by wgy创建
     *
     * @param entity 对象信息
     * @return Boolean 返回新增后主键
     */
    Boolean addParkTrusteeship (ParkTrusteeship entity);

    /**
     * Description: 修改 车场托管对象信息 <br>
     * Version1.0 2023-06-28 by wgy创建
     *
     * @param entity 对象信息
     * @return Boolean 返回更新后的结果
     */
    Boolean modifyParkTrusteeship (ParkTrusteeship entity);

    /**
     * Description: 删除  车场托管对象信息 <br>
     * Version1.0 2023-06-28 by wgy创建
     *
     * @param id 对象id
     * @return Boolean 返回更新后的结果
     */
    Boolean removeParkTrusteeshipById (Long id);
    
    /**
     * Description: 保存车场托管数据
     * Version1.0 2023-06-29 by wgy 创建
     * 
     * @param parkTrusteeship   参数
     * @return java.lang.Boolean       
     */
    Boolean saveParkTrusteeship(ParkTrusteeship parkTrusteeship);

    /**
     * Description: 根据车场ID查询 车场托管对象信息 <br>
     * Version1.0 2023-06-28 by wgy创建
     *
     * @param parkId 车场 id
     * @return ParkTrusteeship
     */
    ParkTrusteeship getParkTrusteeshipByParkId(Long parkId);

    /**
     * Description: 分页查询车场托管记录
     * Version1.0 2023-06-29 by wgy 创建
     * 
     * @param parkTrusteeshipParam  参数
     * @param currentDate           当前时间
     * @return com.icetech.common.domain.Page<com.icetech.cloudcenter.domain.dto.ParkTrusteeshipDto>       
     */
    Page<ParkTrusteeship> searchParkTrusteeship(ParkTrusteeshipParam parkTrusteeshipParam, Date currentDate);
    
    /**
     * Description: 查询临近过期提醒的车场数据
     * Version1.0 2023-07-04 by wgy 创建
     * 
     * @return java.util.List<com.icetech.cloudcenter.domain.entity.ParkTrusteeship>       
     */
    List<ParkTrusteeship> getNearExpireWarnPark();    
    
    /**
     * Description: 查询过期提醒的车场数据
     * Version1.0 2023-07-04 by wgy 创建
     * 
     * @return java.util.List<com.icetech.cloudcenter.domain.entity.ParkTrusteeship>       
     */
    List<ParkTrusteeship> getExpireWarnPark();
    
}
