package com.icetech.park.service.park;


import com.icetech.cloudcenter.domain.park.query.ParkTrusteeshipRecordParam;
import com.icetech.common.domain.Page;
import com.icetech.db.mybatis.base.service.IBaseService;
import com.icetech.park.domain.entity.ParkTrusteeshipRecord;

import java.math.BigDecimal;

/**
 * 车场托管缴费记录 服务类
 *
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wgy
 * @version 1.0 @date 2023-06-28
 */
public interface ParkTrusteeshipRecordService extends IBaseService<ParkTrusteeshipRecord> {

    /**
     * Description: 根据ID查询 车场托管缴费记录对象信息 <br>
     * Version1.0 2023-06-28 by wgy创建
     *
     * @param id 对象id
     * @return ParkTrusteeshipRecord
     */
    ParkTrusteeshipRecord getParkTrusteeshipRecordById (Long id);

    /**
     * Description: 新增  车场托管缴费记录对象信息 <br>
     * Version1.0 2023-06-28 by wgy创建
     *
     * @param entity 对象信息
     * @return Boolean 返回新增后主键
     */
    Boolean addParkTrusteeshipRecord (ParkTrusteeshipRecord entity);

    /**
     * Description: 修改 车场托管缴费记录对象信息 <br>
     * Version1.0 2023-06-28 by wgy创建
     *
     * @param entity 对象信息
     * @return Boolean 返回更新后的结果
     */
    Boolean modifyParkTrusteeshipRecord (ParkTrusteeshipRecord entity);

    /**
     * Description: 删除  车场托管缴费记录对象信息 <br>
     * Version1.0 2023-06-28 by wgy创建
     *
     * @param id 对象id
     * @return Boolean 返回更新后的结果
     */
    Boolean removeParkTrusteeshipRecordById (Long id);

    /**
     * Description: 查询托管缴费记录
     * Version1.0 2023-06-29 by wgy 创建
     * 
     * @param parkTrusteeshipRecordParam 参数
     * @return com.icetech.common.domain.Page<com.icetech.cloudcenter.domain.dto.ParkTrusteeshipRecordDto>       
     */
    Page<ParkTrusteeshipRecord> searchParkTrusteeshipRecord(ParkTrusteeshipRecordParam parkTrusteeshipRecordParam);
    
    /**
     * Description: 查询支付汇总数据
     * Version1.0 2023-07-04 by wgy 创建
     * 
     * @param parkTrusteeshipRecordParam    请求参数
     * @return java.math.BigDecimal       
     */
    BigDecimal totalPayAmount(ParkTrusteeshipRecordParam parkTrusteeshipRecordParam);
    
}
