package com.icetech.park.service.park;

import com.icetech.common.domain.Page;
import com.icetech.db.mybatis.base.service.IBaseService;
import com.icetech.park.domain.entity.park.ParkRecoveryApply;
import com.icetech.park.domain.entity.park.ParkRecoverySettle;
import com.icetech.park.domain.request.ParkRecoveryApplyQuery;
import com.icetech.park.domain.request.ParkRecoverySettleQuery;

import java.math.BigDecimal;
import java.util.List;

/**
 * 车场欠费追缴月度结算 服务类
 *
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wgy
 * @version 1.0 @date 2023-07-20
 */
public interface ParkRecoverySettleService extends IBaseService<ParkRecoverySettle> {

    /**
     * Description: 根据ID查询 车场欠费追缴月度结算对象信息 <br>
     * Version1.0 2023-07-20 by wgy创建
     *
     * @param id 对象id
     * @return ParkRecoverySettle
     */
    ParkRecoverySettle getParkRecoverySettleById (Long id);

    /**
     * Description: 新增  车场欠费追缴月度结算对象信息 <br>
     * Version1.0 2023-07-20 by wgy创建
     *
     * @param entity 对象信息
     * @return Boolean 返回新增后主键
     */
    Boolean addParkRecoverySettle (ParkRecoverySettle entity);

    /**
     * Description: 修改 车场欠费追缴月度结算对象信息 <br>
     * Version1.0 2023-07-20 by wgy创建
     *
     * @param entity 对象信息
     * @return Boolean 返回更新后的结果
     */
    Boolean modifyParkRecoverySettle (ParkRecoverySettle entity);

    /**
     * Description: 删除  车场欠费追缴月度结算对象信息 <br>
     * Version1.0 2023-07-20 by wgy创建
     *
     * @param id 对象id
     * @return Boolean 返回更新后的结果
     */
    Boolean removeParkRecoverySettleById (Long id);

    /**
     * Description: 结算数据查询
     * Version1.0 2023-07-27 by wgy 创建
     * 
     * @param parkRecoverySettleQuery   查询参数
     * @param parkIds                   车场 id
     * @return com.icetech.common.domain.Page<com.icetech.park.domain.entity.park.ParkRecoverySettle>       
     */
    Page<ParkRecoverySettle> getParkRecoverySettlePage(ParkRecoverySettleQuery parkRecoverySettleQuery, List<Long> parkIds);

    /**
     * Description: 查询总的费用
     * Version1.0 2023-07-27 by wgy 创建
     * 
     * @param parkRecoverySettleQuery   参数
     * @param parkIds                   车场 id
     * @return com.icetech.park.domain.entity.park.ParkRecoverySettle       
     */
    ParkRecoverySettle totalMoney(ParkRecoverySettleQuery parkRecoverySettleQuery, List<Long> parkIds);

    /**
     * Description: 通过订单号查询
     * Version1.0 2023-07-27 by wgy 创建
     * 
     * @param orderNum  订单号
     * @return com.icetech.park.domain.entity.park.ParkRecoverySettle       
     */
    ParkRecoverySettle getParkRecoverySettleByNo(String orderNum);

    /**
     * Description: 通过车场 id 和结算月份查询
     * Version1.0 2023-07-28 by wgy 创建
     * 
     * @param parkId        车场 id
     * @param settleMonth   结算月份
     * @return com.icetech.park.domain.entity.park.ParkRecoverySettle       
     */
    ParkRecoverySettle getParkRecoverySettleByParKMonth(Long parkId, String settleMonth);

}
