package com.icetech.park.service.park;

import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.db.mybatis.base.service.IBaseService;
import com.icetech.park.domain.entity.park.ParkRecovery;
import com.icetech.park.domain.vo.ParkRecoveryVo;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.Collection;
import java.util.List;

/**
 * 车场欠费追缴 服务类
 *
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wgy
 * @version 1.0 @date 2023-07-20
 */
public interface ParkRecoveryService extends IBaseService<ParkRecovery> {

    /**
     * Description: 根据ID查询 车场欠费追缴对象信息 <br>
     * Version1.0 2023-07-20 by wgy创建
     *
     * @param id 对象id
     * @return ParkRecovery
     */
    ParkRecovery getParkRecoveryById (Long id);

    /**
     * Description: 新增  车场欠费追缴对象信息 <br>
     * Version1.0 2023-07-20 by wgy创建
     *
     * @param entity 对象信息
     * @return Boolean 返回新增后主键
     */
    Boolean addParkRecovery (ParkRecovery entity);

    /**
     * Description: 修改 车场欠费追缴对象信息 <br>
     * Version1.0 2023-07-20 by wgy创建
     *
     * @param entity 对象信息
     * @return Boolean 返回更新后的结果
     */
    Boolean modifyParkRecovery (ParkRecovery entity);

    /**
     * Description: 删除  车场欠费追缴对象信息 <br>
     * Version1.0 2023-07-20 by wgy创建
     *
     * @param id 对象id
     * @return Boolean 返回更新后的结果
     */
    Boolean removeParkRecoveryById (Long id);

    /**
     * Description: 通过车场 id 查询
     * Version1.0 2023-07-21 by wgy 创建
     *
     * @param parkId    车场 id
     * @return com.icetech.park.domain.entity.park.ParkRecovery
     */
    ParkRecoveryVo getParkRecoveryByParkId(Long parkId);

    /**
     * Description: 车场 id 集合 查询
     * Version1.0 2023-07-25 by wgy 创建
     *
     * @param parkIds   车场 id 集合
     * @return java.util.List<com.icetech.park.domain.entity.park.ParkRecovery>
     */
    List<ParkRecoveryVo> getParkRecoveryByParkIds(List<Long> parkIds);

    /**
     * 获取开通的车场
     * @param parkIds
     * @return
     */
    List<ParkRecoveryVo> getOpenParkRecoveryByParkIds(List<Long> parkIds);

    /**
     * Description: 通过车场名称 搜索车场数据
     * Version1.0 2023-07-25 by wgy 创建
     *
     * @param name      名称
     * @param parkIds   用户的车场权限 -1 没限制
     * @param limit     限制条数
     * @return java.util.List<com.icetech.park.domain.vo.ParkRecoveryVo>
     */
    List<ParkRecoveryVo> getBaseParkName(String name, Collection<Long> parkIds, Integer limit);
    
    /**
     * Description: 欠费追缴开通过的 数量
     * Version1.0 2023-08-04 by wgy 创建
     * 
     * @param parkIds   车场 id
     * @return java.lang.Integer       
     */
    Integer getOpenedCount(List<Long> parkIds);
}
