package com.icetech.park.service.park;

import com.icetech.common.domain.Page;
import com.icetech.db.mybatis.base.service.IBaseService;
import com.icetech.park.domain.entity.park.ParkRecoveryApply;
import com.icetech.park.domain.request.ParkRecoveryApplyQuery;

import java.math.BigDecimal;
import java.util.List;

/**
 * 车场欠费追缴申请记录 服务类
 *
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wgy
 * @version 1.0 @date 2023-07-20
 */
public interface ParkRecoveryApplyService extends IBaseService<ParkRecoveryApply> {

    /**
     * Description: 根据ID查询 车场欠费追缴申请记录对象信息 <br>
     * Version1.0 2023-07-20 by wgy创建
     *
     * @param id 对象id
     * @return ParkRecoveryApply
     */
    ParkRecoveryApply getParkRecoveryApplyById (Long id);

    /**
     * Description: 新增  车场欠费追缴申请记录对象信息 <br>
     * Version1.0 2023-07-20 by wgy创建
     *
     * @param entity 对象信息
     * @return Boolean 返回新增后主键
     */
    Boolean addParkRecoveryApply (ParkRecoveryApply entity);

    /**
     * Description: 修改 车场欠费追缴申请记录对象信息 <br>
     * Version1.0 2023-07-20 by wgy创建
     *
     * @param entity 对象信息
     * @return Boolean 返回更新后的结果
     */
    Boolean modifyParkRecoveryApply (ParkRecoveryApply entity);

    /**
     * Description: 删除  车场欠费追缴申请记录对象信息 <br>
     * Version1.0 2023-07-20 by wgy创建
     *
     * @param id 对象id
     * @return Boolean 返回更新后的结果
     */
    Boolean removeParkRecoveryApplyById (Long id);

    /**
     * Description: 申请开通欠费追缴
     * Version1.0 2023-07-20 by wgy 创建
     * 
     * @param parkRecoveryApply 申请参数
     * @return java.lang.Boolean       
     */
    Boolean parkRecoveryApply(ParkRecoveryApply parkRecoveryApply);
    
    /**
     * Description: 分页查询记录
     * Version1.0 2023-07-24 by wgy 创建
     * 
     * @param parkRecoveryApplyQuery    查询参数
     * @param parkIds                   车场权限 id    
     * @return com.icetech.common.domain.Page<com.icetech.park.domain.entity.park.ParkRecoveryApply>       
     */
    Page<ParkRecoveryApply> getParkRecoveryApplyPage(ParkRecoveryApplyQuery parkRecoveryApplyQuery, List<Long> parkIds);

    /**
     * Description: 查询总的服务费用
     * Version1.0 2023-07-24 by wgy 创建
     * 
     * @param parkRecoveryApplyQuery    查询参数
     * @param parkIds                   车场权限
     * @return java.math.BigDecimal       
     */
    BigDecimal totalServiceCharge(ParkRecoveryApplyQuery parkRecoveryApplyQuery, List<Long> parkIds);
    
    /**
     * Description: 订单号查询 
     * Version1.0 2023-07-25 by wgy 创建
     * 
     * @param orderNum  订单号
     * @return com.icetech.park.domain.entity.park.ParkRecoveryApply       
     */
    ParkRecoveryApply getParkRecoveryApplyByOrder(String orderNum);

    /**
     * Description: 车场id获取生效中的
     * Version1.0 2023-07-25 by wgy 创建
     *
     * @param parkId  车场id
     * @return com.icetech.park.domain.entity.park.ParkRecoveryApply
     */
    ParkRecoveryApply getParkRecoveryApplyByOrder(Long parkId);

    /**
     * Description: 欠费追缴申请的数量
     * Version1.0 2023-08-04 by wgy 创建
     *
     * @param parkIds   车场 id
     * @return java.lang.Integer
     */
    Integer getApplyCount(List<Long> parkIds);

    /**
     * Description: 按车场id查询
     * Version1.0 2023-07-25 by wgy 创建
     *
     * @param parkId  车场id
     * @return com.icetech.park.domain.entity.park.ParkRecoveryApply
     */
    ParkRecoveryApply getParkRecoveryApplyByParkId(Long parkId);

    /**
     * 查询当前在有效期内的开通记录
     * @param parkId 车场ID
     * @return 有效的开通记录
     */
    ParkRecoveryApply getValidateRecoveryApplyByParkId(Long parkId);
}
