package com.icetech.park.service.park;

import com.icetech.park.domain.entity.park.ParkAdvert;
import com.icetech.db.mybatis.base.service.IBaseService;

/**
 * 车场广告管理 服务类
 *
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wanggang
 * @version 1.0 @date 2021-09-02
 */
public interface ParkAdvertService extends IBaseService<ParkAdvert> {

    /**
     * Description: 根据ID查询 车场广告管理对象信息 <br>
     * Version1.0 2021-09-02 by wanggang创建
     *
     * @param id 对象id
     * @return ParkAdvert
     */
    ParkAdvert getParkAdvertById (Long id);

    /**
     * Description: 新增  车场广告管理对象信息 <br>
     * Version1.0 2021-09-02 by wanggang创建
     *
     * @param entity 对象信息
     * @return Boolean 返回新增后主键
     */
    Boolean addParkAdvert (ParkAdvert entity);

    /**
     * Description: 修改 车场广告管理对象信息 <br>
     * Version1.0 2021-09-02 by wanggang创建
     *
     * @param entity 对象信息
     * @return Boolean 返回更新后的结果
     */
    Boolean modifyParkAdvert (ParkAdvert entity);

    /**
     * Description: 删除  车场广告管理对象信息 <br>
     * Version1.0 2021-09-02 by wanggang创建
     *
     * @param id 对象id
     * @return Boolean 返回更新后的结果
     */
    Boolean removeParkAdvertById (Long id);

    /**
     * 根据车场id获取广告管理信息
     * @param parkId
     * @return
     */
    ParkAdvert getByParkId (Integer parkId);

    /**
     * 根据车场编号获取广告管理信息
     * @param parkCode
     * @return
     */
    ParkAdvert getByParkCode (String parkCode);
}
