package com.icetech.park.service.other.impl;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ReUtil;
import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.icetech.base.api.IcePushApi;
import com.icetech.base.request.PushMessageRequest;
import com.icetech.park.domain.entity.ParkTrusteeship;
import com.icetech.park.handle.CacheHandle;
import com.icetech.park.service.handle.PublicHandle;
import com.icetech.park.service.park.ParkTrusteeshipService;
import com.icetech.third.anno.DS_SLAVE;
import com.icetech.basics.dao.device.ParkDeviceDao;
import com.icetech.basics.dao.park.ParkDao;
import com.icetech.basics.domain.entity.device.ParkDevice;
import com.icetech.cloudcenter.api.park.ChannelAlarmService;
import com.icetech.cloudcenter.api.park.ParkDeviceService;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.cloudcenter.api.parkvip.IParkVipService;
import com.icetech.cloudcenter.api.parkvip.IVipEquitiesService;
import com.icetech.park.dao.other.ChannelAlarmDao;
import com.icetech.cloudcenter.domain.response.ChannelAlarmDto;
import com.icetech.third.service.third.MqPushService;
import com.icetech.user.dao.SaasUserDao;
import com.icetech.park.domain.entity.ChannelAlarm;
import com.icetech.park.domain.entity.park.Park;
import com.icetech.basics.domain.entity.park.ParkInoutdevice;
import com.icetech.user.domain.entity.user.SaasUser;
import com.icetech.cloudcenter.domain.enumeration.DataCollectionEnum;
import com.icetech.cloudcenter.domain.parkvip.VipEquitiesEnum;
import com.icetech.cloudcenter.domain.request.CarEnterRequest;
import com.icetech.cloudcenter.domain.request.CarExitRequest;
import com.icetech.cloudcenter.domain.vo.InOutYuneasyInfoVo;
import com.icetech.third.utils.RedisUtils;
import com.icetech.basics.utils.RegStr;
import com.icetech.common.constants.CodeConstants;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.utils.StringUtils;
import com.icetech.oss.OssService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

import static com.icetech.cloudcenter.api.constants.RedisConstants.APP_PUSH_CALL_INFO;

/**
 * <p>
 * 进出口报警记录表 服务实现类
 * </p>
 *
 * @author fangct
 * @since 2020-06-161
 */
@Slf4j
@Service
@RefreshScope
public class ChannelAlarmServiceImpl implements ChannelAlarmService {

    @Autowired
    private ChannelAlarmDao channelAlarmDao;
    @Autowired
    private ParkDeviceService parkDeviceService;
    @Autowired
    private SaasUserDao saasUserDao;
    @Autowired
    private CacheHandle cacheHandle;
    @Autowired
    private ParkService parkService;
    @Autowired
    private OssService ossService;

    @Autowired
    private IcePushApi icePushApi;

    @Autowired
    private ParkDeviceDao parkDeviceDao;
    
    @Autowired
    private ParkDao parkDao;
    
    @Value(value = "${alarm.appMsg.parkCodes}")
    public String alarmAppMsgParkCodes;
    @Autowired
    private IVipEquitiesService vipEquitiesService;
    @Autowired
    private IParkVipService parkVipService;
    @Autowired
    private RedisUtils redisUtils;
    @Autowired
    private PublicHandle publicHandle;
    @Autowired
    private ParkTrusteeshipService parkTrusteeshipService;
    @Autowired
    private MqPushService mqPushService;
    @Value("${mor.videoUrl:default}")
    private String morVideoUrl;


    @Override
    public ObjectResponse addAlarm(ChannelAlarm channelAlarm) {
        if (channelAlarm.getParkId() == null || channelAlarm.getChannelCode() == null) {
            return ObjectResponse.failed(CodeConstants.ERROR_400);
        }
        String channelCode = channelAlarm.getChannelCode();
        Long parkId = channelAlarm.getParkId();
        ChannelAlarm channelAlarmOld = channelAlarmDao.selectOneByParkIdAndChannelCode(parkId, channelCode, channelAlarm.getAlarmType());
        if (channelAlarmOld != null) {
            ChannelAlarm channelAlarmUpdate = new ChannelAlarm();
            channelAlarmUpdate.setId(channelAlarmOld.getId());
            channelAlarmUpdate.setStatus(ChannelAlarm.Status.超时未处理.getStatus());
            channelAlarmUpdate.setOperator("system");
            channelAlarmDao.updateById(channelAlarmUpdate);
        }
        ObjectResponse<Park> parkObjectResponse = parkService.findByParkId(channelAlarm.getParkId());
        ObjectResponse.isSuccess(parkObjectResponse);
        Park park = parkObjectResponse.getData();
        ParkInoutdevice parkInoutdevice = null;
        if (StringUtils.isNotBlank(channelCode)){
            parkInoutdevice = parkService.getInoutDeviceByCode(channelCode).getData();

        }

        //呼叫告警推送有无通道都可以推送
        if (channelAlarm.getAlarmType() == 3){
            if (StringUtils.isNotBlank(channelCode)){
                channelAlarmDao.insert(channelAlarm);
            }
            //发送呼叫请求消息
            sendAppMessage(park,parkInoutdevice,channelAlarm.getRemark());
            return ObjectResponse.success();
        }

        if (Objects.isNull(parkInoutdevice)) {
            log.warn("[通道不存在] {}", channelCode);
            return null;
        }
        if (!DataCollectionEnum.端网云.getType().equals(publicHandle.cloudType(park.getParkCode()))) {
            if (!p2cChannelDeal(channelAlarm, park, parkInoutdevice)){
                return ObjectResponse.success();
            }
        }
        channelAlarmDao.insert(channelAlarm);
        mqPushService.pushChannelAlarm(channelAlarm);
        // 发送滞留车辆消息
        sendAppMessage(park, channelAlarm.getChannelCode(), channelAlarm.getImage(), parkInoutdevice.getInandoutName());
        return ObjectResponse.success();
    }
    private Boolean p2cChannelDeal(ChannelAlarm channelAlarm, Park park, ParkInoutdevice parkInoutdevice) {
        //端云处理
        if (parkInoutdevice.getInandoutType() == 1) {
            CarEnterRequest carEnterRequest = cacheHandle.getEntrance(park.getParkCode(), channelAlarm.getChannelCode());
            if (Objects.isNull(carEnterRequest)) {
                return Boolean.FALSE;
            }
            if (channelAlarm.getOrderNum() != null && !channelAlarm.getOrderNum().equals(carEnterRequest.getOrderNum())) {
                log.info("[滞留报警] 订单和当前缓存订单不一致, orderNum[{}]", channelAlarm.getOrderNum());
                return Boolean.FALSE;
            }
            channelAlarm.setImage(carEnterRequest.getSmallImage());
            channelAlarm.setOrderNum(carEnterRequest.getOrderNum());
        }
        if (parkInoutdevice.getInandoutType() == 2) {
            CarExitRequest carExitRequest = cacheHandle.getExit(park.getParkCode(), channelAlarm.getChannelCode());
            if (Objects.isNull(carExitRequest)) {
                if (channelAlarm.getAlarmType() == 2) {
                    channelAlarm.setImage("default");
                    channelAlarm.setOrderNum("default");
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
            if (channelAlarm.getOrderNum() != null && !channelAlarm.getOrderNum().equals(carExitRequest.getOrderNum())) {
                log.info("[滞留报警] 滞留订单和当前缓存订单不一致, orderNum[{}]", channelAlarm.getOrderNum());
                return Boolean.FALSE;
            }
            channelAlarm.setImage(carExitRequest.getSmallImage());
            channelAlarm.setOrderNum(carExitRequest.getOrderNum());
        }
        return Boolean.TRUE;
    }

    @Override
    public ObjectResponse updateStatus(ChannelAlarm channelAlarm) {
        channelAlarmDao.update(channelAlarm);
        return ObjectResponse.success();
    }

    @Override
    public List<ChannelAlarm> getChannelAlarmByPark(Long parkId, String channelCode) {
        return channelAlarmDao.selectByParkIdAndChannelCode(parkId, channelCode);
    }

    @Override
    public List<ChannelAlarm> getChannelAlarmTimeOut(Long parkId, Integer status, Date time) {
        return channelAlarmDao.getChannelAlarmTimeOut(parkId,status,time);
    }

    @Override
    @DS_SLAVE
    public ObjectResponse<List<ChannelAlarmDto>> getChannelAlarm(String parkCodes, Integer pageNo, Integer pageSize) {
        List<ChannelAlarmDto> channelAlarmDtoList =  new ArrayList<>();
        try {
            String[] split = parkCodes.split(",");
            if (split.length == 0) {
                return ObjectResponse.success(channelAlarmDtoList);
            }
            String parkid = parkDao.selectByCodes(split);
            if (parkid == null) {
                return ObjectResponse.success(channelAlarmDtoList);
            }
            if(parkid.endsWith(",")){
                parkid = parkid.substring(0,parkid.length()-1);
            }
            List<ChannelAlarm> list = channelAlarmDao.selectAlarmList(new com.baomidou.mybatisplus.extension.plugins.pagination.Page<>(pageNo, pageSize), parkid);
            for (int i = 0; i < list.size(); i++) {
                ChannelAlarmDto channelAlarmDto = new ChannelAlarmDto();
                ChannelAlarm channelAlarm = list.get(i);
                Park park = parkService.findByParkId(channelAlarm.getParkId()).getData();
                channelAlarmDto.setParkCode(park.getParkCode());
                channelAlarmDto.setParkId(channelAlarm.getParkId());
                channelAlarmDto.setAisleCode(channelAlarm.getChannelCode());
                channelAlarmDto.setParkName(park.getParkName());
                if (StringUtils.isNotEmpty(channelAlarm.getImage())) {
                    channelAlarmDto.setImage(ossService.getImageUrl(channelAlarm.getImage()));
                }
                ParkInoutdevice parkInoutdevice = parkService.getChannelByCodeAndParkId(channelAlarm.getParkId(), channelAlarm.getChannelCode());;
                if (parkInoutdevice == null){
                    log.warn("[通道查询失败，参数：] [{}]", channelAlarm);
                    continue;
                }
                channelAlarmDto.setAisleName(parkInoutdevice.getInandoutName());
                channelAlarmDto.setAisleType(parkInoutdevice.getInandoutType());
                channelAlarmDto.setRemark(channelAlarm.getRemark());
                channelAlarmDto.setCreateTime(channelAlarm.getCreateTime());
                List<Integer> status = new ArrayList<>();
                status.add(1);
                status.add(2);
                List<Integer> deviceType = new ArrayList<>();
                deviceType.add(1);
                deviceType.add(4);
                deviceType.add(6);
                deviceType.add(9);
                List<String> inandoutCode = new ArrayList<>();
                inandoutCode.add(channelAlarm.getChannelCode());
                ParkTrusteeship parkTrusteeship = parkTrusteeshipService.getParkTrusteeshipByParkId(park.getId());
                if (Objects.nonNull(parkTrusteeship)) {
                    Date currentDate = new Date();
                    channelAlarmDto.setTrusteeshipStatus(DateUtil.compare(currentDate, parkTrusteeship.getStartTime()) < 0 ? 1 : (DateUtil.compare(currentDate,
                            parkTrusteeship.getStartTime()) > 0 && DateUtil.compare(currentDate, parkTrusteeship.getEndTime()) < 0 ? 2 : 3) );
                    channelAlarmDto.setTrusteeshipEndTime(parkTrusteeship.getEndTime());
                } else {
                    channelAlarmDto.setTrusteeshipStatus(0);
                }
                List<ParkDevice> parkDevices = parkDeviceDao.selectDeviceList(parkInoutdevice.getParkId(), inandoutCode, status, deviceType);
                for (int j = 0; j < parkDevices.size(); j++) {
                    ParkDevice parkDevice = parkDevices.get(j);
                    channelAlarmDto.setSerialNumber(parkDevice.getSerialNumber());
                    if (parkDevice.getType() == 4) {
                        channelAlarmDto.setVoiceDeviceId(parkDevice.getSerialNumber());
                    }
                    if (parkDevice.getType() == 4 && Objects.nonNull(parkDevice.getVoicevendorType()) && parkDevice.getVoicevendorType() == 1) {
                        channelAlarmDto.setYuneasyNumber(parkDevice.getSerialNumber());
                    }
                    if (parkDevice.getType() == 6) {
                        channelAlarmDto.setVideoUrl(parkDevice.getVideoUrl());
                    }
                    if (parkDevice.getType() == 9) {
                        channelAlarmDto.setIceMorSn(parkDevice.getSerialNumber());
                        channelAlarmDto.setIceMorVideoUrl(String.format(morVideoUrl, parkDevice.getSerialNumber()));
                    }
                    if (parkDevice.getType() == 1) {
                        channelAlarmDto.setIp(parkDevice.getIp());
                        channelAlarmDto.setPort(parkDevice.getPort());
                    }
                }
                channelAlarmDtoList.add(channelAlarmDto);
            }
        }catch (Exception e){
            log.error("操作失败: {}. parkCodes[{}]", e.getMessage(), parkCodes, e);
        }
        return ObjectResponse.success(channelAlarmDtoList);
    }

    @Override
    @DS_SLAVE
    public ObjectResponse<Integer> getChannelAlarmCount(String parkCodes) {
        String[] split = parkCodes.split(",");
        String parkIds = parkDao.selectByCodes(split);
        if (StringUtils.isNotEmpty(parkIds) && parkIds.endsWith(",")) {
            parkIds = parkIds.substring(0, parkIds.length() - 1);
        }
        return ObjectResponse.success(channelAlarmDao.selectAlarmCount(parkIds));
    }

    /**
     * Description: 发送app 滞留车辆消息
     * Version1.0 2021-08-06 by wgy 创建
     *
     * @param park          车场
     * @param channelCode   通道编码
     * @param imgUrl        图片地址
     * @param aisleName     通道名称
     * @return void
     */
    public void sendAppMessage(Park park, String channelCode, String imgUrl, String aisleName) {
        if (StringUtils.isNotEmpty(alarmAppMsgParkCodes)) {
            String[] parkCodes = alarmAppMsgParkCodes.split(",");
            if (Arrays.stream(parkCodes).noneMatch(t-> t.equals(park.getParkCode()))) {
                log.info("[当前车场不在白名单中], {}", park.getParkCode());
                return;
            }
        }
        List<ChannelAlarm> channelAlarmList = getChannelAlarmByPark(park.getId(), channelCode);
        if (CollectionUtils.isNotEmpty(channelAlarmList) && channelAlarmList.size() > 1) {
            log.info("[已经发过滞留消息],{},{}", park.getId(), channelCode);
            return;
        }
        ObjectResponse<InOutYuneasyInfoVo> inOutYuneasyInfoVoResp = parkDeviceService.getInOutYuneasyInfoVo(park.getId(), channelCode);
        if (!ObjectResponse.isSuccess(inOutYuneasyInfoVoResp) || Objects.isNull(inOutYuneasyInfoVoResp.getData())) {
            log.warn("[inOutYuneasyInfoVo 查询异常]， {}, {}", park.getId(), channelCode);
            return;
        }
        InOutYuneasyInfoVo inOutYuneasyInfoVo = inOutYuneasyInfoVoResp.getData();
        List<String> usernames = getUserNames(park);
        if (CollectionUtils.isEmpty(usernames)){
            log.warn("[未找到车场的用户信息-暂不推送] {},{}",park.getParkName(),park.getParkCode());
            return;
        }
        PushMessageRequest pushMessageRequest = new PushMessageRequest();
        pushMessageRequest.setTemplateCode("7C5FAEBEA4214991BF5BDCFC420B303F");
        pushMessageRequest.setSendAccount("system");
        pushMessageRequest.setReceiveAccounts(usernames);
        Map<String, Object> pushParamMap = new HashMap<>();
        pushParamMap.put("parkName", park.getParkName());
        pushParamMap.put("aisleName", aisleName);
        pushMessageRequest.setPushParamMap(pushParamMap);
        if (StringUtils.isNotEmpty(imgUrl)) {
            pushMessageRequest.setMinIcon(ossService.getImageUrl(imgUrl));
        }
        Map<String, String> target = Maps.newHashMap();
        target.put("serialNumber", inOutYuneasyInfoVo.getSerialNumber());
        target.put("yuneasyNumber", inOutYuneasyInfoVo.getYuneasyNumber());
        target.put("parkCode", park.getParkCode());
        pushMessageRequest.setSkipTarget(JSON.toJSONString(target));
        icePushApi.pushMessage(pushMessageRequest);
        log.info("[app推送发起],pushMessageRequest {}",pushMessageRequest);
        //增加滞留车辆权益统计
        ObjectResponse<Boolean> judgeParkVip = parkVipService.judgeParkVip(park.getParkCode());
        if (judgeParkVip.getData()){
            vipEquitiesService.countEquities(park.getParkCode(),null, VipEquitiesEnum.滞留车辆推送.getType());
        }
    }


    /**
     * 呼叫请求推送
     * @param park
     * @param parkInoutdevice
     * @param mobile
     */
    public void sendAppMessage(Park park,ParkInoutdevice parkInoutdevice,String mobile) {

        if (StringUtils.isNotEmpty(alarmAppMsgParkCodes)) {
            String[] parkCodes = alarmAppMsgParkCodes.split(",");
            if (Arrays.stream(parkCodes).noneMatch(t-> t.equals(park.getParkCode()))) {
                log.info("[当前车场不在白名单中], {}", park.getParkCode());
                return;
            }
        }

        List<String> usernames = getUserNames(park);
        if (CollectionUtils.isEmpty(usernames)){
            log.warn("[未找到车场的用户信息-暂不推送] {},{}",park.getParkName(),park.getParkCode());
            return;
        }
        String s = redisUtils.get(APP_PUSH_CALL_INFO + park.getParkCode() +":"+ mobile, String.class);
        if (StringUtils.isNotEmpty(s)){
            log.warn("[当前呼叫已经推送],{}",mobile);
            return;
        }

        PushMessageRequest pushMessageRequest = new PushMessageRequest();
        if (Objects.isNull(parkInoutdevice)){
            //无通道
            pushMessageRequest.setTemplateCode("35A786EE797B4B2EA0604B907D78E902");
            pushMessageRequest.setSendAccount("system");
            pushMessageRequest.setReceiveAccounts(usernames);
            Map<String, Object> pushParamMap = new HashMap<>();
            pushParamMap.put("parkName", park.getParkName());
            pushParamMap.put("callTime", DateUtil.formatTime(DateUtil.date()));
            pushParamMap.put("phoneNumber", mobile);
            pushMessageRequest.setPushParamMap(pushParamMap);
            Map<String, String> target = Maps.newHashMap();
            target.put("parkCode", park.getParkCode());
            target.put("phoneNumber", mobile);
            pushMessageRequest.setSkipTarget(JSON.toJSONString(target));
        }else {
            //有通道
            pushMessageRequest.setTemplateCode("D2BDDBA11E3D48FABA1908548D9D1F0B");
            pushMessageRequest.setSendAccount("system");
            pushMessageRequest.setReceiveAccounts(usernames);
            Map<String, Object> pushParamMap = new HashMap<>();
            pushParamMap.put("parkName", park.getParkName());
            pushParamMap.put("aisleName", parkInoutdevice.getInandoutName());
            pushParamMap.put("callTime", DateUtil.formatTime(DateUtil.date()));
            Map<String, String> target = Maps.newHashMap();
            ObjectResponse<InOutYuneasyInfoVo> inOutYuneasyInfoVoResp = parkDeviceService.getInOutYuneasyInfoVo(park.getId(), parkInoutdevice.getInandoutCode());
            if (ObjectResponse.isSuccess(inOutYuneasyInfoVoResp)) {
                InOutYuneasyInfoVo inOutYuneasyInfoVo = inOutYuneasyInfoVoResp.getData();
                target.put("serialNumber", inOutYuneasyInfoVo.getSerialNumber());
                target.put("yuneasyNumber", inOutYuneasyInfoVo.getYuneasyNumber());
            }
            target.put("parkCode", park.getParkCode());

            if (ReUtil.isMatch(RegStr.MOBILE,mobile)){
                pushParamMap.put("phoneNumber", mobile);
                target.put("phoneNumber", mobile);
            }else{
                pushParamMap.put("phoneNumber", "");
                target.put("phoneNumber", "");
            }
            pushMessageRequest.setPushParamMap(pushParamMap);
            pushMessageRequest.setSkipTarget(JSON.toJSONString(target));
            //有通道增加滞留车辆权益统计
            ObjectResponse<Boolean> judgeParkVip = parkVipService.judgeParkVip(park.getParkCode());
            if (judgeParkVip.getData()){
                vipEquitiesService.countEquities(park.getParkCode(),null, VipEquitiesEnum.滞留车辆推送.getType());
            }
        }
        redisUtils.set(APP_PUSH_CALL_INFO + park.getParkCode() +":"+ mobile,mobile,30);
        icePushApi.pushMessage(pushMessageRequest);
    }

    private List<String> getUserNames(Park park){
        // 查询角色信息
        ArrayList<String> roleNames = Lists.newArrayList("车场管理员", "云岗亭管理员", "系统管理员");
        String subInstitutionId = saasUserDao.getSubInstitutionId(park.getInstitutionId());
        List<String> subInstitutionIdsStr = Arrays.asList(subInstitutionId.split(","));
        subInstitutionIdsStr = subInstitutionIdsStr.stream().filter(string -> !string.isEmpty()).collect(Collectors.toList());
        List<Long> subInstitutionIds = subInstitutionIdsStr.stream().map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
        List<Long> userIds = saasUserDao.getUserIdsSaasUserParkByInstitutionIds(subInstitutionIds);
        if (CollectionUtils.isEmpty(userIds)){
            userIds = Lists.newArrayList();
        }
        List<Long> userIdsPark = saasUserDao.getUserIdsSaasUserParkByParkId(park.getId());
        if (CollectionUtils.isEmpty(userIds)){
            userIdsPark = Lists.newArrayList();
        }
        userIds.addAll(userIdsPark);
        if (CollectionUtils.isEmpty(userIds)){
            return Lists.newArrayList();
        }
        userIds = userIds.stream().distinct().collect(Collectors.toList());
        List<SaasUser> saasUsers = saasUserDao.getUserByUserIdAndRoleName(userIds, roleNames);
        List<String> usernames = saasUsers.stream().map(SaasUser::getUsername).collect(Collectors.toList());
        return usernames;
    }



}
