package com.icetech.park.service.other.impl;

import com.icetech.basics.dao.park.ParkConfigDao;
import com.icetech.basics.domain.entity.park.ParkConfig;
import com.icetech.park.service.other.AutopayService;
import com.icetech.common.constants.CodeConstants;
import com.icetech.paycenter.domain.PlatformPayType;
import com.icetech.order.domain.entity.OrderInfo;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.utils.DateTools;
import com.icetech.common.utils.MoneyTool;
import com.icetech.paycenter.api.IPayCenterService;
import com.icetech.paycenter.domain.request.autopay.EnterNotifyRequest;
import com.icetech.paycenter.domain.request.autopay.ExitNotifyRequest;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.Objects;

@Slf4j
@Service("autoPayServiceImpl")
public class AutopayServiceImpl implements AutopayService {
    @Autowired
    private ParkConfigDao parkConfigDao;
    @Autowired
    private IPayCenterService payCenterService;

    private static final String SUCCESS = "SUCCESS";
    private static final String FAIL = "FAIL";

    @Override
    public String enterNotify(Long parkId, String orderNum, String parkCode, String plateNum, Long enterTime, Integer type) {
        ParkConfig parkConfig = parkConfigDao.selectByParkId(parkId);
        //获取车场的高级配置
        if (Objects.nonNull(parkConfig) && parkConfig.getIsNosenpayment()==1
                && PlatformPayType.NO_SEN_UNION_PAY.getCode().equals(parkConfig.getNoSenPayment())
                && type==1){
            EnterNotifyRequest enterNotifyRequest = new EnterNotifyRequest();
            enterNotifyRequest.setParkCode(parkCode);
            enterNotifyRequest.setPlateNum(plateNum);
            enterNotifyRequest.setOrderNum(orderNum);
            enterNotifyRequest.setEnterTime(DateTools.secondTostring(Math.toIntExact(enterTime)));
            try{
                ObjectResponse<String> response = payCenterService.autoPayEnterNotify(enterNotifyRequest);
                if (response.getCode().equals(CodeConstants.SUCCESS)){
                    return SUCCESS;
                }else {
                    log.info("[免密支付入场通知]通知失败，orderNum[{}]", orderNum);
                }
            }catch (Exception e){
                log.error("[免密支付入场通知]通知失败: {}. orderNum[{}]", e.getMessage(), orderNum, e);
            }
        }
        return FAIL;
    }

    @Override
    public String exitNotify(OrderInfo orderInfo, String parkCode) {
        ParkConfig parkConfig = parkConfigDao.selectByParkId(orderInfo.getParkId());

        if (Objects.nonNull(parkConfig)&&parkConfig.getIsNosenpayment()==1
                && PlatformPayType.NO_SEN_UNION_PAY.getCode().equals(parkConfig.getNoSenPayment())
                &&orderInfo.getType()==1) {
            ExitNotifyRequest exitNotifyRequest = new ExitNotifyRequest();
            exitNotifyRequest.setParkCode(parkCode);
            exitNotifyRequest.setPlateNum(orderInfo.getPlateNum());
            exitNotifyRequest.setOrderNum(orderInfo.getOrderNum());
            exitNotifyRequest.setPaidPrice(MoneyTool.fromYuanToFen(orderInfo.getPaidPrice()));
            exitNotifyRequest.setExitTime(orderInfo.getExitTime() == null
                    ? DateTools.getFormat(new Date()): DateTools.secondTostring(Math.toIntExact(orderInfo.getExitTime())));

            ObjectResponse<String> response = payCenterService.autoPayExitNotify(exitNotifyRequest);
            if (response.getCode().equals(CodeConstants.SUCCESS)) {
                return SUCCESS;
            }else{
                log.info("[免密支付离场通知]通知失败，订单参数：[{}]", orderInfo);
            }
        }
        return FAIL;
    }
}
