package com.icetech.park.service.order.impl.exit;

import com.icetech.basics.domain.entity.park.ParkRegion;
import com.icetech.cloudcenter.api.order.OrderService;
import com.icetech.cloudcenter.domain.charge.dto.OrderSumFeeDto;
import com.icetech.cloudcenter.domain.request.CarExitRequest;
import com.icetech.cloudcenter.domain.response.PlateTypeDto;
import com.icetech.common.constants.CodeConstants;
import com.icetech.common.constants.OrderStatusConstants;
import com.icetech.common.constants.PlateTypeEnum;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.exception.ResponseBodyException;
import com.icetech.common.thread.ThreadUtils;
import com.icetech.common.utils.AssertTools;
import com.icetech.common.utils.StringUtils;
import com.icetech.order.dao.*;
import com.icetech.order.domain.entity.*;
import com.icetech.park.domain.vo.RegionFreeSpaceUpdateVo;
import com.icetech.park.service.monthcar.impl.MonthCarServiceImpl;
import com.icetech.park.service.report.ReportParamHolder;
import com.icetech.third.service.third.MqPushService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ThreadPoolExecutor;

@Slf4j
@Service
public class SubChannelCarOrderExitServiceImpl extends CommonExitImpl {
    @Autowired
    private OrderInfoDao orderInfoDao;
    @Autowired
    private StringRedisTemplate redisTemplate;
    @Autowired
    private MonthCarServiceImpl monthCarService;
    @Autowired
    private OrderPayDao orderPayDao;
    @Resource
    private OrderSonCarInfoDao orderSonCarInfoDao;
    @Autowired
    private OrderSonInfoDao orderSonInfoDao;
    @Autowired
    private ThreadPoolExecutor asyncExecutor;
    @Autowired
    private MqPushService pushService;
    @Autowired
    private OrderCarInfoDao orderCarInfoDao;
    @Autowired
    private OrderService orderService;


    public ObjectResponse<Map<String, Object>> exit(CarExitRequest exitRequest, ReportParamHolder paramHolder,
                                                    Integer status, Integer oddStatus, OrderInfo orderInfo) {
        Long parkId = exitRequest.getParkId();
        String orderNum = exitRequest.getOrderNum();
        Long regionId = paramHolder.getParkChannel().getRegionId();
        //子通道的处理逻辑
        subChannelExit(exitRequest, paramHolder, status, oddStatus, parkId, orderNum, orderInfo, regionId);

        //保存轨迹
        saveTrack(exitRequest, paramHolder.getParkChannel().getRegionId(), oddStatus);
        //月卡多位多车处理
        if (exitRequest.getType().equals(PlateTypeEnum.月卡车.getType())) {
            asyncExecutor.execute(ThreadUtils.wrapTrace(() ->
                monthCarService.innerAreaExitAbMonthDeal(
                        parkId, exitRequest.getPlateNum(), exitRequest.getExitTime(), regionId)
            ));
        }

        asyncHandler(exitRequest, parkId, orderNum, orderInfo, null, oddStatus);

        //返回
        Map<String, Object> map = new HashMap<>();
        map.put("orderNum", orderNum);
        return ObjectResponse.success(map);
    }

    private void subChannelExit(CarExitRequest exitRequest, ReportParamHolder paramHolder, Integer status, Integer oddStatus,
                                Long parkId, String orderNum, OrderInfo orderInfo, Long regionId) {
        ParkRegion parkRegion = parkRegionDao.selectById(regionId);
        AssertTools.notNull(parkRegion, CodeConstants.ERROR_400, CodeConstants.getName(CodeConstants.ERROR_400));
        //半嵌套子通道出
        if (!Long.valueOf(0).equals(parkRegion.getFatherRelationId())) {
            //从内区主通道进入,再从内区域子通道出到外区
            if (regionId.equals(orderInfo.getRegionId())) {
                //记录进内场子订单（离场状态）和进外场子订单（在场状态）
                OrderSonInfo orderSonInfo = new OrderSonInfo();
                orderSonInfo.setOrderNum(orderNum);
                orderSonInfo.setRegionId(regionId);
                orderSonInfo.setParkId(parkId);
                orderSonInfo = orderSonInfoDao.selectOneByEntity(orderSonInfo);
                OrderSonCarInfo sonCarInfo;

                List<RegionFreeSpaceUpdateVo> freeSpaceUpdateVos = new ArrayList<>();
                if (orderSonInfo == null) {
                    orderSonInfo = new OrderSonInfo();
                    BeanUtils.copyProperties(orderInfo, orderSonInfo);
                    orderSonInfo.setServiceStatus(status);
                    orderSonInfo.setOddStatus(oddStatus);
                    //orderSonInfo.setExitTime(exitRequest.getExitTime());
                    orderSonInfo.setOperAccount(exitRequest.getOperAccount());
                    setOrderSonPrice(exitRequest, status, parkId, orderNum, orderSonInfo);
                    orderSonInfoDao.insertWithPlateNum2(orderSonInfo);

                    freeSpaceUpdateVos.add(RegionFreeSpaceUpdateVo.builder()
                            .regionId(orderSonInfo.getRegionId()).type(orderSonInfo.getType()).num(1).build());

                    OrderCarInfo carInfo = orderCarInfoDao.selectByOrderNum(orderNum);
                    OrderSonCarInfo sonCarInfoSub = new OrderSonCarInfo();
                    BeanUtils.copyProperties(carInfo, sonCarInfoSub);
                    sonCarInfoSub.setOrderSonId(orderSonInfo.getId());
                    sonCarInfoSub.setExitChannelId(exitRequest.getInandoutCode());
                    sonCarInfoSub.setExitNo(exitRequest.getInandoutName());
                    sonCarInfoSub.setExitImage(exitRequest.getMaxImage());
                    sonCarInfoSub.setSmallExitImage(exitRequest.getSmallImage());

                    sonCarInfoSub.setExitWay(exitRequest.getExitWay());
                    sonCarInfoSub.setExitTerminal(exitRequest.getExitTerminal());
                    sonCarInfoSub.setExitOperAccount(exitRequest.getOperAccount());
                    sonCarInfoSub.setExitRemark(exitRequest.getExitRemark());
                    orderSonCarInfoDao.insert(sonCarInfoSub);
                    log.info("[端云-子通道离场服务] 补-子订单数据：{}", exitRequest.getPlateNum());

                    orderSonInfo = new OrderSonInfo();
                    BeanUtils.copyProperties(exitRequest, orderSonInfo);
                    orderSonInfo.setExitTime(null);
                    orderSonInfo.setEnterTime(exitRequest.getExitTime());
                    orderSonInfo.setOrderNum(orderNum);

                    ParkRegion parkRegion1 = parkRegionDao.selectOutByParkid(parkId);
                    if (parkRegion1 == null) {
                        throw new ResponseBodyException(CodeConstants.ERROR_400, "parkId[" + parkId + "]没有外区域");
                    }
                    //查询车辆类型
                    ObjectResponse<PlateTypeDto> plateTypeDtoObjectResponse =
                            orderService.getPlateType(parkId, exitRequest.getPlateNum(), parkRegion1.getId());
                    PlateTypeDto plateTypeDto = plateTypeDtoObjectResponse.getData();
                    orderSonInfo.setType(plateTypeDto.getPlateTypeEnum().getType());
                    orderSonInfo.setRegionId(parkRegion1.getId());
                    orderSonInfo.setOperAccount(exitRequest.getOperAccount());
                    orderSonInfo.setServiceStatus(OrderStatusConstants.IN_PARK);
                    orderSonInfoDao.insertWithPlateNum2(orderSonInfo);
                    log.info("[端云-子通道离场服务] 补外区-子订单数据：{}", exitRequest.getPlateNum());

                    freeSpaceUpdateVos.add(RegionFreeSpaceUpdateVo.builder()
                            .regionId(orderSonInfo.getRegionId()).type(orderSonInfo.getType()).num(-1).build());
                    updateRegionFreeSpace(paramHolder, freeSpaceUpdateVos);

                    sonCarInfo = new OrderSonCarInfo();
                    BeanUtils.copyProperties(exitRequest, sonCarInfo);
                    sonCarInfo.setEnterChannelId(exitRequest.getInandoutCode());
                    sonCarInfo.setEnterNo(exitRequest.getInandoutName());
                    sonCarInfo.setEnterImage(exitRequest.getMaxImage());
                    sonCarInfo.setSmallEnterImage(exitRequest.getSmallImage());
                    sonCarInfo.setEnterOperAccount(exitRequest.getOperAccount());
                    sonCarInfo.setEnterReliability(exitRequest.getReliability());
                    sonCarInfo.setOrderSonId(orderSonInfo.getId());
                    orderSonCarInfoDao.insert(sonCarInfo);
                    log.info("[端云-子通道离场服务] 补外区-子订单车辆数据：{}", exitRequest.getPlateNum());

                    orderInfo.setHasSon(1);
                    orderInfo.setOperAccount(exitRequest.getOperAccount());
                    orderInfoDao.updateByOrderNum(orderInfo);
                    log.info("[端云-子通道离场服务] 补-主订单更新为hasSon字段为1：{}", exitRequest.getPlateNum());
                } else {
                    // 填充子订单出场信息
                    orderSonInfo.setBalancePrice(orderInfo.getBalancePrice());
                    orderSonInfo.setServiceStatus(status);
                    //orderSonInfo.setExitTime(exitRequest.getExitTime());
                    orderSonInfo.setOddStatus(oddStatus);
                    orderSonInfo.setOperAccount(exitRequest.getOperAccount());
                    setOrderSonPrice(exitRequest, status, parkId, orderNum, orderSonInfo);
                    orderSonInfoDao.updateById(orderSonInfo);

                    updateRegionFreeSpace(paramHolder, RegionFreeSpaceUpdateVo.builder()
                            .regionId(orderSonInfo.getRegionId()).type(orderSonInfo.getType()).num(1).build());

                    /*sonCarInfo = orderSonCarInfoDao.selectByOrderSonId(orderSonInfo.getId());
                    // 填充子订单车辆信息
                    sonCarInfo.setExitImage(exitRequest.getMaxImage());
                    sonCarInfo.setSmallExitImage(exitRequest.getSmallImage());
                    sonCarInfo.setExitNo(exitRequest.getInandoutName());
                    sonCarInfo.setExitChannelId(exitRequest.getInandoutCode());
                    sonCarInfo.setExitReliability(exitRequest.getReliability());
                    orderSonCarInfoDao.updateById(sonCarInfo);
                    log.info("[端云-离场服务] 修改子订单及车辆信息完成: {} - {}", orderSonInfo.getId(), sonCarInfo.getId());*/
                    //发送MQ消息，同步给其他相机
                    pushService.pushOrderSonExit(orderSonInfo);
                }

                if (Boolean.TRUE.equals(redisTemplate.hasKey("sub:" + orderSonInfo.getOrderNum()))) {
                    redisTemplate.delete("sub:" + orderSonInfo.getOrderNum());
                    log.info("[端云-小场离场服务] 使用完毕，清除redis小场计费结果：{}", orderSonInfo.getOrderNum());
                }
                return;
            }
        }

        //当前区域的子订单
        OrderSonInfo orderSonInfo = null;
        //外区域对应的子订单
        OrderSonInfo mainOrderSonInfo = null;
        OrderSonInfo orderSonInfoParam = new OrderSonInfo();
        orderSonInfoParam.setOrderNum(orderNum);
        orderSonInfoParam.setParkId(parkId);
        List<OrderSonInfo> orderSonInfos = orderSonInfoDao.selectList(orderSonInfoParam);
        if (CollectionUtils.isNotEmpty(orderSonInfos)) {
            Optional<OrderSonInfo> first1 = orderSonInfos.stream()
                    .filter(osi -> parkRegion.getFatherRelationId().equals(osi.getRegionId())).findFirst();
            if (first1.isPresent()) {
                mainOrderSonInfo = first1.get();
            }
            Optional<OrderSonInfo> first2 = orderSonInfos.stream()
                    .filter(osi -> regionId.equals(osi.getRegionId())).findFirst();
            if (first2.isPresent()) {
                orderSonInfo = first2.get();
            }
        }

        OrderSonCarInfo sonCarInfo;

        List<RegionFreeSpaceUpdateVo> freeSpaceUpdateVos = new ArrayList<>();
        if (orderSonInfo == null) {
            orderSonInfo = new OrderSonInfo();
            BeanUtils.copyProperties(exitRequest, orderSonInfo);
            //查询车辆类型
            ObjectResponse<PlateTypeDto> plateTypeDtoObjectResponse =
                    orderService.getPlateType(parkId, exitRequest.getPlateNum(), regionId);
            PlateTypeDto plateTypeDto = plateTypeDtoObjectResponse.getData();
            orderSonInfo.setType(plateTypeDto.getPlateTypeEnum().getType());
            if (PlateTypeEnum.月卡车.getType().equals(plateTypeDto.getPlateTypeEnum().getType())
                    || PlateTypeEnum.VIP车辆.getType().equals(plateTypeDto.getPlateTypeEnum().getType())) {
                orderSonInfo.setEnterTime(orderInfo.getEnterTime());
            } else {
                orderSonInfo.setEnterTime(exitRequest.getExitTime());
            }
            orderSonInfo.setOrderNum(orderNum);
            orderSonInfo.setRegionId(regionId);
            log.info("[端云-子通道离场服务] 补-子订单数据：{}", exitRequest.getPlateNum());

            sonCarInfo = new OrderSonCarInfo();
            BeanUtils.copyProperties(exitRequest, sonCarInfo);
            log.info("[端云-子通道离场服务] 补-子订单车辆数据：{}", exitRequest.getPlateNum());

            orderInfo.setHasSon(1);
            orderInfo.setOperAccount(exitRequest.getOperAccount());
            orderInfoDao.updateByOrderNum(orderInfo);
            log.info("[端云-子通道离场服务] 补-主订单更新为hasSon字段为1：{}", exitRequest.getPlateNum());
        } else {
            sonCarInfo = orderSonCarInfoDao.selectByOrderSonId(orderSonInfo.getId());
        }

        if (mainOrderSonInfo == null) {
            //保存主订单的子订单记录
            saveMainOrderSonInfo(orderNum, orderInfo, parkRegion.getFatherRelationId());
        } else {
            orderSonInfoDao.setInPark(mainOrderSonInfo.getId());
            freeSpaceUpdateVos.add(RegionFreeSpaceUpdateVo.builder()
                    .regionId(mainOrderSonInfo.getRegionId()).type(mainOrderSonInfo.getType()).num(-1).build());
        }
        // 填充子订单出场信息
        orderSonInfo.setBalancePrice(orderInfo.getBalancePrice());
        orderSonInfo.setServiceStatus(status);
        orderSonInfo.setExitTime(exitRequest.getExitTime());
        orderSonInfo.setOddStatus(oddStatus);
        orderSonInfo.setOperAccount(exitRequest.getOperAccount());

        // 填充子订单车辆信息
        sonCarInfo.setExitImage(exitRequest.getMaxImage());
        sonCarInfo.setSmallExitImage(exitRequest.getSmallImage());
        sonCarInfo.setExitNo(exitRequest.getInandoutName());
        sonCarInfo.setExitChannelId(exitRequest.getInandoutCode());
        sonCarInfo.setExitReliability(exitRequest.getReliability());
        sonCarInfo.setExitWay(exitRequest.getExitWay());
        sonCarInfo.setExitTerminal(exitRequest.getExitTerminal());
        sonCarInfo.setExitRemark(exitRequest.getExitRemark());
        sonCarInfo.setExitOperAccount(exitRequest.getOperAccount());

        setOrderSonPrice(exitRequest, status, parkId, orderNum, orderSonInfo);

        if(orderSonInfo.getId() == null) {
            orderSonInfo.setNoneEnterFlag(1);
            orderSonInfoDao.insertWithPlateNum2(orderSonInfo);
            sonCarInfo.setOrderSonId(orderSonInfo.getId());
            orderSonCarInfoDao.insert(sonCarInfo);
            log.info("[端云-离场服务] 补-子订单及车辆信息新增完成: {} - {}", orderSonInfo.getId(), sonCarInfo.getId());
        } else {
            orderSonInfoDao.updateById(orderSonInfo);
            orderSonCarInfoDao.updateById(sonCarInfo);
            log.info("[端云-离场服务] 修改子订单及车辆信息完成: {} - {}", orderSonInfo.getId(), sonCarInfo.getId());
            //发送MQ消息，同步给其他相机
            pushService.pushOrderSonExit(orderSonInfo);

            freeSpaceUpdateVos.add(RegionFreeSpaceUpdateVo.builder()
                    .regionId(orderSonInfo.getRegionId()).type(orderSonInfo.getType()).num(1).build());
        }
        updateRegionFreeSpace(paramHolder, freeSpaceUpdateVos);

        if (Boolean.TRUE.equals(redisTemplate.hasKey("sub:" + orderSonInfo.getOrderNum()))) {
            redisTemplate.delete("sub:" + orderSonInfo.getOrderNum());
            log.info("[端云-小场离场服务] 使用完毕，清除redis小场计费结果：{}", orderSonInfo.getOrderNum());
        }
    }

    private void setOrderSonPrice(CarExitRequest exitRequest, Integer status, Long parkId, String orderNum, OrderSonInfo orderSonInfo) {
        if (OrderStatusConstants.LEAVED_PARK == status) {
            // 正常离场时，汇总平台数据
            OrderPay orderPay = new OrderPay();
            orderPay.setParkId(parkId);
            orderPay.setOrderNum(orderNum);
            OrderSumFeeDto orderSumFeeDto = orderPayDao.sumFee(orderPay);
            if (orderSumFeeDto != null) {
                orderSonInfo.setTotalPrice(String.valueOf(orderSumFeeDto.getTotalPrice()));
                orderSonInfo.setPaidPrice(String.valueOf(orderSumFeeDto.getPaidPrice()));
                orderSonInfo.setDiscountPrice(String.valueOf(orderSumFeeDto.getDiscountPrice()));
            } else {
                orderSonInfo.setTotalPrice("0.00");
                orderSonInfo.setPaidPrice("0.00");
                orderSonInfo.setDiscountPrice("0.00");
            }
        } else {
            // 异常离场时，以查询待缴费为准
            orderSonInfo.setTotalPrice(StringUtils.isBlank(exitRequest.getTotalAmount()) ? "0.00" : exitRequest.getTotalAmount());
            orderSonInfo.setPaidPrice(StringUtils.isBlank(exitRequest.getPaidAmount()) ? "0.00" : exitRequest.getPaidAmount());
            orderSonInfo.setDiscountPrice(StringUtils.isBlank(exitRequest.getDiscountAmount()) ? "0.00" : exitRequest.getDiscountAmount());
        }
    }

    private OrderSonInfo saveMainOrderSonInfo(String orderNum, OrderInfo orderInfo, Long regionId) {
        OrderSonInfo orderSonInfoMain = new OrderSonInfo();
        BeanUtils.copyProperties(orderInfo, orderSonInfoMain);
        //setOrderSonPrice(orderInfo.getParkId(), orderNum, orderSonInfoMain);
        orderSonInfoMain.setRegionId(regionId);
        orderSonInfoMain.setServiceStatus(OrderStatusConstants.IN_PARK);
        orderSonInfoMain.setCreateTime(null);
        orderSonInfoDao.insertWithPlateNum2(orderSonInfoMain);
        log.info("[入场服务-子通道] 插入子订单表的主订单信息[{}]", orderSonInfoMain);

        //如果车辆进过内区，主离场记录---->子出入场记录表
        OrderCarInfo carInfo = orderCarInfoDao.selectByOrderNum(orderNum);

        OrderSonCarInfo sonCarInfoMain = new OrderSonCarInfo();
        BeanUtils.copyProperties(carInfo, sonCarInfoMain);
        sonCarInfoMain.setOrderSonId(orderSonInfoMain.getId());
        orderSonCarInfoDao.insert(sonCarInfoMain);
        log.info("[入场服务-子通道] 主离场记录插入子出入场记录表完成，orderNum：{}", orderNum);
        return orderSonInfoMain;
    }

}
