package com.icetech.park.service.order.impl.exit;

import com.icetech.basics.domain.entity.park.ParkConfig;
import com.icetech.basics.domain.entity.park.ParkInoutdevice;
import com.icetech.basics.domain.entity.park.ParkRegion;
import com.icetech.cloudcenter.domain.enumeration.OrderOddStatusEnum;
import com.icetech.cloudcenter.domain.request.CarExitRequest;
import com.icetech.cloudcenter.domain.response.MonthDetailDto;
import com.icetech.cloudcenter.domain.response.QueryOrderFeeResponse;
import com.icetech.common.constants.CodeConstants;
import com.icetech.common.constants.OrderStatusConstants;
import com.icetech.common.constants.PlateTypeEnum;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.thread.ThreadUtils;
import com.icetech.common.utils.AssertTools;
import com.icetech.common.utils.NumberUtils;
import com.icetech.order.dao.OrderCarInfoDao;
import com.icetech.order.dao.OrderInfoDao;
import com.icetech.order.dao.OrderSonCarInfoDao;
import com.icetech.order.dao.OrderSonInfoDao;
import com.icetech.order.domain.entity.OrderCarInfo;
import com.icetech.order.domain.entity.OrderInfo;
import com.icetech.order.domain.entity.OrderSonCarInfo;
import com.icetech.order.domain.entity.OrderSonInfo;
import com.icetech.order.service.impl.OrderSonInfoServiceImpl;
import com.icetech.park.domain.vo.RegionFreeSpaceUpdateVo;
import com.icetech.park.service.monthcar.impl.MonthCarServiceImpl;
import com.icetech.park.service.report.ReportParamHolder;
import com.icetech.third.utils.RedisUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.*;
import java.util.concurrent.ThreadPoolExecutor;

@Slf4j
@Service
public class MasterChannelCarOrderExitServiceImpl extends CommonExitImpl {
    @Resource
    private OrderCarInfoDao orderCarInfoDao;
    @Autowired
    private RedisUtils redisUtils;
    @Autowired
    private MonthCarServiceImpl monthCarService;
    @Resource
    private OrderSonCarInfoDao orderSonCarInfoDao;
    @Autowired
    private OrderSonInfoDao orderSonInfoDao;
    @Autowired
    private OrderSonInfoServiceImpl orderSonInfoService;
    @Autowired
    private ThreadPoolExecutor asyncExecutor;
    @Autowired
    private OrderInfoDao orderInfoDao;

    public ObjectResponse<Map<String, Object>> exit(CarExitRequest exitRequest, ReportParamHolder paramHolder,
                                                    Integer status, Integer oddStatus, OrderInfo orderInfo) {
        Long parkId = exitRequest.getParkId();
        String orderNum = exitRequest.getOrderNum();

        //离场流程处理
        dealExit(exitRequest, status, oddStatus, orderInfo, paramHolder);
        //保存轨迹
        saveTrack(exitRequest, paramHolder.getParkChannel().getRegionId(), oddStatus);
        //月卡多位多车处理
        if (PlateTypeEnum.月卡车.getType().equals(exitRequest.getType())) {
            asyncExecutor.execute(ThreadUtils.wrapTrace(() -> {
                log.info("[场中场月卡车出场] 准备处理plateNum[{}]", exitRequest.getPlateNum());
                monthCarService.masterAreaExitAbMonthDeal(parkId, exitRequest.getPlateNum(),
                        exitRequest.getExitTime(), paramHolder.getParkChannel().getRegionId());
            }));
        }

        /*//使用优惠
        if (NumberUtils.parseFloat(orderInfo.getDiscountPrice()) > 0) {
            OrderPay orderPay1 = new OrderPay();
            orderPay1.setOrderNum(orderNum);
            orderPay1.setParkId(parkId);
            orderPay1.setPayStatus(PayStatusConstants.PAID);
            PageQuery<OrderPay> pageQuery = new PageQuery<>();
            pageQuery.setParam(orderPay1);
            List<OrderPay> orderPays = orderPayDao.selectListByPage(pageQuery);
            if (orderPays != null && orderPays.size() > 0) {
                OrderPay orderPay2 = orderPays.get(0);
                orderPayServiceImpl.useDiscount(orderPay2);
            }
        }*/

        ParkConfig parkConfig = paramHolder.getParkConfig();
        asyncHandler(exitRequest, parkId, orderNum, orderInfo, parkConfig, oddStatus);

        //返回
        Map<String, Object> map = new HashMap<>();
        map.put("orderNum", orderNum);
        return ObjectResponse.success(map);
    }
    private boolean isAnyRegionMonthCard(ReportParamHolder paramHolder) {
        List<OrderSonInfo> orderSonInfos = paramHolder.getOrderSonInfos();
        if (CollectionUtils.isEmpty(orderSonInfos)) {
            MonthDetailDto otherRegionMonthDetail = paramHolder.getOtherRegionMonthDetail();
            return MonthDetailDto.MonthType.月卡车.equals(otherRegionMonthDetail.getMonthType())
                    || MonthDetailDto.MonthType.过期月卡车.equals(otherRegionMonthDetail.getMonthType());
        }
        return orderSonInfos.stream().anyMatch(orderSonInfo -> PlateTypeEnum.月卡车.getType().equals(orderSonInfo.getType()));
    }

    private void dealExit(CarExitRequest exitRequest, Integer status, Integer oddStatus, OrderInfo orderInfo, ReportParamHolder paramHolder) {
        Long parkId = exitRequest.getParkId();
        String orderNum = exitRequest.getOrderNum();

        ParkInoutdevice parkInoutdevice = paramHolder.getParkChannel();

        Long regionId = parkInoutdevice.getRegionId();
        ParkRegion parkRegion = parkRegionDao.selectById(regionId);
        AssertTools.notNull(parkRegion, CodeConstants.ERROR_400, CodeConstants.getName(CodeConstants.ERROR_400));

        //主通道处理逻辑
        commonExitFlow(exitRequest, status, oddStatus, parkId, orderNum, orderInfo);
        if (Integer.valueOf(0).equals(orderInfo.getHasSon())) {
            updateRegionFreeSpace(paramHolder,
                    RegionFreeSpaceUpdateVo.builder().regionId(orderInfo.getRegionId()).type(orderInfo.getType()).num(1).build());
            log.info("[主通道离场] 没有子订单，orderNum[{}]", orderNum);
            return;
        }
        //半嵌套主通道
        if (paramHolder.getRegionType() == 2) {
            //脱机补报计费数据
            if (Integer.valueOf(2).equals(exitRequest.getProperty())
                    && CollectionUtils.isNotEmpty(exitRequest.getOtherRegionFee())) {
                offlineHalfNestHandle(exitRequest, paramHolder, orderInfo, parkId, orderNum, regionId);
                return;
            }
            halfNestExit(exitRequest, paramHolder, status, oddStatus, parkId, orderNum, orderInfo, regionId);
        } else {
            //全嵌套主通道
            //脱机补报计费数据
            if (Integer.valueOf(2).equals(exitRequest.getProperty())
                    && CollectionUtils.isNotEmpty(exitRequest.getOtherRegionFee())) {
                offlineFullNestHandle(exitRequest, paramHolder, orderInfo, parkId, orderNum, parkInoutdevice);
                return;
            }
            List<RegionFreeSpaceUpdateVo> freeSpaceUpdateVos = new ArrayList<>();
            //判断是不是内区半嵌套入场
            Long enterRegion = orderInfo.getRegionId();
            if (!enterRegion.equals(regionId)) {
                halfNestExit(exitRequest, paramHolder, status, oddStatus, parkId, orderNum, orderInfo, regionId);
            } else {
                //当前区域的子订单
                OrderSonInfo orderSonInfo = null;
                //外区域对应的子订单
                OrderSonInfo orderSonInfoMain = null;
                OrderSonInfo orderSonInfoParam = new OrderSonInfo();
                orderSonInfoParam.setOrderNum(orderNum);
                orderSonInfoParam.setParkId(parkId);
                List<OrderSonInfo> orderSonInfos = orderSonInfoDao.selectList(orderSonInfoParam);
                paramHolder.setOrderSonInfos(orderSonInfos);
                if (CollectionUtils.isNotEmpty(orderSonInfos)) {
                    Optional<OrderSonInfo> first1 = orderSonInfos.stream()
                            .filter(osi -> !regionId.equals(osi.getRegionId())).findFirst();
                    if (first1.isPresent()) {
                        orderSonInfo = first1.get();
                    }
                    Optional<OrderSonInfo> first2 = orderSonInfos.stream()
                            .filter(osi -> regionId.equals(osi.getRegionId())).findFirst();
                    if (first2.isPresent()) {
                        orderSonInfoMain = first2.get();
                    }
                }
                if (orderSonInfo == null) {
                    log.info("内区子订单不存在, orderNum[{}]", orderNum);
                    return;
                }
                if (orderSonInfoMain == null) {
                    log.info("外区子订单不存在, orderNum[{}]", orderNum);
                    return;
                }
                if (orderSonInfo.getExitTime() == null) {
                    orderSonInfo.setNoneExitFlag(1);
                }
                if (OrderStatusConstants.IN_PARK == orderSonInfo.getServiceStatus()) {
                    orderSonInfo.setServiceStatus(OrderStatusConstants.LEAVED_PARK);
                    if ((PlateTypeEnum.月卡车.getType().equals(orderSonInfo.getType())
                            || PlateTypeEnum.VIP车辆.getType().equals(orderSonInfo.getType()))) {
                        log.info("月卡/vip车内场出口未识别, 补出场时间为外区出场时间, plateNum[{}]", orderSonInfo.getPlateNum());
                        orderSonInfo.setExitTime(exitRequest.getExitTime());
                    } else {
                        orderSonInfo.setExitTime(orderSonInfo.getEnterTime());
                    }
                    orderSonInfo.setTotalPrice("0.00");
                    orderSonInfo.setPaidPrice("0.00");
                    orderSonInfo.setDiscountPrice("0.00");
                    orderSonInfo.setOperAccount(exitRequest.getOperAccount());
                    log.info("出大场-小场出未识别，更新子订单表，子订单信息：{}", orderSonInfo);
                    freeSpaceUpdateVos.add(RegionFreeSpaceUpdateVo.builder()
                            .regionId(orderSonInfo.getRegionId()).type(orderSonInfo.getType()).num(1).build());
                }
                BigDecimal nowPaidPrice = BigDecimal.valueOf(NumberUtils.parseFloat(orderSonInfo.getPaidPrice()));
                BigDecimal nowDiscountPrice = BigDecimal.valueOf(NumberUtils.parseFloat(orderSonInfo.getDiscountPrice()));
                BigDecimal nowTotalPrice = BigDecimal.valueOf(NumberUtils.parseFloat(orderSonInfo.getTotalPrice()));
                BigDecimal nowBalancePrice = BigDecimal.valueOf(NumberUtils.parseFloat(orderSonInfo.getBalancePrice()));

                //如果车辆进过内区，将主订单插入子订单表中以及将主离场记录插入子出入场记录表中
                QueryOrderFeeResponse queryOrderFeeResponse = redisUtils.get("sub:" + orderInfo.getOrderNum(), QueryOrderFeeResponse.class);
                log.info("[端云-车辆离场服务] 小场计费结果：{}", queryOrderFeeResponse);
                boolean noPay = NumberUtils.parseFloat(orderInfo.getTotalPrice()) == 0;
                if (queryOrderFeeResponse == null) {
                    //分账记录
                    orderSonInfoMain.setTotalPrice(noPay ? "0.00" : new BigDecimal(orderInfo.getTotalPrice())
                            .subtract(nowTotalPrice).toString());
                    orderSonInfoMain.setPaidPrice(noPay ? "0.00" : new BigDecimal(orderInfo.getPaidPrice())
                            .subtract(nowPaidPrice).toString());
                    orderSonInfoMain.setDiscountPrice(noPay ? "0.00" : new BigDecimal(orderInfo.getDiscountPrice())
                            .subtract(nowDiscountPrice).toString());
                    if (orderInfo.getBalancePrice() != null) {
                        orderSonInfoMain.setBalancePrice(orderInfo.getBalancePrice().subtract(nowBalancePrice));
                    }
                    orderSonInfoMain.setRegionId(parkInoutdevice.getRegionId());
                    orderSonInfoMain.setOperAccount(exitRequest.getOperAccount());

                    if (noPay) {
                        orderSonInfo.setTotalPrice("0.00");
                        orderSonInfo.setPaidPrice("0.00");
                        orderSonInfo.setDiscountPrice("0.00");
                    }
                    orderSonInfo.setOperAccount(exitRequest.getOperAccount());
                } else {
                    if (noPay) {
                        orderSonInfo.setTotalPrice("0.00");
                        orderSonInfo.setPaidPrice("0.00");
                        orderSonInfo.setDiscountPrice("0.00");
                        orderSonInfo.setOperAccount(exitRequest.getOperAccount());

                        orderSonInfoMain.setTotalPrice("0.00");
                        orderSonInfoMain.setPaidPrice("0.00");
                        orderSonInfoMain.setDiscountPrice("0.00");
                        orderSonInfoMain.setRegionId(parkInoutdevice.getRegionId());
                        orderSonInfoMain.setOperAccount(exitRequest.getOperAccount());

                        redisTemplate.delete("sub:" + orderInfo.getOrderNum());
                        log.info("[端云-车辆离场服务] 使用完毕，清除redis小场计费结果：{}", orderInfo.getOrderNum());
                    } else {
                        //分账记录
                        orderSonInfo.setTotalPrice(queryOrderFeeResponse.getTotalAmount());
                        orderSonInfo.setPaidPrice(NumberUtils.parseFloat(orderInfo.getPaidPrice()) == 0 ? "0.00" :
                                new BigDecimal(queryOrderFeeResponse.getPaidAmount())
                                        .add(new BigDecimal(queryOrderFeeResponse.getUnpayPrice()))
                                        .setScale(2, RoundingMode.HALF_UP).toString());
                        orderSonInfo.setDiscountPrice(new BigDecimal(queryOrderFeeResponse.getDiscountAmount())
                                .add(new BigDecimal(queryOrderFeeResponse.getDiscountPrice())).toString());
                        if (OrderOddStatusEnum.免费放行.getVal().equals(oddStatus)) {
                            orderSonInfo.setPaidPrice(nowPaidPrice.toString());
                            orderSonInfo.setDiscountPrice(new BigDecimal(orderSonInfo.getTotalPrice()).subtract(nowPaidPrice).toString());
                        }
                        orderSonInfo.setOddStatus(oddStatus);
                        if (NumberUtils.parseFloat(orderInfo.getBalancePrice()) > 0) {//储值卡车
                            //@TODO 储值卡支付了一部分，不确定是支付的场内还是场外
                            //储值卡全部支付
                            orderSonInfo.setPaidPrice("0.00");
                            orderSonInfo.setBalancePrice(new BigDecimal(queryOrderFeeResponse.getUnpayPrice()));
                        }
                        //上次支付时间，查询小场费用的时间就是小场支付时间
                        //orderSonInfo.setPrepayTime(queryOrderFeeResponse.getPayTime());
                        orderSonInfo.setOperAccount(exitRequest.getOperAccount());
                        log.debug("orderSonInfo {}", orderSonInfo);

                        BigDecimal sonInfoMainTotalPrice = new BigDecimal(orderInfo.getTotalPrice()).subtract(new BigDecimal(orderSonInfo.getTotalPrice()));
                        orderSonInfoMain.setTotalPrice(sonInfoMainTotalPrice.compareTo(BigDecimal.ZERO) > 0 ? sonInfoMainTotalPrice.toString() : "0.00");

                        BigDecimal sonInfoMainPaidPrice = new BigDecimal(orderInfo.getPaidPrice()).subtract(new BigDecimal(orderSonInfo.getPaidPrice()));
                        orderSonInfoMain.setPaidPrice(sonInfoMainPaidPrice.compareTo(BigDecimal.ZERO) > 0 ? sonInfoMainPaidPrice.toString() : "0.00");

                        BigDecimal sonInfoMainDiscountPrice = new BigDecimal(orderInfo.getDiscountPrice()).subtract(new BigDecimal(orderSonInfo.getDiscountPrice()));
                        orderSonInfoMain.setDiscountPrice(sonInfoMainDiscountPrice.compareTo(BigDecimal.ZERO) > 0 ? sonInfoMainDiscountPrice.toString() : "0.00");
                        if (NumberUtils.parseFloat(orderInfo.getBalancePrice()) > 0) {//储值卡车
                            if (orderSonInfo.getBalancePrice() != null) {
                                orderSonInfoMain.setBalancePrice(orderInfo.getBalancePrice().subtract(orderSonInfo.getBalancePrice()));
                            }
                        }
                        orderSonInfoMain.setRegionId(parkInoutdevice.getRegionId());
                        orderSonInfoMain.setOperAccount(exitRequest.getOperAccount());

                        redisTemplate.delete("sub:" + orderInfo.getOrderNum());
                        log.info("[端云-车辆离场服务] 使用完毕，清除redis小场计费结果：{}", orderInfo.getOrderNum());
                    }
                }
                orderSonInfoMain.setServiceStatus(orderInfo.getServiceStatus());
                orderSonInfoMain.setOddStatus(orderInfo.getOddStatus());
                orderSonInfoMain.setExitTime(orderInfo.getExitTime());
                orderSonInfoService.updateBatchById(Arrays.asList(orderSonInfoMain, orderSonInfo));

                freeSpaceUpdateVos.add(RegionFreeSpaceUpdateVo.builder()
                        .regionId(orderSonInfoMain.getRegionId()).type(orderSonInfoMain.getType()).num(1).build());
                updateRegionFreeSpace(paramHolder, freeSpaceUpdateVos);

                OrderCarInfo carInfo = orderCarInfoDao.selectByOrderNum(orderNum);
                OrderSonCarInfo sonCarInfo = orderSonCarInfoDao.selectByOrderSonId(orderSonInfoMain.getId());

                sonCarInfo.setExitChannelId(carInfo.getExitChannelId());
                sonCarInfo.setExitNo(carInfo.getExitNo());
                sonCarInfo.setExitImage(carInfo.getExitImage());
                sonCarInfo.setExitReliability(carInfo.getExitReliability());
                sonCarInfo.setSmallExitImage(carInfo.getSmallExitImage());
                sonCarInfo.setExitWay(carInfo.getExitWay());
                sonCarInfo.setExitTerminal(carInfo.getExitTerminal());
                sonCarInfo.setExitOperAccount(carInfo.getExitOperAccount());
                sonCarInfo.setExitRemark(carInfo.getExitRemark());
                orderSonCarInfoDao.updateById(sonCarInfo);
                log.info("[离场服务] 主离场记录更新子记录表完成，orderNum：{}", orderNum);
            }
        }
    }

    private void offlineFullNestHandle(CarExitRequest exitRequest, ReportParamHolder paramHolder, OrderInfo orderInfo, Long parkId, String orderNum, ParkInoutdevice parkInoutdevice) {
        List<CarExitRequest.OtherRegionFee> otherRegionFee = exitRequest.getOtherRegionFee();
        int otherRegionTotalPriceSum = 0;
        int otherRegionDiscountPriceSum = 0;
        int otherRegionPaidPriceSum = 0;

        List<OrderSonInfo> orderSonInfos = new ArrayList<>();
        List<RegionFreeSpaceUpdateVo> freeSpaceUpdateVos = new ArrayList<>();
        for (CarExitRequest.OtherRegionFee regionFee : otherRegionFee) {
            otherRegionTotalPriceSum += regionFee.getPaidAmountFen() + regionFee.getDiscountAmountFen();
            otherRegionDiscountPriceSum += regionFee.getDiscountAmountFen();
            otherRegionPaidPriceSum += regionFee.getPaidAmountFen();
            OrderSonInfo orderSonInfo = new OrderSonInfo();
            orderSonInfo.setOrderNum(orderNum);
            orderSonInfo.setParkId(parkId);
            orderSonInfo.setRegionId(regionFee.getRegionId());
            orderSonInfo = orderSonInfoDao.selectOneByEntity(orderSonInfo);
            if (orderSonInfo == null) {
                log.warn("[端云脱机离场-小场分账] 子订单记录不存在, regionId[" + regionFee.getRegionId() + "]");
                continue;
            }

            BigDecimal nowPaidPrice = BigDecimal.valueOf(NumberUtils.parseFloat(orderSonInfo.getPaidPrice()));
            BigDecimal nowDiscountPrice = BigDecimal.valueOf(NumberUtils.parseFloat(orderSonInfo.getDiscountPrice()));
            BigDecimal nowTotalPrice = BigDecimal.valueOf(NumberUtils.parseFloat(orderSonInfo.getTotalPrice()));

            orderSonInfo.setServiceStatus(OrderStatusConstants.LEAVED_PARK);
            orderSonInfo.setTotalPrice(nowTotalPrice.add(BigDecimal.valueOf((regionFee.getPaidAmountFen() + regionFee.getDiscountAmountFen()) / 100.00)).toString());
            orderSonInfo.setPaidPrice(nowPaidPrice.add(BigDecimal.valueOf(regionFee.getPaidAmountFen() / 100.00)).toString());
            orderSonInfo.setDiscountPrice(nowDiscountPrice.add(BigDecimal.valueOf(regionFee.getDiscountAmountFen() / 100.00)).toString());
            orderSonInfoDao.updateByOrderNumAndRegionId(orderSonInfo);
            orderSonInfos.add(orderSonInfo);
            log.info("[端云脱机离场-小场分账] 更新子订单信息[{}]", orderSonInfo);
            freeSpaceUpdateVos.add(RegionFreeSpaceUpdateVo.builder()
                    .regionId(orderSonInfo.getRegionId()).type(orderSonInfo.getType()).num(1).build());
        }

        OrderSonInfo orderSonInfo = new OrderSonInfo();
        orderSonInfo.setOrderNum(orderNum);
        orderSonInfo.setParkId(parkId);
        orderSonInfo.setRegionId(parkInoutdevice.getRegionId());
        OrderSonInfo orderSonInfoMain = orderSonInfoDao.selectOneByEntity(orderSonInfo);
        orderSonInfoMain.setTotalPrice(new BigDecimal(orderInfo.getTotalPrice()).subtract(new BigDecimal(otherRegionTotalPriceSum / 100.0)).toString());
        orderSonInfoMain.setPaidPrice(new BigDecimal(orderInfo.getPaidPrice()).subtract(new BigDecimal(otherRegionPaidPriceSum / 100.0)).toString());
        orderSonInfoMain.setDiscountPrice(new BigDecimal(orderInfo.getDiscountPrice()).subtract(new BigDecimal(otherRegionDiscountPriceSum / 100.0)).toString());
        orderSonInfoMain.setRegionId(parkInoutdevice.getRegionId());
        orderSonInfoDao.updateById(orderSonInfoMain);
        orderSonInfos.add(orderSonInfoMain);
        paramHolder.setOrderSonInfos(orderSonInfos);

        updateRegionFreeSpace(paramHolder, freeSpaceUpdateVos);
        log.info("[端云脱机离场-小场分账] 插入子订单表的主订单信息[{}]", orderSonInfoMain);

        //如果车辆进过内区，主离场记录---->子出入场记录表
        OrderCarInfo carInfo = orderCarInfoDao.selectByOrderNum(orderNum);
        OrderSonCarInfo sonCarInfo = orderSonCarInfoDao.selectByOrderSonId(orderSonInfoMain.getId());

        sonCarInfo.setExitChannelId(carInfo.getExitChannelId());
        sonCarInfo.setExitNo(carInfo.getExitNo());
        sonCarInfo.setExitImage(carInfo.getExitImage());
        sonCarInfo.setExitReliability(carInfo.getExitReliability());
        sonCarInfo.setSmallExitImage(carInfo.getSmallExitImage());
        sonCarInfo.setExitWay(carInfo.getExitWay());
        sonCarInfo.setExitTerminal(carInfo.getExitTerminal());
        sonCarInfo.setExitOperAccount(carInfo.getExitOperAccount());
        sonCarInfo.setExitRemark(carInfo.getExitRemark());
        orderSonCarInfoDao.updateById(sonCarInfo);
        log.info("[离场服务] 主离场记录更新子记录表完成，orderNum：{}", orderNum);
    }

    private void offlineHalfNestHandle(CarExitRequest exitRequest, ReportParamHolder paramHolder, OrderInfo orderInfo, Long parkId, String orderNum, Long regionId) {
        int otherRegionTotalPriceSum = 0;
        int otherRegionDiscountPriceSum = 0;
        int otherRegionPaidPriceSum = 0;
        List<CarExitRequest.OtherRegionFee> otherRegionFee = exitRequest.getOtherRegionFee();
        for (CarExitRequest.OtherRegionFee regionFee : otherRegionFee) {
            otherRegionTotalPriceSum += regionFee.getPaidAmountFen() + regionFee.getDiscountAmountFen();
            otherRegionDiscountPriceSum += regionFee.getDiscountAmountFen();
            otherRegionPaidPriceSum += regionFee.getPaidAmountFen();
        }
        List<RegionFreeSpaceUpdateVo> freeSpaceUpdateVos = new ArrayList<>();
        OrderSonInfo orderSonInfo = new OrderSonInfo();
        orderSonInfo.setOrderNum(orderNum);
        orderSonInfo.setParkId(parkId);
        orderSonInfo.setRegionId(regionId);
        orderSonInfo = orderSonInfoDao.selectOneByEntity(orderSonInfo);
        OrderSonCarInfo sonCarInfo;
        if (orderSonInfo == null) {
            orderSonInfo = new OrderSonInfo();
            BeanUtils.copyProperties(exitRequest, orderSonInfo);
            orderSonInfo.setEnterTime(exitRequest.getExitTime());
            orderSonInfo.setOrderNum(orderNum);
            orderSonInfo.setRegionId(regionId);
            log.info("[端云-子通道离场服务] 补-子订单数据：{}", exitRequest.getPlateNum());

            sonCarInfo = new OrderSonCarInfo();
            BeanUtils.copyProperties(exitRequest, sonCarInfo);
            log.info("[端云-子通道离场服务] 补-子订单车辆数据：{}", exitRequest.getPlateNum());

            orderInfo.setHasSon(1);
            orderInfo.setOperAccount(exitRequest.getOperAccount());
            orderInfoDao.updateByOrderNum(orderInfo);
            log.info("[端云-子通道离场服务] 补-主订单更新为hasSon字段为1：{}", exitRequest.getPlateNum());
            log.warn("未查询到子订单, orderNum[{}], regionId[{}]", orderNum, regionId);
        } else {
            sonCarInfo = orderSonCarInfoDao.selectByOrderSonId(orderSonInfo.getId());

            freeSpaceUpdateVos.add(RegionFreeSpaceUpdateVo.builder()
                    .regionId(orderSonInfo.getRegionId()).type(orderSonInfo.getType()).num(1).build());
        }
        BigDecimal nowPaidPrice = BigDecimal.valueOf(NumberUtils.parseFloat(orderSonInfo.getPaidPrice()));
        BigDecimal nowDiscountPrice = BigDecimal.valueOf(NumberUtils.parseFloat(orderSonInfo.getDiscountPrice()));
        BigDecimal nowTotalPrice = BigDecimal.valueOf(NumberUtils.parseFloat(orderSonInfo.getTotalPrice()));

        orderSonInfo.setServiceStatus(OrderStatusConstants.LEAVED_PARK);
        orderSonInfo.setTotalPrice(nowTotalPrice.add(new BigDecimal(orderInfo.getTotalPrice()).subtract(BigDecimal.valueOf(otherRegionTotalPriceSum / 100.00))).toString());
        orderSonInfo.setPaidPrice(nowPaidPrice.add(new BigDecimal(orderInfo.getPaidPrice()).subtract(BigDecimal.valueOf(otherRegionPaidPriceSum / 100.00))).toString());
        orderSonInfo.setDiscountPrice(nowDiscountPrice.add(new BigDecimal(orderInfo.getPaidPrice()).subtract(BigDecimal.valueOf(otherRegionDiscountPriceSum / 100.00))).toString());

        // 填充子订单车辆信息
        sonCarInfo.setExitImage(exitRequest.getMaxImage());
        sonCarInfo.setSmallExitImage(exitRequest.getSmallImage());
        sonCarInfo.setExitNo(exitRequest.getInandoutName());
        sonCarInfo.setExitChannelId(exitRequest.getInandoutCode());
        sonCarInfo.setExitReliability(exitRequest.getReliability());
        sonCarInfo.setExitWay(exitRequest.getExitWay());
        sonCarInfo.setExitTerminal(exitRequest.getExitTerminal());
        sonCarInfo.setExitOperAccount(exitRequest.getOperAccount());
        sonCarInfo.setExitRemark(exitRequest.getExitRemark());

        if (orderSonInfo.getId() == null) {
            orderSonInfo.setNoneEnterFlag(1);
            orderSonInfoDao.insertWithPlateNum2(orderSonInfo);
            sonCarInfo.setOrderSonId(orderSonInfo.getId());
            orderSonCarInfoDao.insert(sonCarInfo);
            log.info("[端云-离场服务] 补-子订单及车辆信息新增完成: {} - {}", orderSonInfo.getId(), sonCarInfo.getId());
        } else {
            orderSonInfoDao.updateById(orderSonInfo);
            orderSonCarInfoDao.updateById(sonCarInfo);
            log.info("[端云-离场服务] 修改子订单及车辆信息完成: {} - {}", orderSonInfo.getId(), sonCarInfo.getId());
            //发送MQ消息，同步给其他相机
            //pushService.pushOrderSonExit(orderSonInfo);
        }
        updateRegionFreeSpace(paramHolder, freeSpaceUpdateVos);
        if (Boolean.TRUE.equals(redisTemplate.hasKey("sub:" + orderSonInfo.getOrderNum()))) {
            redisTemplate.delete("sub:" + orderSonInfo.getOrderNum());
            log.info("[端云-小场离场服务] 使用完毕，清除redis小场计费结果：{}", orderSonInfo.getOrderNum());
        }
    }

    private void halfNestExit(CarExitRequest exitRequest, ReportParamHolder paramHolder, Integer status, Integer oddStatus,
                              Long parkId, String orderNum, OrderInfo orderInfo, Long regionId) {
        OrderSonInfo orderSonInfoMain = null;
        OrderSonInfo orderSonInfo = null;
        OrderSonInfo orderSonInfoParam = new OrderSonInfo();
        orderSonInfoParam.setOrderNum(orderNum);
        orderSonInfoParam.setParkId(parkId);
        List<OrderSonInfo> orderSonInfos = orderSonInfoDao.selectList(orderSonInfoParam);
        paramHolder.setOrderSonInfos(orderSonInfos);
        if (CollectionUtils.isNotEmpty(orderSonInfos)) {
            Optional<OrderSonInfo> first1 = orderSonInfos.stream()
                    .filter(osi -> orderInfo.getRegionId().equals(osi.getRegionId())).findFirst();
            if (first1.isPresent()) {
                orderSonInfoMain = first1.get();
            }
            Optional<OrderSonInfo> first2 = orderSonInfos.stream()
                    .filter(osi -> !orderInfo.getRegionId().equals(osi.getRegionId())).findFirst();
            if (first2.isPresent()) {
                orderSonInfo = first2.get();
            }
        }
        if (orderSonInfoMain == null) {
            log.info("子订单不存在, orderNum[{}], regionId[{}]", orderNum, regionId);
            return;
        }
        if (orderSonInfo == null) {
            log.info("子订单不存在, orderNum[{}], regionId[{}]", orderNum, regionId);
            return;
        }
        orderSonInfo.setExitTime(exitRequest.getExitTime());
        //内区直入、出内区、内区入未识别、直出内区
        if (regionId.equals(orderSonInfoMain.getRegionId()) && OrderStatusConstants.IN_PARK == orderSonInfo.getServiceStatus()) {
            orderSonInfo.setExitTime(orderSonInfo.getEnterTime());
            log.info("出大场-小场出未识别，使用入场时间作为出场时间：{}", orderSonInfo);
        }
        orderSonInfo.setServiceStatus(status);
        orderSonInfo.setOddStatus(oddStatus);
        BigDecimal nowPaidPrice = BigDecimal.valueOf(NumberUtils.parseFloat(orderSonInfo.getPaidPrice()));
        BigDecimal nowDiscountPrice = BigDecimal.valueOf(NumberUtils.parseFloat(orderSonInfo.getDiscountPrice()));
        BigDecimal nowTotalPrice = BigDecimal.valueOf(NumberUtils.parseFloat(orderSonInfo.getTotalPrice()));
        BigDecimal nowBalancePrice = BigDecimal.valueOf(NumberUtils.parseFloat(orderSonInfo.getBalancePrice()));

        //如果车辆进过内区，将主订单插入子订单表中以及将主离场记录插入子出入场记录表中
        QueryOrderFeeResponse queryOrderFeeResponse = redisUtils.get("sub:" + orderInfo.getOrderNum(), QueryOrderFeeResponse.class);
        log.info("[端云-车辆离场服务] 小场计费结果：{}", queryOrderFeeResponse);

        orderSonInfoMain.setServiceStatus(status);
        orderSonInfoMain.setOddStatus(oddStatus);
        orderSonInfoMain.setExitTime(exitRequest.getExitTime());

        List<RegionFreeSpaceUpdateVo> freeSpaceUpdateVos = new ArrayList<>();

        freeSpaceUpdateVos.add(RegionFreeSpaceUpdateVo.builder().num(1)
                .regionId(regionId).type(orderSonInfos.stream()
                        .filter(osi -> regionId.equals(osi.getRegionId())).findFirst().map(OrderSonInfo::getType)
                        .orElse(null)).build());
        boolean noPay = NumberUtils.parseFloat(orderInfo.getTotalPrice()) == 0;
        if (queryOrderFeeResponse == null) {
            //分账记录
            orderSonInfoMain.setTotalPrice(noPay ? "0.00" : new BigDecimal(orderInfo.getTotalPrice())
                    .subtract(nowTotalPrice).toString());
            orderSonInfoMain.setPaidPrice(noPay ? "0.00" : new BigDecimal(orderInfo.getPaidPrice())
                    .subtract(nowPaidPrice).toString());
            orderSonInfoMain.setDiscountPrice(noPay ? "0.00" : new BigDecimal(orderInfo.getDiscountPrice())
                    .subtract(nowDiscountPrice).toString());
            if (orderInfo.getBalancePrice() != null) {
                orderSonInfoMain.setBalancePrice(orderInfo.getBalancePrice().subtract(nowBalancePrice));
            }
            orderSonInfoMain.setOperAccount(exitRequest.getOperAccount());
            orderSonInfoDao.updateById(orderSonInfoMain);

            if (!orderSonInfoMain.getId().equals(orderSonInfo.getId())) {
                orderSonInfo.setTotalPrice(noPay ? "0.00" : nowTotalPrice.toString());
                orderSonInfo.setPaidPrice(noPay ? "0.00" : nowPaidPrice.toString());
                orderSonInfo.setDiscountPrice(noPay ? "0.00" : nowDiscountPrice.toString());
                orderSonInfo.setOperAccount(exitRequest.getOperAccount());
                orderSonInfoDao.updateById(orderSonInfo);
                log.info("更新子订单表，子订单id：{}", orderSonInfo.getId());
            }
        } else {
            if (noPay) {
                orderSonInfo.setTotalPrice("0.00");
                orderSonInfo.setPaidPrice("0.00");
                orderSonInfo.setDiscountPrice("0.00");
                orderSonInfo.setOperAccount(exitRequest.getOperAccount());
                orderSonInfoDao.updateById(orderSonInfo);

                orderSonInfoMain.setTotalPrice("0.00");
                orderSonInfoMain.setPaidPrice("0.00");
                orderSonInfoMain.setDiscountPrice("0.00");
                orderSonInfoMain.setOperAccount(exitRequest.getOperAccount());
                orderSonInfoDao.updateById(orderSonInfoMain);

                redisTemplate.delete("sub:" + orderInfo.getOrderNum());
                log.info("[端云-车辆离场服务] 使用完毕，清除redis小场计费结果：{}", orderInfo.getOrderNum());
            } else {
                //分账记录
                orderSonInfo.setTotalPrice(queryOrderFeeResponse.getTotalAmount());
                orderSonInfo.setPaidPrice(NumberUtils.parseFloat(orderInfo.getPaidPrice()) == 0 ? "0.00" :
                        new BigDecimal(queryOrderFeeResponse.getPaidAmount())
                        .add(new BigDecimal(queryOrderFeeResponse.getUnpayPrice()))
                        .setScale(2, RoundingMode.HALF_UP).toString());
                orderSonInfo.setDiscountPrice(new BigDecimal(queryOrderFeeResponse.getDiscountAmount())
                        .add(new BigDecimal(queryOrderFeeResponse.getDiscountPrice()))
                        .setScale(2, RoundingMode.HALF_UP).toString());
                if (OrderOddStatusEnum.免费放行.getVal().equals(oddStatus)) {
                    orderSonInfo.setPaidPrice(nowPaidPrice.toString());
                    orderSonInfo.setDiscountPrice(new BigDecimal(orderSonInfo.getTotalPrice()).subtract(nowPaidPrice).toString());
                }
                orderSonInfo.setOddStatus(oddStatus);
                if (NumberUtils.parseFloat(orderInfo.getBalancePrice()) > 0) {//储值卡车
                    //@TODO 储值卡支付了一部分，不确定是支付的场内还是场外
                    //储值卡全部支付
                    orderSonInfo.setPaidPrice("0.00");
                    orderSonInfo.setBalancePrice(new BigDecimal(queryOrderFeeResponse.getUnpayPrice()));
                }
                //上次支付时间，查询小场费用的时间就是小场支付时间
                //orderSonInfo.setPrepayTime(queryOrderFeeResponse.getQueryTime());
                orderSonInfo.setOperAccount(exitRequest.getOperAccount());
                orderSonInfoDao.updateById(orderSonInfo);

                BigDecimal sonInfoMainTotalPrice = new BigDecimal(orderInfo.getTotalPrice()).subtract(new BigDecimal(orderSonInfo.getTotalPrice()));
                orderSonInfoMain.setTotalPrice(sonInfoMainTotalPrice.compareTo(BigDecimal.ZERO) > 0 ? sonInfoMainTotalPrice.toString() : "0.00");

                BigDecimal sonInfoMainPaidPrice = new BigDecimal(orderInfo.getPaidPrice()).subtract(new BigDecimal(orderSonInfo.getPaidPrice()));
                orderSonInfoMain.setPaidPrice(sonInfoMainPaidPrice.compareTo(BigDecimal.ZERO) > 0 ? sonInfoMainPaidPrice.toString() : "0.00");

                BigDecimal sonInfoMainDiscountPrice = new BigDecimal(orderInfo.getDiscountPrice()).subtract(new BigDecimal(orderSonInfo.getDiscountPrice()));
                orderSonInfoMain.setDiscountPrice(sonInfoMainDiscountPrice.compareTo(BigDecimal.ZERO) > 0 ? sonInfoMainDiscountPrice.toString() : "0.00");
                if (NumberUtils.parseFloat(orderInfo.getBalancePrice()) > 0) {//储值卡车
                    if (orderSonInfo.getBalancePrice() != null) {
                        orderSonInfoMain.setBalancePrice(orderInfo.getBalancePrice().subtract(orderSonInfo.getBalancePrice()));
                    }
                }
                orderSonInfoMain.setOperAccount(exitRequest.getOperAccount());
                orderSonInfoDao.updateById(orderSonInfoMain);

                redisTemplate.delete("sub:" + orderInfo.getOrderNum());
                log.info("[端云-车辆离场服务] 使用完毕，清除redis小场计费结果：{}", orderInfo.getOrderNum());
            }
        }
        updateRegionFreeSpace(paramHolder, freeSpaceUpdateVos);

        OrderSonCarInfo sonCarInfoMain = orderSonCarInfoDao.selectByOrderSonId(orderSonInfoMain.getId());
        if (sonCarInfoMain != null) {
            sonCarInfoMain.setExitChannelId(exitRequest.getInandoutCode());
            sonCarInfoMain.setExitNo(exitRequest.getInandoutName());
            sonCarInfoMain.setExitImage(exitRequest.getMaxImage());
            sonCarInfoMain.setSmallExitImage(exitRequest.getSmallImage());

            sonCarInfoMain.setExitWay(exitRequest.getExitWay());
            sonCarInfoMain.setExitTerminal(exitRequest.getExitTerminal());
            sonCarInfoMain.setExitOperAccount(exitRequest.getOperAccount());
            sonCarInfoMain.setExitRemark(exitRequest.getExitRemark());
            orderSonCarInfoDao.updateById(sonCarInfoMain);
            log.info("[离场服务] 更新子订单信息表完成，sonCarInfo：{}", sonCarInfoMain);
        }
        OrderSonCarInfo sonCarInfo = orderSonCarInfoDao.selectByOrderSonId(orderSonInfo.getId());
        if (sonCarInfo != null) {
            sonCarInfo.setExitChannelId(exitRequest.getInandoutCode());
            sonCarInfo.setExitNo(exitRequest.getInandoutName());
            sonCarInfo.setExitImage(exitRequest.getMaxImage());
            sonCarInfo.setSmallExitImage(exitRequest.getSmallImage());

            sonCarInfo.setExitWay(exitRequest.getExitWay());
            sonCarInfo.setExitTerminal(exitRequest.getExitTerminal());
            sonCarInfo.setExitOperAccount(exitRequest.getOperAccount());
            sonCarInfo.setExitRemark(exitRequest.getExitRemark());
            orderSonCarInfoDao.updateById(sonCarInfo);
            log.info("[离场服务] 更新子订单信息表完成，sonCarInfo2：{}", sonCarInfo);
        }
        exitRequest.setType(orderSonInfo.getType());
    }

}
