package com.icetech.park.service.order.impl.exit;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.icetech.basics.dao.park.ParkRegionDao;
import com.icetech.basics.domain.entity.park.ParkConfig;
import com.icetech.basics.domain.entity.park.ParkInoutdevice;
import com.icetech.basics.service.redis.RedisMsgListener;
import com.icetech.cloudcenter.api.constants.MqConstants;
import com.icetech.cloudcenter.api.order.CarOrderExitService;
import com.icetech.cloudcenter.api.order.OrderService;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.cloudcenter.domain.charge.dto.OrderSumFeeDto;
import com.icetech.cloudcenter.domain.enumeration.OrderOddStatusEnum;
import com.icetech.cloudcenter.domain.request.CarExitRequest;
import com.icetech.cloudcenter.domain.vo.ApplyCarVideoVo;
import com.icetech.cloudcenter.domain.websocket.WebsocketPushData;
import com.icetech.common.constants.CodeConstants;
import com.icetech.common.constants.OrderCarInfoConstant;
import com.icetech.common.constants.OrderStatusConstants;
import com.icetech.common.constants.PayStatusConstants;
import com.icetech.common.constants.PlateTypeEnum;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.thread.ThreadUtils;
import com.icetech.common.utils.AssertTools;
import com.icetech.common.utils.CodeTools;
import com.icetech.common.utils.JsonUtils;
import com.icetech.common.utils.NumberUtils;
import com.icetech.common.utils.StringUtils;
import com.icetech.mq.sender.RabbitSender;
import com.icetech.order.dao.OrderCarInfoDao;
import com.icetech.order.dao.OrderPayDao;
import com.icetech.order.dao.OrderTrackMapper;
import com.icetech.order.domain.entity.OrderCarInfo;
import com.icetech.order.domain.entity.OrderInfo;
import com.icetech.order.domain.entity.OrderNotpay;
import com.icetech.order.domain.entity.OrderPay;
import com.icetech.order.domain.entity.OrderSonInfo;
import com.icetech.order.domain.entity.OrderTrack;
import com.icetech.order.service.OrderNotpayService;
import com.icetech.park.dao.other.ChannelAlarmDao;
import com.icetech.park.dao.park.ParkFreespaceDao;
import com.icetech.park.dao.park.ParkVisitDao;
import com.icetech.park.domain.entity.ChannelAlarm;
import com.icetech.park.domain.entity.park.ParkVisit;
import com.icetech.park.domain.vo.RegionFreeSpaceUpdateVo;
import com.icetech.park.service.handle.MorCacheHandle;
import com.icetech.park.service.report.ReportParamHolder;
import com.icetech.third.service.third.MqPushService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.http.util.TextUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.data.redis.core.StringRedisTemplate;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.stream.Collectors;
import java.util.stream.Stream;

import static com.icetech.common.constants.OrderCarInfoConstant.IN_OUT_WAY_SOFTWARE_MANUAL;

@Slf4j
@RefreshScope
public class CommonExitImpl implements CarOrderExitService {
    @Resource
    protected OrderService orderService;
    @Resource
    protected OrderCarInfoDao orderCarInfoDao;
    @Autowired
    protected StringRedisTemplate redisTemplate;
    @Autowired
    protected OrderPayDao orderPayDao;
    @Autowired
    protected ParkVisitDao parkVisitDao;
    @Autowired
    protected ChannelAlarmDao channelAlarmDao;
    @Autowired
    protected ThreadPoolExecutor asyncExecutor;
    @Autowired
    protected OrderTrackMapper orderTrackMapper;
    @Autowired
    protected MqPushService mqPushService;
    @Autowired
    protected ParkRegionDao parkRegionDao;
    @Autowired
    protected OrderNotpayService orderNotpayService;
    @Autowired
    protected ParkService parkService;
    @Resource
    private MorCacheHandle morCacheHandle;
    @Resource
    private ParkFreespaceDao parkFreespaceDao;
    @Resource
    private RabbitSender rabbitSender;
    @Value("${aisle.applyCarVideo.time:30}")
    private Integer aisleApplyCarVideoTime;
    @Value("${notpay.tag.days:7}")
    private Integer notPayTagDaysConfig = 7;

    protected void commonExitFlow(CarExitRequest exitRequest, Integer status, Integer oddStatus,
                                  Long parkId, String orderNum, OrderInfo orderInfo) {
        // 修改订单状态为离场
        orderInfo.setServiceStatus(status);
        orderInfo.setExitTime(exitRequest.getExitTime());
        orderInfo.setOddStatus(oddStatus);
        // 重新设置车辆类型
        orderInfo.setType(exitRequest.getType());
        orderInfo.setOperAccount(exitRequest.getOperAccount());
        orderInfo.setCarType(exitRequest.getCarType());

        if (OrderStatusConstants.LEAVED_PARK == status){
            if (exitRequest.getIsAfterPay() != null && exitRequest.getIsAfterPay() == 1) {  // 先离场后付费
                orderInfo.setTotalPrice(StringUtils.isBlank(exitRequest.getTotalAmount()) ? "0.00" : exitRequest.getTotalAmount());
                orderInfo.setPaidPrice(StringUtils.isBlank(exitRequest.getPaidAmount()) ? "0.00" : exitRequest.getPaidAmount());
                orderInfo.setDiscountPrice(StringUtils.isBlank(exitRequest.getDiscountAmount()) ? "0.00" : exitRequest.getDiscountAmount());
                orderInfo.setCityAutopay(1);
                orderInfo.setNeedPrice(StringUtils.isBlank(exitRequest.getUnpayPrice()) ? "0.00" : exitRequest.getUnpayPrice());
            } else {
                // 正常离场时，汇总平台数据
                OrderPay orderPay = new OrderPay();
                orderPay.setParkId(parkId);
                orderPay.setOrderNum(orderNum);
                OrderSumFeeDto orderSumFeeDto = orderPayDao.sumFee(orderPay);
                if (orderSumFeeDto != null){
                    orderInfo.setTotalPrice(String.valueOf(orderSumFeeDto.getTotalPrice()));
                    orderInfo.setPaidPrice(String.valueOf(orderSumFeeDto.getPaidPrice()));
                    orderInfo.setDiscountPrice(String.valueOf(orderSumFeeDto.getDiscountPrice()));
                }else{
                    if (Integer.valueOf(2).equals(exitRequest.getProperty())
                            && NumberUtils.toPrimitive(exitRequest.getPaidAmountFen()) > 0) {
                        OrderPay orderPay1 = new OrderPay();
                        orderPay1.setOrderNum(orderNum);
                        orderPay1.setTradeNo(CodeTools.GenerateTradeNo());
                        orderPay1.setPayStatus(PayStatusConstants.PAID);
                        orderPay1.setParkId(parkId);

                        //支付类型，遥控器开闸
                        orderPay1.setPayChannel(10);
                        //支付终端
                        orderPay1.setPayTerminal(exitRequest.getInandoutName());
                        //支付方式
                        orderPay1.setPayWay(1);
                        orderPay1.setChannelId(exitRequest.getInandoutCode());
                        orderPay1.setBalancePrice(new BigDecimal("0.00"));
                        orderPay1.setOrderTime(exitRequest.getExitTime());
                        orderPay1.setPayTime(exitRequest.getExitTime());
                        orderPay1.setPaidPrice(NumberUtils.parseString(exitRequest.getPaidAmountFen() / 100.00, "#.00"));
                        orderPay1.setTotalPrice(NumberUtils.parseString(
                                (exitRequest.getPaidAmountFen() + NumberUtils.toPrimitive(exitRequest.getDiscountAmountFen())) / 100.00,
                                "#.00"));
                        orderPay1.setDiscountPrice("0.00");
                        orderPay1.setIsSync(0);
                        orderPayDao.insert(orderPay1);

                        orderInfo.setPaidPrice(orderPay1.getPaidPrice());
                        orderInfo.setDiscountPrice(orderPay1.getDiscountPrice());
                        orderInfo.setTotalPrice(orderPay1.getTotalPrice());
                    } else {
                        orderInfo.setTotalPrice("0.00");
                        orderInfo.setPaidPrice("0.00");
                        orderInfo.setDiscountPrice("0.00");
                    }
                }
            }
        } else {
            log.info("[端云-离场服务] 异常离场修改费用，orderNum：{}, totalAmount：{}", orderNum, exitRequest.getTotalAmount());
            // 异常离场时，以查询待缴费为准
            if (StringUtils.isBlank(exitRequest.getTotalAmount())){
                // 正常离场时，汇总平台数据
                OrderPay orderPay = new OrderPay();
                orderPay.setParkId(parkId);
                orderPay.setOrderNum(orderNum);
                OrderSumFeeDto orderSumFeeDto = orderPayDao.sumFee(orderPay);
                if (orderSumFeeDto != null){
                    orderInfo.setTotalPrice(String.valueOf(orderSumFeeDto.getTotalPrice()));
                    orderInfo.setPaidPrice(String.valueOf(orderSumFeeDto.getPaidPrice()));
                    orderInfo.setDiscountPrice(String.valueOf(orderSumFeeDto.getDiscountPrice()));
                } else {
                    orderInfo.setTotalPrice("0.00");
                    orderInfo.setPaidPrice("0.00");
                    orderInfo.setDiscountPrice("0.00");
                }
            } else {
                orderInfo.setTotalPrice(exitRequest.getTotalAmount());
                orderInfo.setPaidPrice(exitRequest.getPaidAmount());
                orderInfo.setDiscountPrice(exitRequest.getDiscountAmount());
            }
        }
        orderInfo.setExitChannelId(exitRequest.getInandoutCode());
        orderService.updateOrderWithPush(orderInfo);
        log.info("[端云-离场服务] 修改订单主信息完成，orderNum：{}", orderNum);
        exitRequest.setPaidAmount(orderInfo.getPaidPrice());

        // 先查询订单号是否存在，再插入记录
        OrderCarInfo carInfo = orderCarInfoDao.selectByOrderNum(orderNum);
        AssertTools.notNull(carInfo, CodeConstants.ERROR, "平台订单数据不完整");
        BeanUtils.copyProperties(exitRequest, carInfo);
        carInfo.setExitChannelId(exitRequest.getInandoutCode());
        carInfo.setExitNo(exitRequest.getInandoutName());
        carInfo.setExitImage(exitRequest.getMaxImage());
        carInfo.setSmallExitImage(exitRequest.getSmallImage());
        carInfo.setExitReliability(exitRequest.getReliability());
        carInfo.setExitOperAccount(exitRequest.getOperAccount());
        carInfo.setExitRemark(exitRequest.getExitRemark());
        orderCarInfoDao.updateById(carInfo);
        log.info("[端云-离场服务] 更新订单车辆表完成，orderNum：{}", orderNum);
    }

    protected void asyncHandler(CarExitRequest exitRequest, Long parkId, String orderNum, OrderInfo orderInfo, ParkConfig parkConfig, Integer oddStatus) {
        asyncExecutor.execute(ThreadUtils.wrapTrace(() -> {
            //欠费追缴处理
            notPayHandle(exitRequest, parkId, orderNum, orderInfo, oddStatus, parkConfig);

            log.info("sendWebsocketMessage > {} {}", orderInfo, exitRequest.getPaidAmount());
            exitRequest.setOpenFlag(1);
            exitRequest.setUnpayPrice(orderInfo.getPaidPrice());
            exitRequest.setPaidAmount(orderInfo.getPaidPrice());
            sendWebsocketMessage(exitRequest, (null != orderInfo.getPaidPrice() && !"0.00".equals(orderInfo.getPaidPrice()))
                    ? "5" : "2", 1, (null != orderInfo.getPaidPrice() && !"0.00".equals(orderInfo.getPaidPrice())) ? 0 : 1);

            //更新访客预约订单状态
            ParkVisit parkVisit = parkVisitDao.selectVisitByParkidPlate(parkId, orderInfo.getPlateNum(),
                    new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
            if (parkVisit != null && exitRequest.getType().equals(PlateTypeEnum.访客车辆.getType())) {
                parkVisit.setVisitStatus(3);
                parkVisit.setOrderNum(orderNum);
                parkVisit.setExitTime(Math.toIntExact(exitRequest.getExitTime()));
                parkVisitDao.updateVisit(parkVisit);
                log.info("[端云-离场服务] 更新访客预约表完成，orderId：{}", orderInfo.getId());
            }
            // 更新通道的报警记录为已处理
            if (exitRequest.getInandoutCode() != null) {
                ChannelAlarm channelAlarm = new ChannelAlarm();
                channelAlarm.setParkId(parkId);
                channelAlarm.setChannelCode(exitRequest.getInandoutCode());
                channelAlarm.setStatus(ChannelAlarm.Status.已处理.getStatus());
                channelAlarmDao.update(channelAlarm);
            }
        }));
    }

    private void notPayHandle(CarExitRequest exitRequest, Long parkId, String orderNum, OrderInfo orderInfo, Integer oddStatus, ParkConfig parkConfig) {
        if (Boolean.TRUE.equals(exitRequest.getFuzzyOrder())) {
            log.info("[端云-离场服务] 模糊匹配订单不算欠费[{}]", exitRequest);
            return;
        }
        //欠费订单记录
        if (Integer.valueOf(0).equals(orderInfo.getCityAutopay())) {
            BigDecimal totalPrice = NumberUtils.parseDecimal(orderInfo.getTotalPrice());
            BigDecimal paidPrice = NumberUtils.parseDecimal(orderInfo.getPaidPrice());
            BigDecimal discountPrice = NumberUtils.parseDecimal(orderInfo.getDiscountPrice());
            BigDecimal balancePrice = NumberUtils.parseDecimal(orderInfo.getBalancePrice());
            //不是遥控器、人工操作开闸 并且 应收大于 应缴费+优惠 时，认为欠费
            int[] excludeExitWays = {OrderCarInfoConstant.IN_OUT_WAY_REMOTE_CONTROL, OrderCarInfoConstant.IN_OUT_WAY_SOFTWARE_MANUAL};
            int notPayTagDays = NumberUtils.toPrimitive(parkConfig.getNotpayTagDays(), notPayTagDaysConfig);
            if (!ArrayUtils.contains(excludeExitWays, exitRequest.getExitWay())
                    && OrderOddStatusEnum.非正常出场.getVal().equals(oddStatus)
                    && totalPrice.compareTo(paidPrice.add(discountPrice).add(balancePrice)) > 0
                    && (exitRequest.getExitTime() - orderInfo.getEnterTime()) <= (long) notPayTagDays * 3600 * 24) {
                log.info("[端云-离场服务] 当前为欠费订单[{}]", exitRequest);
                String videoId = CodeTools.getCharAndNumr(16);
                Long channelId = null;
                if (exitRequest.getInandoutCode() != null) {
                    ObjectResponse<ParkInoutdevice> inoutDeviceByCode =
                            parkService.getInoutDeviceByCode(exitRequest.getInandoutCode());
                    if (ObjectResponse.isSuccess(inoutDeviceByCode)) {
                        channelId = inoutDeviceByCode.getData().getId();
                    }
                }
                BigDecimal notPayPrice = totalPrice.subtract(paidPrice).subtract(discountPrice).subtract(balancePrice);
                String serialNumber = morCacheHandle.getSerialNumber(exitRequest.getParkCode(), exitRequest.getInandoutCode());
                if (serialNumber == null) {
                    OrderNotpay orderNotpay = orderNotpayService.getOne(Wrappers.lambdaQuery(OrderNotpay.class)
                            .eq(OrderNotpay::getOrderNum, orderNum)
                            .eq(OrderNotpay::getStatus, 1));
                    if (orderNotpay != null) {
                        if (exitRequest.getExitTime().equals(orderNotpay.getExitTime())) {
                            log.info("[端云-离场服务] 已处理过欠费[{}]", orderNotpay);
                            return;
                        }
                        log.info("[端云-离场服务] 更新欠费订单, 订单[{}], 原欠费金额[{}], 最新欠费[{}]", orderNum, orderNotpay.getPaidPrice(), notPayPrice);
                        OrderNotpay orderNotPayUpdate = new OrderNotpay();
                        orderNotPayUpdate.setId(orderNotpay.getId());
                        orderNotPayUpdate.setTotalPrice(notPayPrice);
                        orderNotPayUpdate.setPaidPrice(BigDecimal.ZERO);
                        orderNotPayUpdate.setLastPayTime(exitRequest.getLastPayTime());
                        orderNotPayUpdate.setExitTime(exitRequest.getExitTime());
                        orderNotPayUpdate.setChannelId(channelId);
                        orderNotpay.setChannelId(channelId);
                        orderNotPayUpdate.setVideoId(videoId);
                        orderNotpay.setVideoId(videoId);
                        //更新大额欠费订单状态
                        orderNotpayService.largeOrder(orderNotPayUpdate);
                        orderNotpayService.updateById(orderNotPayUpdate);
                    } else {
                        orderNotpay = new OrderNotpay();
                        BeanUtils.copyProperties(exitRequest, orderNotpay);
                        orderNotpay.setTotalPrice(notPayPrice);
                        orderNotpay.setPaidPrice(BigDecimal.ZERO);
                        orderNotpay.setDiscountPrice(BigDecimal.ZERO);
                        orderNotpay.setEnterTime(NumberUtils.toPrimitive(orderInfo.getNoneEnterFlag()) == 0
                                ? orderInfo.getEnterTime() : null);
                        orderNotpay.setLastPayTime(exitRequest.getLastPayTime());
                        orderNotpay.setChannelId(channelId);
                        orderNotpay.setVideoId(videoId);
                        //更新大额欠费订单状态
                        orderNotpayService.largeOrder(orderNotpay);
                        orderNotpayService.addOrderNotpay(orderNotpay);
                    }
                } else {
                    ApplyCarVideoVo vo = new ApplyCarVideoVo();
                    vo.setVideoType(1);
                    vo.setSn(serialNumber);
                    vo.setChannelId(channelId);
                    vo.setOrderNum(orderNum);
                    vo.setParkId(parkId);
                    vo.setPlateNum(orderInfo.getPlateNum());
                    vo.setVideoId(videoId);
                    vo.setRecTime(exitRequest.getExitTime());
                    vo.setNotPayPrice(notPayPrice);
                    vo.setLastPayTime(exitRequest.getLastPayTime());
                    vo.setType(exitRequest.getType());
                    vo.setCarType(exitRequest.getCarType());
                    rabbitSender.sendMessage(MqConstants.Exchange.AISLE_DELAYED_EXCHANGE,
                            MqConstants.Routing.APPLY_CAR_VIDEO_ROUTING, vo, aisleApplyCarVideoTime * 1000L);
                    log.info("[端云-出口] 请求视频延迟消息发送, [{}]", vo);
                }
            }
        }
    }

    /**
     * 出入场通知 redis 订阅发布
     * @param exitRequest 离场参数
     */
    @Override
    public void sendWebsocketMessage(CarExitRequest exitRequest, String payStatus, Integer allow, Integer needPay){
        WebsocketPushData websocketPushData = new WebsocketPushData();
        websocketPushData.setRecordType(2);
        websocketPushData.setExitTime(null != exitRequest.getExitTime()?exitRequest.getExitTime().intValue():(int)System.currentTimeMillis()/1000);
        websocketPushData.setType(exitRequest.getType());
        websocketPushData.setCarType(exitRequest.getCarType());
        websocketPushData.setChannelId(exitRequest.getInandoutCode());
        websocketPushData.setExitNo(exitRequest.getInandoutName());
        websocketPushData.setParkCode(exitRequest.getParkCode());
        websocketPushData.setPlateNum(exitRequest.getPlateNum());
        websocketPushData.setPlateColor(exitRequest.getPlateColor());
        websocketPushData.setTotalPrice(TextUtils.isEmpty(exitRequest.getUnpayPrice())?"0":exitRequest.getUnpayPrice());
        websocketPushData.setPaidPrice(TextUtils.isEmpty(exitRequest.getPaidAmount())?"0":exitRequest.getPaidAmount());
        websocketPushData.setDiscountPrice(TextUtils.isEmpty(exitRequest.getDiscountAmount())?"0":exitRequest.getDiscountAmount());
        websocketPushData.setPayStatus(payStatus);
        websocketPushData.setOrderNum(exitRequest.getOrderNum());
        websocketPushData.setOpened(exitRequest.getOpenFlag());
        websocketPushData.setAllow(allow);
        websocketPushData.setNeedPay(needPay);
        String data = JsonUtils.toString(websocketPushData);
        log.info("sendWebsocketMessage  >> {}",data);
        redisTemplate.convertAndSend(RedisMsgListener.TOPIC, data);
    }

    protected void updateRegionFreeSpace(ReportParamHolder paramHolder, RegionFreeSpaceUpdateVo vo) {
        updateRegionFreeSpace(paramHolder, Collections.singletonList(vo));
    }

    protected void updateRegionFreeSpace(ReportParamHolder paramHolder, Collection<RegionFreeSpaceUpdateVo> vos) {
        ParkConfig parkConfig = paramHolder.getParkConfig();
        if (CollectionUtils.isEmpty(vos)) {
            return;
        }
        List<Integer> typeList = vos.stream().map(RegionFreeSpaceUpdateVo::getType).distinct().collect(Collectors.toList());
        if (!typeList.contains(PlateTypeEnum.月卡车.getType()) || NumberUtils.toPrimitive(parkConfig.getIsCardcount()) == 1) {
            Collection<Long> regionIds = vos.stream().map(RegionFreeSpaceUpdateVo::getRegionId).collect(Collectors.toSet());
            // 更新空车位
            if (parkConfig.getCalcSpaceMethod(1) == 1) {
                for (RegionFreeSpaceUpdateVo vo : vos) {
                    parkRegionDao.addFreeSpaceByPark(vo.getRegionId(), vo.getNum());
                }
            } else {
                parkRegionDao.updateFreeParkByIds(regionIds);
            }
            parkFreespaceDao.calculateFreeSpaceByParks(Collections.singleton(paramHolder.getParkId()));
            if (paramHolder.getRegionType() == 2) {
                for (Long regionId : regionIds) {
                    mqPushService.pushRegionFreeSpace(paramHolder.getParkId(), regionId);
                }
            } else {
                mqPushService.pushParkFreeSpace(paramHolder.getParkId());
            }
        } else {
            for (RegionFreeSpaceUpdateVo vo : vos) {
                if (!PlateTypeEnum.月卡车.getType().equals(vo.getType())
                        || NumberUtils.toPrimitive(parkConfig.getIsCardcount()) == 1) {
                    if (parkConfig.getCalcSpaceMethod(1) == 1) {
                        parkRegionDao.addFreeSpaceByPark(vo.getRegionId(), vo.getNum());
                    } else {
                        parkRegionDao.updateFreeParkByIds(Collections.singleton(vo.getRegionId()));
                    }
                    parkFreespaceDao.calculateFreeSpaceByParks(Collections.singleton(paramHolder.getParkId()));
                    if (paramHolder.getRegionType() == 2) {
                        mqPushService.pushRegionFreeSpace(paramHolder.getParkId(), vo.getRegionId());
                    } else {
                        mqPushService.pushParkFreeSpace(paramHolder.getParkId());
                    }
                }
            }
        }
    }

    protected void saveTrack(CarExitRequest exitRequest, Long regionId, Integer exceptionReason) {
        OrderTrack one = orderTrackMapper.selectLimitOne(Wrappers.lambdaQuery(OrderTrack.class)
                .eq(OrderTrack::getOrderNum, exitRequest.getOrderNum())
                .eq(OrderTrack::getRecordType, 2)
                .eq(OrderTrack::getRegionId, regionId)
                .eq(OrderTrack::getEnexTime, exitRequest.getExitTime())
        );
        if (one != null) {
            OrderTrack orderTrack = new OrderTrack();
            orderTrack.setInoutEvent(getInoutEvent(exitRequest));
            orderTrack.setOpenReason(exceptionReason);
            orderTrack.setOperAccount(exitRequest.getOperAccount());
            orderTrack.setExTerminal(exitRequest.getExitTerminal());
            orderTrackMapper.update(orderTrack, Wrappers.lambdaQuery(OrderTrack.class).eq(OrderTrack::getId, one.getId()));
            return;
        }
        OrderTrack orderTrack = new OrderTrack();
        BeanUtils.copyProperties(exitRequest, orderTrack);
        orderTrack.setInoutEvent(getInoutEvent(exitRequest));
        orderTrack.setChannelName(exitRequest.getInandoutName());
        orderTrack.setRegionId(regionId);
        orderTrack.setRecordType(2);
        orderTrack.setEnexTime(exitRequest.getExitTime());
        orderTrack.setImage(exitRequest.getMaxImage());
        orderTrack.setExTerminal(exitRequest.getExitTerminal());
        orderTrack.setOpenReason(exceptionReason);
        orderTrackMapper.insert(orderTrack);
    }

    private Integer getInoutEvent(CarExitRequest exitRequest) {
        if (exitRequest.getExitWay() != null) {
            return exitRequest.getExitWay();
        } else if (exitRequest.getPlateNum().startsWith("临") && exitRequest.getOperAccount() == null){
            return OrderCarInfoConstant.IN_OUT_WAY_QR_CODE;
        } else if (exitRequest.getOperAccount() != null) {
            return IN_OUT_WAY_SOFTWARE_MANUAL;
        } else {
            return OrderCarInfoConstant.IN_OUT_WAY_PLATE_NUM;
        }
    }
}
