package com.icetech.park.service.order.impl.exit;

import com.icetech.order.dao.OrderInfoDao;
import com.icetech.order.domain.entity.OrderInfo;
import com.icetech.park.domain.entity.park.Park;
import com.icetech.basics.domain.entity.park.ParkConfig;
import com.icetech.basics.domain.entity.park.ParkInoutdevice;
import com.icetech.basics.domain.entity.VipType;
import com.icetech.cloudcenter.domain.request.CarExitRequest;
import com.icetech.common.constants.CodeConstants;
import com.icetech.common.constants.OrderStatusConstants;
import com.icetech.common.constants.PlateTypeEnum;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.thread.ThreadUtils;
import com.icetech.common.utils.NumberUtils;
import com.icetech.common.utils.StringUtils;
import com.icetech.park.service.freespace.UpdateParkFreeSpaceServiceImpl;
import com.icetech.park.service.monthcar.impl.MonthCarServiceImpl;
import com.icetech.park.service.report.ReportParamHolder;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ThreadPoolExecutor;

@Slf4j
@Service("carOrderExitService")
public class CarOrderExitServiceImpl extends CommonExitImpl {
    @Autowired
    private OrderInfoDao orderInfoDao;
    @Autowired
    private UpdateParkFreeSpaceServiceImpl updateParkFreeSpaceService;
    @Autowired
    private MonthCarServiceImpl monthCarService;
    @Autowired
    private ThreadPoolExecutor asyncExecutor;
    @Autowired
    private MasterChannelCarOrderExitServiceImpl masterChannelCarOrderExitService;
    @Autowired
    private SubChannelCarOrderExitServiceImpl subChannelCarOrderExitService;

    @Override
    @Transactional
    public ObjectResponse<Map<String, Object>> exit(CarExitRequest exitRequest) {
        ReportParamHolder paramHolder = new ReportParamHolder(exitRequest.getParkId(), exitRequest.getParkCode(),
                exitRequest.getInandoutCode(), null, null,
                exitRequest.getPlateNum(), 2, exitRequest.getOrderNum());
        return exit(exitRequest, paramHolder, OrderStatusConstants.LEAVED_PARK, null);
    }

    @Transactional
    public ObjectResponse<Map<String, Object>> exit(CarExitRequest exitRequest, ReportParamHolder paramHolder) {
        return exit(exitRequest, paramHolder, OrderStatusConstants.LEAVED_PARK, null);
    }

    @Override
    @Transactional
    public ObjectResponse<Map<String, Object>> exceptionExit(CarExitRequest exitRequest, Integer oddStatus) {
        ReportParamHolder paramHolder = new ReportParamHolder(exitRequest.getParkId(), exitRequest.getParkCode(),
                exitRequest.getInandoutCode(), null, null,
                exitRequest.getPlateNum(), 2, exitRequest.getOrderNum());
        return exit(exitRequest, paramHolder, OrderStatusConstants.EXCEPTION, oddStatus);
    }

    public ObjectResponse<Map<String, Object>> exit(CarExitRequest exitRequest, ReportParamHolder paramHolder, Integer status, Integer oddStatus) {
        Long parkId = exitRequest.getParkId();
        String orderNum = exitRequest.getOrderNum();
        if (!PlateTypeEnum.VIP车辆.getType().equals(exitRequest.getType())) {
            //校验车辆类型
            ObjectResponse<VipType> validVipCar = paramHolder.getVipTypeResp();
            if (ObjectResponse.isSuccess(validVipCar)){
                exitRequest.setType(PlateTypeEnum.VIP车辆.getType());
            }
        }
        /*
         * 必传参数判断
         */
        if (StringUtils.isBlank(orderNum) || parkId == null){
            return ObjectResponse.failed(CodeConstants.ERROR_400);
        }

        OrderInfo orderInfo = orderInfoDao.selectByOrderNum(orderNum);

        if (Objects.isNull(orderInfo)) {
            log.warn("[订单不存在]|订单编号[{}]",orderNum);
            return ObjectResponse.failed(CodeConstants.ERROR_404);
        }
        if (orderInfo.getServiceStatus() == OrderStatusConstants.LEAVED_PARK
                && NumberUtils.toPrimitive(oddStatus) == OrderStatusConstants.EXCEPTION) {
            //当前订单已经正常离场，不用再次处理
            return ObjectResponse.failed(CodeConstants.ERROR_405, "当前订单已经离场");
        }
        if (exitRequest.getType() == null) {
            exitRequest.setType(orderInfo.getType());
        }

        //离场流程处理
        ParkInoutdevice parkInoutdevice = paramHolder.getParkChannel();
        Park park = paramHolder.getParkInfo();
        //判断是否是场中场 和主通道
        if (park.getIsInterior() == null || park.getIsInterior() == 0 || orderInfo.getRegionId() == null){
            return orderHandle(exitRequest, paramHolder, status, oddStatus, orderInfo);
        }else if(parkInoutdevice.getIsMaster() == 1) {
            return masterChannelCarOrderExitService.exit(exitRequest, paramHolder, status, oddStatus, orderInfo);
        }else{
            return subChannelCarOrderExitService.exit(exitRequest, paramHolder, status, oddStatus, orderInfo);
        }
    }

    private ObjectResponse<Map<String, Object>> orderHandle(CarExitRequest exitRequest, ReportParamHolder paramHolder,
                                       Integer status, Integer oddStatus, OrderInfo orderInfo) {
        Long parkId = exitRequest.getParkId();
        String orderNum = exitRequest.getOrderNum();
        commonExitFlow(exitRequest, status, oddStatus, parkId, orderNum, orderInfo);
        //月卡多位多车处理
        if (orderInfo.getType().equals(PlateTypeEnum.月卡车.getType())) {
            asyncExecutor.execute(ThreadUtils.wrapTrace(() -> {
                log.info("[月卡车出场] 准备处理plateNum[{}]", exitRequest.getPlateNum());
                monthCarService.exitAbMonthDeal(parkId, exitRequest.getPlateNum(), exitRequest.getExitTime());
            }));
        }

        /*if (NumberUtils.parseFloat(orderInfo.getDiscountPrice()) > 0){
            OrderPay orderPay1 = new OrderPay();
            orderPay1.setOrderNum(orderNum);
            orderPay1.setParkId(parkId);
            orderPay1.setPayStatus(PayStatusConstants.PAID);
            PageQuery<OrderPay> pageQuery = new PageQuery<>();
            pageQuery.setParam(orderPay1);
            List<OrderPay> orderPays = orderPayDao.selectListByPage(pageQuery);
            if (orderPays != null && orderPays.size() > 0){
//                OrderPay orderPay2 = orderPays.get(0);
//                orderPayServiceImpl.useDiscount(orderPay2);
            }
        }*/

        ParkConfig parkConfig = paramHolder.getParkConfig();
        // 非月卡车或月卡车计入空车位时
        if (!exitRequest.getType().equals(PlateTypeEnum.月卡车.getType())
                || NumberUtils.toPrimitive(parkConfig.getIsCardcount()) == 1) {
            // 更新空车位
            if (parkConfig.getCalcSpaceMethod(1) == 1) {
                updateParkFreeSpaceService.addFreeSpace(parkId, null, 1);
            } else {
                updateParkFreeSpaceService.syncFreeSpace(parkId, null);
            }
            mqPushService.pushParkFreeSpace(parkId);
        }
        asyncHandler(exitRequest, parkId, orderNum, orderInfo, parkConfig, oddStatus);

        //返回
        Map<String, Object> map = new HashMap<>();
        map.put("orderNum", orderNum);
        return ObjectResponse.success(map);
    }
}
