package com.icetech.park.service.order.impl.enter;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;

import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.icetech.basics.api.BlacklistService;
import com.icetech.basics.domain.entity.VipType;
import com.icetech.cloudcenter.api.discount.MerchantDiscountService;
import com.icetech.cloudcenter.api.discount.MerchantUserService;
import com.icetech.cloudcenter.api.month.VipCarService;
import com.icetech.cloudcenter.api.order.OrderDiscountService;
import com.icetech.cloudcenter.api.order.OrderEnterService;
import com.icetech.cloudcenter.api.order.OrderService;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.cloudcenter.domain.response.MerchantDiscountDto;
import com.icetech.common.constants.PlateTypeEnum;
import com.icetech.order.dao.OrderCarInfoDao;
import com.icetech.order.dao.OrderInfoDao;
import com.icetech.order.dao.OrderSonCarInfoDao;
import com.icetech.order.dao.OrderSonInfoDao;
import com.icetech.order.domain.entity.OrderDiscount;
import com.icetech.park.dao.other.ChannelAlarmDao;
import com.icetech.basics.dao.park.ParkRegionDao;
import com.icetech.park.dao.park.ParkVisitDao;
import com.icetech.third.dao.send.SendinfoDao;
import com.icetech.cloudcenter.domain.constants.ParkVisitMoreType;
import com.icetech.cloudcenter.domain.constants.RedisConstants;
import com.icetech.cloudcenter.domain.constants.SpecialConstants;
import com.icetech.basics.domain.entity.Blacklist;
import com.icetech.park.domain.entity.ChannelAlarm;
import com.icetech.order.domain.entity.OrderCarInfo;
import com.icetech.order.domain.entity.OrderInfo;
import com.icetech.order.domain.entity.OrderSonCarInfo;
import com.icetech.order.domain.entity.OrderSonInfo;
import com.icetech.order.domain.entity.OrderTrack;
import com.icetech.order.domain.entity.ReenterRecord;
import com.icetech.park.domain.entity.park.Park;
import com.icetech.basics.domain.entity.park.ParkConfig;
import com.icetech.basics.domain.entity.park.ParkInoutdevice;
import com.icetech.basics.domain.entity.park.ParkRegion;
import com.icetech.park.domain.entity.park.ParkVisit;
import com.icetech.third.domain.entity.third.SendInfo;
import com.icetech.cloudcenter.domain.enumeration.DownServiceEnum;
import com.icetech.cloudcenter.domain.enumeration.OrderOddStatusEnum;
import com.icetech.cloudcenter.domain.enumeration.PncVersionEnum;
import com.icetech.cloudcenter.domain.order.update.OrderInfoUpdate;
import com.icetech.cloudcenter.domain.request.EnterRequest;
import com.icetech.cloudcenter.domain.websocket.WebsocketPushData;
import com.icetech.order.service.ReenterRecordService;
import com.icetech.order.service.impl.OrderTrackServiceImpl;
import com.icetech.park.service.other.impl.AutopayServiceImpl;
import com.icetech.basics.service.redis.RedisMsgListener;
import com.icetech.third.service.third.MqPushService;
import com.icetech.third.utils.RedisUtils;
import com.icetech.common.constants.CodeConstants;
import com.icetech.common.constants.OrderCarInfoConstant;
import com.icetech.common.constants.OrderStatusConstants;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.exception.ResponseBodyException;
import com.icetech.common.thread.ThreadUtils;
import com.icetech.common.utils.CodeTools;
import com.icetech.common.utils.DateTools;
import com.icetech.common.utils.JsonUtils;
import com.icetech.common.utils.NumberUtils;
import com.icetech.common.utils.StringUtils;
import com.icetech.redis.lock.RedissonDistributedLock;
import lombok.extern.slf4j.Slf4j;
import org.redisson.api.RLock;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import static com.icetech.common.utils.CodeTools.GenerateDiscountNo;

@Slf4j
@Service("orderEnterService")
public class OrderEnterServiceImpl implements OrderEnterService {
    @Autowired
    private OrderInfoDao orderInfoDao;
    @Resource
    private OrderService orderService;
    @Resource
    private OrderCarInfoDao orderCarInfoDao;
    @Autowired
    private ParkService parkService;
    @Autowired
    private AutopayServiceImpl autopayService;
    @Autowired
    private ParkVisitDao parkVisitDao;
    @Autowired
    private ChannelAlarmDao channelAlarmDao;
    @Autowired
    private ParkRegionDao parkRegionDao;
    @Autowired
    private OrderSonInfoDao orderSonInfoDao;
    @Resource
    private OrderSonCarInfoDao orderSonCarInfoDao;
    @Autowired
    private StringRedisTemplate redisTemplate;
    @Autowired
    private ThreadPoolExecutor asyncExecutor;
    @Autowired
    private OrderTrackServiceImpl orderTrackService;
    @Autowired
    private RedisUtils redisUtils;
    @Autowired
    protected MqPushService pushService;

    @Autowired
    protected ReenterRecordService reenterRecordService;

    @Autowired
    private RedissonDistributedLock redissonDistributedLock;

    @Autowired
    protected BlacklistService blacklistService;

    @Autowired
    private SendinfoDao sendInfoDao;

    @Autowired
    private VipCarService vipCarService;

    @Autowired
    private MerchantDiscountService merchantDiscountService;

    @Autowired
    private OrderDiscountService orderDiscountService;

    @Autowired
    private MerchantUserService merchantUserService;

    @Override
    @Transactional
    public ObjectResponse<Map<String, Object>> enter(EnterRequest enterRequest, String parkCode) {
        String channelCode = enterRequest.getChannelId();
        if (channelCode == null) return ObjectResponse.failed(CodeConstants.ERROR_400, "通道不存在");
        ParkInoutdevice parkChannel = parkService.getInoutDeviceByCode(channelCode).getData();
        if (parkChannel == null) return ObjectResponse.failed(CodeConstants.ERROR_402, "channelId未被注册");
        ParkRegion parkRegion = parkChannel.getRegionId() == null ? null : parkRegionDao.selectById(parkChannel.getRegionId());
        long fatherRelationId = 0;

        OrderInfo orderInfo = new OrderInfo();
        orderInfo.setLocalOrderNum(enterRequest.getOrderId());
        orderInfo.setParkId(enterRequest.getParkId());
        OrderInfo existsOrder = orderInfoDao.selectLimitOneOrderByEnterDesc(orderInfo);

        // 按主订单处理
        if (parkRegion == null
                || (fatherRelationId = NumberUtils.toPrimitive(parkRegion.getFatherRelationId())) == 0  // 主区域
                || NumberUtils.toPrimitive(parkChannel.getIsMaster()) == 1  // 子区域主通道
        ) {
            existsOrder = saveMasterOrder(enterRequest, parkCode, parkRegion, parkChannel, existsOrder);
        } else {
            // 场中场
            // 子区域且子通道，确定通道方向及连接区域
            ParkRegion parentRegion = parkRegionDao.selectById(fatherRelationId);
            if (parentRegion == null) return ObjectResponse.failed(CodeConstants.ERROR_402, "区域所属主区域不存在");
            ParkRegion originRegion = null, destRegion = null;
            if (parkChannel.getInandoutType() == 1) {    // 入口，代表从主区域到子区域
                originRegion = parentRegion;
                destRegion = parkRegion;
            } else { // 出口，代表从子区域到主区域
                originRegion = parkRegion;
                destRegion = parentRegion;
            }
            existsOrder = saveSonOrder(enterRequest, parkCode, originRegion, destRegion, parkChannel, existsOrder);
        }

        Map<String, Object> map = new HashMap<>();
        map.put("orderId", existsOrder.getLocalOrderNum());
        map.put("orderNum", existsOrder.getOrderNum());
        return ObjectResponse.success(map);
    }

    /**
     * 保存主订单
     *
     * @param enterRequest
     * @param enterRequest
     * @param parkCode
     * @param parkRegion
     * @return
     */
    private OrderInfo saveMasterOrder(EnterRequest enterRequest, String parkCode, ParkRegion parkRegion, ParkInoutdevice parkChannel, OrderInfo existsOrder) {
        String plateNum = enterRequest.getPlateNum();
        Long parkId = enterRequest.getParkId();
        String orderId = enterRequest.getOrderId();
        if (existsOrder != null) {
            log.info("[车辆入场服务] orderId重复，参数：[{},{}]", parkId, orderId);
            return existsOrder;
        }
        //主要是解决上报顺序问题，当出现未识别的时候会导致上报顺序打乱
        OrderSonInfo orderSonInfoSearch = new OrderSonInfo();
        orderSonInfoSearch.setLocalOrderNum(orderId);
        orderSonInfoSearch.setParkId(parkId);
        OrderSonInfo orderSonInfo = orderSonInfoDao.selectOneByEntity(orderSonInfoSearch);
        // 判断是否重复入场，并取消旧的订单记录
        checkSamePlate(plateNum, parkCode, parkId, enterRequest);
        // 新增订单记录表
        OrderInfo orderInfo = existsOrder == null ? new OrderInfo() : existsOrder;
        BeanUtils.copyProperties(enterRequest, orderInfo);
        String orderNum = orderInfo.getId() == null ? CodeTools.GenerateOrderNum() : orderInfo.getOrderNum();
        // 如果通道编号没有上传，将自动匹配区域，匹配后也需要主子订单号保持一致
        if (parkRegion != null && StringUtils.isNotBlank(parkRegion.getOrderNum())) {
            orderNum = parkRegion.getOrderNum();
            orderInfo.setHasSon(1);
        }
        //如果入场的时候发下子订单表有数据，说明先上报的是子订单，那么主订单的订单号要和子订单保持一直
        if (!Objects.isNull(orderSonInfo)) {
            orderNum = orderSonInfo.getOrderNum();
            orderInfo.setHasSon(1);
        }
        orderInfo.setOrderNum(orderNum);
        orderInfo.setLocalOrderNum(orderId);
        if (!Objects.isNull(parkRegion)) {
            orderInfo.setRegionId(parkRegion.getId());
        }
        if (enterRequest.getNoneEnterFlag()) {
            orderInfo.setNoneEnterFlag(1);
        } else {
            orderInfo.setEnterChannelId(parkChannel.getInandoutCode());
        }
        orderInfo.setServiceStatus(OrderStatusConstants.IN_PARK);
        try {
            orderService.addOrderInfo(orderInfo);
        } catch (DuplicateKeyException e) {
            orderNum = CodeTools.GenerateOrderNum();
            orderInfo.setOrderNum(orderNum);
            orderService.addOrderInfo(orderInfo);
        }
        log.info("[车辆入场服务] 插入主订单信息表完成，orderNum：{}", orderNum);

        // 新增订单进出场记录表
        OrderCarInfo carInfo = buildCarInfo(parkCode, enterRequest, orderInfo, parkChannel);
        orderCarInfoDao.insert(carInfo);
        log.info("[车辆入场服务] 插入订单进出场表完成，orderNum：{}", orderNum);

        // 补充入场轨迹
        ObjectResponse<Park> parkResp = parkService.findByParkId(orderInfo.getParkId());
        if(ObjectResponse.isSuccess(parkResp) && NumberUtils.toPrimitive(parkResp.getData().getIsInterior()) == 1
                && NumberUtils.toPrimitive(parkResp.getData().getNestType()) != 0) {
            String version = redisUtils.hGet(RedisConstants.PNC_VERSION,
                    String.valueOf(orderInfo.getParkId()), String.class);
            if (version != null && PncVersionEnum.getIndex(version) < PncVersionEnum.版本7.getIndex()) {
                OrderTrack orderTrack = new OrderTrack()
                        .setRecordType(1)
                        .setParkId(orderInfo.getParkId())
                        .setRegionId(orderInfo.getRegionId())
                        .setChannelName(carInfo.getEnterNo())
                        .setOrderNum(orderInfo.getOrderNum())
                        .setEnexTime(enterRequest.getEnterTime())
                        .setPlateNum(enterRequest.getPlateNum())
                        .setType(orderInfo.getType())
                        .setImage(carInfo.getEnterImage())
                        .setInoutEvent(0);
                orderTrackService.save(orderTrack);
            }
        }

        saveOrderAfter(parkId, orderNum, parkCode, plateNum, enterRequest, carInfo);
        return orderInfo;
    }

    /**
     * 保存子订单
     * @return
     */
    private OrderInfo saveSonOrder(EnterRequest enterRequest, String parkCode, ParkRegion originRegion, ParkRegion destRegion, ParkInoutdevice parkChannel, OrderInfo mainOrder) {
        List<OrderSonInfo> orderSonInfos = orderSonInfoDao.selectList(Wrappers.lambdaQuery(OrderSonInfo.class)
                .eq(OrderSonInfo::getParkId, enterRequest.getParkId())
                .eq(OrderSonInfo::getLocalOrderNum, enterRequest.getOrderId())
                .in(OrderSonInfo::getServiceStatus, OrderStatusConstants.IN_PARK, OrderStatusConstants.LEAVED_PARK));
        Map<Long, OrderSonInfo> orderSonInfoMap = orderSonInfos.stream().collect(Collectors.toMap(OrderSonInfo::getRegionId, Function.identity(), (older, newer) -> newer, HashMap::new));
        OrderSonInfo originOrderSon = orderSonInfoMap.get(originRegion.getId());
        OrderSonInfo destOrderSon = orderSonInfoMap.get(destRegion.getId());

        OrderCarInfo mainCarInfo = null;
        if (mainOrder == null) { // 缺失主订单
            mainOrder = new OrderInfo();
            BeanUtils.copyProperties(enterRequest, mainOrder);
            mainOrder.setOrderNum(CodeTools.GenerateOrderNum())
                    .setLocalOrderNum(enterRequest.getOrderId())
                    .setServiceStatus(OrderStatusConstants.IN_PARK)
                    .setHasSon(1)
                    .setNoneEnterFlag(1);
            String regionName = null;
            if (NumberUtils.toPrimitive(originRegion.getFatherRelationId()) == 0) {  // 源区域为主区域
                mainOrder.setRegionId(originRegion.getId());
                regionName = originRegion.getRegionName();
            } else if (NumberUtils.toPrimitive(destRegion.getFatherRelationId()) == 0) { // 目的区域为主区域
                mainOrder.setRegionId(destRegion.getId());
                regionName = destRegion.getRegionName();
            } else {
                throw new ResponseBodyException(CodeConstants.ERROR_402, "两个子区域无法切换");
            }
            if (NumberUtils.toPrimitive(mainOrder.getNoneEnterFlag()) == 0) {
                mainOrder.setEnterChannelId(parkChannel.getInandoutCode());
            }
            orderService.addOrderInfo(mainOrder);
            log.info("[车辆入场服务] 补充主订单信息完成，orderNum：{}，区域名称：{}", mainOrder.getOrderNum(), regionName);
            mainCarInfo = buildCarInfo(parkCode, enterRequest, mainOrder, parkChannel);
            orderCarInfoDao.insert(mainCarInfo);
            log.info("[车辆入场服务] 补充主订单车辆信息完成，orderNum：{}，区域名称：{}", mainOrder.getOrderNum(), regionName);
            saveOrderAfter(enterRequest.getParkId(), mainOrder.getOrderNum(), parkCode, enterRequest.getPlateNum(), enterRequest, mainCarInfo);
        } else if (NumberUtils.toPrimitive(mainOrder.getHasSon()) == 0) {
            mainOrder.setHasSon(1);
            OrderInfo updateMain = new OrderInfo().setId(mainOrder.getId()).setHasSon(1);
            orderInfoDao.updateById(updateMain);
        }
        OrderCarInfoWrapper mainCarInfoWrapper = new OrderCarInfoWrapper();
        mainCarInfoWrapper.orderCarInfo = mainCarInfo;
        // 处理源区域订单, 置为离场
        originOrderSon = handleOrderSon(parkCode, enterRequest, originRegion, parkChannel,
                mainOrder, mainCarInfoWrapper, originOrderSon, OrderStatusConstants.LEAVED_PARK);
        // 处理目的区域订单, 置为入场
        destOrderSon = handleOrderSon(parkCode, enterRequest, destRegion, parkChannel,
                mainOrder, mainCarInfoWrapper, destOrderSon, OrderStatusConstants.IN_PARK);

        return destOrderSon;
    }

    private OrderSonInfo handleOrderSon(String parkCode, EnterRequest request, ParkRegion parkRegion, ParkInoutdevice parkChannel,
                                        OrderInfo mainOrder, OrderCarInfoWrapper mainCarInfoWrapper, OrderSonInfo orderSonInfo, int targetStatus) {
        if (orderSonInfo == null) {    // 补充区域订单
            orderSonInfo = new OrderSonInfo();
            OrderSonCarInfo orderSonCarInfo = null;
            if (mainOrder.getRegionId().equals(parkRegion.getId())) { // 如果区域与主订单区域一致，则拷贝主订单到子订单
                BeanUtils.copyProperties(mainOrder, orderSonInfo);
                orderSonCarInfo = new OrderSonCarInfo();
                if (mainCarInfoWrapper.orderCarInfo == null) {
                    mainCarInfoWrapper.orderCarInfo = orderCarInfoDao.selectByOrderNum(mainOrder.getOrderNum());
                }
                BeanUtils.copyProperties(mainCarInfoWrapper.orderCarInfo, orderSonCarInfo);
            } else {
                BeanUtils.copyProperties(request, orderSonInfo);
                orderSonInfo.setRegionId(parkRegion.getId())
                        .setOrderNum(mainOrder.getOrderNum())
                        .setLocalOrderNum(request.getOrderId());
            }
            orderSonInfo.setServiceStatus(targetStatus);
            if (targetStatus == OrderStatusConstants.IN_PARK) {
                orderSonInfo.setEnterTime(request.getEnterTime());
            } else if(!mainOrder.getRegionId().equals(orderSonInfo.getRegionId())) {
                orderSonInfo.setExitTime(request.getEnterTime());
            }
            orderSonInfoDao.insertWithPlateNum2(orderSonInfo);
            if (orderSonCarInfo == null) {
                orderSonCarInfo = (OrderSonCarInfo) buildCarInfo(parkCode, request, orderSonInfo, parkChannel);
            }
            orderSonCarInfo.setOrderSonId(orderSonInfo.getId());
            if (org.apache.commons.lang3.StringUtils.isNotEmpty(request.getPlateColor())) {
                orderSonCarInfo.setPlateColor(request.getPlateColor());
            }
            orderSonCarInfoDao.insert(orderSonCarInfo);
        } else {    // 区域订单已存在则更改订单状态
            if (targetStatus == OrderStatusConstants.IN_PARK) {
                orderSonInfoDao.setInPark(orderSonInfo.getId());
            } else {
                OrderSonInfo updateOrderSon = new OrderSonInfo();
                updateOrderSon.setId(orderSonInfo.getId())
                        .setServiceStatus(targetStatus);
                if (!mainOrder.getRegionId().equals(orderSonInfo.getRegionId())) {
                    updateOrderSon.setExitTime(request.getEnterTime());
                }
                OrderSonCarInfo updateOrderSonCarInfo = new OrderSonCarInfo();
                updateOrderSonCarInfo.setOrderSonId(orderSonInfo.getId())
                        .setExitNo(parkChannel.getInandoutName())
                        .setExitChannelId(parkChannel.getInandoutCode())
                        .setExitImage(fillImage(request.getEnterImage(), parkCode))
                        .setSmallExitImage(request.getSmallImage())
                        .setExitReliability(request.getReliability());
                if (org.apache.commons.lang3.StringUtils.isNotEmpty(request.getPlateColor())) {
                    updateOrderSonCarInfo.setPlateColor(request.getPlateColor());
                }
                orderSonInfoDao.updateById(updateOrderSon);
                orderSonCarInfoDao.updateByOrderSonId(updateOrderSonCarInfo);
            }
        }

        if (targetStatus == OrderStatusConstants.IN_PARK) {
            // 补充入场记录
            ObjectResponse<Park> parkResp = parkService.findByParkId(request.getParkId());
            if(ObjectResponse.isSuccess(parkResp) && NumberUtils.toPrimitive(parkResp.getData().getIsInterior()) == 1
                    && NumberUtils.toPrimitive(parkResp.getData().getNestType()) != 0) {
                String version = redisUtils.hGet(RedisConstants.PNC_VERSION,
                        String.valueOf(parkRegion.getParkId()), String.class);
                if (version != null && PncVersionEnum.getIndex(version) < PncVersionEnum.版本7.getIndex()) {
                    OrderTrack orderTrack = new OrderTrack()
                            .setRecordType(1)
                            .setParkId(parkRegion.getParkId())
                            .setOrderNum(orderSonInfo.getOrderNum())
                            .setRegionId(parkRegion.getId())
                            .setType(orderSonInfo.getType())
                            .setChannelName(parkChannel.getInandoutName())
                            .setEnexTime(request.getEnterTime())
                            .setPlateNum(request.getPlateNum())
                            .setImage(fillImage(request.getEnterImage(), parkCode))
                            .setInoutEvent(0);
//                .setOperAccount("");
                    orderTrackService.save(orderTrack);
                }
            }
        }
        return orderSonInfo;
    }

    private OrderCarInfo buildCarInfo(String parkCode, EnterRequest request, OrderInfo orderInfo, ParkInoutdevice parkChannel) {
        OrderCarInfo orderCarInfo = null;
        if (orderInfo instanceof OrderSonInfo) {
            orderCarInfo = new OrderSonCarInfo();
        } else {
            orderCarInfo = new OrderCarInfo();
        }
        BeanUtils.copyProperties(request, orderCarInfo);
        orderCarInfo.setOrderNum(orderInfo.getOrderNum());
        String imgFileName = fillImage(request.getEnterImage(), parkCode);
        if (orderInfo.getServiceStatus() != OrderStatusConstants.IN_PARK) {
            orderCarInfo.setExitNo(parkChannel.getInandoutName());
            orderCarInfo.setExitChannelId(parkChannel.getInandoutCode());
            orderCarInfo.setExitImage(imgFileName);
            orderCarInfo.setSmallExitImage(request.getSmallImage());
            orderCarInfo.setExitReliability(request.getReliability());
        }
        if (NumberUtils.toPrimitive(orderInfo.getNoneEnterFlag()) == 0) {
            orderCarInfo.setEnterNo(parkChannel.getInandoutName());
            orderCarInfo.setEnterChannelId(parkChannel.getInandoutCode());
            orderCarInfo.setEnterImage(imgFileName);
            orderCarInfo.setSmallEnterImage(request.getSmallImage());
            orderCarInfo.setEnterReliability(request.getReliability());
            orderCarInfo.setEnterWay(request.getInoutEvent());
            orderCarInfo.setEnterOperAccount(request.getOperAccount());
            orderCarInfo.setEnterTerminal(request.getExTerminal());
        }
        return orderCarInfo;
    }

    private String fillImage(String image, String parkCode) {
        if (StringUtils.isNotBlank(image) && !image.contains("/image/")) {
            String date = DateTools.getFormat(DateTools.DF_, new Date());
            String[] ymd = date.split("-");
            image = parkCode + "/image/" + ymd[0] + ymd[1] + "/" + ymd[2] + "/" + image;
        }
        return image;
    }

    private static class OrderCarInfoWrapper {
        OrderCarInfo orderCarInfo;
    }

    /**
     * 订单保存完成后操作
     *
     * @param parkId
     * @param orderNum
     * @param parkCode
     * @param plateNum
     * @param enterRequest
     * @param carInfo
     */
    protected void saveOrderAfter(Long parkId, String orderNum,
                                  String parkCode, String plateNum, EnterRequest enterRequest, OrderCarInfo carInfo) {
        //调用支付中心进场通知(只有临时车和开启无感支付才需要调用接口)
        autopayService.enterNotify(parkId, orderNum, parkCode, plateNum,
                enterRequest.getEnterTime(), enterRequest.getType());
        //消息下发车场信息并且进行入场通知
//        sendMQMessage(enterRequest,parkCode);
        sendWebsocketMessage(enterRequest, parkCode, carInfo);
        //更新访客预约订单状态
        ParkVisit parkVisit = parkVisitDao.selectVisitByParkidPlate(
                parkId, plateNum, new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
        if (parkVisit != null) {
            parkVisit.setVisitStatus(2);
            if (ParkVisitMoreType.ONE.getType().equals(parkVisit.getInoutMore())) {
                parkVisit.setInoutNum(0);
            }
            parkVisit.setOrderNum(orderNum);
            parkVisit.setEnterTime(Math.toIntExact(enterRequest.getEnterTime()));
            // 访客优惠处理
            if (parkVisit.getSendFlag() != null && parkVisit.getSendFlag() == 0) {
                if (parkVisit.getIsDiscount() != null && parkVisit.getIsDiscount() ==1) {
                    // 通过商家优惠id获取优惠信息
                    ObjectResponse<MerchantDiscountDto> discountObj = merchantDiscountService.findMerchantDiscountById(Long.valueOf(parkVisit.getMerchantDisId()));
                    if (ObjectResponse.isSuccess(discountObj)) {
                        MerchantDiscountDto merchantDiscountDto = discountObj.getData();
                        BigDecimal deductMoney = merchantDiscountDto.getDeductMoney() == null ? BigDecimal.ZERO :  merchantDiscountDto.getDeductMoney();
                        OrderDiscount addOrderDis = new OrderDiscount();
                        addOrderDis.setMerchantDisId(Long.valueOf(merchantDiscountDto.getId()));
                        addOrderDis.setDiscountNo(GenerateDiscountNo());
                        addOrderDis.setParkId(enterRequest.getParkId());
                        addOrderDis.setType(merchantDiscountDto.getType());
                        addOrderDis.setMerchantId(Long.valueOf(merchantDiscountDto.getMerchantId()));
                        addOrderDis.setAmount(merchantDiscountDto.getAmount());
                        addOrderDis.setFrom(1);
                        addOrderDis.setOrderNum(orderNum);
                        addOrderDis.setPlateNum(plateNum);
                        addOrderDis.setDiscountName(merchantDiscountDto.getName());
                        addOrderDis.setDeductMoney(merchantDiscountDto.getDeductMoney().doubleValue());
                        addOrderDis.setSendTime(new Date());
                        addOrderDis.setStatus(0);
                        addOrderDis.setUseTime(new Date());
                        // 添加优惠
                        ObjectResponse<Long> addDiscount = orderDiscountService.addDiscount(addOrderDis);
                        if (ObjectResponse.isSuccess(addDiscount)) {
                            parkVisit.setSendFlag(1);
                            log.info("[端网云访客车优惠]添加成功,返回的id:{}", addDiscount.getData());
                        }
                        // 扣减余额
                        merchantUserService.subMerchantMoney(merchantDiscountDto.getMerchantId(), deductMoney);
                    }
                }
            }
            parkVisitDao.updateVisit(parkVisit);
            log.info("[车辆入场服务] 更新访客预约表完成，orderNum：{},parkVisit:{}", orderNum, parkVisit);

        }
        // 更新通道的报警记录为已处理
        if (enterRequest.getChannelId() != null) {
            ChannelAlarm channelAlarm = new ChannelAlarm();
            channelAlarm.setParkId(parkId);
            channelAlarm.setChannelCode(enterRequest.getChannelId());
            channelAlarm.setStatus(ChannelAlarm.Status.已处理.getStatus());
            channelAlarmDao.update(channelAlarm);
        }
    }

    /**
     * 出入场 websocket 消息发布
     *
     * @param enterRequest
     * @param parkCode
     */
    private void sendWebsocketMessage(EnterRequest enterRequest, String parkCode, OrderCarInfo carInfo) {
        WebsocketPushData websocketPushData = new WebsocketPushData();
        websocketPushData.setRecordType(1);
        websocketPushData.setEnterTime(enterRequest.getEnterTime().intValue());
        websocketPushData.setType(enterRequest.getType());
        websocketPushData.setCarType(enterRequest.getCarType());
        websocketPushData.setChannelId(enterRequest.getChannelId());
        websocketPushData.setEnterNo(carInfo.getEnterNo());
        websocketPushData.setParkCode(parkCode);
        websocketPushData.setPlateNum(enterRequest.getPlateNum());
        websocketPushData.setPlateColor(carInfo.getPlateColor());
        websocketPushData.setOrderNum(carInfo.getOrderNum());
        String data = JsonUtils.toString(websocketPushData);
        log.info("sendWebsocketMessage redis消息订阅内容 {}", data);
        redisTemplate.convertAndSend(RedisMsgListener.TOPIC, data);
    }

    /**
     * 判断是否有场内重复车牌，并修改状态为取消
     *
     * @param plateNum
     * @return
     */
    private void checkSamePlate(String plateNum, String parkCode, Long parkId, EnterRequest enterRequest) {
        //未识别车牌不做重复处理
        if (plateNum.equals(SpecialConstants.NO_PLATE_NUM)) {
            return;
        }
        if (plateNum.equals(SpecialConstants.NO_PLATE_NUM2)) {
            return;
        }
        String part = plateNum.substring(1);
        OrderInfo orderInfo_res = orderInfoDao.fuzzyInParkPlate2(parkId, part);
        if (orderInfo_res != null) {
            log.info("[车辆入场服务] 重复入场，当前车牌号：{}，已在场车牌号：{}", plateNum, orderInfo_res.getPlateNum());
            OrderCarInfo orderCarInfo = orderCarInfoDao.selectByOrderNum(orderInfo_res.getOrderNum());
            if (orderCarInfo != null && Integer.valueOf(5).equals(orderCarInfo.getEnterWay())) {
                return;
            }
            OrderInfoUpdate orderInfoUpdate = new OrderInfoUpdate();
            OrderInfo orderInfoNeo = new OrderInfo();
            // 将当前车辆订单设为异常离场
            orderInfoNeo.setServiceStatus(OrderStatusConstants.EXCEPTION);
            orderInfoNeo.setOddStatus(OrderOddStatusEnum.重复入场.getVal());
            orderInfoNeo.setExitTime(orderInfo_res.getEnterTime());
            orderInfoUpdate.setNeo(orderInfoNeo);
            OrderInfo orderInfoOld = new OrderInfo();
            orderInfoOld.setServiceStatus(OrderStatusConstants.IN_PARK);
            orderInfoOld.setParkId(parkId);
            orderInfoOld.setPlateNum(orderInfo_res.getPlateNum());
            orderInfoUpdate.setOld(orderInfoOld);
            orderInfoDao.updateStatus(orderInfoUpdate);
            boolean notMonthCar = !PlateTypeEnum.月卡车.getType().equals(enterRequest.getType());
            boolean notFreeVip = !PlateTypeEnum.VIP车辆.getType().equals(enterRequest.getType());
            if (PlateTypeEnum.VIP车辆.getType().equals(enterRequest.getType())) {
                ObjectResponse<VipType> objectResponse = vipCarService.getRecentVipCar(parkId, plateNum, null);
                if (ObjectResponse.isSuccess(objectResponse) && !Integer.valueOf(1).equals(objectResponse.getData().getType())) {
                    notFreeVip = true;
                }
            }
            boolean moreThan5Minutes = (enterRequest.getEnterTime() - orderInfo_res.getEnterTime()) / 60 >= 5;
            // 五分钟 并且是遥控器
            if (notMonthCar && notFreeVip && moreThan5Minutes
                    && OrderCarInfoConstant.IN_OUT_WAY_REMOTE_CONTROL != NumberUtils.toPrimitive(enterRequest.getInoutEvent())) {
                ReenterRecord reenterRecord = ReenterRecord.builder()
                        .orderNum(orderInfo_res.getOrderNum())
                        .parkId(parkId)
                        .plateNum(orderInfo_res.getPlateNum())
                        .carType(orderInfo_res.getCarType())
                        .enterTime(orderInfo_res.getEnterTime())
                        .exitTime(orderInfo_res.getEnterTime())
                        .build();
                // 重复入场记录表
                reenterRecordService.addReenterRecord(reenterRecord);
                // 入口黑名单处理
                ObjectResponse<ParkConfig> configObj = parkService.getParkConfig(parkCode);
                if (ObjectResponse.isSuccess(configObj) && Objects.nonNull(configObj.getData())) {
                    ParkConfig config = configObj.getData();
                    if (NumberUtils.toPrimitive(config.getEnableReenterBlack()) == 1
                            && config.getReenterBlackTime() != null && config.getReenterBlackTime() > 0) {
                        // 加入黑名单
                        asyncExecutor.execute(ThreadUtils.wrapTrace(
                                () -> {
                                    try {
                                        RLock lock = redissonDistributedLock.getLock("lock:blacklist:" + parkId + ":" + plateNum);
                                        //如果已经处理过此messageId的业务，则直接返回
                                        if (!lock.tryLock(0, 2, TimeUnit.SECONDS)) {
                                            log.info("端网云黑名单其他线程正在处理|{}|{}", parkId, plateNum);
                                            return;
                                        }
                                        asyncBlackListHandle(reenterRecord, parkId, plateNum, config.getReenterBlackTime());
                                    } catch (Exception e) {
                                        log.error("端网云黑名单处理失败, plateNum[{}]", plateNum);
                                    }
                                }));
                    }
                }
            }else {
                log.info("[端网云车辆入场服务] 重复入场不符合加入黑名单条件,  不是遥控器[{}], 超过5分钟[{}]", enterRequest.getInoutEvent(), moreThan5Minutes);
            }
            if (Integer.valueOf(1).equals(orderInfo_res.getHasSon())) {
                orderSonInfoDao.setException(orderInfo_res.getOrderNum(),
                        orderInfoNeo.getExitTime(), OrderOddStatusEnum.重复入场.getVal());
            }
            orderInfo_res.setServiceStatus(OrderStatusConstants.EXCEPTION);
            orderInfo_res.setOddStatus(OrderOddStatusEnum.重复入场.getVal());
            orderInfo_res.setExitTime(orderInfo_res.getEnterTime());
            pushService.pushOrderExit(orderInfo_res);

            //发送银联前一次订单的离场通知
            orderInfo_res.setExitTime(DateTools.unixTimestamp());
            asyncExecutor.execute(ThreadUtils.wrapTrace(() -> autopayService.exitNotify(orderInfo_res, parkCode)));
        }
    }
    @Transactional(rollbackFor = Exception.class)
    public void asyncBlackListHandle(ReenterRecord record, Long parkId, String plateNum, Integer reenterBlackTime) {
        int count = reenterRecordService.count(Wrappers.lambdaQuery(ReenterRecord.class)
                .eq(ReenterRecord::getParkId, parkId)
                .eq(ReenterRecord::getPlateNum, plateNum)
                .eq(ReenterRecord::getBlackId, 0)
                .ne(ReenterRecord::getOrderNum, record.getOrderNum()));
        count = count + 1;
        if (count >= reenterBlackTime) {
            ObjectResponse<Blacklist> blackListObj = blacklistService.getValidByPlate(parkId, plateNum);
            if (ObjectResponse.isSuccess(blackListObj)) {
                Blacklist blacklist = blackListObj.getData();
                Blacklist newBlackList = new Blacklist();
                newBlackList.setId(blacklist.getId());
                newBlackList.setRepeatNumbers(count);
                if (Integer.valueOf(2).equals(blacklist.getOperateType())) {
                    log.info("[端网云重复入场] 黑名单已添加, 直接返回, [{}]", blacklist);
                    return;
                }
                blacklistService.updateById(newBlackList);
                ReenterRecord reenterRecord = new ReenterRecord();
                reenterRecord.setBlackId(blacklist.getId().longValue());
                reenterRecordService.update(reenterRecord, new LambdaUpdateWrapper<ReenterRecord>()
                        .eq(ReenterRecord::getParkId, parkId)
                        .eq(ReenterRecord::getPlateNum, plateNum)
                        .eq(ReenterRecord::getBlackId, 0));
            } else {
                Blacklist blacklist = Blacklist.builder()
                        .parkId(parkId)
                        .plate(plateNum)
                        .owner(plateNum)
                        .carType(record.getCarType())
                        .type(1)
                        .status(0)
                        .operateType(2)
                        .repeatNumbers(count)
                        .operAccount("system")
                        .build();
                ObjectResponse<Integer> response = blacklistService.addBlackList(blacklist);
                if (ObjectResponse.isSuccess(response)) {
                    ReenterRecord reenterRecord = new ReenterRecord();
                    reenterRecord.setBlackId(blacklist.getId().longValue());
                    reenterRecordService.update(reenterRecord, new LambdaUpdateWrapper<ReenterRecord>()
                            .eq(ReenterRecord::getParkId, parkId)
                            .eq(ReenterRecord::getPlateNum, plateNum)
                            .eq(ReenterRecord::getBlackId, 0));
                    // 黑名单下发
                   SendInfo sendInfo = new SendInfo(parkId, reenterRecord.getBlackId(), DownServiceEnum.黑名单下发.getServiceType());
                   sendInfoDao.insert(sendInfo);
                }
            }
        }

    }

}
