package com.icetech.park.service.order.impl.enter;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.icetech.basics.api.BlacklistService;
import com.icetech.basics.dao.park.ParkRegionDao;
import com.icetech.basics.domain.entity.Blacklist;
import com.icetech.basics.domain.entity.VipType;
import com.icetech.basics.domain.entity.park.ParkConfig;
import com.icetech.basics.domain.entity.park.ParkInoutdevice;
import com.icetech.basics.service.redis.RedisMsgListener;
import com.icetech.basics.utils.FuzzyPlateTools;
import com.icetech.city.common.api.BlacklistApi;
import com.icetech.city.common.domain.entity.common.BlacklistPark;
import com.icetech.cloudcenter.api.discount.MerchantDiscountService;
import com.icetech.cloudcenter.api.discount.MerchantUserService;
import com.icetech.cloudcenter.api.month.VipCarService;
import com.icetech.cloudcenter.api.order.CarOrderEnterService;
import com.icetech.cloudcenter.api.order.OrderDiscountService;
import com.icetech.cloudcenter.api.order.OrderPayService;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.cloudcenter.api.park.ParkVisitService;
import com.icetech.cloudcenter.api.store.StoreCardService;
import com.icetech.cloudcenter.api.third.ThirdInfoService;
import com.icetech.cloudcenter.domain.charge.dto.OrderSumFeeDto;
import com.icetech.cloudcenter.domain.constants.ParkVisitMoreType;
import com.icetech.cloudcenter.domain.constants.SpecialConstants;
import com.icetech.cloudcenter.domain.enumeration.DownServiceEnum;
import com.icetech.cloudcenter.domain.enumeration.OrderOddStatusEnum;
import com.icetech.cloudcenter.domain.order.query.OrderPayCondition;
import com.icetech.cloudcenter.domain.order.update.OrderInfoUpdate;
import com.icetech.cloudcenter.domain.request.CarEnterRequest;
import com.icetech.cloudcenter.domain.response.MerchantDiscountDto;
import com.icetech.cloudcenter.domain.response.MonthAbDto;
import com.icetech.cloudcenter.domain.response.MonthDetailDto;
import com.icetech.cloudcenter.domain.websocket.WebsocketPushData;
import com.icetech.common.constants.CodeConstants;
import com.icetech.common.constants.OrderCarInfoConstant;
import com.icetech.common.constants.OrderStatusConstants;
import com.icetech.common.constants.PlateTypeEnum;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.exception.ResponseBodyException;
import com.icetech.common.thread.ThreadUtils;
import com.icetech.common.utils.DateTools;
import com.icetech.common.utils.JsonUtils;
import com.icetech.common.utils.NumberUtils;
import com.icetech.fee.dao.monthcar.MonthInfoDao;
import com.icetech.fee.dao.vip.VipInfoDao;
import com.icetech.fee.domain.entity.monthcar.MonthInfo;
import com.icetech.fee.domain.entity.storecard.StoreCard;
import com.icetech.order.dao.OrderCarInfoDao;
import com.icetech.order.dao.OrderInfoDao;
import com.icetech.order.dao.OrderSonInfoDao;
import com.icetech.order.dao.OrderTrackMapper;
import com.icetech.order.domain.entity.*;
import com.icetech.order.service.OrderTagsService;
import com.icetech.order.service.ReenterRecordService;
import com.icetech.park.dao.other.ChannelAlarmDao;
import com.icetech.park.dao.park.ParkFreespaceDao;
import com.icetech.park.dao.park.ParkVisitDao;
import com.icetech.park.dao.vehicle.VehiclePlateDao;
import com.icetech.park.domain.dto.TagsDto;
import com.icetech.park.domain.entity.ChannelAlarm;
import com.icetech.park.domain.entity.more.MoreMonthPark;
import com.icetech.park.domain.entity.park.ParkVisit;
import com.icetech.park.domain.entity.vehicle.VehiclePlate;
import com.icetech.park.domain.vo.RegionFreeSpaceUpdateVo;
import com.icetech.park.service.freespace.UpdateRegionFreeSpaceServiceImpl;
import com.icetech.park.service.monthcar.impl.MonthCarServiceImpl;
import com.icetech.park.service.more.MoreMonthParkService;
import com.icetech.park.service.order.impl.OrderServiceImpl;
import com.icetech.park.service.report.ReportParamHolder;
import com.icetech.redis.lock.RedissonDistributedLock;
import com.icetech.third.dao.send.SendinfoDao;
import com.icetech.third.domain.entity.third.SendInfo;
import com.icetech.third.service.third.MqPushService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.redisson.api.RLock;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

import static com.icetech.common.utils.CodeTools.GenerateDiscountNo;

/**
 * 端云入场处理通用类
 * @author fangct
 */
@Slf4j
public class CommonEnterImpl implements CarOrderEnterService {

    @Autowired
    protected OrderInfoDao orderInfoDao;
    @Resource
    protected OrderCarInfoDao orderCarInfoDao;
    @Autowired
    protected UpdateRegionFreeSpaceServiceImpl updateRegionFreeSpaceService;
    @Autowired
    protected MonthCarServiceImpl monthCarService;
    @Autowired
    protected VehiclePlateDao vehiclePlateDao;
    @Autowired
    protected ParkService parkService;
    @Autowired
    protected VipCarService vipCarService;
    @Autowired
    protected ParkVisitDao parkVisitDao;
    @Autowired
    protected ParkVisitService parkVisitService;
    @Autowired
    protected ChannelAlarmDao channelAlarmDao;
    @Autowired
    protected MonthInfoDao monthInfoDao;
    @Autowired
    protected VipInfoDao vipInfoDao;
    @Autowired
    protected StoreCardService storeCardService;
    @Autowired
    protected OrderServiceImpl orderService;
    @Autowired
    protected StringRedisTemplate redisTemplate;
    @Autowired
    protected OrderTagsService orderTagsService;
    @Autowired
    protected ThreadPoolExecutor asyncExecutor;
    @Autowired
    protected OrderTrackMapper orderTrackMapper;
    @Autowired
    protected MqPushService mqPushService;
    @Autowired
    protected OrderSonInfoDao orderSonInfoDao;
    @Autowired
    protected MqPushService pushService;
    @Autowired
    protected ReenterRecordService reenterRecordService;
    @Autowired
    protected BlacklistService blacklistService;
    @Autowired
    private RedissonDistributedLock redissonDistributedLock;
    @Autowired
    private SendinfoDao sendInfoDao;
    @Autowired
    private ParkRegionDao parkRegionDao;
    @Resource
    private ParkFreespaceDao parkFreespaceDao;
    @Resource
    private ThirdInfoService thirdInfoService;
    @Resource
    private MoreMonthParkService moreMonthParkService;
    @Resource
    private OrderPayService orderPayService;

    @Autowired
    private OrderDiscountService orderDiscountService;

    @Autowired
    private MerchantDiscountService merchantDiscountService;

    @Autowired
    private MerchantUserService merchantUserService;
    @Autowired
    private BlacklistApi cityBlacklistApi;

    //时间与相机比较的偏移量
    protected static final Long OFFSET = 600L;

    /**
     * 验证车牌类型
     *
     * @param enterRequest 请求参数
     * @param plateNum 车牌号
     * @param parkId 车场ID
     */
    protected void validateCarInfo(CarEnterRequest enterRequest, String plateNum, Long parkId) {
        if (SpecialConstants.NO_PLATE_NUM.equals(plateNum)) {
            return;
        }
        String inandoutCode = enterRequest.getInandoutCode();
        ParkInoutdevice parkChannel = null;
        if (inandoutCode != null) {
            parkChannel = parkService.getInoutDeviceByCode(inandoutCode).getData();
        }
        Long regionId = parkChannel != null && parkChannel.getRegionId() != null ? parkChannel.getRegionId() : null;
        // 如果不是调试模式并且是相机主动开闸，则需要重新判断车辆类型
        if (!enterRequest.isDebug() && enterRequest.getOpenFlag() != null && enterRequest.getOpenFlag() == 1) {
            validateType(enterRequest, plateNum, parkId, regionId);
        }

        // 临时车时，再根据通道模糊规则匹配
        if (PlateTypeEnum.临时车.getType().equals(enterRequest.getType()) && Objects.nonNull(parkChannel)) {
            int isOpenVaguetype = NumberUtils.toPrimitive(parkChannel.getIsOpenVaguetype());
            if (isOpenVaguetype == 1) {
                //疑似车牌识别错误的标识
                boolean recWrongPlate = false;
                int vaguetype = NumberUtils.toPrimitive(parkChannel.getVaguetype());
                List<String> partOfPlateList = FuzzyPlateTools.fuzzyCharacter(plateNum, vaguetype);
                String newPlateNum = monthInfoDao.fuzzyValidatePlate(parkId, partOfPlateList);
                if (newPlateNum != null && !newPlateNum.equals(plateNum)) {
                    Boolean isMonthCard = monthCarService.judgeMonthCar(parkId, newPlateNum, regionId);
                    if (isMonthCard) {
                        recWrongPlate = true;
                        enterRequest.setType(PlateTypeEnum.月卡车.getType());
                        log.info("月卡车辆{}", newPlateNum);
                    }
                }
                if (!recWrongPlate) {
                    newPlateNum = vipInfoDao.fuzzyValidatePlate(parkId, partOfPlateList);
                    if (newPlateNum != null && !newPlateNum.equals(plateNum)) {
                        recWrongPlate = true;
                        enterRequest.setType(PlateTypeEnum.VIP车辆.getType());
                        log.info("VIP车辆{}", newPlateNum);
                    }
                }
                if (!recWrongPlate) {
                    newPlateNum = parkVisitDao.fuzzyValidatePlate(parkId, partOfPlateList);
                    if (newPlateNum != null && !newPlateNum.equals(plateNum)) {
                        ObjectResponse<ParkVisit> visitCar = parkVisitService.checkVisitPlate(parkId, newPlateNum);
                        if (ObjectResponse.isSuccess(visitCar)) {
                            recWrongPlate = true;
                            enterRequest.setType(PlateTypeEnum.访客车辆.getType());
                            log.info("访客车辆{}", newPlateNum);
                        }
                    }
                }
                if (recWrongPlate) {
                    enterRequest.setPlateNum(newPlateNum);
                    log.info("[端云-车辆入场服务] 上报车牌[{}]，模糊匹配车牌[{}]", plateNum, newPlateNum);
                }
            }
        }
    }

    protected void validateType(CarEnterRequest enterRequest, String plateNum, Long parkId, Long regionId) {
        if (SpecialConstants.NO_PLATE_NUM.equals(plateNum)) {
            return;
        }
        MonthAbDto monthAbDto = monthCarService.abMonthCar(parkId, plateNum, regionId);
        if (monthAbDto != null) {
            if (monthAbDto.getMonthCar()) {
                enterRequest.setType(PlateTypeEnum.月卡车.getType());
                log.info("月卡车辆, {}", enterRequest.getPlateNum());
                return;
            } else if (monthAbDto.getAbCar()) {
                List<TagsDto> tagsDtos = new ArrayList<>();
                TagsDto tagsDto = TagsDto.builder().tagId(1).regionId(regionId)
                        .remark(monthAbDto.getPlotCount() + "位"
                                + monthAbDto.getPlateNumCount() + "车第"
                                + monthAbDto.getIndex() + "车").build();
                tagsDtos.add(tagsDto);
                enterRequest.setTags(tagsDtos);
                enterRequest.setType(PlateTypeEnum.临时车.getType());
                log.info("多位多车月卡车辆, {}", enterRequest.getPlateNum());
                return;
            }
        }

        Integer btype = cityBlacklistApi.getPlateType(plateNum, BlacklistPark.PARK_TYPE_PARK, parkId);
        if (com.icetech.city.common.domain.entity.common.Blacklist.PLATE_TYPE_WHITE.equals(btype)) {
            enterRequest.setType(PlateTypeEnum.VIP车辆.getType());
            log.info("白名单车辆, {}", enterRequest.getPlateNum());
            return;
        }
//            if (com.icetech.city.common.domain.entity.common.Blacklist.PLATE_TYPE_BLACK.equals(type)) {
//                enterRequest.setType(PlateTypeEnum.VIP车辆.getType());
//                log.info("黑名单车辆, {}", enterRequest.getPlateNum());
//                return;
//            }

        //济南定制VIP车辆判断
        VehiclePlate vehiclePlate = vehiclePlateDao.selectVip(enterRequest.getParkId(), enterRequest.getPlateNum());
        if (vehiclePlate != null) {
            enterRequest.setType(PlateTypeEnum.VIP车辆.getType());
            log.info("济南VIP车辆, {}", enterRequest.getPlateNum());
        } else {
            //vip车辆判断
            ObjectResponse<VipType> validVipCar = vipCarService.getValidVipCar(parkId, plateNum, regionId);
            if (ObjectResponse.isSuccess(validVipCar)) {
                enterRequest.setType(PlateTypeEnum.VIP车辆.getType());
                enterRequest.setCarDesc(validVipCar.getData().getName());
                log.info("VIP车辆, {}", enterRequest.getPlateNum());
            } else {
                ObjectResponse<ParkVisit> visitCar = parkVisitService.checkVisitPlate(parkId, plateNum);
                if (ObjectResponse.isSuccess(visitCar)) {
                    enterRequest.setType(PlateTypeEnum.访客车辆.getType());
                    log.info("访客车辆, {}", enterRequest.getPlateNum());
                } else {
                    ObjectResponse<StoreCard> objectResponse = storeCardService.getValidStoreCards(enterRequest.getPlateNum(), parkId);
                    if (objectResponse != null && CodeConstants.SUCCESS.equals(objectResponse.getCode())) {
                        enterRequest.setType(PlateTypeEnum.储值卡车.getType());
                        log.info("储值卡车, {}", enterRequest.getPlateNum());
                    } else {
                        Integer type = enterRequest.getType();
                        if (!PlateTypeEnum.特殊车辆.getType().equals(type)) {
                            enterRequest.setType(PlateTypeEnum.临时车.getType());
                            log.info("临时车辆, {}", enterRequest.getPlateNum());
                        }
                    }
                }
            }
        }
    }

    protected void delTags(CarEnterRequest enterRequest, String orderNum, Long regionId, OrderCarInfo carInfo) {
        if (CollectionUtil.isNotEmpty(enterRequest.getTags())) {
            List<TagsDto> tags = enterRequest.getTags();
            String tagIds = tags.stream().map(TagsDto::getTagId).map(String::valueOf).collect(Collectors.joining(","));
            carInfo.setTags(tagIds);

            List<OrderTags> orderTags = tags.stream()
                    .map(tagsDto -> OrderTags.builder()
                            .orderNum(orderNum)
                            .parkId(enterRequest.getParkId())
                            .regionId(regionId)
                            .tagId(tagsDto.getTagId())
                            .remark(tagsDto.getRemark()).build()
                    ).collect(Collectors.toList());
            orderTagsService.saveBatch(orderTags);
        }
    }

    /**
     * 异步处理业务
     * @param enterRequest 请求参数
     */
    protected void asyncHandle(CarEnterRequest enterRequest) {

        Long parkId = enterRequest.getParkId();
        String plateNum = enterRequest.getPlateNum();
        String orderNum = enterRequest.getOrderNum();

        //更新访客预约订单状态
        ParkVisit parkVisit = parkVisitDao.selectVisitByParkidPlate(parkId, plateNum,
                new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
        if (parkVisit != null) {
            parkVisit.setVisitStatus(2);
            Integer inoutMore = parkVisit.getInoutMore();
            if (ParkVisitMoreType.ONE.getType().equals(inoutMore)){
                parkVisit.setInoutNum(0);
            }
            parkVisit.setOrderNum(orderNum);
            parkVisit.setEnterTime(Math.toIntExact(enterRequest.getEnterTime()));
            // 访客优惠处理
            if (parkVisit.getSendFlag() != null && parkVisit.getSendFlag() == 0) {
                if (parkVisit.getIsDiscount() != null && parkVisit.getIsDiscount() ==1) {
                    // 通过商家优惠id获取优惠信息
                    ObjectResponse<MerchantDiscountDto> discountObj = merchantDiscountService.findMerchantDiscountById(Long.valueOf(parkVisit.getMerchantDisId()));
                    if (ObjectResponse.isSuccess(discountObj)) {
                        MerchantDiscountDto merchantDiscountDto = discountObj.getData();
                        BigDecimal deductMoney = merchantDiscountDto.getDeductMoney() == null ? BigDecimal.ZERO :  merchantDiscountDto.getDeductMoney();
                        OrderDiscount addOrderDis = new OrderDiscount();
                        addOrderDis.setMerchantDisId(Long.valueOf(merchantDiscountDto.getId()));
                        addOrderDis.setDiscountNo(GenerateDiscountNo());
                        addOrderDis.setParkId(enterRequest.getParkId());
                        addOrderDis.setType(merchantDiscountDto.getType());
                        addOrderDis.setMerchantId(Long.valueOf(merchantDiscountDto.getMerchantId()));
                        addOrderDis.setAmount(merchantDiscountDto.getAmount());
                        addOrderDis.setFrom(1);
                        addOrderDis.setOrderNum(orderNum);
                        addOrderDis.setPlateNum(plateNum);
                        addOrderDis.setDiscountName(merchantDiscountDto.getName());
                        addOrderDis.setDeductMoney(merchantDiscountDto.getDeductMoney().doubleValue());
                        addOrderDis.setSendTime(new Date());
                        addOrderDis.setStatus(0);
                        addOrderDis.setUseTime(new Date());
                        // 添加优惠
                        ObjectResponse<Long> addDiscount = orderDiscountService.addDiscount(addOrderDis);
                        if (ObjectResponse.isSuccess(addDiscount)) {
                            parkVisit.setSendFlag(1);
                            log.info("[访客车优惠]添加成功,返回的id:{}", addDiscount.getData());
                        }
                        // 扣减余额
                        merchantUserService.subMerchantMoney(merchantDiscountDto.getMerchantId(), deductMoney);
                    }
                }
            }
            parkVisitDao.updateVisit(parkVisit);
            log.info("[端云-车辆入场服务] 更新访客预约表完成，orderNum：{}", orderNum);
        }
        sendWebsocketMessage(enterRequest, 1);

        /*
         * 更新通道的报警记录为已处理
         */
        if (enterRequest.getInandoutCode() != null) {
            ChannelAlarm channelAlarm = new ChannelAlarm();
            channelAlarm.setParkId(parkId);
            channelAlarm.setChannelCode(enterRequest.getInandoutCode());
            channelAlarm.setStatus(ChannelAlarm.Status.已处理.getStatus());
            channelAlarmDao.update(channelAlarm);
        }

        //海大定制-更新其他车场历史异常订单
        haidaMore(parkId, plateNum);
    }

    private void haidaMore(Long parkId, String plateNum) {
        if (Objects.nonNull(thirdInfoService.selectHaiDaJituan(parkId))) {
            // 查询当前是否为集团月卡
            MonthInfo monthInfo = monthInfoDao.selectByPlateNum(parkId, plateNum, 1);
            if (Objects.nonNull(monthInfo)&&monthInfo.getMoreMonthType()!= null && monthInfo.getMoreMonthType()== 1){
                log.info("[海大定制更新其余车场的异常订单为异常离场]");
                List<MoreMonthPark> moreMonthParks = moreMonthParkService.getMonthParkByMoreMonthId(monthInfo.getMoreMonthId());
                List<Long> parkIds = moreMonthParks.stream().map(MoreMonthPark::getParkId).collect(Collectors.toList());
                if (CollectionUtil.isNotEmpty(parkIds)){
                    parkIds = parkIds.stream().filter(item -> !item.equals(parkId)).collect(Collectors.toList());
                    List<OrderInfo> orderInfos = orderInfoDao.selectList(Wrappers.lambdaQuery(OrderInfo.class).in(OrderInfo::getParkId, parkIds)
                            .eq(OrderInfo::getPlateNum, plateNum).eq(OrderInfo::getServiceStatus, OrderStatusConstants.IN_PARK));
                    if (CollectionUtil.isNotEmpty(orderInfos)){
                        orderInfos.forEach(item -> {
                            OrderInfoUpdate orderInfoUpdate = new OrderInfoUpdate();
                            OrderInfo orderInfoNeo = new OrderInfo();
                            // 将订单设为异常离场
                            orderInfoNeo.setServiceStatus(OrderStatusConstants.EXCEPTION);
                            orderInfoNeo.setOddStatus(OrderOddStatusEnum.重复入场.getVal());
                            orderInfoNeo.setExitTime(item.getEnterTime());
                            orderInfoUpdate.setNeo(orderInfoNeo);
                            OrderInfo orderInfoOld = new OrderInfo();
                            orderInfoOld.setServiceStatus(OrderStatusConstants.IN_PARK);
                            orderInfoOld.setParkId(item.getParkId());
                            orderInfoOld.setPlateNum(item.getPlateNum());
                            orderInfoUpdate.setOld(orderInfoOld);
                            orderInfoDao.updateStatus(orderInfoUpdate);
                        });
                    }
                }
            }
        }
    }

    /**
     * 出入场 websocket 消息发布
     * @param enterRequest 请求参数
     */
    @Override
    public void sendWebsocketMessage(CarEnterRequest enterRequest, Integer allow) {
        WebsocketPushData websocketPushData = new WebsocketPushData();
        websocketPushData.setRecordType(1);
        websocketPushData.setEnterTime(enterRequest.getEnterTime().intValue());
        websocketPushData.setType(enterRequest.getType());
        websocketPushData.setCarType(enterRequest.getCarType());
        websocketPushData.setChannelId(enterRequest.getInandoutCode());
        websocketPushData.setEnterNo(enterRequest.getInandoutName());
        websocketPushData.setParkCode(enterRequest.getParkCode());
        websocketPushData.setPlateNum(enterRequest.getPlateNum());
        websocketPushData.setPlateColor(enterRequest.getPlateColor());
        Integer property = enterRequest.getProperty();
        if (property != null && property == 2) {
            websocketPushData.setOpened(1);
        } else {
            websocketPushData.setOpened(0);
        }
        Integer openFlag = enterRequest.getOpenFlag();
        if ((openFlag != null && openFlag == 1) || allow == 1) {
            websocketPushData.setOpened(1);
        } else {
            websocketPushData.setOpened(0);
        }
        websocketPushData.setAllow(websocketPushData.getOpened() == 1 ? 1 : allow);
        websocketPushData.setOrderNum(enterRequest.getOrderNum());
        String data = JsonUtils.toString(websocketPushData);
        log.info("sendWebsocketMessage redis消息订阅内容 {}", data);
        redisTemplate.convertAndSend(RedisMsgListener.TOPIC, data);
    }

    /**
     * 判断是否有场内重复车牌，并修改状态为异常离场
     * @param plateNum 车牌号
     * @param parkId 车场ID
     * @param currEnterTime 入场时间
     * @param enterWay 入场方式
     * @param property 实时/断网续传
     * @param replenishOrder 补录入场标识
     * @param type 车辆类型
     * @return 受影响的行数
     */
    protected int checkSamePlate(String plateNum, Long parkId, Long currEnterTime, Integer enterWay, Integer property,
                                 boolean replenishOrder, Integer type) {
        //未识别车牌不做重复处理
        if (plateNum.equals(SpecialConstants.NO_PLATE_NUM)) {
            return 0;
        }
        String part = plateNum.substring(1);
        OrderInfo orderInfoRes = orderInfoDao.fuzzyInParkPlate2(parkId, part);
        if (orderInfoRes != null) {
            //上次的入场时间大于当次入场时间（网络等其他原因导致延迟接收），并且上次入场时间小于当前时间+偏移量
            //如果上次入场时间大于等于当前时间+偏移量，则可以认为上次的入场时间有问题，取消上次问题订单，以新订单为准
            if (orderInfoRes.getEnterTime() > currEnterTime
                    && orderInfoRes.getEnterTime() < DateTools.unixTimestamp() + OFFSET) {
                log.warn("[车辆入场服务] 后上报的入场时间比前次小[{}]秒，车牌号：{}", orderInfoRes.getEnterTime() - currEnterTime, plateNum);
                if (replenishOrder) {
                    return 0;
                }
                throw new ResponseBodyException(CodeConstants.ERROR_405, "后上报的入场时间比前次小");
            }
            log.info("[车辆入场服务] 重复入场，当前车牌号：{}，在场车牌号[{}]", plateNum, orderInfoRes.getPlateNum());
            OrderInfo existsParam = new OrderInfo();
            existsParam.setServiceStatus(OrderStatusConstants.IN_PARK);
            existsParam.setPlateNum(plateNum);
            existsParam.setParkId(parkId);
            List<OrderInfo> existsOrders = orderInfoDao.selectList(existsParam);
            if (CollectionUtils.isEmpty(existsOrders)) {
                return 0;
            }
            //是否实时数据
            boolean realTime = Integer.valueOf(1).equals(property);
            boolean notRemoteControlOpen = OrderCarInfoConstant.IN_OUT_WAY_REMOTE_CONTROL != NumberUtils.toPrimitive(enterWay);
            List<OrderInfo> updateOrders = new ArrayList<>(existsOrders.size());
            List<ReenterRecord> reenterRecords = new ArrayList<>(existsOrders.size());
            for (OrderInfo existsOrder : existsOrders) {
                OrderCarInfo orderCarInfo = orderCarInfoDao.selectByOrderNum(existsOrder.getOrderNum());
                //如果库里在场订单是断电应急并且当前订单不是
                if (orderCarInfo != null && orderCarInfo.getEnterWay() != null
                        && (!orderCarInfo.getEnterWay().equals(enterWay)
                        && Arrays.asList(orderCarInfo.getEnterWay(), enterWay).contains(5))) {
                    continue;
                }
                OrderPayCondition orderPayCondition = new OrderPayCondition();
                orderPayCondition.setParkId(existsOrder.getParkId());
                orderPayCondition.setOrderNum(existsOrder.getOrderNum());
                orderPayCondition.setPayStatus(2);
                ObjectResponse<OrderSumFeeDto> sumPay = orderPayService.getSumPay(orderPayCondition);
                OrderInfo updateOrder = new OrderInfo();
                updateOrder.setId(existsOrder.getId());
                // 车辆重复入场,设置订单状态为异常状态
                updateOrder.setServiceStatus(OrderStatusConstants.EXCEPTION);
                updateOrder.setOddStatus(OrderOddStatusEnum.重复入场.getVal());
                updateOrder.setExitTime(existsOrder.getEnterTime());
                if (ObjectResponse.isSuccess(sumPay)) {
                    OrderSumFeeDto orderSumFeeDto = sumPay.getData();
                    updateOrder.setTotalPrice(String.valueOf(orderSumFeeDto.getTotalPrice()));
                    updateOrder.setPaidPrice(String.valueOf(orderSumFeeDto.getPaidPrice()));
                    updateOrder.setDiscountPrice(String.valueOf(orderSumFeeDto.getDiscountPrice()));
                } else {
                    updateOrder.setTotalPrice("0.00");
                    updateOrder.setPaidPrice("0.00");
                    updateOrder.setDiscountPrice("0.00");
                }
                updateOrders.add(updateOrder);

                boolean notMonthCar = !PlateTypeEnum.月卡车.getType().equals(type);
                boolean notFreeVip = !PlateTypeEnum.VIP车辆.getType().equals(type);
                if (PlateTypeEnum.VIP车辆.getType().equals(type)) {
                    ObjectResponse<VipType> objectResponse = vipCarService.getRecentVipCar(parkId, plateNum, null);
                    if (ObjectResponse.isSuccess(objectResponse) && !Integer.valueOf(1).equals(objectResponse.getData().getType())) {
                        notFreeVip = true;
                    }
                }
                boolean moreThan5Minutes = (currEnterTime - existsOrder.getEnterTime()) / 60 >= 5;
                if (notMonthCar && notFreeVip && realTime && notRemoteControlOpen && moreThan5Minutes) {
                    ReenterRecord reenterRecord = ReenterRecord.builder()
                            .orderNum(existsOrder.getOrderNum())
                            .parkId(parkId)
                            .plateNum(plateNum)
                            .carType(existsOrder.getCarType())
                            .enterTime(existsOrder.getEnterTime())
                            .exitTime(existsOrder.getEnterTime())
                            .build();
                    reenterRecords.add(reenterRecord);
                } else {
                    log.info("[车辆入场服务] 重复入场不符合加入黑名单条件, 不是月卡车[{}], 不是全免VIP[{}], 实时性[{}], 不是遥控器[{}], 超过5分钟[{}]",
                            notMonthCar, notFreeVip, realTime, notRemoteControlOpen, moreThan5Minutes);
                }

                if (Integer.valueOf(1).equals(existsOrder.getHasSon())) {
                    orderSonInfoDao.setException(existsOrder.getOrderNum(),
                            updateOrder.getExitTime(), OrderOddStatusEnum.重复入场.getVal());
                }
                existsOrder.setServiceStatus(OrderStatusConstants.EXCEPTION);
                existsOrder.setOddStatus(OrderOddStatusEnum.重复入场.getVal());
                existsOrder.setExitTime(existsOrder.getEnterTime());
                pushService.pushOrderExit(existsOrder);
            }
            orderService.updateBatchById(updateOrders);
            if (!reenterRecords.isEmpty()) {
                ObjectResponse<ParkConfig> parkConfigResp = parkService.getParkConfig(parkId);
                ParkConfig parkConfig = parkConfigResp.getData();
                if (NumberUtils.toPrimitive(parkConfig.getEnableReenterBlack()) == 1
                        && NumberUtils.toPrimitive(parkConfig.getReenterBlackTime()) > 0) {
                    reenterRecordService.saveBatch(reenterRecords);
                    //异步处理黑名单逻辑
                    asyncExecutor.execute(ThreadUtils.wrapTrace(
                            () -> {
                                try {
                                    RLock lock = redissonDistributedLock.getLock("lock:blacklist:" + parkId + ":" + plateNum);
                                    //如果已经处理过此messageId的业务，则直接返回
                                    if (!lock.tryLock(0, 2, TimeUnit.SECONDS)) {
                                        log.info("其他线程正在处理|{}|{}", parkId, plateNum);
                                        return;
                                    }
                                    asyncBlackListHandle(reenterRecords, parkId, plateNum, parkConfig.getReenterBlackTime());
                                } catch (Exception e) {
                                    log.error("黑名单处理失败, plateNum[{}]", plateNum, e);
                                }
                            }));
                }
            }
            return updateOrders.size();
        }
        return 0;
    }

    protected void saveTrack(CarEnterRequest carEnterRequest, Long regionId) {
        if (carEnterRequest.getNoneEnterFlag()) {
            return;
        }
        OrderTrack orderTrack = new OrderTrack();
        BeanUtils.copyProperties(carEnterRequest, orderTrack);
        if (carEnterRequest.getEnterWay() != null) {
            orderTrack.setInoutEvent(carEnterRequest.getEnterWay());
        } else if (carEnterRequest.getPlateNum().startsWith("临") && carEnterRequest.getOperaUser() == null){
            orderTrack.setInoutEvent(OrderCarInfoConstant.IN_OUT_WAY_QR_CODE);
        } else if (carEnterRequest.getOperaUser() != null) {
            orderTrack.setInoutEvent(OrderCarInfoConstant.IN_OUT_WAY_SOFTWARE_MANUAL);
        } else {
            orderTrack.setInoutEvent(OrderCarInfoConstant.IN_OUT_WAY_PLATE_NUM);
        }
        orderTrack.setChannelName(carEnterRequest.getInandoutName());
        orderTrack.setRegionId(regionId);
        orderTrack.setRecordType(1);
        orderTrack.setEnexTime(carEnterRequest.getEnterTime());
        orderTrack.setImage(carEnterRequest.getMaxImage());
        orderTrack.setOperAccount(carEnterRequest.getOperaUser());
        orderTrack.setExTerminal(carEnterRequest.getEnterTerminal());
        orderTrackMapper.insert(orderTrack);
    }

    @Transactional(rollbackFor = Exception.class)
    public void asyncBlackListHandle(List<ReenterRecord> reenterRecords, Long parkId, String plateNum, int reenterBlackTime) {

        int count = reenterRecordService.count(Wrappers.lambdaQuery(ReenterRecord.class)
                .eq(ReenterRecord::getParkId, parkId)
                .eq(ReenterRecord::getPlateNum, plateNum)
                .eq(ReenterRecord::getBlackId, 0)
                .notIn(ReenterRecord::getOrderNum,
                        reenterRecords.stream().map(ReenterRecord::getOrderNum).collect(Collectors.toList())));
        int num = reenterRecords.size() + count;
        if (num >= reenterBlackTime) {
            ObjectResponse<Blacklist> objectResponse = blacklistService.getValidByPlate(parkId, plateNum);
            if (ObjectResponse.isSuccess(objectResponse)) {
                Blacklist blacklist = objectResponse.getData();
                Blacklist newBlackList = new Blacklist();
                newBlackList.setId(blacklist.getId());
                newBlackList.setRepeatNumbers(num);
                if (Integer.valueOf(2).equals(blacklist.getOperateType())) {
                    log.info("[重复入场] 黑名单已添加, 直接返回, [{}]", blacklist);
                    return;
                }
                //newBlackList.setReason((blacklist.getReason() == null ? "" : blacklist.getReason())
                //        + "; 重复入场次数达到[" + num + "]，系统自动添加");
                blacklistService.updateById(newBlackList);

                ReenterRecord reenterRecord = new ReenterRecord();
                reenterRecord.setBlackId(blacklist.getId().longValue());
                reenterRecordService.update(reenterRecord, new LambdaUpdateWrapper<ReenterRecord>()
                        .eq(ReenterRecord::getParkId, parkId)
                        .eq(ReenterRecord::getPlateNum, plateNum)
                        .eq(ReenterRecord::getBlackId, 0));
            } else {
                Blacklist blacklist = Blacklist.builder()
                        .parkId(parkId)
                        .plate(plateNum)
                        .owner(plateNum)
                        .carType(reenterRecords.get(0).getCarType())
                        .type(1)
                        .status(0)
                        //.reason("重复入场次数达到[" + num + "]，系统自动添加")
                        .operateType(2)
                        .repeatNumbers(num)
                        .operAccount("system").build();
                ObjectResponse<Integer> response = blacklistService.addBlackList(blacklist);
                if (ObjectResponse.isSuccess(response)) {
                    SendInfo sendInfo = new SendInfo(parkId, blacklist.getId().longValue(), DownServiceEnum.黑名单下发.getServiceType());
                    sendInfoDao.insert(sendInfo);

                    ReenterRecord reenterRecord = new ReenterRecord();
                    reenterRecord.setBlackId(blacklist.getId().longValue());
                    reenterRecordService.update(reenterRecord, new LambdaUpdateWrapper<ReenterRecord>()
                            .eq(ReenterRecord::getParkId, parkId)
                            .eq(ReenterRecord::getPlateNum, plateNum)
                            .eq(ReenterRecord::getBlackId, 0));
                }
            }
        }
    }

    protected boolean isMonthCard(CarEnterRequest enterRequest, ReportParamHolder paramHolder) {
        return PlateTypeEnum.月卡车.getType().equals(enterRequest.getType())
                || MonthDetailDto.MonthType.月卡车.equals(paramHolder.getOtherRegionMonthDetail().getMonthType())
                || MonthDetailDto.MonthType.过期月卡车.equals(paramHolder.getOtherRegionMonthDetail().getMonthType());
    }
    protected void updateRegionFreeSpace(ReportParamHolder paramHolder, Collection<RegionFreeSpaceUpdateVo> vos) {
        ParkConfig parkConfig = paramHolder.getParkConfig();
        if (org.apache.commons.collections.CollectionUtils.isEmpty(vos)) {
            return;
        }
        List<Integer> typeList = vos.stream().map(RegionFreeSpaceUpdateVo::getType).distinct().collect(Collectors.toList());
        if (!typeList.contains(PlateTypeEnum.月卡车.getType()) || NumberUtils.toPrimitive(parkConfig.getIsCardcount()) == 1) {
            Collection<Long> regionIds = vos.stream().map(RegionFreeSpaceUpdateVo::getRegionId).collect(Collectors.toSet());
            // 更新空车位
            if (parkConfig.getCalcSpaceMethod(1) == 1) {
                for (RegionFreeSpaceUpdateVo vo : vos) {
                    if (vo.getRegionId() != null) {
                        parkRegionDao.addFreeSpaceByPark(vo.getRegionId(), vo.getNum());
                    }
                }
            } else {
                parkRegionDao.updateFreeParkByIds(regionIds);
            }
            parkFreespaceDao.calculateFreeSpaceByParks(Collections.singleton(paramHolder.getParkId()));
            if (paramHolder.getRegionType() == 2) {
                for (Long regionId : regionIds) {
                    mqPushService.pushRegionFreeSpace(paramHolder.getParkId(), regionId);
                }
            }
        } else {
            for (RegionFreeSpaceUpdateVo vo : vos) {
                if (!PlateTypeEnum.月卡车.getType().equals(vo.getType())
                        || NumberUtils.toPrimitive(parkConfig.getIsCardcount()) == 1) {
                    if (vo.getRegionId() != null) {
                        continue;
                    }
                    if (parkConfig.getCalcSpaceMethod(1) == 1) {
                        parkRegionDao.addFreeSpaceByPark(vo.getRegionId(), vo.getNum());
                    } else {
                        parkRegionDao.updateFreeParkByIds(Collections.singleton(vo.getRegionId()));
                    }
                    parkFreespaceDao.calculateFreeSpaceByParks(Collections.singleton(paramHolder.getParkId()));
                    if (paramHolder.getRegionType() == 2) {
                        mqPushService.pushRegionFreeSpace(paramHolder.getParkId(), vo.getRegionId());
                    }
                }
            }
        }

    }
}
