package com.icetech.park.service.order.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.csp.sentinel.annotation.SentinelResource;
import com.alibaba.fastjson.TypeReference;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.github.pagehelper.PageHelper;
import com.google.common.collect.Lists;
import com.icetech.basics.dao.park.ParkDao;
import com.icetech.basics.domain.entity.VipType;
import com.icetech.basics.domain.entity.park.ParkConfig;
import com.icetech.basics.domain.entity.park.ParkInoutdevice;
import com.icetech.basics.domain.entity.park.ParkRegion;
import com.icetech.basics.sentinel.ExceptionUtils;
import com.icetech.basics.utils.FuzzyPlateTools;
import com.icetech.cloudcenter.api.AlarmService;
import com.icetech.cloudcenter.api.month.VipCarService;
import com.icetech.cloudcenter.api.order.OrderDiscountService;
import com.icetech.cloudcenter.api.order.OrderPayService;
import com.icetech.cloudcenter.api.order.OrderService;
import com.icetech.cloudcenter.api.park.ParkFreeSpaceService;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.cloudcenter.api.park.ParkVisitService;
import com.icetech.cloudcenter.api.store.StoreCardService;
import com.icetech.cloudcenter.api.third.ThirdInfoService;
import com.icetech.cloudcenter.domain.charge.dto.OrderSumFeeDto;
import com.icetech.cloudcenter.domain.constants.SpecialConstants;
import com.icetech.cloudcenter.domain.enumeration.DataCollectionEnum;
import com.icetech.cloudcenter.domain.enumeration.DownServiceEnum;
import com.icetech.cloudcenter.domain.enumeration.OrderOddStatusEnum;
import com.icetech.cloudcenter.domain.order.ModifyCarDto;
import com.icetech.cloudcenter.domain.order.OrderVO;
import com.icetech.cloudcenter.domain.request.BaseQueryRequest;
import com.icetech.cloudcenter.domain.request.FlowRequest;
import com.icetech.cloudcenter.domain.request.OrderAddRequest;
import com.icetech.cloudcenter.domain.request.OrderQueryRequest;
import com.icetech.cloudcenter.domain.request.PlateModifyCarRequest;
import com.icetech.cloudcenter.domain.request.QueryOrderFeeRequest;
import com.icetech.cloudcenter.domain.request.SearchCarRequest;
import com.icetech.cloudcenter.domain.request.ThirdFeeRequest;
import com.icetech.cloudcenter.domain.response.EnterCarDto;
import com.icetech.cloudcenter.domain.response.ExitCarDto;
import com.icetech.cloudcenter.domain.response.InParkNumInfoResponse;
import com.icetech.cloudcenter.domain.response.MonthOrderDto;
import com.icetech.cloudcenter.domain.response.OrderCountDto;
import com.icetech.cloudcenter.domain.response.OrderDto;
import com.icetech.cloudcenter.domain.response.OrderPayDto;
import com.icetech.cloudcenter.domain.response.PlateTypeDto;
import com.icetech.cloudcenter.domain.response.QueryOrderFeeResponse;
import com.icetech.cloudcenter.domain.response.SearchCarResponse;
import com.icetech.common.domain.SendRequest;
import com.icetech.fee.dao.monthcar.MonthPlateDao;
import com.icetech.fee.domain.entity.monthcar.MonthPlate;
import com.icetech.order.dao.OrderSonCarInfoDao;
import com.icetech.order.domain.dto.OrderInfoDto;
import com.icetech.order.domain.entity.OrderSonCarInfo;
import com.icetech.order.domain.entity.OrderTrack;
import com.icetech.order.service.OrderTagsService;
import com.icetech.park.domain.request.OrderStatusParam;
import com.icetech.park.domain.vo.ParkRecoveryVo;
import com.icetech.park.service.down.pnc.impl.ModifyCarServiceImpl;
import com.icetech.park.service.factory.UpdateFreeSpaceServiceFactory;
import com.icetech.park.service.freespace.UpdateFreeSpaceService;
import com.icetech.order.service.impl.OrderTrackServiceImpl;
import com.icetech.park.component.SnowFlackIdGenerator;
import com.icetech.park.service.freespace.UpdateParkFreeSpaceServiceImpl;
import com.icetech.park.service.freespace.UpdateRegionFreeSpaceServiceImpl;
import com.icetech.third.service.third.MqPushService;
import com.icetech.third.utils.DateRangeUtils;
import com.icetech.third.utils.RedisUtils;
import com.icetech.common.constants.CodeConstants;
import com.icetech.common.constants.CodeConstantsEnum;
import com.icetech.common.constants.OrderCarInfoConstant;
import com.icetech.common.constants.OrderStatusConstants;
import com.icetech.common.constants.PayStatusConstants;
import com.icetech.common.constants.PlateTypeEnum;
import com.icetech.common.domain.AsyncNotifyInterface;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.domain.response.PageQuery;
import com.icetech.common.exception.ResponseBodyException;
import com.icetech.common.utils.CodeTools;
import com.icetech.common.utils.DateTools;
import com.icetech.common.utils.JsonUtils;
import com.icetech.common.utils.NumberUtils;
import com.icetech.common.utils.UUIDTools;
import com.icetech.db.mybatis.base.service.impl.BaseServiceImpl;
import com.icetech.fee.dao.monthcar.MonthInfoDao;
import com.icetech.fee.dao.monthcar.MonthOrderDao;
import com.icetech.fee.domain.entity.monthcar.MonthInfo;
import com.icetech.fee.domain.entity.storecard.StoreCard;
import com.icetech.order.dao.OrderAfterPayDao;
import com.icetech.order.dao.OrderCarInfoDao;
import com.icetech.order.dao.OrderInfoDao;
import com.icetech.order.dao.OrderModifyRecordDao;
import com.icetech.order.dao.OrderPayDao;
import com.icetech.order.dao.OrderSonInfoDao;
import com.icetech.order.domain.entity.OrderAfterPay;
import com.icetech.order.domain.entity.OrderCarInfo;
import com.icetech.order.domain.entity.OrderDiscount;
import com.icetech.order.domain.entity.OrderInfo;
import com.icetech.order.domain.entity.OrderModifyRecord;
import com.icetech.order.domain.entity.OrderPay;
import com.icetech.order.domain.entity.OrderSonInfo;
import com.icetech.order.domain.entity.OrderTags;
import com.icetech.order.service.impl.OrderCarInfoServiceImpl;
import com.icetech.order.service.impl.OrderSonInfoServiceImpl;
import com.icetech.oss.OssService;
import com.icetech.park.dao.made.MadePlateDao;
import com.icetech.park.dao.vehicle.VehiclePlateDao;
import com.icetech.park.domain.entity.MadePlate;
import com.icetech.park.domain.entity.car.CarClean;
import com.icetech.park.domain.entity.park.Park;
import com.icetech.park.domain.entity.park.ParkFreespace;
import com.icetech.park.domain.entity.park.ParkRecovery;
import com.icetech.park.domain.entity.park.ParkVisit;
import com.icetech.park.domain.entity.vehicle.VehiclePlate;
import com.icetech.park.service.car.CarCleanService;
import com.icetech.park.service.down.pnc.impl.BatchSetExitServiceImpl;
import com.icetech.park.service.impl.QueryThirdFeeServiceImpl;
import com.icetech.park.service.monthcar.impl.MonthCarServiceImpl;
import com.icetech.park.service.park.ParkRecoveryService;
import com.icetech.park.service.park.impl.ParkMerchantServiceImpl;
import com.icetech.park.service.queryfee.impl.P2cQueryFeeServiceImpl;
import com.icetech.park.service.queryfee.impl.PncQueryFeeServiceImpl;
import com.icetech.third.anno.DS_SLAVE;
import com.icetech.third.dao.send.SendinfoDao;
import com.icetech.third.domain.entity.third.SendInfo;
import com.icetech.third.domain.entity.third.ThirdInfo;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.util.TextUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.core.annotation.Order;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

@Slf4j
@RefreshScope
@Service("orderService")
public class OrderServiceImpl extends BaseServiceImpl<OrderInfoDao, OrderInfo> implements OrderService {
    @Autowired
    private OrderInfoDao orderInfoDao;
    @Resource
    private ParkService parkService;
    @Resource
    private ParkDao parkDao;
    @Autowired
    private com.icetech.park.service.order.impl.QueryOrderFeeServiceImpl queryOrderFeeService;
    @Resource
    private OrderCarInfoDao orderCarInfoDao;
    @Resource
    private OrderCarInfoServiceImpl orderCarInfoService;
    @Autowired
    private OssService ossService;
    @Autowired
    private P2cQueryFeeServiceImpl p2cQueryFeeService;
    @Autowired
    private PncQueryFeeServiceImpl pncQueryFeeService;
    @Autowired
    private RedisUtils redisUtils;
    @Autowired
    private OrderPayDao orderPayDao;
    @Autowired
    private MonthOrderDao monthOrderDao;
    @Autowired
    private OrderPayService orderPayService;
    @Autowired
    private MonthInfoDao monthInfoDao;
    @Autowired
    private ParkFreeSpaceService parkFreeSpaceService;
    @Autowired
    private UpdateFreeSpaceServiceFactory updateFreeSpaceServiceFactory;
    @Autowired
    private MonthCarServiceImpl monthCarService;
    @Autowired
    private VehiclePlateDao vehiclePlateDao;
    @Autowired
    private VipCarService vipCarService;
    @Autowired
    private ParkVisitService parkVisitService;
    @Autowired
    private OrderAfterPayDao orderAfterPayDao;
    /**
     * 车牌置信度低人工修正表
     */
    @Autowired
    private MadePlateDao madePlateDao;
    /**
     *
     */
    @Autowired
    private OrderModifyRecordDao orderModifyRecordDao;
    @Autowired
    private SendinfoDao sendinfoDao;
    @Autowired
    private AlarmService alarmService;
    @Autowired
    private QueryThirdFeeServiceImpl queryThirdFeeService;
    @Autowired
    private OrderSonInfoServiceImpl orderSonInfoService;
    @Autowired
    private CarCleanService carCleanService;
    @Autowired
    private OrderTagsService orderTagsService;
    @Autowired
    private ModifyCarServiceImpl modifyCarService;
    /**
     * 月卡
     */
    private static final Integer MONTH_CARD = 2;
    /**
     * 无需支付
     */
    private static final Integer NO_NEED_PAY = 1;

    /**
     * 车牌可信度是否需要插入人工修改表的阈值
     */
    @Value(value = "${secondrec.reliability.threshold}")
    public Integer reliabilityThreshold;

    /**
     * 储值卡操作服务类
     */
    @Autowired
    private StoreCardService storeCardService;

    /**
     * 三方配置信息类
     */
    @Autowired
    private ThirdInfoService thirdInfoService;
    @Resource
    protected MqPushService pushService;
    @Autowired
    private BatchSetExitServiceImpl batchSetExitService;
    @Autowired
    private OrderSonInfoDao orderSonInfoDao;

    @Autowired
    private ParkRecoveryService parkRecoveryService;
    @Autowired
    private OrderDiscountService orderDiscountService;
    @Autowired
    private ParkMerchantServiceImpl parkMerchantService;
    @Autowired
    private MonthPlateDao monthPlateDao;

    @Autowired
    private OrderSonCarInfoDao orderSonCarInfoDao;

    @Autowired
    private OrderTrackServiceImpl orderTrackService;

    @Autowired
    private SnowFlackIdGenerator idGenerator;
    @Autowired
    private UpdateRegionFreeSpaceServiceImpl updateRegionFreeSpaceService;
    @Autowired
    private UpdateParkFreeSpaceServiceImpl updateParkFreeSpaceService;

    @Override
    public ObjectResponse<String> addOrderAfterPay(Long parkId, OrderInfo orderInfo, Integer type) {
        String tradeNo = CodeTools.GenerateTradeNo();
        try {
            OrderAfterPay orderAfterPay = new OrderAfterPay();
            orderAfterPay.setOrderNum(orderInfo.getOrderNum());
            orderAfterPay.setPlateNum(orderInfo.getPlateNum());
            orderAfterPay.setTradeNo(tradeNo);
            orderAfterPay.setParkId(parkId.intValue());
            orderAfterPay.setPaidPrice(orderInfo.getPaidPrice());
            orderAfterPay.setDiscountPrice(orderInfo.getDiscountPrice());
            orderAfterPay.setTotalPrice(String.valueOf(NumberUtils.parseDouble(orderInfo.getPaidPrice())
                    + NumberUtils.parseDouble(orderInfo.getDiscountPrice())));
            orderAfterPay.setType(Objects.isNull(type) ? 1 : type);
            orderAfterPayDao.insert(orderAfterPay);
        } catch (Exception e) {
            log.error("处理失败: {}. parkId[{}], queryOrderFeeResponse[{}]", e.getMessage(), parkId, orderInfo, e);
            return ObjectResponse.failed(CodeConstantsEnum.ERROR);
        }
        return ObjectResponse.success(tradeNo);
    }

    @Override
    public ObjectResponse<List<OrderAfterPay>> selectAfterPayList(Integer status, Integer type) {
        List<OrderAfterPay> orderAuthInfos = orderAfterPayDao.selectAfterPay(status, type);
        return ObjectResponse.success(orderAuthInfos);
    }

    @Override
    public ObjectResponse<List<OrderAfterPay>> selectAfterPayLists(Integer status, Integer type, String time) {
        List<OrderAfterPay> orderAuthInfos = orderAfterPayDao.selectAfterPays(status, type, time);
        return ObjectResponse.success(orderAuthInfos);
    }

    @Override
    public ObjectResponse updateAfterPay(OrderAfterPay orderAfterPay) {
        orderAfterPay.setUpdateTime(new Date());
        if (orderAfterPay.getRequestNum() != null && orderAfterPay.getRequestNum() >= 22) {
            orderAfterPay.setStatus(2);
        }
        int update = orderAfterPayDao.update(orderAfterPay);
        return ObjectResponse.success(update);
    }


    @Override
    public ObjectResponse<List<EnterCarDto>> getAlarmPlateList(String parkCode, Date startTime, Date endTime) {
        List<EnterCarDto> list = new ArrayList<>();
        try {
            if (!TextUtils.isEmpty(parkCode)) {
                String[] split = parkCode.split(",");
                if (null != split && split.length > 0) {
                    String parkid = parkDao.selectByCodes(split);
                    if (!TextUtils.isEmpty(parkid)) {
                        String timeString = Objects.isNull(startTime) ? null : DateTools.getFormat(startTime);
                        log.info("getAlarmPlateList ====>{}", timeString);
                        List<OrderInfo> strings = orderInfoDao.selectMadeOrders(parkid, timeString);
                        for (int i = 0; i < strings.size(); i++) {
                            EnterCarDto enterCarDto = new EnterCarDto();
                            OrderInfo orderInfo = strings.get(i);
                            OrderInfo orderInfo1 = orderInfoDao.selectLimitOneOrderByEnterDesc(orderInfo);
                            Park park = parkService.findByParkId(orderInfo1.getParkId()).getData();
                            enterCarDto.setPlateNumber(orderInfo1.getPlateNum());
                            enterCarDto.setParkName(park.getParkName());
                            enterCarDto.setOrderNum(orderInfo1.getOrderNum());
                            list.add(enterCarDto);
                        }
                    }
                }
            }
            return ObjectResponse.success(list);
        } catch (Exception e) {
            log.error("处理失败: {}. parkCode[{}], startTime[{}], endTime[{}]", e.getMessage(), parkCode, startTime, endTime, e);
            return ObjectResponse.failed(CodeConstantsEnum.ERROR);
        }
    }

    @Override
    @DS_SLAVE
    @SentinelResource(value = "OrderService.countExitCarList",
            defaultFallback = "defaultFallbackHandle", fallbackClass = {ExceptionUtils.class})
    public ObjectResponse<Map<String, Object>> countExitCarList(OrderQueryRequest orderQueryRequest) {
        try {
            String parkCode = orderQueryRequest.getParkCode();
            String plateNumber = orderQueryRequest.getPlateNumber();
            Date startTime = orderQueryRequest.getStartTime();
            Date endTime = orderQueryRequest.getEndTime();
            Date enterStartTime = orderQueryRequest.getEnterStartTime();
            Date enterEndTime = orderQueryRequest.getEnterEndTime();
            List<Integer> type = orderQueryRequest.getTypes();
            String[] split = parkCode.split(",");
            String parkid = parkDao.selectByCodes(split);
            if (StringUtils.isNotEmpty(plateNumber)) {
                plateNumber = plateNumber.toUpperCase();
            }
            int count = orderInfoDao.countExitRecords(parkid,
                    Objects.isNull(startTime) ? null : startTime.getTime() / 1000,
                    Objects.isNull(endTime) ? null : endTime.getTime() / 1000,
                    plateNumber, type,
                    Objects.isNull(enterStartTime) ? null : enterStartTime.getTime() / 1000,
                    Objects.isNull(enterEndTime) ? null : enterEndTime.getTime() / 1000,
                    orderQueryRequest.getTagIds());
            Map<String, Object> map = new HashMap<>();
            map.put("count", count);
            return ObjectResponse.success(map);
        } catch (Exception e) {
            log.error("[车场管家获取离场车辆总数据量接口]处理失败: {}. orderQueryRequest[{}]", e.getMessage(), orderQueryRequest, e);
            return ObjectResponse.failed(CodeConstantsEnum.ERROR);
        }
    }

    private ObjectResponse<Long> delOrder(String orderNum, String username, boolean syncLocal) {
        OrderInfo orderinfo = orderInfoDao.selectByOrderNum(orderNum);
        if (orderinfo != null) {
            orderinfo.setServiceStatus(OrderStatusConstants.CANCEL);
            int update = orderInfoDao.updateByOrderNum(orderinfo);
            if (update > 0) {
                OrderSonInfo orderSonInfo = null;
                if (Integer.valueOf(1).equals(orderinfo.getHasSon())) {
                    List<OrderSonInfo> orderSonInfos = orderSonInfoDao.selectList(Wrappers.lambdaQuery(OrderSonInfo.class)
                            .eq(OrderSonInfo::getOrderNum, orderNum)
                            .eq(OrderSonInfo::getServiceStatus, 1));
                    orderSonInfo = CollectionUtils.isEmpty(orderSonInfos) ? null : orderSonInfos.get(0);

                    OrderSonInfo orderSonInfoUpdate = new OrderSonInfo();
                    orderSonInfoUpdate.setServiceStatus(OrderStatusConstants.CANCEL);
                    orderSonInfoDao.update(orderSonInfoUpdate, Wrappers.lambdaQuery(OrderSonInfo.class)
                            .eq(OrderSonInfo::getOrderNum, orderNum)
                            .eq(OrderSonInfo::getServiceStatus, 1));
                }
                OrderModifyRecord orderModifyRecord = new OrderModifyRecord();
                // 修正类型
                orderModifyRecord.setAction(2);
                orderModifyRecord.setOrderNum(orderNum);
                orderModifyRecord.setParkId(orderinfo.getParkId());
                orderModifyRecord.setModifyTime(DateTools.getFormat(new Date()));
                orderModifyRecordDao.insert(orderModifyRecord);
                if (StringUtils.isNotEmpty(username)) {
                    String enterImageUrl = null;
                    OrderCarInfo orderCarInfo = orderCarInfoDao.selectByOrderNum(orderNum);
                    if (Objects.nonNull(orderCarInfo) && StringUtils.isNotBlank(orderCarInfo.getEnterImage())) {
                        enterImageUrl = orderCarInfo.getEnterImage();
                    }
                    CarClean carClean = CarClean.builder()
                            .parkId(orderinfo.getParkId())
                            .batchCode(UUIDTools.getUuid())
                            .orderNum(orderinfo.getOrderNum())
                            .enterTime(getEnterTime(orderinfo.getEnterTime(), orderinfo.getCreateTime()))
                            .carType(orderinfo.getCarType())
                            .plateNum(orderinfo.getPlateNum())
                            .operator(username)
                            .enterImage(enterImageUrl)
                            .type(3)
                            .build();
                    carCleanService.save(carClean);
                }

                if (syncLocal) {
                    sendinfoDao.insert(new SendInfo(orderinfo.getParkId(), orderModifyRecord.getId(), DownServiceEnum.订单修改.getServiceType()));
                }
                // 重新计算车位
                ObjectResponse<ParkConfig> configResp = parkService.getParkConfig(orderinfo.getParkId());
                if (!ObjectResponse.isSuccess(configResp)) {
                    log.warn("查找订单[{}]对应车场高级配置信息失败: {} - {}", orderNum, configResp.getCode(), configResp.getMsg());
                    return ObjectResponse.failed(CodeConstants.ERROR_404, "车场高级配置不存在");
                }
                ParkConfig parkConfig = configResp.getData();
                if (parkConfig.getDelOrderCalcSpaceFlag(0) == 1
                        && (!PlateTypeEnum.月卡车.getType().equals(orderinfo.getType())
                        || NumberUtils.toPrimitive(parkConfig.getIsCardcount()) == 1)) {
                    UpdateFreeSpaceService updateFreeSpaceService = updateFreeSpaceServiceFactory.getUpdateFreeSpaceService(parkConfig.getParkId());
                    Long regionId = orderSonInfo != null ? orderSonInfo.getRegionId() : null;
                    if (parkConfig.getCalcSpaceMethod(1) == 1) {
                        updateFreeSpaceService.addFreeSpace(orderinfo.getParkId(), regionId, 1);
                    } else {
                        updateFreeSpaceService.syncFreeSpace(orderinfo.getParkId(), regionId);
                    }
                }

                //释放优惠券占位
                OrderDiscount param = new OrderDiscount();
                param.setParkId(orderinfo.getParkId());
                param.setOrderNum(orderinfo.getOrderNum());
                param.setStatus(0);
                ObjectResponse<List<OrderDiscount>> list = orderDiscountService.findList(param);
                if (!CollectionUtils.isEmpty(list.getData())) {
                    for (OrderDiscount orderDiscount : list.getData()) {
                        parkMerchantService.releasePlace(orderDiscount);
                    }
                }
                return ObjectResponse.success(orderModifyRecord.getId());
            }
        }
        return ObjectResponse.failed(CodeConstants.ERROR_404);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public ObjectResponse<Long> delOrder(String orderNum, String username) {
        return delOrder(orderNum, username, true);
    }

    public Long getEnterTime(Long enterTime, Date createTime) {
        if (enterTime != null) {
            return enterTime;
        }
        return DateUtil.toLocalDateTime(createTime).toEpochSecond(ZoneOffset.of("+8"));
    }

    /**
     * 判断是否是月卡车
     *
     * @param parkId
     * @param plateNumber
     * @return
     */
    private boolean isMonthCar(Long parkId, String plateNumber) {
        MonthInfo monthInfo = monthInfoDao.selectByPlateNum(parkId, plateNumber, 1);
        if (monthInfo != null) {
            return true;
        } else {
            return false;
        }
    }

    private boolean isVipCar(Long parkId, String plateNumber, Long regionId) {
        ObjectResponse<VipType> validVipCar = vipCarService.getValidVipCar(parkId, plateNumber, regionId);
        if (ObjectResponse.isSuccess(validVipCar)) {
            return true;
        } else {
            return false;
        }
    }

    @Override
    public ObjectResponse checkCar(String orderNum, String plateNumber, Integer carType) {
        OrderInfo order = new OrderInfo();
        order.setOrderNum(orderNum);
        OrderInfo orderinfo = orderInfoDao.selectByOrderNum(orderNum);
        if (orderinfo != null) {
            List<Integer> type = new ArrayList<>();
            type.add(orderinfo.getType());
            List<OrderInfo> orderInfos = orderInfoDao.selectEnterRecords(
                    String.valueOf(orderinfo.getParkId()), null, null, plateNumber, type, null, null, null);
            if (orderInfos.size() == 0) {
                return ObjectResponse.failed(CodeConstants.SUCCESS);
            }
        }
        return ObjectResponse.failed(CodeConstants.ERROR_405);
    }

    @Override
    @Transactional
    public ObjectResponse modifyCar(String orderNum, String plateNumber, Integer carType) {
        PlateModifyCarRequest plateModifyCarRequest = new PlateModifyCarRequest();
        plateModifyCarRequest.setOrderNum(orderNum);
        plateModifyCarRequest.setNewPlateNum(plateNumber);
        plateModifyCarRequest.setNewCarType(carType);
        return modifyCar(plateModifyCarRequest);
    }

    @Override
    public ObjectResponse<Long> modifyCar(ModifyCarDto dto) {
        String orderNum = dto.getOrderNum();
        //删除订单
        if (dto.getAction() == 2) {
            return delOrder(orderNum, null, dto.isSyncLocal());
        }
        OrderInfo orderinfo = orderInfoDao.selectByOrderNum(orderNum);
        if (orderinfo != null) {
            return modifyCar(dto, orderinfo);
        } else {
            return ObjectResponse.failed(CodeConstants.ERROR_404);
        }
    }

    @Override
    public ObjectResponse<Long> modifyCar(PlateModifyCarRequest plateModifyCarRequest) {
        if (StringUtils.isEmpty(plateModifyCarRequest.getOrderNum())
                || (plateModifyCarRequest.getNewPlateNum() == null
                && plateModifyCarRequest.getNewCarType() == null)) {
            return ObjectResponse.failed(CodeConstants.ERROR_400);
        }
        OrderInfo orderInfo = orderInfoDao.selectByOrderNum(plateModifyCarRequest.getOrderNum());
        // 车场权限校验
        if (Objects.nonNull(plateModifyCarRequest.getParkCodes())) {
            String[] split = plateModifyCarRequest.getParkCodes().split(",");
            String parkIds = parkDao.selectByCodes(split);
            if (parkIds.endsWith(",")) {
                parkIds = parkIds.substring(0, parkIds.length() - 1);
            }
            String[] parkIdList = parkIds.split(",");
            if (parkIdList.length == 0
                    || Arrays.stream(parkIdList).noneMatch(str -> str.equals(orderInfo.getParkId().toString()))) {
                return ObjectResponse.failed(CodeConstants.ERROR_404);
            }
        }
        // 车场权限校验
        if (CollectionUtils.isNotEmpty(plateModifyCarRequest.getParkIds())
                && !plateModifyCarRequest.getParkIds().contains(-1L)) {
            if (!plateModifyCarRequest.getParkIds().contains(orderInfo.getParkId())) {
                return ObjectResponse.failed(CodeConstants.ERROR_404);
            }
        }
        if (orderInfo != null) {
            int correctType;
            String beforeModify;
            String afterModify;
            ModifyCarDto modifyCarDto = new ModifyCarDto();
            modifyCarDto.setOrderNum(plateModifyCarRequest.getOrderNum());
            modifyCarDto.setOperAccount(plateModifyCarRequest.getOperAccount());
            if (orderInfo.getPlateNum().equals(plateModifyCarRequest.getNewPlateNum())
                    && orderInfo.getCarType().equals(plateModifyCarRequest.getNewCarType())) {
                return ObjectResponse.failed(CodeConstants.ERROR_405);
            }
            boolean success = true;
            if (!orderInfo.getPlateNum().equals(plateModifyCarRequest.getNewPlateNum())) {
                correctType = 1;
                beforeModify = orderInfo.getPlateNum();
                afterModify = plateModifyCarRequest.getNewPlateNum();
                modifyCarDto.setModifyType(correctType);
                modifyCarDto.setNewVal(afterModify);
                modifyCarDto.setOldVal(beforeModify);
                ObjectResponse objectResponse = modifyCar(modifyCarDto);
                success = ObjectResponse.isSuccess(objectResponse);
            } else {
                //更新车牌置信度低人工修正表
                MadePlate madePlate = new MadePlate();
                madePlate.setNewPlateNum(plateModifyCarRequest.getNewPlateNum());
                madePlate.setOrderNum(plateModifyCarRequest.getOrderNum());
                madePlate.setOperAccount(plateModifyCarRequest.getOperAccount());
                //更新为1，已处理
                madePlate.setStatus(1);
                updateMadePlate(madePlate);
            }
            if (Objects.nonNull(plateModifyCarRequest.getNewCarType())
                    && !orderInfo.getCarType().equals(plateModifyCarRequest.getNewCarType())) {
                correctType = 2;
                beforeModify = String.valueOf(orderInfo.getCarType());
                afterModify = String.valueOf(plateModifyCarRequest.getNewCarType());
                modifyCarDto.setModifyType(correctType);
                modifyCarDto.setNewVal(afterModify);
                modifyCarDto.setOldVal(beforeModify);
                ObjectResponse objectResponse = modifyCar(modifyCarDto);
                success = success && ObjectResponse.isSuccess(objectResponse);
            }
            return success ? ObjectResponse.success() : ObjectResponse.failed(CodeConstants.ERROR);

        } else {
            return ObjectResponse.failed(CodeConstants.ERROR_404);
        }
    }

    /**
     * @param dto
     * @param orderInfo
     * @return 订单修改记录ID
     */
    private ObjectResponse<Long> modifyCar(ModifyCarDto dto, OrderInfo orderInfo) {
        String orderNum = orderInfo.getOrderNum();
        Integer modifyType = dto.getModifyType();
        String newVal = dto.getNewVal();
        String oldVal = dto.getOldVal();
        String carDesc = dto.getCarDesc();

        int updateRows = 0;
        //更新修正操作记录表
        OrderModifyRecord modifyRecord = new OrderModifyRecord();
        //修正类型
        modifyRecord.setAction(dto.getAction());
        //修正表数据
        modifyRecord.setCorrectType(modifyType);
        modifyRecord.setOrderNum(orderNum);
        modifyRecord.setParkId(orderInfo.getParkId());
        modifyRecord.setBeforeModify(oldVal);
        modifyRecord.setAfterModify(newVal);
        if (modifyType == 1) {
            String plateNumber = newVal;
            //监测是否有相同车牌号的订单
            List<OrderInfo> orderInfos = orderInfoDao.selectEnterRecords(
                    String.valueOf(orderInfo.getParkId()), null, null, plateNumber, null, null, null, null);
            ParkConfig parkConfig = parkService.getParkConfig(orderInfo.getParkId()).getData();
            if (orderInfos.size() > 0) {
                OrderInfo orderInfo1 = orderInfos.get(0);
                //正确车牌的入场时间大于错误车牌的入场时间时，取消错误的，否则取消正确的
                if (orderInfo1.getEnterTime() > orderInfo.getEnterTime()) {
                    orderInfo.setServiceStatus(OrderStatusConstants.CANCEL);
                    orderInfoDao.updateByOrderNum(orderInfo);

                    //更新空车位
                    freeSpaceHandle(orderInfo, parkConfig);
                    orderInfo = orderInfo1;
                } else {
                    orderInfo1.setServiceStatus(OrderStatusConstants.CANCEL);
                    orderInfoDao.updateByOrderNum(orderInfo1);

                    //更新空车位
                    freeSpaceHandle(orderInfo1, parkConfig);
                }

            }
            //端云的以平台业务数据为准，端网云以本地上报为准
            if (parkConfig.getDataCollection().equals(1) || parkConfig.getDataCollection().equals(3)) {
                ObjectResponse<PlateTypeDto> plateType = getPlateType(orderInfo.getParkId(), plateNumber);
                PlateTypeDto data = plateType.getData();
                orderInfo.setType(data.getPlateTypeEnum().getType());
            }
            orderInfo.setPlateNum(plateNumber);
            updateRows = orderInfoDao.updateByOrderNum(orderInfo);

        } else if (modifyType == 2) {
            String carType = newVal;
            try {
                orderInfo.setCarType(Integer.parseInt(carType));
            } catch (NumberFormatException e) {
                return ObjectResponse.failed(CodeConstants.ERROR_402, "车型修改时值类型错误");
            }
            updateRows = orderInfoDao.updateByOrderNum(orderInfo);

        } else if (modifyType == 3) {
            try {
                orderInfo.setType(Integer.parseInt(newVal));
            } catch (NumberFormatException e) {
                return ObjectResponse.failed(CodeConstants.ERROR_402, "车辆类型修改时值类型错误");
            }
            if (StringUtils.isNotBlank(carDesc)) {
                orderInfo.setCarDesc(carDesc);
                modifyRecord.setAfterCardesc(carDesc);
                modifyRecord.setBeforeCardesc(orderInfo.getCarDesc());
            }
            updateRows = orderInfoDao.updateByOrderNum(orderInfo);
        }

        if (updateRows > 0) {
            modifyRecord.setModifyTime(DateTools.getFormat(new Date()));
            orderModifyRecordDao.insert(modifyRecord);
            if (dto.isSyncLocal()) {
                sendinfoDao.insert(new SendInfo(orderInfo.getParkId(), modifyRecord.getId(), DownServiceEnum.订单修改.getServiceType()));
            }
            if (modifyType == 1) {
                //更新车牌置信度低人工修正表
                MadePlate madePlate = new MadePlate();
                madePlate.setNewPlateNum(newVal);
                madePlate.setOrderNum(orderNum);
                madePlate.setOperAccount(dto.getOperAccount());
                //更新为1，已处理
                madePlate.setStatus(1);
                updateMadePlate(madePlate);
            }
            return ObjectResponse.success(modifyRecord.getId());
        } else {
            return ObjectResponse.failed(CodeConstants.ERROR, "修改车牌信息失败");
        }
    }

    private OrderSonInfo freeSpaceHandle(OrderInfo orderInfo, ParkConfig parkConfig) {
        OrderSonInfo orderSonInfo = null;
        if (Integer.valueOf(1).equals(orderInfo.getHasSon())) {
            orderSonInfo = orderSonInfoDao.selectOrderSonInpark(orderInfo.getPlateNum(), orderInfo.getParkId());
            OrderSonInfo orderSonInfoUpdate = new OrderSonInfo();
            orderSonInfoUpdate.setServiceStatus(OrderStatusConstants.CANCEL);
            orderSonInfoDao.update(orderSonInfoUpdate, Wrappers.lambdaQuery(OrderSonInfo.class)
                    .eq(OrderSonInfo::getOrderNum, orderInfo.getOrderNum())
                    .eq(OrderSonInfo::getServiceStatus, 1));
        }

        // 判断订单是否为月卡车
        if (!PlateTypeEnum.月卡车.getType().equals(orderInfo.getType()) || NumberUtils.toPrimitive(parkConfig.getIsCardcount()) == 1) {
            UpdateFreeSpaceService updateFreeSpaceService = updateFreeSpaceServiceFactory.getUpdateFreeSpaceService(parkConfig.getParkId());
            Long regionId = orderSonInfo != null ? orderSonInfo.getRegionId() : null;
            if (parkConfig.getCalcSpaceMethod(1) == 1) {
                updateFreeSpaceService.addFreeSpace(orderInfo.getParkId(), regionId, 1);
            } else {
                updateFreeSpaceService.syncFreeSpace(orderInfo.getParkId(), regionId);
            }
        }
        log.info("[修改车牌服务] 有重复订单，增加空车位，parkId：{}", orderInfo.getParkId());
        return orderSonInfo;
    }

    @Override
    @DS_SLAVE
    @SentinelResource(value = "OrderService.selectListByParam",
            defaultFallback = "defaultFallbackHandle", fallbackClass = {ExceptionUtils.class})
    public ObjectResponse<List<OrderInfo>> selectListByParam(Long parkId, Long startTime, Long endTime, String plateNumber) {
        List<OrderInfo> list = orderInfoDao.selectListByParam(parkId, startTime, endTime, plateNumber);
        if (list != null && list.size() > 0) {
            return ObjectResponse.success(list);
        } else {
            return ObjectResponse.failed(CodeConstants.ERROR_404);
        }
    }

    @Override
    public ObjectResponse<OrderInfo> findByOrderNum(String orderNum) {
        if (StringUtils.isEmpty(orderNum)) {
            return ObjectResponse.failed(CodeConstants.ERROR_400);
        }
        OrderInfo orderInfo = orderInfoDao.selectByOrderNum(orderNum);
        if (orderInfo != null) {
            return ObjectResponse.success(orderInfo);
        } else {
            log.info("根据订单号查询订单，未找到结果，参数：{}", orderNum);
            return ObjectResponse.failed(CodeConstants.ERROR_404);
        }
    }

    @Override
    public ObjectResponse<OrderInfo> findWithHistoryByOrderNum(String orderNum) {
        if (StringUtils.isEmpty(orderNum)) {
            return ObjectResponse.failed(CodeConstants.ERROR_400);
        }
        Date startDate = DateUtil.offsetDay(DateUtil.date(), -365);
        OrderInfo orderInfo = orderInfoDao.selectWithHistoryByOrderNum(
                DateRangeUtils.getYearQuarterRangeTableName(startDate), orderNum);
        if (orderInfo != null) {
            return ObjectResponse.success(orderInfo);
        } else {
            log.info("根据订单号查询订单，未找到结果，参数：{}", orderNum);
            return ObjectResponse.failed(CodeConstants.ERROR_404);
        }
    }

    @Override
    public List<OrderInfo> findWithHistoryByOrderNums(List<String> orderNums, List<String> tables) {
        if (CollectionUtils.isEmpty(orderNums)) {
            return null;
        }
        return orderInfoDao.selectWithHistoryByOrderNumList(tables, orderNums);
    }

    @Override
    public ObjectResponse<OrderInfo> findInPark(String plateNum, String parkCode) {
        Long parkId = null;
        if (parkCode != null) {
            Park park = parkService.findByParkCode(parkCode).getData();
            if (park == null) {
                return ObjectResponse.failed(CodeConstants.ERROR_400, "车场编号不存在");
            }
            parkId = park.getId();
        }
        return findInParkId(plateNum, parkId);
    }

    @Override
    public ObjectResponse<OrderInfo> findInParkId(String plateNum, Long parkId) {
        if (StringUtils.isEmpty(plateNum) || SpecialConstants.NO_PLATE_NUM.equals(plateNum) || SpecialConstants.NO_PLATE_NUM2.equals(plateNum)) {
            return ObjectResponse.failed(CodeConstants.ERROR_400);
        }
        OrderInfo orderInfoPara = new OrderInfo();
        orderInfoPara.setParkId(parkId);
        orderInfoPara.setPlateNum(plateNum);
        orderInfoPara.setServiceStatus(OrderStatusConstants.IN_PARK);
        List<OrderInfo> orderInfos = orderInfoDao.selectListOrderByEnterDesc(orderInfoPara);
        if (!CollectionUtils.isEmpty(orderInfos)) {
            OrderInfo orderInfo = orderInfos.get(0);
            if (orderInfos.size() == 1) {
                return ObjectResponse.success(orderInfo);
            } else {
                OrderCarInfo orderCarInfo = orderCarInfoDao.selectByOrderNum(orderInfo.getOrderNum());
                if (orderCarInfo == null || Integer.valueOf(5).equals(orderCarInfo.getEnterWay())) {
                    OrderInfo orderInfo2 = orderInfos.get(1);
                    OrderCarInfo orderCarInfo2 = orderCarInfoDao.selectByOrderNum(orderInfo2.getOrderNum());
                    if (orderCarInfo2 != null && !Integer.valueOf(5).equals(orderCarInfo2.getEnterWay())) {
                        orderInfo = orderInfo2;
                    }
                }
                return ObjectResponse.success(orderInfo);
            }
        } else {
            orderInfoPara.setServiceStatus(null);
            OrderInfo orderInfo = orderInfoDao.selectLimitOneByIdDesc(orderInfoPara);
            if (orderInfo == null) {
                log.info("根据车场编号和车牌号未查询到场内订单, 参数:{}, {}", plateNum, parkId);
            } else if (orderInfo.getServiceStatus().equals(OrderStatusConstants.EXCEPTION)
                    && (orderInfo.getNoneEnterFlag() == null || orderInfo.getNoneEnterFlag() == 0)) {
                OrderCarInfo orderCarInfo = orderCarInfoDao.selectByOrderNum(orderInfo.getOrderNum());
                //不是断电应急入场
                if (orderCarInfo != null && !Integer.valueOf(5).equals(orderCarInfo.getEnterWay())
                        && OrderOddStatusEnum.非正常出场.getVal().equals(orderInfo.getOddStatus())) {
                    if (orderInfo.getExitTime() == null || orderInfo.getExitTime() > (DateTools.unixTimestamp() - 24 * 3600)) {
                        log.info("根据车场编号和车牌号查询到了最后一次订单是异常离场, 参数:{}, {}, {}, {}", plateNum, parkId, orderInfo.getId(),
                                orderInfo.getExitTime());
                        return ObjectResponse.success(orderInfo);
                    }
                }
            }
            return ObjectResponse.failed(CodeConstantsEnum.ERROR_404.getCode(), "您的爱车不在场");
        }
    }

    @Override
    public ObjectResponse<OrderSonInfo> findOrderSon(String orderNum, Long regionId) {
        if (orderNum == null || regionId == null) {
            return ObjectResponse.failed(CodeConstants.ERROR_400);
        }
        OrderSonInfo param = new OrderSonInfo();
        param.setOrderNum(orderNum);
        param.setRegionId(regionId);
        OrderSonInfo orderSonInfo = orderSonInfoDao.selectOneByEntity(param);
        return ObjectResponse.returnNotFoundIfNull(orderSonInfo);
    }

    @Override
    @DS_SLAVE
    @SentinelResource(value = "OrderService.searchCarInfo",
            defaultFallback = "defaultFallbackHandle", fallbackClass = {ExceptionUtils.class})
    public ObjectResponse<List<SearchCarResponse>> searchCarInfo(PageQuery<SearchCarRequest> pageQuery) {
        SearchCarRequest searchCarRequest = pageQuery.getParam();
        String parkCode = searchCarRequest.getParkCode();
        String plateNum = searchCarRequest.getPlateNum();
        Park park = parkService.findByParkCode(parkCode).getData();
        if (park == null) {
            return ObjectResponse.failed(CodeConstants.ERROR_402, "车场未注册");
        }
        Long parkId = park.getId();

        List<OrderInfo> orderInfos = getOrderInfos(pageQuery, plateNum, parkId);
        if (orderInfos != null && orderInfos.size() > 0) {
            List<SearchCarResponse> list = new ArrayList<SearchCarResponse>();
            for (OrderInfo orderInfo1 : orderInfos) {
                SearchCarResponse searchCarResponse = getSearchCarResponse(parkCode, plateNum, orderInfo1);
                list.add(searchCarResponse);
            }
            return ObjectResponse.success(list);
        } else {
            return ObjectResponse.failed(CodeConstants.ERROR_404);
        }
    }

    @Override
    public ObjectResponse<OrderInfo> findByOrderInfo(OrderInfo orderInfo) {
        OrderInfo orderInfoRet = orderInfoDao.selectLimitOneOrderByEnterDesc(orderInfo);
        if (orderInfoRet != null) {
            return ObjectResponse.success(orderInfoRet);
        } else {
            return ObjectResponse.failed(CodeConstants.ERROR_404);
        }
    }

    @Override
    @DS_SLAVE
    @SentinelResource(value = "OrderService.countEnterCarList",
            defaultFallback = "defaultFallbackHandle", fallbackClass = {ExceptionUtils.class})
    public ObjectResponse<Map<String, Object>> countEnterCarList(OrderQueryRequest orderQueryRequest) {
        try {
            String parkCode = orderQueryRequest.getParkCode();
            String plateNumber = orderQueryRequest.getPlateNumber();
            Date startTime = orderQueryRequest.getStartTime();
            Date endTime = orderQueryRequest.getEndTime();
            Integer reliability = orderQueryRequest.getReliability();
            List<Integer> type = orderQueryRequest.getTypes();
            String[] split = parkCode.split(",");
            String parkid = parkDao.selectByCodes(split);
            if (StringUtils.isNotEmpty(plateNumber)) {
                plateNumber = plateNumber.toUpperCase();
            }
            //查询在场记录信息
            int count = orderInfoDao.countEnterRecords(parkid,
                    Objects.isNull(startTime) ? null : startTime.getTime() / 1000, Objects.isNull(endTime) ? null : endTime.getTime() / 1000, plateNumber, type, reliability);
            Map<String, Object> map = new HashMap<>();
            map.put("count", count);
            return ObjectResponse.success(map);
        } catch (Exception e) {
            log.error("[车场管家获取入场车辆总条数接口]处理失败: {}. orderQueryRequest[{}]", e.getMessage(), orderQueryRequest, e);
            return ObjectResponse.failed(CodeConstantsEnum.ERROR);
        }
    }

    @Override
    @DS_SLAVE
    @SentinelResource(value = "OrderService.getEnterCarList",
            defaultFallback = "defaultFallbackHandle", fallbackClass = {ExceptionUtils.class})
    public ObjectResponse<List<EnterCarDto>> getEnterCarList(OrderQueryRequest orderQueryRequest) {
        try {
            String parkCode = orderQueryRequest.getParkCode();
            String plateNumber = orderQueryRequest.getPlateNumber();
            Date startTime = orderQueryRequest.getStartTime();
            Date endTime = orderQueryRequest.getEndTime();
            Integer reliability = orderQueryRequest.getReliability();
            List<Integer> type = orderQueryRequest.getTypes();
            List<Integer> tagIds = orderQueryRequest.getTagIds();
            String[] split = parkCode.split(",");
            String parkid = parkDao.selectByCodes(split);
            if (parkid.endsWith(",")) {
                parkid = parkid.substring(0, parkid.length() - 1);
            }
            log.info("getEnterCarList  ==> {} {} {} {} {} {}", parkid, startTime, plateNumber, type, reliability, tagIds);
            PageHelper.startPage(orderQueryRequest.getPageNo(), orderQueryRequest.getPageSize());
            if (StringUtils.isNotEmpty(plateNumber)) {
                plateNumber = plateNumber.toUpperCase();
            }
            //查询在场记录信息
            List<OrderInfo> records = orderInfoDao.selectEnterRecords(parkid,
                    Objects.isNull(startTime) ? null : startTime.getTime() / 1000,
                    Objects.isNull(endTime) ? null : endTime.getTime() / 1000, plateNumber, type, reliability, tagIds, orderQueryRequest.getChannelCodes());
            if (CollectionUtils.isEmpty(records)) {
                //暂无记录
                return ObjectResponse.failed(CodeConstantsEnum.ERROR_404);
            }
            //封装返回数据
            List<EnterCarDto> enterCarDtos = Lists.newArrayList();
            Long currentDate = System.currentTimeMillis() / 1000;
            List<Long> parkIds = records.stream().map(OrderInfo::getParkId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            List<ParkRecoveryVo> recoveryByParkIds = parkRecoveryService.getOpenParkRecoveryByParkIds(parkIds);
            Set<Long> recoveryParkIds = new HashSet<>();
            if (!CollectionUtils.isEmpty(recoveryByParkIds)) {
                recoveryParkIds.addAll(recoveryByParkIds.stream()
                        .map(ParkRecovery::getParkId)
                        .filter(Objects::nonNull)
                        .collect(Collectors.toSet()));
            }
            records.forEach(orderInfo -> {
                EnterCarDto enterCarDto = new EnterCarDto();

                enterCarDto.setId(orderInfo.getId());
                enterCarDto.setEnterTime(new Date(orderInfo.getEnterTime() * 1000));
                enterCarDto.setPlateNumber(orderInfo.getPlateNum());
                enterCarDto.setType(orderInfo.getType());
                enterCarDto.setOrderNum(orderInfo.getOrderNum());
                //重新计算停车时长
                long parkTime = currentDate - orderInfo.getEnterTime();
                enterCarDto.setParkTime(parkTime);
                Park park = parkService.findByParkId(orderInfo.getParkId()).getData();
                enterCarDto.setParkName(park.getParkName());
                enterCarDto.setNoneEnterFlag(orderInfo.getNoneEnterFlag());
                //获取入场记录信息
                OrderCarInfo carInfo = orderCarInfoDao.selectByOrderNum(orderInfo.getOrderNum());
                if (carInfo != null) {
                    //oss重新获取图片链接
                    enterCarDto.setImgUrl(ossService.getImageUrl(carInfo.getEnterImage()));
                    enterCarDto.setEnterName(carInfo.getEnterNo());
                }
                if (parkTime >= 60) {
                    enterCarDto.setParkTimeStr(DateTools.secondToSecondsTime((int) parkTime));
                } else {
                    enterCarDto.setParkTimeStr(parkTime + "秒");
                }
                enterCarDto.setCarType(orderInfo.getCarType());
                String s = orderInfoDao.selectMadeNum(orderInfo.getOrderNum());
                if (!Objects.isNull(s)) {
                    enterCarDto.setReliability(1);
                }
                enterCarDto.setHasSon(orderInfo.getHasSon());
                // 标签展示
                if (recoveryParkIds.contains(orderInfo.getParkId())) {
                    List<OrderTags> orderTags = orderTagsService.getListByOrderNum(orderInfo.getOrderNum(), 0);
                    if (!CollectionUtils.isEmpty(orderTags)) {
                        enterCarDto.setOrderTag(orderTags.stream()
                                .map(OrderTags::getTagId)
                                .filter(Objects::nonNull)
                                .collect(Collectors.toList()));
                    }
                }
                enterCarDtos.add(enterCarDto);
            });
            return ObjectResponse.success(enterCarDtos);
        } catch (Exception e) {
            log.error("[车场管家获取入场车辆接口]处理失败: {}. orderQueryRequest[{}]", e.getMessage(), orderQueryRequest, e);
            return ObjectResponse.failed(CodeConstantsEnum.ERROR);
        }
    }


    @Override
    @DS_SLAVE
    @SentinelResource(value = "OrderService.getEnterCarDetail",
            defaultFallback = "defaultFallbackHandle", fallbackClass = {ExceptionUtils.class})
    public ObjectResponse<EnterCarDto> getEnterCarDetail(String parkCode, Integer recordId) {
        try {
            //查询记录
            OrderInfo orderInfo = orderInfoDao.selectById(recordId);

            //获取入场记录信息
            OrderCarInfo carInfo = orderCarInfoDao.selectByOrderNum(orderInfo.getOrderNum());

            //封装参数
            Long currentDate = System.currentTimeMillis() / 1000;
            EnterCarDto enterCarDto = new EnterCarDto();
            enterCarDto.setId(orderInfo.getId());
            enterCarDto.setRegionId(orderInfo.getRegionId());
            enterCarDto.setEnterTime(new Date(orderInfo.getEnterTime() * 1000));
            enterCarDto.setPlateNumber(orderInfo.getPlateNum());
            enterCarDto.setType(orderInfo.getType());
            enterCarDto.setCarType(orderInfo.getCarType());

            long parkTime = currentDate - orderInfo.getEnterTime();
            //重新计算停车时长
            enterCarDto.setParkTime(parkTime);
            //oss重新获取图片链接
            enterCarDto.setImgUrl(ossService.getImageUrl(carInfo.getEnterImage()));
            enterCarDto.setEnterName(carInfo.getEnterNo());
            enterCarDto.setParkTimeStr(DateTools.secondToSecondsTime((int) parkTime));
            enterCarDto.setHasSon(orderInfo.getHasSon());
            enterCarDto.setRemark(carInfo.getRemark());
            enterCarDto.setEnterWay(carInfo.getEnterWay());
            enterCarDto.setEnterOperAccount(carInfo.getEnterOperAccount());
            enterCarDto.setEnterTerminal(carInfo.getEnterTerminal());
            return ObjectResponse.success(enterCarDto);
        } catch (Exception e) {
            log.error("[车场管家获取入场车辆详情接口]处理失败: {}. parkCode[{}], recordId[{}]", e.getMessage(), parkCode, recordId, e);
            return ObjectResponse.failed(CodeConstantsEnum.ERROR);
        }
    }


    @Override
    @DS_SLAVE
    @SentinelResource(value = "OrderService.getExitCarList",
            defaultFallback = "defaultFallbackHandle", fallbackClass = {ExceptionUtils.class})
    public ObjectResponse<List<ExitCarDto>> getExitCarList(OrderQueryRequest orderQueryRequest) {
        try {
            String parkCodes = orderQueryRequest.getParkCode();
            String plateNumber = orderQueryRequest.getPlateNumber();
            Date startTime = orderQueryRequest.getStartTime();
            Date endTime = orderQueryRequest.getEndTime();
            List<Integer> type = orderQueryRequest.getTypes();
            Date enterStartTime = orderQueryRequest.getEnterStartTime();
            Date enterEndTime = orderQueryRequest.getEnterEndTime();
            String[] split = parkCodes.split(",");
            List<Integer> tagIds = orderQueryRequest.getTagIds();
            String cardOwner = orderQueryRequest.getCardOwner();
            List<String> plateNums = new ArrayList<>();
            String parkid = orderQueryRequest.getParkId() == null ? null : orderQueryRequest.getParkId().toString();
            if (parkid == null) {
                parkid = parkDao.selectByCodes(split);
                if (parkid.endsWith(",")) {
                    parkid = parkid.substring(0, parkid.length() - 1);
                }
            }
            if (StringUtils.isNotBlank(cardOwner)) {
                Long parkId = NumberUtils.parseLong(parkid.split(",")[0]);
                List<MonthPlate> monthPlates = monthPlateDao.selectByParkIdAndOwner(parkId, cardOwner);
                if (CollectionUtils.isNotEmpty(monthPlates)) {
                    plateNums.addAll(monthPlates.stream().map(MonthPlate::getPlateNum).collect(Collectors.toList()));
                }
                List<MonthInfo> monthInfos = monthInfoDao.selectByParkIdAndOwner(parkId, cardOwner);
                if (CollectionUtils.isNotEmpty(monthInfos)) {
                    List<MonthPlate> monthPlateList = monthPlateDao.selectByMonthIds(monthInfos.stream().map(MonthInfo::getId).collect(Collectors.toList()));
                    if (CollectionUtils.isNotEmpty(monthPlateList)) {
                        plateNums.addAll(monthPlateList.stream().map(MonthPlate::getPlateNum).collect(Collectors.toList()));
                    }
                }
            }
            PageHelper.startPage(orderQueryRequest.getPageNo(), orderQueryRequest.getPageSize());
            List<OrderInfo> records = orderInfoDao.selectExitRecords(parkid,
                    Objects.isNull(startTime) ? null : startTime.getTime() / 1000,
                    Objects.isNull(endTime) ? null : endTime.getTime() / 1000,
                    plateNumber, type,
                    Objects.isNull(enterStartTime) ? null : enterStartTime.getTime() / 1000,
                    Objects.isNull(enterEndTime) ? null : enterEndTime.getTime() / 1000, orderQueryRequest.getNoplateFee(), orderQueryRequest.getOrderNum(),
                    tagIds, orderQueryRequest.getFreeFlag(), orderQueryRequest.getChannelCodes(), plateNums);
            if (CollectionUtils.isEmpty(records)) {
                //暂无记录
                return ObjectResponse.failed(CodeConstantsEnum.ERROR_404);
            }
            List<ExitCarDto> exitCarDtos = Lists.newArrayList();
            List<Long> parkIds = records.stream().map(OrderInfo::getParkId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            List<ParkRecoveryVo> parkRecoveryByParkIds = parkRecoveryService.getOpenParkRecoveryByParkIds(parkIds);
            Set<Long> recoveryParkIds = new HashSet<>();
            if (!CollectionUtils.isEmpty(parkRecoveryByParkIds)) {
                recoveryParkIds.addAll(parkRecoveryByParkIds.stream()
                        .map(ParkRecovery::getParkId)
                        .filter(Objects::nonNull)
                        .collect(Collectors.toSet()));
            }
            records.forEach(orderInfo -> {
                Park park = parkService.findByParkId(orderInfo.getParkId()).getData();
                ExitCarDto exitCarDto = new ExitCarDto();
                exitCarDto.setId(orderInfo.getId());
                if (orderInfo.getEnterTime() != null) {
                    exitCarDto.setEnterTime(new Date(orderInfo.getEnterTime() * 1000));
                }
                if (orderInfo.getExitTime() != null) {
                    exitCarDto.setExitTime(new Date(orderInfo.getExitTime() * 1000));
                    long parktime = orderInfo.getExitTime() - orderInfo.getEnterTime();
                    parktime = parktime < 0 ? 0 : parktime;
                    exitCarDto.setParkTime(parktime);
                    exitCarDto.setParkTimeStr(DateTools.secondToSecondsTime((int) parktime));
                }

                exitCarDto.setPlateNumber(orderInfo.getPlateNum());
                exitCarDto.setType(orderInfo.getType());
                exitCarDto.setPaidPrice(orderInfo.getPaidPrice());
                exitCarDto.setOperAccouont(orderInfo.getOperAccount());
                exitCarDto.setParkName(park.getParkName());
                exitCarDto.setTotalPrice(orderInfo.getTotalPrice());
                exitCarDto.setDiscountPrice(orderInfo.getDiscountPrice());
                exitCarDto.setOrderNo(orderInfo.getOrderNum());
                exitCarDto.setHasSon(orderInfo.getHasSon());
                exitCarDto.setNoneEnterFlag(orderInfo.getNoneEnterFlag());

                OrderCarInfo carInfo = orderCarInfoDao.selectByOrderNum(orderInfo.getOrderNum());
                if (carInfo != null) {
                    if (StringUtils.isNotBlank(carInfo.getEnterImage())) {
                        exitCarDto.setEnterImg(ossService.getImageUrl(carInfo.getEnterImage()));
                    }
                    exitCarDto.setEnterName(carInfo.getEnterNo());
                    if (StringUtils.isNotBlank(carInfo.getExitImage())) {
                        exitCarDto.setExitImg(ossService.getImageUrl(carInfo.getExitImage()));
                    }
                }
                // 开通的展示标识
                if (recoveryParkIds.contains(orderInfo.getParkId())) {
                    // 标签展示
                    List<OrderTags> orderTags = orderTagsService.getListByOrderNum(orderInfo.getOrderNum(), 0);
                    if (!CollectionUtils.isEmpty(orderTags)) {
                        exitCarDto.setOrderTag(orderTags.stream()
                                .map(OrderTags::getTagId)
                                .filter(Objects::nonNull)
                                .collect(Collectors.toList()));
                    }
                }
                exitCarDtos.add(exitCarDto);
            });
            return ObjectResponse.success(exitCarDtos);
        } catch (Exception e) {
            log.error("[车场管家获取离场车辆接口]处理失败: {}. orderQueryRequest[{}]", e.getMessage(), orderQueryRequest, e);
            return ObjectResponse.failed(CodeConstantsEnum.ERROR);
        }
    }

    @Override
    @DS_SLAVE
    @SentinelResource(value = "OrderService.countParkingTime",
            defaultFallback = "defaultFallbackHandle", fallbackClass = {ExceptionUtils.class})
    public ObjectResponse<List<ExitCarDto>> countParkingTime(String parkIds, Integer day, String pointMonth) {
        try {
            SimpleDateFormat sf = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
            Date startTime;
            Date endTime;
            if (day == 2) {
                List<String> list = DateRangeUtils.getDaysMultiformat(1, 1);
                startTime = sf.parse(list.get(0) + " 00:00:00");
                endTime = sf.parse(list.get(list.size() - 1) + " 23:59:59");
            } else if (day == 7 || day == 30) {
                List<String> list = DateRangeUtils.getDaysMultiformat(day, 1);
                startTime = sf.parse(list.get(0) + " 00:00:00");
                endTime = sf.parse(list.get(list.size() - 1) + " 23:59:59");
            } else {
                startTime = sf.parse(pointMonth + "/01 00:00:00");
                endTime = sf.parse(pointMonth + "/31 23:59:59");
            }
            List<OrderInfo> records = orderInfoDao.countParkingTime(parkIds,
                    Objects.isNull(startTime) ? null : startTime.getTime() / 1000,
                    Objects.isNull(endTime) ? null : endTime.getTime() / 1000);
            if (CollectionUtils.isEmpty(records)) {
                //暂无记录
                return ObjectResponse.failed(CodeConstantsEnum.ERROR_404);
            }
            List<ExitCarDto> exitCarDtos = Lists.newArrayList();
            records.forEach(orderInfo -> {
                ExitCarDto exitCarDto = new ExitCarDto();
                if (orderInfo.getEnterTime() != null) {
                    exitCarDto.setEnterTime(new Date(orderInfo.getEnterTime() * 1000));
                }
                if (orderInfo.getExitTime() != null) {
                    exitCarDto.setExitTime(new Date(orderInfo.getExitTime() * 1000));
                }
                long parktime = orderInfo.getExitTime() - orderInfo.getEnterTime();
                exitCarDto.setParkTime(parktime < 0 ? 0 : parktime);
                exitCarDtos.add(exitCarDto);
            });
            return ObjectResponse.success(exitCarDtos);
        } catch (Exception e) {
            log.error("[车主端小程序-停车时长统计]处理失败: {}. parkIds[{}], day[{}], pointMonth[{}]", e.getMessage(), parkIds, day, pointMonth, e);
            return ObjectResponse.failed(CodeConstantsEnum.ERROR);
        }
    }


    @Override
    @DS_SLAVE
    @SentinelResource(value = "OrderService.getExitCarDetail",
            defaultFallback = "defaultFallbackHandle", fallbackClass = {ExceptionUtils.class})
    public ObjectResponse<ExitCarDto> getExitCarDetail(String parkCode, Integer recordId) {
        try {
            //查询记录详情
            OrderInfo orderInfo = orderInfoDao.selectById(recordId);

            //查询入离场记录信息
            OrderCarInfo carInfo = orderCarInfoDao.selectByOrderNum(orderInfo.getOrderNum());

            //封装参数
            ExitCarDto exitCarDto = new ExitCarDto();
            exitCarDto.setId(carInfo.getId());
            exitCarDto.setOrderNo(carInfo.getOrderNum());
            exitCarDto.setEnterTime(new Date(orderInfo.getEnterTime() * 1000));
            exitCarDto.setExitTime(new Date(orderInfo.getExitTime() * 1000));
            long time = orderInfo.getExitTime() - orderInfo.getEnterTime();
            time = time < 0 ? 0 : time;
            exitCarDto.setParkTime(time);
            exitCarDto.setParkTimeStr(DateTools.secondToSecondsTime((int) time));
            exitCarDto.setPlateNumber(orderInfo.getPlateNum());
            exitCarDto.setType(orderInfo.getType());
            exitCarDto.setCarType(orderInfo.getCarType());
            exitCarDto.setTotalPrice(orderInfo.getTotalPrice());
            exitCarDto.setPaidPrice(orderInfo.getPaidPrice());
            exitCarDto.setDiscountPrice(orderInfo.getDiscountPrice());
            exitCarDto.setEnterImg(ossService.getImageUrl(carInfo.getEnterImage()));
            exitCarDto.setExitImg(ossService.getImageUrl(carInfo.getExitImage()));
            exitCarDto.setEnterName(carInfo.getEnterNo());
            exitCarDto.setOddStatus(orderInfo.getOddStatus());
            exitCarDto.setExitName(carInfo.getExitNo());
            exitCarDto.setHasSon(orderInfo.getHasSon());
            exitCarDto.setExitWay(carInfo.getExitWay());
            exitCarDto.setEnterWay(carInfo.getEnterWay());
            exitCarDto.setExitOperAccount(carInfo.getExitOperAccount());
            exitCarDto.setEnterOperAccount(carInfo.getEnterOperAccount());
            exitCarDto.setExitTerminal(carInfo.getExitTerminal());
            exitCarDto.setEnterTerminal(carInfo.getEnterTerminal());
            exitCarDto.setNoneEnterFlag(orderInfo.getNoneEnterFlag());
            exitCarDto.setEnterRemark(carInfo.getRemark());
            exitCarDto.setExitRemark(carInfo.getExitRemark());
            return ObjectResponse.success(exitCarDto);
        } catch (Exception e) {
            log.error("[车场管家获取离场车辆详情接口]处理失败: {}. parkCode[{}], recordId[{}]", e.getMessage(), parkCode, recordId, e);
            return ObjectResponse.failed(CodeConstantsEnum.ERROR);
        }

    }

    @Override
    public ObjectResponse addOrderInfo(OrderInfo orderInfo) {
        orderInfoDao.insertWithPlateNum2(orderInfo);
        if (orderInfo.getServiceStatus() != null && orderInfo.getServiceStatus() == OrderStatusConstants.IN_PARK) {
            pushService.pushOrderEnter(orderInfo);
        }

        if (orderInfo.getServiceStatus() != null
                && (orderInfo.getServiceStatus() == OrderStatusConstants.LEAVED_PARK || orderInfo.getServiceStatus() == OrderStatusConstants.EXCEPTION)) {
            pushService.pushOrderEnter(orderInfo);
            pushService.pushOrderExit(orderInfo, 5000);
        }
        return ObjectResponse.success();
    }

    @Override
    public ObjectResponse updateOrderInfo(OrderInfo orderInfo) {
        orderInfoDao.updateByOrderNum(orderInfo);
        return ObjectResponse.success();
    }

    @Override
    public ObjectResponse<Integer> updateOrderWithPush(OrderInfo orderInfo) {
        int result = orderInfoDao.updateByOrderNum(orderInfo);
        OrderInfo para = new OrderInfo();
        para.setParkId(orderInfo.getParkId());
        para.setPlateNum(orderInfo.getPlateNum());
        para.setServiceStatus(OrderStatusConstants.IN_PARK);
        OrderInfo orderInfo1 = orderInfoDao.selectLimitOneNotOrderByEnterDesc(para, orderInfo.getOrderNum());
        if (orderInfo1 != null
                && orderInfo1.getEnterTime() < NumberUtils.toPrimitive(orderInfo.getEnterTime())) {
            log.info("有其他在场订单, 删除订单{}", orderInfo1);
            orderInfo1.setServiceStatus(OrderStatusConstants.CANCEL);
            orderInfoDao.updateByOrderNum(orderInfo1);
        }
        if (result > 0 && orderInfo.getServiceStatus() != null
                && (orderInfo.getServiceStatus() == OrderStatusConstants.LEAVED_PARK || orderInfo.getServiceStatus() == OrderStatusConstants.EXCEPTION)) {
            pushService.pushOrderExit(orderInfo);
        }
        if (result == 0 && orderInfo.getCreateTime() != null) {
            log.info("更新订单历史表, {}", orderInfo);
            Date startDate = DateUtil.offsetDay(DateUtil.date(), -90);
            List<String> yearQuarterRangeTableName = DateRangeUtils.getYearQuarterRangeTableName(startDate);
            for (String tableName : yearQuarterRangeTableName) {
                int n = orderInfoDao.updateHistoryTable(tableName, orderInfo);
                if (n > 0) {
                    result = n;
                    break;
                }
            }
        }

        return ObjectResponse.success(result);
    }

    @Override
    public ObjectResponse<QueryOrderFeeResponse> p2cQueryFee(OrderInfo orderInfo, ParkConfig parkConfig, String channelId) {
        Park park = parkService.findByParkId(orderInfo.getParkId()).getData();
        QueryOrderFeeRequest queryOrderFeeRequest = new QueryOrderFeeRequest();
        queryOrderFeeRequest.setOrderNum(orderInfo.getOrderNum());
        queryOrderFeeRequest.setParkCode(park.getParkCode());
        queryOrderFeeRequest.setPlateNum(orderInfo.getPlateNum());
        queryOrderFeeRequest.setChannelId(channelId);
        queryOrderFeeRequest.setExitTime(orderInfo.getExitTime());
        ThirdInfo payUrlThirdInfo = null;
        try {
            payUrlThirdInfo = thirdInfoService.getThirdFeeUrl(parkConfig.getParkId());
        } catch (Exception e) {
            log.error("三方请求支付处理失败: {}. orderInfo[{}], parkConfig[{}], channelId[{}]", e.getMessage(), orderInfo, parkConfig, channelId, e);
        }

        try {
            //转换三方请求支付
            if (Objects.nonNull(payUrlThirdInfo)) {
                ThirdFeeRequest thirdFeeRequest = new ThirdFeeRequest();
                thirdFeeRequest.setCarType(orderInfo.getCarType());
                thirdFeeRequest.setChannelCode(channelId);
                thirdFeeRequest.setEnterTime(orderInfo.getEnterTime());
                thirdFeeRequest.setExitTime(DateTools.unixTimestamp());
                thirdFeeRequest.setOrderNum(orderInfo.getOrderNum());
                thirdFeeRequest.setParkCode(park.getParkCode());
                thirdFeeRequest.setParkTime(Math.toIntExact(thirdFeeRequest.getExitTime() - orderInfo.getEnterTime()));
                thirdFeeRequest.setPlateNum(orderInfo.getPlateNum());
                return queryThirdFeeService.getThirdFeeFromUrl(payUrlThirdInfo, thirdFeeRequest);
            }
            return p2cQueryFeeService.queryFee(queryOrderFeeRequest, orderInfo, park, parkConfig);
        } catch (ResponseBodyException re) {
            log.warn("处理失败: {}:{}. orderInfo[{}], parkConfig[{}], channelId[{}]", re.getErrCode(), re.getMessage(), orderInfo, parkConfig, channelId, re);
            return ObjectResponse.failed(re.getErrCode(), re.getMessage());
        } catch (Exception e) {
            log.error("处理失败: {}. orderInfo[{}], parkConfig[{}], channelId[{}]", e.getMessage(), orderInfo, parkConfig, channelId, e);
            return ObjectResponse.failed(CodeConstants.ERROR, CodeConstants.getName(CodeConstants.ERROR) + e.getMessage());
        }
    }

    @Override
    public ObjectResponse<QueryOrderFeeResponse> p2cQueryFee(OrderInfo orderInfo, ParkConfig parkConfig) {
        Park park = parkService.findByParkId(orderInfo.getParkId()).getData();
        QueryOrderFeeRequest queryOrderFeeRequest = new QueryOrderFeeRequest();
        queryOrderFeeRequest.setOrderNum(orderInfo.getOrderNum());
        queryOrderFeeRequest.setParkCode(park.getParkCode());
        queryOrderFeeRequest.setPlateNum(orderInfo.getPlateNum());
        try {
            return p2cQueryFeeService.queryFee(queryOrderFeeRequest, orderInfo, park, parkConfig);
        } catch (ResponseBodyException re) {
            log.warn("处理失败: {}:{}. orderInfo[{}], parkConfig[{}]", re.getErrCode(), re.getMessage(), orderInfo, parkConfig, re);
            return ObjectResponse.failed(re.getErrCode(), re.getMessage());
        } catch (Exception e) {
            log.error("处理失败: {}. orderInfo[{}], parkConfig[{}]", e.getMessage(), orderInfo, parkConfig, e);
            return ObjectResponse.failed(CodeConstants.ERROR, CodeConstants.getName(CodeConstants.ERROR) + e.getMessage());
        }
    }

    @Override
    public ObjectResponse<QueryOrderFeeResponse> p2cQueryFee(QueryOrderFeeRequest queryOrderFeeRequest) {
        String orderNum = queryOrderFeeRequest.getOrderNum();
        if (StringUtils.isBlank(orderNum)) {
            return ObjectResponse.failed(CodeConstants.ERROR_400, "订单号不能为空");
        }
        String parkCode = queryOrderFeeRequest.getParkCode();
        Park park = parkService.findByParkCode(parkCode).getData();
        ParkConfig parkConfig = parkService.getParkConfig(park.getId()).getData();
        if (Boolean.TRUE.equals(queryOrderFeeRequest.getWithNotPay()) && Integer.valueOf(1).equals(queryOrderFeeRequest.getExType())) {
            QueryOrderFeeResponse queryOrderFeeResponse = queryOrderFeeService.queryNotPay(queryOrderFeeRequest,
                    queryOrderFeeRequest.getPlateNum(), parkConfig, null, park.getParkName());
            if (queryOrderFeeResponse == null) {
                return ObjectResponse.failed(CodeConstants.ERROR_404, "无欠费记录");
            } else {
                return ObjectResponse.success(queryOrderFeeResponse);
            }
        }
        OrderInfo orderInfo = new OrderInfo();
        orderInfo.setParkId(park.getId());
        orderInfo.setOrderNum(orderNum);
        OrderInfo orderInfoRet = orderInfoDao.selectLimitOneOrderByEnterDesc(orderInfo);
        if (orderInfoRet == null) {
            return ObjectResponse.failed(CodeConstants.ERROR_400, "订单号不存在");
        }
        if (orderInfoRet.getServiceStatus() != null
                && (orderInfoRet.getServiceStatus().equals(OrderStatusConstants.LEAVED_PARK)
                || orderInfoRet.getServiceStatus().equals(OrderStatusConstants.CANCEL))) {
            return ObjectResponse.failed(CodeConstants.ERROR_3004, "车辆已离场");
        }
        ObjectResponse<QueryOrderFeeResponse> objectResponse = executeQueryFee(queryOrderFeeRequest, park, orderInfoRet, parkConfig);
        if (!Boolean.TRUE.equals(queryOrderFeeRequest.getWithNotPay())) {
            return objectResponse;
        }
        QueryOrderFeeResponse queryOrderFeeResponse = queryOrderFeeService.queryNotPay(queryOrderFeeRequest,
                orderInfoRet.getPlateNum(), parkConfig, objectResponse.getData(), park.getParkName());
        if (queryOrderFeeResponse == null) {
            return ObjectResponse.failed(objectResponse.getCode(), objectResponse.getMsg());
        } else {
            return ObjectResponse.success(queryOrderFeeResponse);
        }
    }

    private ObjectResponse<QueryOrderFeeResponse> executeQueryFee(QueryOrderFeeRequest queryOrderFeeRequest, Park park,
                                                                  OrderInfo orderInfoRet, ParkConfig parkConfig) {
        ThirdInfo payUrlThirdInfo = null;
        try {
            payUrlThirdInfo = thirdInfoService.getThirdFeeUrl(parkConfig.getParkId());
        } catch (Exception e) {
            log.error("三方请求支付处理失败: {}. orderInfo[{}], parkConfig[{}], channelId[{}]", e.getMessage(),
                    orderInfoRet, parkConfig, queryOrderFeeRequest.getChannelId(), e);
        }

        try {
            //转换三方请求支付
            if (Objects.nonNull(payUrlThirdInfo)) {
                ThirdFeeRequest thirdFeeRequest = new ThirdFeeRequest();
                thirdFeeRequest.setCarType(orderInfoRet.getCarType());
                thirdFeeRequest.setChannelCode(queryOrderFeeRequest.getChannelId());
                thirdFeeRequest.setEnterTime(orderInfoRet.getEnterTime());
                thirdFeeRequest.setExitTime(DateTools.unixTimestamp());
                thirdFeeRequest.setOrderNum(orderInfoRet.getOrderNum());
                thirdFeeRequest.setParkCode(park.getParkCode());
                thirdFeeRequest.setParkTime(Math.toIntExact(thirdFeeRequest.getExitTime() - orderInfoRet.getEnterTime()));
                thirdFeeRequest.setPlateNum(orderInfoRet.getPlateNum());
                return queryThirdFeeService.getThirdFeeFromUrl(payUrlThirdInfo, thirdFeeRequest);
            }
            return p2cQueryFeeService.queryFee(queryOrderFeeRequest, orderInfoRet, park, parkConfig);
        } catch (ResponseBodyException re) {
            log.error("处理失败: {}:{}. queryOrderFeeRequest[{}]", re.getErrCode(), re.getMessage(), queryOrderFeeRequest);
            return ObjectResponse.failed(re.getErrCode(), re.getMessage());
        } catch (Exception e) {
            log.error("处理失败: {}. queryOrderFeeRequest[{}]", e.getMessage(), queryOrderFeeRequest, e);
            return ObjectResponse.failed(CodeConstants.ERROR, CodeConstants.getName(CodeConstants.ERROR) + e.getMessage());
        }
    }

    @Override
    public ObjectResponse<Void> pncQueryFee(QueryOrderFeeRequest queryOrderFeeRequest) {
        String orderNum = queryOrderFeeRequest.getOrderNum();
        String parkCode = queryOrderFeeRequest.getParkCode();
        Park park = parkService.findByParkCode(parkCode).getData();
        OrderInfo orderInfo = new OrderInfo();
        orderInfo.setParkId(park.getId());
        orderInfo.setOrderNum(orderNum);
        OrderInfo orderInfoRet = orderInfoDao.selectLimitOneOrderByEnterDesc(orderInfo);
        return pncQueryFeeService.queryFee(queryOrderFeeRequest, orderInfoRet, park);
    }

    @Override
    public ObjectResponse<OrderInfo> fuzzyPlate(Long parkId, String inandoutCode, String plateNum) {
        if (StringUtils.isBlank(plateNum)) {
            return ObjectResponse.failed(CodeConstants.ERROR_404, "您的爱车不在场");
        }
        OrderInfo orderInfo = null;
        ObjectResponse<ParkInoutdevice> parkChannelResp = parkService.getInoutDeviceByCode(inandoutCode);
        if (!ObjectResponse.isSuccess(parkChannelResp)) {
            return ObjectResponse.failed(CodeConstants.ERROR_404);
        }
        ParkInoutdevice parkChannel = parkChannelResp.getData();
        int isOpenVaguetype = NumberUtils.toPrimitive(parkChannel.getIsOpenVaguetype());
        if (isOpenVaguetype == 1) {
            int vaguetype = NumberUtils.toPrimitive(parkChannel.getVaguetype());
            if (vaguetype == 0) {
                String plateNumPart = plateNum.substring(1);
                orderInfo = orderInfoDao.fuzzyInParkPlate2(parkId, plateNumPart);
            } else if (vaguetype == 1) {
                orderInfo = fuzzyPlateNum(parkId, plateNum, 1);
            } else if (vaguetype == 2) {
                orderInfo = fuzzyPlateNum(parkId, plateNum, 1);
                if (orderInfo == null) {
                    orderInfo = fuzzyPlateNum(parkId, plateNum, 2);
                }
            }
            if (orderInfo != null) {
                OrderInfo orderInfoRet = orderInfoDao.fuzzyByPlateNums(parkId, getFuzzyPlateNums(vaguetype, plateNum));
                boolean queryHistory = false;
                if (orderInfoRet != null && orderInfo.getId().equals(orderInfoRet.getId())) {
                    queryHistory = true;
                }
                if (orderInfoRet == null && (DateTools.unixTimestamp() - orderInfo.getEnterTime()) / 3600 / 24 > 30) {
                    queryHistory = true;
                }
                if (queryHistory) {
                    Date startDate = new Date(orderInfo.getEnterTime() * 1000);
                    orderInfoRet = orderInfoDao.fuzzyRecentHistoryOrder(
                            DateRangeUtils.getYearQuarterRangeTableName(startDate), parkId, getFuzzyPlateNums(vaguetype, plateNum));
                }
                if (orderInfoRet != null && (!orderInfo.getId().equals(orderInfoRet.getId()) && orderInfo.getEnterTime() <= orderInfoRet.getEnterTime())) {
                    log.info("模糊匹配失败, 模糊到的入场时间在完整车牌订单之前, 模糊匹配的订单[{}], 当前车牌[{}]", orderInfo, plateNum);
                    orderInfo = null;
                }
            }
        }
        if (orderInfo == null) {
            return ObjectResponse.failed(CodeConstants.ERROR_404, "您的爱车不在场");
        } else {
            return ObjectResponse.success(orderInfo);
        }
    }

    @Override
    public ObjectResponse<OrderInfo> fuzzyPlate(Long parkId, String plateNum) {
        String plateNumPart = plateNum.substring(1);
        OrderInfo orderInfo = orderInfoDao.fuzzyInParkPlate2(parkId, plateNumPart);
        if (orderInfo == null) {
            return ObjectResponse.failed(CodeConstants.ERROR_404);
        } else {
            return ObjectResponse.success(orderInfo);
        }
    }

    @Override
    public ObjectResponse<OrderInfo> fuzzyOrderPlate(long parkId, String plateNum, int status, int vagueType) {
        OrderInfo orderInfo = null;
        if (vagueType == 0) {
            orderInfo = fuzzyPlateNum(parkId, plateNum, status, 0);
        } else if (vagueType == 1) {
            orderInfo = fuzzyPlateNum(parkId, plateNum, status, 1);
        } else if (vagueType == 2) {
            orderInfo = fuzzyPlateNum(parkId, plateNum, status, 1);
            if (orderInfo == null) {
                orderInfo = fuzzyPlateNum(parkId, plateNum, status, 2);
            }
        }
        return ObjectResponse.returnNotFoundIfNull(orderInfo);
    }

    @Override
    @DS_SLAVE
    @SentinelResource(value = "OrderService.getMpOrderList", defaultFallback = "defaultFallbackHandle", fallbackClass = {ExceptionUtils.class})
    public ObjectResponse<List<OrderDto>> getMpOrderList(OrderQueryRequest orderQueryRequest) {
        try (com.github.pagehelper.Page<?> page = PageHelper.startPage(orderQueryRequest.getPageNo(), orderQueryRequest.getPageSize())) {
            List<OrderDto> orderDtos = Lists.newArrayList();
            String plateNum = orderQueryRequest.getPlateNumber();
            Date startTime = orderQueryRequest.getStartTime();
            Date endTime = orderQueryRequest.getEndTime();
            Integer type = orderQueryRequest.getType();
            Integer mpUserId = orderQueryRequest.getMpUserId();
            //临停缴费
            if (type == 1) {
                orderDtos = orderPayDao.selectMpOrderListByPlateNum(mpUserId, plateNum, Objects.isNull(startTime) ? null : startTime.getTime() / 1000, Objects.isNull(endTime) ? null : endTime.getTime() / 1000);
            }
            //月卡续费
            if (type == 2) {
                orderDtos = monthOrderDao.selectMpOrderByPlateNum(mpUserId, plateNum, Objects.isNull(startTime) ? null : startTime.getTime() / 1000, Objects.isNull(endTime) ? null : endTime.getTime() / 1000);
            }
            //两者都有
            if (type == 3) {
                orderDtos = orderPayDao.selectMpOrderList(mpUserId, plateNum, Objects.isNull(startTime) ? null : startTime.getTime() / 1000, Objects.isNull(endTime) ? null : endTime.getTime() / 1000);
            }
            if (CollectionUtils.isEmpty(orderDtos)) {
                return ObjectResponse.failed(CodeConstantsEnum.ERROR_404);
            }
            return ObjectResponse.success(orderDtos);
        }
    }

    @Override
    public ObjectResponse<List<OrderInfoDto>> getMpOrders(OrderQueryRequest orderQueryRequest) {
        try (com.github.pagehelper.Page<OrderInfoDto> page = PageHelper.startPage(orderQueryRequest.getPageNo(), orderQueryRequest.getPageSize(), orderQueryRequest.isCount())) {
            List<OrderInfoDto> orderInfoDtos = orderInfoDao.selectMpOrderInfos(orderQueryRequest);
            return CollectionUtils.isEmpty(orderInfoDtos) ? ObjectResponse.failed(CodeConstantsEnum.ERROR_404) : ObjectResponse.success(orderInfoDtos);
        }
    }

    @Override
    public ObjectResponse<OrderCountDto> countMpOrderList(OrderQueryRequest orderQueryRequest) {
        String plateNum = orderQueryRequest.getPlateNumber();
        Date startTime = orderQueryRequest.getStartTime();
        Date endTime = orderQueryRequest.getEndTime();
        Integer mpUserId = orderQueryRequest.getMpUserId();
        OrderCountDto orderCount = orderPayDao.countMpOrderByPlateNum(mpUserId, plateNum, Objects.isNull(startTime) ? null : startTime.getTime() / 1000, Objects.isNull(endTime) ? null : endTime.getTime() / 1000);
        return ObjectResponse.success(orderCount);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public ObjectResponse batchAddLiveCar(List<OrderAddRequest> result, Boolean flag, Park park, String userName, List<ParkRegion> parkRegions) {
        Long parkId = park.getId();
        // 获取车牌是否在场
        List<String> plateNums = result.stream().map(OrderAddRequest::getPlateNum).filter(Objects::nonNull).collect(Collectors.toList());
        // 在场订单
        List<OrderInfo> liveOrders = getLiveOrderListsByPlateNums(plateNums, parkId);
        if (CollectionUtils.isNotEmpty(liveOrders)) {
            if (CollectionUtils.isNotEmpty(liveOrders)) {
                List<OrderInfo> orderInfos = liveOrders.stream()
                        .map(order -> {
                            OrderInfo update = new OrderInfo();
                            update.setId(order.getId());
                            update.setServiceStatus(OrderStatusConstants.EXCEPTION);
                            update.setOddStatus(OrderOddStatusEnum.重复入场.getVal());
                            update.setOperAccount(userName);
                            update.setExitTime(order.getEnterTime());
                            return update;
                        }).collect(Collectors.toList());
                // 把在场车场批量修改为异常离场重复入场
                updateBatchById(orderInfos);
                List<String> orderNums = liveOrders.stream().map(OrderInfo::getOrderNum).collect(Collectors.toList());
                LambdaQueryWrapper<OrderSonInfo> orderSonQuery = Wrappers.lambdaQuery(OrderSonInfo.class);
                orderSonQuery.in(OrderSonInfo::getOrderNum, orderNums);
                orderSonQuery.eq(OrderSonInfo::getServiceStatus, OrderStatusConstants.IN_PARK);
                List<OrderSonInfo> sonInfos = orderSonInfoService.list(orderSonQuery);
                if (CollectionUtils.isNotEmpty(sonInfos)) {
                    List<OrderSonInfo> updateOrderSons = sonInfos.stream()
                            .map(order -> {
                                OrderSonInfo update = new OrderSonInfo();
                                update.setId(order.getId());
                                update.setServiceStatus(OrderStatusConstants.EXCEPTION);
                                update.setOddStatus(OrderOddStatusEnum.重复入场.getVal());
                                update.setOperAccount(userName);
                                update.setExitTime(order.getEnterTime());
                                return update;
                            }).collect(Collectors.toList());
                    // 把在场子订单批量修改为异常离场重复入场
                    orderSonInfoService.updateBatchById(updateOrderSons);
                }
            }
        }
        if (flag) {
            addNormalLiveOrder(result, parkId, userName);
            return ObjectResponse.success();
        }
        addMorelLiveOrder(result, parkId, userName, parkRegions);
        return ObjectResponse.success();
    }

    /**
     * 通过车场id和车牌号获取在场车辆订单
     *
     * @param plateNums
     * @param parkId
     * @return
     */
    @DS_SLAVE
    public List<OrderInfo> getLiveOrderListsByPlateNums(List<String> plateNums, Long parkId) {
        return list(Wrappers.lambdaQuery(OrderInfo.class)
                .eq(OrderInfo::getParkId, parkId).in(OrderInfo::getPlateNum, plateNums)
                .eq(OrderInfo::getServiceStatus, 1));
    }

    public void addNormalLiveOrder(List<OrderAddRequest> result, Long parkId, String userName) {
        List<OrderInfo> orderInfos = new ArrayList<>();
        List<OrderCarInfo> orderCarInfos = new ArrayList<>();
        for (OrderAddRequest request : result) {
            OrderInfo orderInfo = OrderInfo.builder()
                    .orderNum(idGenerator.nextIdAsString())
                    .parkId(parkId)
                    .plateNum(request.getPlateNum())
                    .plateNum2(StringUtils.substring(request.getPlateNum(), 1))
                    .type(request.getType())
                    .hasSon(0)
                    .enterTime(request.getEnterTime())
                    .serviceStatus(OrderStatusConstants.IN_PARK)
                    .operAccount(userName)
                    .carType(request.getCarType())
                    .build();
            orderInfos.add(orderInfo);
            OrderCarInfo carInfo = new OrderCarInfo();
            carInfo.setOrderNum(orderInfo.getOrderNum());
            carInfo.setPlateColor(request.getPlateColor());
            carInfo.setEnterWay(4);
            carInfo.setEnterTerminal(6);
            carInfo.setEnterOperAccount(userName);
            orderCarInfos.add(carInfo);
        }
        // 批量添加在场订单和进出明细
        saveBatch(orderInfos);
        orderCarInfoService.saveBatch(orderCarInfos);
        // 修改车场余位
        updateParkFreeSpaceService.resetFreeSpace(parkId);
    }

    public void addMorelLiveOrder(List<OrderAddRequest> result, Long parkId, String userName, List<ParkRegion> parkRegions) {
        Long outRegionId = getRegionIdByType(parkRegions, 1);
        Long inRegionId = getRegionIdByType(parkRegions, 2);
        List<OrderInfo> orderInfos = new ArrayList<>();
        List<OrderCarInfo> orderCarInfos = new ArrayList<>();
        List<OrderSonInfo> outOrderSonInfos = new ArrayList<>();
        List<OrderSonCarInfo> outOrderSonCarInfos = new ArrayList<>();
        List<OrderSonInfo> innerOrderSonInfos = new ArrayList<>();
        List<OrderSonCarInfo> innerOrderSonCarInfos = new ArrayList<>();
        List<OrderTrack> tracks = new ArrayList<>();
        Map<String, List<OrderAddRequest>> map = result.stream()
                .collect(Collectors.groupingBy(OrderAddRequest::getPlateNum));
        for (Map.Entry<String, List<OrderAddRequest>> entry : map.entrySet()) {
            List<OrderAddRequest> requests = entry.getValue();
            if (requests.size() > 1) {
                processMultipleRequests(parkId, userName, inRegionId, outRegionId, orderInfos, orderCarInfos, outOrderSonInfos, outOrderSonCarInfos, innerOrderSonInfos, innerOrderSonCarInfos, tracks, entry);
            } else {
                processSingleRequest(parkId, userName, outRegionId, inRegionId, orderInfos, orderCarInfos, outOrderSonInfos, outOrderSonCarInfos, innerOrderSonInfos, innerOrderSonCarInfos, tracks, requests.get(0));
            }
        }
        saveAll(orderInfos, orderCarInfos, outOrderSonInfos, outOrderSonCarInfos, innerOrderSonInfos, innerOrderSonCarInfos, tracks, parkId, parkRegions);
    }

    public Long getRegionIdByType(List<ParkRegion> parkRegions, int type) {
        return parkRegions.stream()
                .filter(region -> region.getRegionType() != null && region.getRegionType() == type)
                .map(ParkRegion::getId)
                .findFirst()
                .orElse(null);
    }

    public void processMultipleRequests(Long parkId, String userName, Long inRegionId, Long outRegionId, List<OrderInfo> orderInfos, List<OrderCarInfo> orderCarInfos, List<OrderSonInfo> outOrderSonInfos, List<OrderSonCarInfo> outOrderSonCarInfos, List<OrderSonInfo> innerOrderSonInfos, List<OrderSonCarInfo> innerOrderSonCarInfos, List<OrderTrack> tracks, Map.Entry<String, List<OrderAddRequest>> entry) {
        List<OrderAddRequest> requests = entry.getValue();
        Optional<OrderAddRequest> first = requests.stream()
                .filter(a -> a.getRegionId().equals(outRegionId))
                .findFirst();
        Optional<OrderAddRequest> second = requests.stream()
                .filter(a -> a.getRegionId().equals(inRegionId))
                .findFirst();
        OrderAddRequest outRequest = first.get();
        OrderAddRequest inRequest = second.get();
        String plateNum = entry.getKey();
        OrderInfo orderInfo = createOrderInfo(parkId, userName, outRegionId, plateNum, outRequest);
        orderInfo.setHasSon(1);
        orderInfos.add(orderInfo);
        orderCarInfos.add(createOrderCarInfo(orderInfo, outRequest, userName));
        // 外区域订单
        OrderSonInfo outSonInfo = new OrderSonInfo();
        outSonInfo.setOrderNum(orderInfo.getOrderNum());
        outSonInfo.setParkId(orderInfo.getParkId());
        outSonInfo.setPlateNum(plateNum);
        outSonInfo.setType(outRequest.getType());
        outSonInfo.setRegionId(outRegionId);
        outSonInfo.setHasSon(0);
        outSonInfo.setEnterTime(outRequest.getEnterTime());
        outSonInfo.setPlateNum2(StringUtils.substring(plateNum, 1));
        outSonInfo.setCarType(outRequest.getCarType());
        outSonInfo.setServiceStatus(OrderStatusConstants.LEAVED_PARK);
        outSonInfo.setOperAccount(userName);
        outOrderSonInfos.add(outSonInfo);
        outOrderSonCarInfos.add(createOrderSonCarInfo(orderInfo, outRequest, userName));
        // 内区域订单
        OrderSonInfo inSonInfo = new OrderSonInfo();
        inSonInfo.setOrderNum(orderInfo.getOrderNum());
        inSonInfo.setParkId(orderInfo.getParkId());
        inSonInfo.setPlateNum(plateNum);
        inSonInfo.setType(inRequest.getType());
        inSonInfo.setRegionId(inRegionId);
        inSonInfo.setHasSon(0);
        inSonInfo.setEnterTime(inRequest.getEnterTime());
        inSonInfo.setPlateNum2(StringUtils.substring(plateNum, 1));
        inSonInfo.setCarType(inRequest.getCarType());
        inSonInfo.setServiceStatus(OrderStatusConstants.IN_PARK);
        inSonInfo.setOperAccount(userName);
        innerOrderSonInfos.add(inSonInfo);
        innerOrderSonCarInfos.add(createOrderSonCarInfo(orderInfo, inRequest, userName));
        // 内区域的轨迹
        tracks.add(new OrderTrack()
                .setRecordType(1)
                .setParkId(orderInfo.getParkId())
                .setRegionId(inRequest.getRegionId())
                .setOrderNum(orderInfo.getOrderNum())
                .setPlateNum(orderInfo.getPlateNum())
                .setEnexTime(inRequest.getEnterTime())
                .setType(inRequest.getType())
                .setInoutEvent(4)
                .setExTerminal(6));
        // 外区域的轨迹
        tracks.add(new OrderTrack()
                .setRecordType(1)
                .setParkId(orderInfo.getParkId())
                .setRegionId(outRequest.getRegionId())
                .setOrderNum(orderInfo.getOrderNum())
                .setPlateNum(orderInfo.getPlateNum())
                .setEnexTime(outRequest.getEnterTime())
                .setType(outRequest.getType())
                .setInoutEvent(4)
                .setExTerminal(6));
    }

    public void processSingleRequest(Long parkId, String userName, Long outRegionId, Long inRegionId, List<OrderInfo> orderInfos, List<OrderCarInfo> orderCarInfos, List<OrderSonInfo> outOrderSonInfos, List<OrderSonCarInfo> outOrderSonCarInfos, List<OrderSonInfo> innerOrderSonInfos, List<OrderSonCarInfo> innerOrderSonCarInfos, List<OrderTrack> tracks, OrderAddRequest request) {
        OrderInfo orderInfo = createOrderInfo(parkId, userName, request.getRegionId(), request.getPlateNum(), request);
        orderInfos.add(orderInfo);
        orderCarInfos.add(createOrderCarInfo(orderInfo, request, userName));
        if (!outRegionId.equals(request.getRegionId())) {
            orderInfo.setHasSon(1);
            // Process Outer Region
            outOrderSonInfos.add(createOrderSonInfo(orderInfo, outRegionId, true, null));
            outOrderSonCarInfos.add(createOrderSonCarInfo(orderInfo, request, userName));
            // Process Inner Region
            innerOrderSonInfos.add(createOrderSonInfo(orderInfo, inRegionId, false, null));
            innerOrderSonCarInfos.add(createOrderSonCarInfo(orderInfo, request, userName));
        }
        tracks.add(createOrderTrack(orderInfo));
    }

    private OrderInfo createOrderInfo(Long parkId, String userName, Long regionId, String plateNum, OrderAddRequest request) {
        return OrderInfo.builder()
                .orderNum(idGenerator.nextIdAsString())
                .parkId(parkId)
                .plateNum(plateNum)
                .plateNum2(StringUtils.substring(plateNum, 1))
                .type(request.getType())
                .carType(request.getCarType())
                .hasSon(0)
                .enterTime(request.getEnterTime())
                .serviceStatus(OrderStatusConstants.IN_PARK)
                .regionId(regionId)
                .operAccount(userName)
                .build();
    }

    private OrderCarInfo createOrderCarInfo(OrderInfo orderInfo, OrderAddRequest request, String userName) {
        OrderCarInfo carInfo = new OrderCarInfo();
        carInfo.setOrderNum(orderInfo.getOrderNum());
        carInfo.setPlateColor(request.getPlateColor());
        carInfo.setEnterWay(4);
        carInfo.setEnterTerminal(6);
        carInfo.setEnterOperAccount(userName);
        return carInfo;
    }

    private OrderSonInfo createOrderSonInfo(OrderInfo orderInfo, Long regionId, boolean isOuterRegion, Long enterTime) {
        OrderSonInfo sonInfo = new OrderSonInfo();
        BeanUtils.copyProperties(orderInfo, sonInfo);
        if (Objects.nonNull(enterTime)) {
            sonInfo.setEnterTime(enterTime);
        }
        sonInfo.setRegionId(regionId);
        if (isOuterRegion) {
            sonInfo.setNoneEnterFlag(1);
            sonInfo.setServiceStatus(OrderStatusConstants.LEAVED_PARK);
        }
        return sonInfo;
    }

    private OrderSonCarInfo createOrderSonCarInfo(OrderInfo orderInfo, OrderAddRequest request, String userName) {
        OrderSonCarInfo sonCarInfo = new OrderSonCarInfo();
        sonCarInfo.setOrderNum(orderInfo.getOrderNum());
        sonCarInfo.setPlateColor(request.getPlateColor());
        sonCarInfo.setEnterWay(4);
        sonCarInfo.setEnterTerminal(6);
        sonCarInfo.setEnterOperAccount(userName);
        return sonCarInfo;
    }

    private OrderTrack createOrderTrack(OrderInfo orderInfo) {
        return new OrderTrack()
                .setRecordType(1)
                .setParkId(orderInfo.getParkId())
                .setRegionId(orderInfo.getRegionId())
                .setOrderNum(orderInfo.getOrderNum())
                .setPlateNum(orderInfo.getPlateNum())
                .setEnexTime(orderInfo.getEnterTime())
                .setType(orderInfo.getType())
                .setInoutEvent(4)
                .setExTerminal(6);
    }

    public void saveAll(List<OrderInfo> orderInfos, List<OrderCarInfo> orderCarInfos, List<OrderSonInfo> outOrderSonInfos, List<OrderSonCarInfo> outOrderSonCarInfos, List<OrderSonInfo> innerOrderSonInfos, List<OrderSonCarInfo> innerOrderSonCarInfos, List<OrderTrack> tracks, Long parkId, List<ParkRegion> parkRegions) {
        saveBatch(orderInfos);
        orderCarInfoService.saveBatch(orderCarInfos);

        if (orderSonInfoService.saveBatch(outOrderSonInfos)) {
            saveOrderSonCarInfos(outOrderSonInfos, outOrderSonCarInfos);
        }

        if (orderSonInfoService.saveBatch(innerOrderSonInfos)) {
            saveOrderSonCarInfos(innerOrderSonInfos, innerOrderSonCarInfos);
        }
        updateRegionFreeSpaceService.resetFreeSpace(parkId);

        if (CollectionUtils.isNotEmpty(tracks)) {
            orderTrackService.saveBatch(tracks);
        }
    }

    public void saveOrderSonCarInfos(List<OrderSonInfo> orderSonInfos, List<OrderSonCarInfo> orderSonCarInfos) {
        Map<String, Long> orderSonInfoMap = orderSonInfos.stream()
                .collect(Collectors.toMap(OrderSonInfo::getOrderNum, OrderSonInfo::getId, (a, b) -> a));
        List<OrderSonCarInfo> collect = orderSonCarInfos.stream()
                .peek(outOrderSonInfo -> {
                    Long orderSonId = orderSonInfoMap.get(outOrderSonInfo.getOrderNum());
                    if (Objects.nonNull(orderSonId)) {
                        outOrderSonInfo.setOrderSonId(orderSonId);
                    }
                }).collect(Collectors.toList());
        orderSonCarInfoDao.batchSave(collect);
    }

    @Override
    public OrderInfo getByLocalOrderNumWithHistory(Long parkId, String localOrderNum) {
        OrderInfo orderInfo = new OrderInfo();
        orderInfo.setLocalOrderNum(localOrderNum);
        orderInfo.setParkId(parkId);
        OrderInfo existsOrder = orderInfoDao.selectLimitOneOrderByEnterDesc(orderInfo);
        if (existsOrder != null) {
            return existsOrder;
        }
        Date startDate = DateUtil.offsetDay(DateUtil.date(), -90);
        List<String> yearQuarterRangeTableName = DateRangeUtils.getYearQuarterRangeTableName(startDate);
        return orderInfoDao.selectByLocalOrderNumWithHistory(parkId, yearQuarterRangeTableName, localOrderNum);
    }

    @Override
    public Integer getChargeLiveCount(Long parkId) {
        return orderInfoDao.selectChargeLiveCount(parkId);
    }

    @Override
    public Integer getOilLiveCount(Long parkId) {
        return orderInfoDao.selectOilLiveCount(parkId);
    }

    @Override
    @DS_SLAVE
    @SentinelResource(value = "OrderService.getMpOrderDetail", defaultFallback = "defaultFallbackHandle", fallbackClass = {ExceptionUtils.class})
    public ObjectResponse getMpOrderDetail(Integer type, Long id) {
        //临停缴费
        if (type == 1) {
            ObjectResponse<OrderPayDto> orderPayDto = orderPayService.getOrderPayDetail(null, Math.toIntExact(id), null);
            return orderPayDto;
        } else {
            MonthOrderDto monthOrderDto = monthOrderDao.getMonthOrderDetail(id);
            if (Objects.isNull(monthOrderDto)) {
                return ObjectResponse.failed(CodeConstantsEnum.ERROR_404);
            }
            return ObjectResponse.success(monthOrderDto);
        }
    }

    @Override
    @DS_SLAVE
    @SentinelResource(value = "OrderService.countEnterCar", defaultFallback = "defaultFallbackHandle", fallbackClass = {ExceptionUtils.class})
    public ObjectResponse<Integer> countEnterCar(Long parkId) {
        Integer count = orderInfoDao.countEnterCar(parkId);
        return ObjectResponse.success(count);
    }

    @Override
    public ObjectResponse<OrderInfo> fuzzyOutPlate(Long parkId, String plateNum) {
        String plateNumPart = plateNum.substring(1);
        OrderInfo orderInfo = orderInfoDao.fuzzyOutParkPlate(parkId, plateNumPart);
        if (orderInfo == null) {
            return ObjectResponse.failed(CodeConstants.ERROR_404);
        } else {
            return ObjectResponse.success(orderInfo);
        }
    }

    @Override
    public ObjectResponse<PlateTypeDto> getPlateType(Long parkId, String plateNum) {
        PlateTypeDto plateTypeDto = new PlateTypeDto();
        plateTypeDto.setPlateTypeEnum(PlateTypeEnum.临时车);
        Boolean isMonthCard = monthCarService.judgeMonthCar(parkId, plateNum);
        return getPlateTypeDto(parkId, plateNum, plateTypeDto, isMonthCard, null);
    }

    @Override
    public ObjectResponse<PlateTypeDto> getPlateType(Long parkId, String plateNum, Long regionId) {
        PlateTypeDto plateTypeDto = new PlateTypeDto();
        plateTypeDto.setPlateTypeEnum(PlateTypeEnum.临时车);
        Boolean isMonthCard = monthCarService.judgeMonthCar(parkId, plateNum, regionId);
        return getPlateTypeDto(parkId, plateNum, plateTypeDto, isMonthCard, regionId);
    }

    private ObjectResponse<PlateTypeDto> getPlateTypeDto(Long parkId, String plateNum, PlateTypeDto plateTypeDto,
                                                         Boolean isMonthCard, Long regionId) {
        ObjectResponse<ParkConfig> configObjectResponse = parkService.getParkConfig(parkId);
        if (ObjectResponse.isSuccess(configObjectResponse)) {
            Integer freeOfficialCars = configObjectResponse.getData().getFreeOfficialCars();
            if (NumberUtils.toPrimitive(freeOfficialCars) == 1 && PlateTypeDto.officialCar(plateNum)) {
                plateTypeDto.setPlateTypeEnum(PlateTypeEnum.特殊车辆);
                return ObjectResponse.success(plateTypeDto);
            }
        }
        if (isMonthCard) {
            plateTypeDto.setPlateTypeEnum(PlateTypeEnum.月卡车);
            return ObjectResponse.success(plateTypeDto);
        } else {
            //济南定制VIP车辆判断
            VehiclePlate vehiclePlate = vehiclePlateDao.selectVip(parkId, plateNum);
            if (vehiclePlate != null) {
                plateTypeDto.setPlateTypeEnum(PlateTypeEnum.VIP车辆);
                return ObjectResponse.success(plateTypeDto);
            } else {
                //vip车辆判断
                ObjectResponse<VipType> validVipCar = vipCarService.getValidVipCar(parkId, plateNum, regionId);
                if (ObjectResponse.isSuccess(validVipCar)) {
                    VipType vipType = validVipCar.getData();
                    plateTypeDto.setCarDesc(vipType.getName());
                    plateTypeDto.setPlateTypeEnum(PlateTypeEnum.VIP车辆);
                    return ObjectResponse.success(plateTypeDto);
                } else {
                    ObjectResponse<ParkVisit> visitCar = parkVisitService.checkVisitPlate(parkId, plateNum);
                    if (ObjectResponse.isSuccess(visitCar)) {
                        plateTypeDto.setPlateTypeEnum(PlateTypeEnum.访客车辆);
                        return ObjectResponse.success(plateTypeDto);
                    } else {
                        ObjectResponse<StoreCard> validStoreCards = storeCardService.getValidStoreCards(plateNum, parkId);
                        if (ObjectResponse.isSuccess(validStoreCards)) {
                            plateTypeDto.setPlateTypeEnum(PlateTypeEnum.储值卡车);
                            return ObjectResponse.success(plateTypeDto);
                        } else {
                            plateTypeDto.setPlateTypeEnum(PlateTypeEnum.临时车);
                            return ObjectResponse.success(plateTypeDto);
                        }
                    }
                }
            }
        }
    }

    private OrderInfo fuzzyPlateNum(Long parkId, String plateNum, int plot) {
        List<String> plates = FuzzyPlateTools.fuzzyCharacter(plateNum, plot);
        return orderInfoDao.fuzzyInParkPlate(parkId, plates);
    }

    private OrderInfo fuzzyPlateNum(long parkId, String plateNum, int status, int plot) {
        List<String> plates = FuzzyPlateTools.fuzzyCharacter(plateNum, plot);
        OrderInfo orderInfo = null;
        for (String plate : plates) {
            orderInfo = orderInfoDao.fuzzyOrderByPlate(parkId, plate, status);
            if (orderInfo != null) {
                break;
            }
        }
        return orderInfo;
    }

    private List<String> getFuzzyPlateNums(int vagueType, String plateNum) {
        if (vagueType == 0) {
            String plateNumPart = plateNum.substring(1);
            return Collections.singletonList("_" + plateNumPart);
        } else if (vagueType == 1) {
            return FuzzyPlateTools.fuzzyCharacter(plateNum, 1);
        } else if (vagueType == 2) {
            List<String> plates1 = FuzzyPlateTools.fuzzyCharacter(plateNum, 1);
            List<String> plates2 = FuzzyPlateTools.fuzzyCharacter(plateNum, 2);
            plates1.addAll(plates2);
            return plates1;
        }
        return null;
    }

    /**
     * 获取响应结果
     *
     * @param parkCode
     * @param plateNum
     * @param orderInfo1
     * @return
     */
    private SearchCarResponse getSearchCarResponse(String parkCode, String plateNum, OrderInfo orderInfo1) {
        SearchCarResponse searchCarResponse = new SearchCarResponse();
        searchCarResponse.setOrderNum(orderInfo1.getOrderNum());
        searchCarResponse.setCarType(orderInfo1.getType());
        searchCarResponse.setEnterTime(DateTools.secondTostring(orderInfo1.getEnterTime().intValue()));
        searchCarResponse.setPlateNum(orderInfo1.getPlateNum());

        if (MONTH_CARD.equals(orderInfo1.getType())) {
            searchCarResponse.setPayStatus(NO_NEED_PAY);
        } else {
            QueryOrderFeeRequest queryOrderFeeRequest = new QueryOrderFeeRequest();
            queryOrderFeeRequest.setParkCode(parkCode);
            queryOrderFeeRequest.setPlateNum(plateNum);
            ObjectResponse<QueryOrderFeeResponse> objectResponse = queryOrderFeeService.queryOrderFee(queryOrderFeeRequest);
            //获取回调的查费结果
            if (CodeConstants.ERROR_12002.equals(objectResponse.getCode())) {
                String messageId = objectResponse.getMsg();
                objectResponse = AsyncNotifyInterface.wait(messageId, 4000L, () -> {
                    ObjectResponse<QueryOrderFeeResponse> response = redisUtils.get(AsyncNotifyInterface.getMessageKey(messageId),
                            new TypeReference<ObjectResponse<QueryOrderFeeResponse>>() {
                            });
                    if (response != null) {
                        if (ObjectResponse.isSuccess(response)) {
                            QueryOrderFeeResponse queryOrderFeeResponse = JsonUtils.parseObject(
                                    JsonUtils.toString(response.getData()), QueryOrderFeeResponse.class);
                            return ObjectResponse.success(queryOrderFeeResponse);
                        } else {
                            return response;
                        }
                    } else {
                        alarmService.queryFeeFailHandler(parkCode, orderInfo1.getParkId(), queryOrderFeeRequest.getChannelId());
                        return ObjectResponse.failed(CodeConstants.ERROR_3001);
                    }
                });
            }
            if (ObjectResponse.isSuccess(objectResponse)) {
                QueryOrderFeeResponse queryOrderFeeResponse = objectResponse.getData();
                Integer status = queryOrderFeeResponse.getStatus();
                searchCarResponse.setPayStatus(status);
            } else {
                searchCarResponse.setPayStatus(NO_NEED_PAY);
            }
        }
        OrderCarInfo carInfo = orderCarInfoDao.selectByOrderNum(orderInfo1.getOrderNum());
        if (StringUtils.isNotBlank(carInfo.getEnterImage())) {
            searchCarResponse.setEnterImage(ossService.getImageUrl(carInfo.getEnterImage()));
//            searchCarResponse.setEnterImage(enterImage);
        }
        return searchCarResponse;
    }

    /**
     * 根据车牌查询订单集合
     *
     * @param pageQuery
     * @param plateNum
     * @param parkId
     * @return
     */
    private List<OrderInfo> getOrderInfos(PageQuery<SearchCarRequest> pageQuery, String plateNum, Long parkId) {
        OrderInfo orderInfo = new OrderInfo();
        orderInfo.setPlateNum(plateNum);
        orderInfo.setParkId(parkId);
        Page<OrderInfo> page = new Page<>(pageQuery.getCurrent(), pageQuery.getSize());
        return orderInfoDao.selectPage(page, Wrappers.query(orderInfo)).getRecords();
    }


    /**
     * @Author zhangpengzhan
     * @Description // 向人工修正表中添加数据
     * @Date 2020/7/3
     * @Param [madePlate]
     * @Return com.icetech.common.domain.response.ObjectResponse
     **/
    @Override
    public ObjectResponse addMadePlate(MadePlate madePlate) {
        int insertResult = madePlateDao.insert(madePlate);
        if (insertResult <= 0) {
            updateMadePlate(madePlate);
        }
        return ObjectResponse.success();
    }

    /**
     * @Author zhangpengzhan
     * @Description // 通过订单号查询人工修正表中的数据
     * @Date 2020/7/3
     * @Param [orderNum]
     * @Return com.icetech.common.domain.response.ObjectResponse<com.icetech.cloudcenter.domain.made.MadePlate>
     **/
    @Override
    public ObjectResponse<MadePlate> findMadePlateByOrderNum(String orderNum) {
        MadePlate madePlate = madePlateDao.selectByOrderNum(orderNum);
        return ObjectResponse.success(madePlate);
    }

    /**
     * @Author zhangpengzhan
     * @Description // 更新人工修改表的记录
     * @Date 2020/7/3
     * @Param [madePlate]
     * @Return com.icetech.common.domain.response.ObjectResponse
     **/

    @Override
    public ObjectResponse updateMadePlate(MadePlate madePlate) {
        madePlateDao.update(madePlate);
        return ObjectResponse.success();
    }

    /**
     * @Author zhangpengzhan
     * @Description // 向修正记录表中插入修正记录
     * @Date 2020/7/3
     * @Param [orderModifyRecord]
     * @Return com.icetech.common.domain.response.ObjectResponse
     **/
    @Override
    public ObjectResponse addOrderModifyReocrd(OrderModifyRecord orderModifyRecord) {
        orderModifyRecordDao.insert(orderModifyRecord);
        return ObjectResponse.success();
    }

    /**
     * @Author zhangpengzhan
     * @Description // 二次识别结果通知接口
     * @Date 2020/7/3
     * @Param [orderNum, newPlateNum, newReliability, newCarType]
     * @Return com.icetech.common.domain.response.ObjectResponse
     **/

    @Override
    public ObjectResponse checkSecRecognition(String orderNum, String newPlateNum, int newReliability, int newCarType) {
        if (StringUtils.isEmpty(orderNum)) {
            return ObjectResponse.failed(CodeConstants.ERROR_400);
        }
        MadePlate madePlate = new MadePlate();
        madePlate.setOrderNum(orderNum);
        madePlate.setPlateReliability(newReliability);
        //小于可信度阈值，直接放入人工修改表中，大于则更新对应的表数据
        if (newReliability < reliabilityThreshold) {
            OrderInfo orderInfo = orderInfoDao.selectByOrderNum(orderNum);
            if (orderInfo == null) {
                return ObjectResponse.failed(CodeConstants.ERROR_404, "订单号不存在");
            }
            OrderCarInfo orderCarInfo = orderCarInfoDao.selectByOrderNum(orderNum);
            if (orderCarInfo == null) {
                return ObjectResponse.failed(CodeConstants.ERROR_404, "订单信息不存在");
            }
            madePlate.setParkId(orderInfo.getParkId());
            madePlate.setEnterTime(orderInfo.getEnterTime());
            madePlate.setOrderNum(orderNum);
            madePlate.setPlateNum(orderInfo.getPlateNum());
            madePlate.setImage(orderCarInfo.getEnterImage());
            madePlate.setCreateTime(DateTools.getFormat(new Date()));
            //0未处理1已处理
            madePlate.setStatus(0);
            addMadePlate(madePlate);
        } else {
            //回传执行结果给下一个调用消费者
            ObjectResponse objectResponse = modifyCar(orderNum, newPlateNum, newCarType);
            return objectResponse;
        }
        return ObjectResponse.success();
    }

    /**
     * @param queryOrderFeeResponse 扣费信息
     * @param orderNum              订单号
     * @return 扣费结果信息
     * @Author zhangpengzhan
     * 储值卡出场扣费逻辑流程
     * 并更新 出场交易记录
     */
    @Override
    public ObjectResponse<StoreCard> chargeStoreCardComplete(QueryOrderFeeResponse queryOrderFeeResponse, String orderNum, Long parkId, String channelCode) {
        //储值卡扣费
        ObjectResponse<StoreCard> objectResponse = storeCardService.chargeStoreCard(queryOrderFeeResponse, parkId);

        //扣费成功则记录交易记录
        if (null != objectResponse && CodeConstants.SUCCESS.equals(objectResponse.getCode())) {
            StoreCard storeCard = objectResponse.getData();
            OrderPay orderPay = new OrderPay();
            orderPay.setOrderNum(orderNum);
            orderPay.setPayStatus(PayStatusConstants.PAID);
            orderPay.setParkId(parkId);
            orderPay.setDiscountPrice(queryOrderFeeResponse.getDiscountPrice());
            //orderPay.setPaidPrice(queryOrderFeeResponse.getUnpayPrice());
            /*
             //储值卡不记录以下参数
            //支付类型
            orderPay.setPayChannel();
            //支付终端
            orderPay.setPayTerminal();
            //支付方式
            orderPay.setPayWay();*/
            orderPay.setCardNum(storeCard.getCardsNum());
            orderPay.setBalancePrice(new BigDecimal(queryOrderFeeResponse.getUnpayPrice()));
            orderPay.setPaidPrice("0");
            orderPay.setOrderTime(queryOrderFeeResponse.getQueryTime());
            orderPay.setPayTime(queryOrderFeeResponse.getQueryTime());
            orderPay.setTotalPrice(NumberUtils.decimalAdd(queryOrderFeeResponse.getUnpayPrice(), queryOrderFeeResponse.getDiscountPrice()).toString());
            orderPay.setTradeNo(CodeTools.GenerateTradeNo());
            orderPay.setIsSync(0);
            orderPay.setChannelId(channelCode);
            orderPayService.addOrderPay(orderPay);
            OrderInfo orderInfo = new OrderInfo();
            orderInfo.setOrderNum(orderNum);
            ObjectResponse<OrderInfo> orderInfoObjectResponse = findByOrderInfo(orderInfo);
            orderInfo.setPaidPrice("0");
            orderInfo.setExitTime(queryOrderFeeResponse.getQueryTime());
            orderInfo.setCarType(queryOrderFeeResponse.getCarType());
            orderInfo.setTotalPrice(queryOrderFeeResponse.getTotalAmount());
            if (orderInfoObjectResponse.getData() != null && orderInfoObjectResponse.getData().getBalancePrice() != null) {
                orderInfo.setBalancePrice(orderInfoObjectResponse.getData().getBalancePrice()
                        .add(new BigDecimal(queryOrderFeeResponse.getUnpayPrice()))
                );
            } else {
                orderInfo.setBalancePrice(new BigDecimal(queryOrderFeeResponse.getUnpayPrice()));
            }
            orderInfo.setType(PlateTypeEnum.储值卡车.getType());
            if (CodeConstants.SUCCESS.equals(orderInfoObjectResponse.getCode())) {
                orderInfoDao.updateByOrderNum(orderInfo);
            } else {
                orderInfo.setParkId(parkId);
                orderInfo.setPlateNum(queryOrderFeeResponse.getPlateNum());
                orderInfo.setEnterTime(queryOrderFeeResponse.getEnterTime());
                orderInfo.setServiceStatus(OrderStatusConstants.IN_PARK);
                try {
                    addOrderInfo(orderInfo);
                } catch (DuplicateKeyException e) {
                    orderNum = CodeTools.GenerateOrderNum();
                    orderInfo.setOrderNum(orderNum);
                    addOrderInfo(orderInfo);
                }
            }

        }

        return objectResponse;
    }

    @Override
    public ObjectResponse<OrderModifyRecord> selectModifyRecordById(Long id) {
        OrderModifyRecord orderModifyRecord = orderModifyRecordDao.selectOneById(id);
        if (orderModifyRecord == null) {
            return ObjectResponse.failed(CodeConstants.ERROR_404);
        } else {
            return ObjectResponse.success(orderModifyRecord);
        }
    }

    @Override
    @Transactional
    @SentinelResource(value = "OrderService.batchExitOrder",
            defaultFallback = "defaultFallbackHandle", fallbackClass = {ExceptionUtils.class})
    public ObjectResponse batchExitOrder(List<String> orderNums, Integer oddStatus, String username) {
        if (CollectionUtil.isEmpty(orderNums)) {
            return ObjectResponse.failed(CodeConstants.ERROR_400, "订单号不能为空");
        }
        List<OrderInfo> orderInfos = orderInfoDao.selectList(Wrappers.lambdaQuery(OrderInfo.class).in(OrderInfo::getOrderNum, orderNums).orderByAsc(OrderInfo::getId));
        if (CollectionUtils.isEmpty(orderInfos)) {
            return ObjectResponse.returnNotFoundIfNull(null);
        }
        Set<Long> orderParkSet = new HashSet<>(orderInfos.size());
        List<OrderPay> feeParams = new ArrayList<>(orderInfos.size());
        for (OrderInfo orderInfo : orderInfos) {
            OrderPay pay = new OrderPay();
            pay.setParkId(orderInfo.getParkId());
            pay.setOrderNum(orderInfo.getOrderNum());
            feeParams.add(pay);
            orderParkSet.add(orderInfo.getParkId());
        }
        List<OrderSumFeeDto> orderSumFeeDtos = orderPayDao.sumFees(feeParams);
        Map<String, OrderSumFeeDto> feeMap = orderSumFeeDtos.stream().collect(Collectors.toMap(OrderSumFeeDto::getOrderNum, Function.identity(), (older, newer) -> newer));
        ObjectResponse<Map<Long, ParkConfig>> configResp = parkService.getParkConfigs(orderParkSet);
        Map<Long, ParkConfig> configMap = ObjectResponse.isSuccess(configResp) ? configResp.getData() : Collections.emptyMap();
        Map<String, Integer> addSpaceParkMap = new HashMap<>(orderParkSet.size());
        Set<Long> syncSpaceParkSet = new HashSet<>(orderParkSet.size());
        List<OrderInfo> updateOrders = new ArrayList<>(orderInfos.size());
        List<String> updateSonOrders = orderInfos.stream().filter(Objects::nonNull)
                .filter(od -> Integer.valueOf(1).equals(od.getHasSon()))
                .map(OrderInfo::getOrderNum)
                .filter(Objects::nonNull).collect(Collectors.toList());

        Map<String, OrderSonInfo> sonOrderMap = new HashMap<>(orderInfos.size());
        if (CollectionUtils.isNotEmpty(updateSonOrders)) {
            List<OrderSonInfo> orderSonInfos = orderSonInfoDao.selectList(Wrappers.lambdaQuery(OrderSonInfo.class)
                    .in(OrderSonInfo::getOrderNum, updateSonOrders)
                    .in(OrderSonInfo::getServiceStatus, 1));
            if (CollectionUtils.isNotEmpty(orderSonInfos)) {
                sonOrderMap = orderSonInfos.stream().collect(
                        Collectors.groupingBy(OrderSonInfo::getOrderNum, Collectors.collectingAndThen(Collectors.toList(), list -> list.get(0))));
            }
        }
        // parkId, localOrderNums
        Map<Long, List<String>> downOrderNumMap = new HashMap<>(configMap.size());
        for (OrderInfo orderInfo : orderInfos) {
            OrderInfo update = new OrderInfo();
            update.setId(orderInfo.getId());
            update.setServiceStatus(OrderStatusConstants.EXCEPTION);
            update.setExitTime(DateUtil.currentSeconds());
            update.setOddStatus(Objects.isNull(oddStatus) ? OrderOddStatusEnum.手动出场.getVal() : oddStatus);
            update.setOperAccount(username);
            if (Objects.nonNull(oddStatus) && OrderOddStatusEnum.车辆盘点.getVal().equals(oddStatus)) {
                update.setServiceStatus(OrderStatusConstants.CANCEL);
                update.setOddStatus(null);
            }
            OrderSumFeeDto orderSumFeeDto = feeMap.get(orderInfo.getOrderNum());
            if (orderSumFeeDto == null) {
                update.setPaidPrice("0.00");
                update.setDiscountPrice("0.00");
                update.setTotalPrice("0.00");
            } else {
                update.setPaidPrice(String.valueOf(orderSumFeeDto.getPaidPrice()));
                update.setDiscountPrice(String.valueOf(orderSumFeeDto.getDiscountPrice()));
                update.setTotalPrice("0.00");
            }
            updateOrders.add(update);
            ParkConfig config = configMap.get(orderInfo.getParkId());
            if (config != null) {
                if (config.getDelOrderCalcSpaceFlag(0) == 1 && (
                        !PlateTypeEnum.月卡车.getType().equals(orderInfo.getType())
                                || NumberUtils.toPrimitive(config.getIsCardcount()) == 1)) {
                    if (config.getCalcSpaceMethod(1) == 1) {
                        OrderSonInfo orderSonInfo = sonOrderMap.get(orderInfo.getOrderNum());
                        Long regionId = orderSonInfo != null ? orderSonInfo.getRegionId() : null;
                        int count = addSpaceParkMap.computeIfAbsent(orderInfo.getParkId() + "," + regionId, key -> 0);
                        addSpaceParkMap.put(orderInfo.getParkId() + "," + regionId, count + 1);
                    } else {
                        syncSpaceParkSet.add(orderInfo.getParkId());
                    }
                }
                // 收集要下发的本地订单号
                if (DataCollectionEnum.端网云.getType().equals(config.getDataCollection())) {
                    List<String> downOrderNums = downOrderNumMap.computeIfAbsent(orderInfo.getParkId(), key -> new ArrayList<>());
                    downOrderNums.add(orderInfo.getLocalOrderNum());
                }
            }
        }
        if (!CollectionUtils.isEmpty(updateOrders)) {
            updateBatchById(updateOrders);
        }
        if (!CollectionUtils.isEmpty(updateSonOrders)) {
            int serviceStatus = OrderStatusConstants.EXCEPTION;
            if (OrderOddStatusEnum.车辆盘点.getVal().equals(oddStatus)) {
                serviceStatus = OrderStatusConstants.CANCEL;
            }
            orderSonInfoService.updateServiceStatusByOrderNums(updateSonOrders, serviceStatus);
        }
        if (oddStatus == null || OrderOddStatusEnum.手动出场.getVal().equals(oddStatus)) {
            List<OrderCarInfo> orderCarInfoList = new ArrayList<>();
            List<OrderCarInfo> orderCarInfos = orderCarInfoDao.selectList(Wrappers.lambdaQuery(OrderCarInfo.class)
                    .in(OrderCarInfo::getOrderNum, orderNums)
                    .orderByAsc(OrderCarInfo::getId));
            orderCarInfos.forEach(orderCarInfo -> {
                OrderCarInfo orderCarInfoUpdate = new OrderCarInfo();
                orderCarInfoUpdate.setId(orderCarInfo.getId());
                orderCarInfoUpdate.setExitWay(OrderCarInfoConstant.IN_OUT_WAY_SOFTWARE_MANUAL);
                orderCarInfoUpdate.setExitOperAccount(username);
                orderCarInfoList.add(orderCarInfoUpdate);
            });
            if (!CollectionUtils.isEmpty(orderCarInfos)) {
                orderCarInfoService.updateBatchById(orderCarInfoList);
            }
        }

        if (Objects.isNull(oddStatus)) {
            if (!addSpaceParkMap.isEmpty()) {
                addSpaceParkMap.forEach((parkIdRegionId, v) -> {
                    String[] parkIdRegionIdArr = parkIdRegionId.split(",");
                    Long parkId = Long.valueOf(parkIdRegionIdArr[0]);
                    Long regionId = StrUtil.isBlankOrUndefined(parkIdRegionIdArr[1]) ? null : Long.valueOf(parkIdRegionIdArr[1]);
                    UpdateFreeSpaceService updateFreeSpaceService = updateFreeSpaceServiceFactory.getUpdateFreeSpaceService(parkId);
                    updateFreeSpaceService.addFreeSpace(parkId, regionId, v);
                });
            }
            if (!syncSpaceParkSet.isEmpty()) {
                syncSpaceParkSet.stream().distinct().forEach(parkId -> {
                    UpdateFreeSpaceService updateFreeSpaceService = updateFreeSpaceServiceFactory.getUpdateFreeSpaceService(parkId);
                    updateFreeSpaceService.resetFreeSpace(parkId);
                });
            }
        } else {
            // 如果是车辆盘点 总车位—真正在场的 由于车场盘点都是单车场所以可以随机去订单的某一个车场id
            if (OrderOddStatusEnum.车辆盘点.getVal().equals(oddStatus)) {
                orderInfos.stream()
                        .map(OrderInfo::getParkId)
                        .filter(Objects::nonNull)
                        .findFirst()
                        .ifPresent(parkId -> {
                            UpdateFreeSpaceService updateFreeSpaceService = updateFreeSpaceServiceFactory.getUpdateFreeSpaceService(parkId);
                            updateFreeSpaceService.resetFreeSpace(parkId);
                        });
            }
        }
        // 下发离场信息至端网云
        if (!downOrderNumMap.isEmpty()) {
            if (Objects.nonNull(oddStatus) && OrderOddStatusEnum.车辆盘点.getVal().equals(oddStatus)) {
                for (Map.Entry<Long, List<String>> downEntry : downOrderNumMap.entrySet()) {
                    batchSetExitService.batchSend(downEntry.getKey(), downEntry.getValue(), 1);
                }
            } else {
                for (Map.Entry<Long, List<String>> downEntry : downOrderNumMap.entrySet()) {
                    batchSetExitService.batchSend(downEntry.getKey(), downEntry.getValue(), 0);
                }
            }
        }
        //释放优惠券占位
        List<OrderDiscount> list = orderDiscountService.findDiscountByOrderNum(orderNums, 0);
        if (!CollectionUtils.isEmpty(list)) {
            for (OrderDiscount orderDiscount : list) {
                parkMerchantService.releasePlace(orderDiscount);
            }
        }
        return ObjectResponse.success();
    }

    /**
     * 查询订单数
     *
     * @return
     */
    @Override
    public ObjectResponse<Integer> findTheMaxIdByDate(Long parkId, String startTime, String endTime) {
        Integer orderId = orderInfoDao.findTheMaxIdByDate(parkId, startTime, endTime);
        return ObjectUtils.isEmpty(orderId) ? ObjectResponse.failed("404") : ObjectResponse.success();
    }

    @Override
    public List<OrderInfo> selectListByOrderNums(Collection<String> orderNumList) {
        return orderInfoDao.selectList(Wrappers.lambdaQuery(OrderInfo.class)
                .in(OrderInfo::getOrderNum, orderNumList).orderByAsc(OrderInfo::getId));
    }

    @Override
    @DS_SLAVE
    public ObjectResponse<com.icetech.common.domain.Page<OrderInfo>> getOrderInfoList(Long parkId, BaseQueryRequest request, Integer orderType) {
        return getOrderInfoList(parkId, null, request, orderType);
    }

    @Override
    @DS_SLAVE
    public ObjectResponse<com.icetech.common.domain.Page<OrderInfo>> getOrderInfoList(Long parkId, String plateNum, BaseQueryRequest request, Integer orderType) {
        Page<OrderInfo> orderInfoPage;
        if (orderType == 1) {
            orderInfoPage = orderInfoDao
                    .selectPage(Wrappers.lambdaQuery(OrderInfo.class)
                                    .eq(OrderInfo::getParkId, parkId)
                                    .eq(plateNum != null, OrderInfo::getPlateNum, plateNum)
                                    .in(OrderInfo::getServiceStatus, 1)
                                    .gt(OrderInfo::getEnterTime, request.getStartTime().getTime() / 1000)
                                    .lt(OrderInfo::getEnterTime, request.getEndTime().getTime() / 1000)
                                    .orderByDesc(OrderInfo::getEnterTime)
                            , request.getPageNo()
                            , request.getPageSize());
        } else {
            orderInfoPage = orderInfoDao
                    .selectPage(Wrappers.lambdaQuery(OrderInfo.class)
                                    .eq(OrderInfo::getParkId, parkId)
                                    .eq(plateNum != null, OrderInfo::getPlateNum, plateNum)
                                    .in(OrderInfo::getServiceStatus, 2, 4)
                                    .gt(OrderInfo::getExitTime, request.getStartTime().getTime() / 1000)
                                    .lt(OrderInfo::getExitTime, request.getEndTime().getTime() / 1000)
                                    .orderByDesc(OrderInfo::getExitTime)
                            , request.getPageNo()
                            , request.getPageSize());
        }
        return ObjectResponse.success(com.icetech.common.domain.Page.instance(Math.toIntExact(orderInfoPage.getPages()), orderInfoPage.getTotal(), orderInfoPage.getRecords()));
    }

    @Override
    @DS_SLAVE
    public ObjectResponse<OrderInfo> getOneOrderInfo(Long parkId, String plateNum) {
        OrderInfo orderInfo = selectLimitOne(Wrappers.lambdaQuery(OrderInfo.class)
                .eq(OrderInfo::getParkId, parkId)
                .eq(OrderInfo::getServiceStatus, 1)
                .eq(OrderInfo::getPlateNum, plateNum)
                .orderByDesc(OrderInfo::getEnterTime));
        if (orderInfo == null) {
            return ObjectResponse.failed(CodeConstantsEnum.ERROR_404);
        }
        return ObjectResponse.success(orderInfo);
    }

    @Override
    @DS_SLAVE
    public com.icetech.common.domain.Page<OrderInfo> getOrderPageBy(Long parkId, String plateNum, Integer pageNo, Integer pageSize) {
        IPage<OrderInfo> page = new Page<>();
        page.setCurrent(pageNo);
        page.setSize(pageSize);
        IPage<OrderInfo> result = page(page, Wrappers.lambdaQuery(OrderInfo.class)
                .eq(OrderInfo::getParkId, parkId)
                .eq(OrderInfo::getServiceStatus, 1)
                .likeRight(OrderInfo::getPlateNum, plateNum)
        );
        return com.icetech.common.domain.Page.instance(Math.toIntExact(result.getPages()), result.getTotal(), result.getRecords());
    }

    @Override
    @DS_SLAVE
    @SentinelResource(value = "OrderService.getEnterCars",
            defaultFallback = "defaultFallbackHandle", fallbackClass = {ExceptionUtils.class})
    public ObjectResponse<List<OrderInfo>> getEnterCars(Long parkId, List<String> plateNums) {
        LambdaQueryWrapper<OrderInfo> queryWrapper = Wrappers.lambdaQuery(OrderInfo.class);
        queryWrapper.eq(OrderInfo::getParkId, parkId);
        queryWrapper.eq(OrderInfo::getServiceStatus, 1);
        queryWrapper.and(a -> a.like(OrderInfo::getPlateNum, plateNums.get(0)).or()
                .like(OrderInfo::getPlateNum, plateNums.get(1)).or()
                .like(OrderInfo::getPlateNum, plateNums.get(2)));
        queryWrapper.orderByDesc(OrderInfo::getId);
        queryWrapper.last(" limit 30");
        List<OrderInfo> list = list(queryWrapper);
        if (CollectionUtils.isEmpty(list)) {
            return ObjectResponse.failed(CodeConstantsEnum.ERROR_404);
        }
        return ObjectResponse.success(list);
    }

    @Override
    @DS_SLAVE
    public ObjectResponse<Integer> getCountBy(Long parkId, String createTime) {
        return ObjectResponse.success(count(Wrappers.lambdaQuery(OrderInfo.class)
                .eq(OrderInfo::getParkId, parkId)
                .gt(OrderInfo::getCreateTime, createTime)));
    }

    @Override
    @DS_SLAVE
    public ObjectResponse<Integer> getSurplusCount(Long parkId, String createTime) {
        return ObjectResponse.success(orderInfoDao.selectSurplusCount(parkId, createTime));
    }

    @Override
    @DS_SLAVE
    public ObjectResponse<List<OrderVO>> getSurplusList(Long parkId, String createTime) {
        List<OrderVO> orders = orderInfoDao.selectSurplusList(parkId, createTime);
        return CollectionUtils.isEmpty(orders) ? ObjectResponse.failed(CodeConstantsEnum.ERROR_404) : ObjectResponse.success(orders);
    }


    @Override
    @DS_SLAVE
    public ObjectResponse<Integer> getLiveCountBy(Long parkId, String crateTime) {
        return ObjectResponse.success(count((Wrappers.lambdaQuery(OrderInfo.class)
                .eq(OrderInfo::getServiceStatus, 1))
                .eq(OrderInfo::getParkId, parkId)
                .lt(OrderInfo::getCreateTime, crateTime)));
    }

    @Override
    @DS_SLAVE
    public ObjectResponse<InParkNumInfoResponse> getInParkNum(Long parkId) {
        InParkNumInfoResponse inParkNumInfoResponse = new InParkNumInfoResponse();
        Integer inParkNum = orderInfoDao.countEnterCar(parkId);
        FlowRequest flowRequest = new FlowRequest();
        flowRequest.setParkIdList(parkId.toString());
        flowRequest.setStartTime(DateUtil.beginOfDay(DateUtil.date()).getTime() / 1000);
        long totalParkNum = orderInfoDao.enterInparkCount(flowRequest);
        ObjectResponse<ParkFreespace> spaceByPark = parkFreeSpaceService.getSpaceByPark(parkId);
        ParkFreespace data = spaceByPark.getData();
        Integer freeSpace = data == null ? 0 : data.getFreeSpace();
        inParkNumInfoResponse.setParkSpaceNum(freeSpace);
        inParkNumInfoResponse.setInParkNum(inParkNum);
        inParkNumInfoResponse.setTotalParkNum(Math.toIntExact(totalParkNum));
        return ObjectResponse.success(inParkNumInfoResponse);
    }

    @Override
    public ObjectResponse<OrderAfterPay> getOrderAfterPayByTradeNo(String tradeNo, Integer status) {
        OrderAfterPay orderAfterPay = orderAfterPayDao.selectOrderAfterPayByTradeNo(tradeNo, status);
        return orderAfterPay == null ? ObjectResponse.failed(CodeConstants.ERROR_404) : ObjectResponse.success(orderAfterPay);
    }

    @Override
    public ObjectResponse<Integer> getExitCarNums(Long startTime, Long endTime) {
        return ObjectResponse.success(count(Wrappers.lambdaQuery(OrderInfo.class)
                .ge(OrderInfo::getExitTime, startTime)
                .lt(OrderInfo::getExitTime, endTime)));
    }

    @Override
    public ObjectResponse<List<OrderInfo>> selectExitOrderBy(Long parkId, Long startTime, Long endTime) {
        List<OrderInfo> orderInfos = orderInfoDao.selectExitOrderBy(parkId, startTime, endTime);
        if (CollectionUtils.isEmpty(orderInfos)) {
            return ObjectResponse.failed(CodeConstants.ERROR_404);
        }
        return ObjectResponse.success(orderInfos);
    }

    @Override
    public ObjectResponse<Boolean> updateOrderType(List<String> orderNums, Integer type) {
        return ObjectResponse.success(update(Wrappers.lambdaUpdate(OrderInfo.class)
                .set(OrderInfo::getType, type)
                .in(OrderInfo::getOrderNum, orderNums)));
    }


    @Override
    public List<String> getLiveCarPlateNums(Long parkId, Integer limitNum) {
        List<String> plateNums = orderInfoDao.selectLivePlateNum(parkId, limitNum);
        if (CollectionUtils.isEmpty(plateNums)) {
            return Collections.emptyList();
        }
        return plateNums.stream()
                .filter(plateNum -> plateNum != null && !"未识别".equals(plateNum))
                .collect(Collectors.toList());
    }

    /**
     * 手动离场
     *
     * @param statusParam 离场参数
     * @return obj
     */
    @Override
    public ObjectResponse<Object> orderExit(OrderStatusParam statusParam) {
        OrderInfo info = orderInfoDao.selectByOrderNum(statusParam.getOrderNum());
        if (info == null) {
            return ObjectResponse.failed("未获取到订单信息");
        }
        if (info.getServiceStatus() != 1) {
            return ObjectResponse.failed("订单状态不是在场状态，离场失败！");
        }
        BigDecimal paidPrice = BigDecimal.ZERO;
        BigDecimal totalPrice = BigDecimal.ZERO;
        List<OrderPay> pays = orderPayDao.selectByOrderNum(statusParam.getOrderNum());
        if (CollectionUtils.isNotEmpty(pays)) {
            totalPrice = pays.stream().map(pay -> strToBig(pay.getTotalPrice())).reduce(BigDecimal.ZERO, BigDecimal::add);
            paidPrice = pays.stream().map(pay -> strToBig(pay.getPaidPrice())).reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        info.setServiceStatus(2);
        info.setExitTime(statusParam.getExitTime().getTime() / 1000);
        info.setErrorCauses(statusParam.getErrorCauses());
        info.setPaidPrice(paidPrice.toString());
        info.setDiscountPrice("0.00");
        info.setTotalPrice(totalPrice.toString());
        long newVal = statusParam.getExitTime().getTime() / 1000;
        orderInfoDao.updateByOrderNum(info);
        OrderCarInfo carInfo = orderCarInfoDao.selectByOrderNum(statusParam.getOrderNum());
        carInfo.setExitWay(4);
        carInfo.setExitOperAccount(statusParam.getUserName());
        orderCarInfoDao.updateByOrderNum(carInfo);
        OrderModifyRecord record = new OrderModifyRecord();
        record.setAction(1);
        record.setCorrectType(6);
        record.setOrderNum(info.getOrderNum());
        record.setParkId(info.getParkId());
        record.setBeforeModify(null);
        record.setAfterModify(String.valueOf(newVal));
        record.setAfterCardesc(statusParam.getErrorCauses());
        record.setModifyTime(DateTools.getFormat(new Date()));
        record.setOperAccount(statusParam.getUserName());
        record.setCreateTime(DateTools.getFormat(new Date()));
        orderModifyRecordDao.insert(record);
        ParkConfig config = parkService.getParkConfig(info.getParkId()).getData();
        if (DataCollectionEnum.端网云.getType().equals(config.getDataCollection())) {
            SendRequest request = new SendRequest();
            request.setParkId(info.getParkId());
            request.setServiceId(record.getId());
            modifyCarService.send(request);
            batchSetExitService.batchSend(info.getParkId(), Collections.singletonList(info.getLocalOrderNum()), 1);
        }
        return ObjectResponse.success();
    }

    /**
     * 入场修改
     *
     * @param statusParam 离场参数
     * @return obj
     */
    @Override
    public ObjectResponse<Object> modifyEnter(OrderStatusParam statusParam) {
        OrderInfo info = orderInfoDao.selectByOrderNum(statusParam.getOrderNum());
        if (info == null) {
            return ObjectResponse.failed("未获取到订单信息");
        }
        if (info.getServiceStatus() != 1) {
            return ObjectResponse.failed("订单状态不是在场状态，修改失败！");
        }
        long oldEnterTime = info.getEnterTime();
        long newEnterTime = statusParam.getEnterTime().getTime() / 1000;

        String oldPlateNum = info.getPlateNum();
        String newPlateNUm = statusParam.getPlateNum();

        int oldCarType = info.getCarType();
        int newCarType = statusParam.getCarType();

        ParkConfig config = parkService.getParkConfig(info.getParkId()).getData();
        info.setEnterTime(newEnterTime);
        info.setPlateNum(newPlateNUm);
        info.setCarType(newCarType);
        info.setOperAccount(statusParam.getUserName());
        orderInfoDao.updateByOrderNum(info);

        List<OrderModifyRecord> records = new ArrayList<>();
        if (oldEnterTime != newEnterTime) {
            OrderModifyRecord record = this.saveOrderRecord(info, String.valueOf(oldEnterTime),
                    String.valueOf(newEnterTime), 5, statusParam.getUserName());
            records.add(record);
        }
        if (!oldPlateNum.equals(newPlateNUm)) {
            OrderModifyRecord record = this.saveOrderRecord(info, oldPlateNum, newPlateNUm, 1,
                    statusParam.getUserName());
            records.add(record);
        }
        if (oldCarType != newCarType) {
            OrderModifyRecord record = this.saveOrderRecord(info, String.valueOf(oldCarType),
                    String.valueOf(newCarType),2, statusParam.getUserName());
            records.add(record);
        }
        if (DataCollectionEnum.端网云.getType().equals(config.getDataCollection())) {
            records.forEach(record -> {
                SendRequest request = new SendRequest();
                request.setParkId(info.getParkId());
                request.setServiceId(record.getId());
                modifyCarService.send(request);
            });
        }
        return ObjectResponse.success();
    }

    private OrderModifyRecord saveOrderRecord(OrderInfo info, String oldVal, String newVal, Integer correctType, String userName) {
        OrderModifyRecord record = new OrderModifyRecord();
        record.setAction(1);
        record.setCorrectType(correctType);
        record.setOrderNum(info.getOrderNum());
        record.setParkId(info.getParkId());
        record.setBeforeModify(String.valueOf(oldVal));
        record.setAfterModify(String.valueOf(newVal));
        record.setParkId(info.getParkId());
        record.setModifyTime(DateTools.getFormat(new Date()));
        record.setOperAccount(userName);
        record.setCreateTime(DateTools.getFormat(new Date()));
        orderModifyRecordDao.insert(record);
        return record;
    }

    public BigDecimal strToBig(String value) {
        return value != null ? new BigDecimal(value) : BigDecimal.ZERO;
    }
}
