package com.icetech.park.service.order.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.csp.sentinel.annotation.SentinelResource;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.google.common.collect.Lists;
import com.icetech.basics.dao.park.ParkDao;
import com.icetech.basics.domain.entity.device.ParkDevice;
import com.icetech.basics.domain.entity.park.ParkConfig;
import com.icetech.basics.domain.entity.park.ParkInoutdevice;
import com.icetech.basics.sentinel.ExceptionUtils;
import com.icetech.basics.utils.ForEachUtils;
import com.icetech.city.road.api.NotifyPayApi;
import com.icetech.city.road.app.undefined.dto.PayToItem;
import com.icetech.city.road.domain.constant.PayAisleConstant;
import com.icetech.city.road.domain.constant.PayChannelConstant;
import com.icetech.city.road.domain.constant.PayWayConstant;
import com.icetech.cloudcenter.api.ManageService;
import com.icetech.cloudcenter.api.discount.MerchantUserService;
import com.icetech.cloudcenter.api.order.OrderPayService;
import com.icetech.cloudcenter.api.park.ParkDeviceService;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.cloudcenter.domain.PageResult;
import com.icetech.cloudcenter.domain.charge.dto.OrderSumFeeDto;
import com.icetech.cloudcenter.domain.constants.RedisConstants;
import com.icetech.cloudcenter.domain.enumeration.DataCollectionEnum;
import com.icetech.cloudcenter.domain.enumeration.DownServiceEnum;
import com.icetech.cloudcenter.domain.enumeration.SwitchTypeEnum;
import com.icetech.cloudcenter.domain.enumeration.TriggerTypeEnum;
import com.icetech.cloudcenter.domain.order.OrderPayWayDto;
import com.icetech.cloudcenter.domain.order.SumOrderDatePayDto;
import com.icetech.cloudcenter.domain.order.SumOrderPayDto;
import com.icetech.cloudcenter.domain.order.query.OrderPayCondition;
import com.icetech.cloudcenter.domain.order.query.OrderPayQuery;
import com.icetech.cloudcenter.domain.pay.MiniOrdersDTO;
import com.icetech.cloudcenter.domain.pay.PayTo;
import com.icetech.cloudcenter.domain.request.ApplyNoPlateEnterRequest;
import com.icetech.cloudcenter.domain.request.BaseQueryRequest;
import com.icetech.cloudcenter.domain.request.BossOrderPayRequest;
import com.icetech.cloudcenter.domain.request.CarEnterRequest;
import com.icetech.cloudcenter.domain.request.FlowRequest;
import com.icetech.cloudcenter.domain.request.InvoiceQueryRequest;
import com.icetech.cloudcenter.domain.request.InvoiceRequest;
import com.icetech.cloudcenter.domain.request.OrderPayQueryRequest;
import com.icetech.cloudcenter.domain.request.ParkIncomeTopRequest;
import com.icetech.cloudcenter.domain.request.PaywayTopRequest;
import com.icetech.cloudcenter.domain.request.SumOrderPayRequest;
import com.icetech.cloudcenter.domain.request.p2c.HintRequest;
import com.icetech.cloudcenter.domain.response.IncomeCountDto;
import com.icetech.cloudcenter.domain.response.IncomeCountHourDto;
import com.icetech.cloudcenter.domain.response.IncomeDetailDto;
import com.icetech.cloudcenter.domain.response.InvoiceQueryResponse;
import com.icetech.cloudcenter.domain.response.InvoiceResponse;
import com.icetech.cloudcenter.domain.response.OrderPayDto;
import com.icetech.cloudcenter.domain.response.ParkIncomeTopDto;
import com.icetech.cloudcenter.domain.response.PayCashNotPay;
import com.icetech.cloudcenter.domain.response.PayWayCountDto;
import com.icetech.cloudcenter.domain.response.PaywayTopDto;
import com.icetech.cloudcenter.domain.response.QueryOrderFeeResponse;
import com.icetech.cloudcenter.domain.response.StoreCardCountDto;
import com.icetech.cloudcenter.domain.response.p2c.CarEnexResponse;
import com.icetech.cloudcenter.domain.vo.NotPayDetailVo;
import com.icetech.common.constants.*;
import com.icetech.common.domain.AsyncNotifyInterface;
import com.icetech.common.domain.SendRequest;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.domain.response.PageQuery;
import com.icetech.common.thread.ThreadUtils;
import com.icetech.common.utils.CodeTools;
import com.icetech.common.utils.DateTools;
import com.icetech.common.utils.NumberUtils;
import com.icetech.common.utils.StringUtils;
import com.icetech.db.mybatis.base.service.impl.BaseServiceImpl;
import com.icetech.fee.dao.merchant.MerchantDiscountDao;
import com.icetech.fee.dao.merchant.ParkMerchantDao;
import com.icetech.fee.dao.storecard.StoreCardDao;
import com.icetech.fee.domain.entity.merchant.MerchantDiscount;
import com.icetech.fee.domain.entity.merchant.ParkMerchant;
import com.icetech.order.dao.OrderCarInfoDao;
import com.icetech.order.dao.OrderDiscountDao;
import com.icetech.order.dao.OrderInfoDao;
import com.icetech.order.dao.OrderPayDao;
import com.icetech.order.domain.entity.OrderCarInfo;
import com.icetech.order.domain.entity.OrderDiscount;
import com.icetech.order.domain.entity.OrderInfo;
import com.icetech.order.domain.entity.OrderNotpay;
import com.icetech.order.domain.entity.OrderPay;
import com.icetech.order.domain.entity.OrderPayDetail;
import com.icetech.order.service.OrderNotpayService;
import com.icetech.order.service.impl.OrderPayDetailServiceImpl;
import com.icetech.oss.OssService;
import com.icetech.park.dao.invoice.InvoiceMerchantParkDao;
import com.icetech.park.domain.dto.InvoiceParksDto;
import com.icetech.park.domain.entity.invoice.InvoiceMerchantPark;
import com.icetech.park.domain.entity.park.Park;
import com.icetech.park.handle.CacheHandle;
import com.icetech.park.handle.DeviceDownServiceFactory;
import com.icetech.park.service.down.p2c.impl.P2cRemoteSwitchServiceImpl;
import com.icetech.park.service.handle.showsay.DownShowSayHandle;
import com.icetech.park.service.impl.DownSendServiceImpl;
import com.icetech.park.service.report.p2c.impl.enter.CarEnterHandler;
import com.icetech.partner.api.TeldService;
import com.icetech.redis.lock.RedissonDistributedLock;
import com.icetech.report.domain.vo.ParkPayReportVo;
import com.icetech.third.anno.DS_SLAVE;
import com.icetech.third.service.third.MqPushService;
import com.icetech.third.utils.DateRangeUtils;
import com.icetech.third.utils.RedisUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;

import static com.icetech.third.utils.DateRangeUtils.getDayTime;
import static com.icetech.third.utils.DateRangeUtils.getDaysOfMonth;
import static com.icetech.third.utils.DateRangeUtils.getHour;
import static com.icetech.third.utils.DateRangeUtils.getMonths;
import static com.icetech.third.utils.DateRangeUtils.getTodayTime;
import static com.icetech.third.utils.DateRangeUtils.getYesterdayHourTime;

@Slf4j
@Service("orderPayService")
public class OrderPayServiceImpl extends BaseServiceImpl<OrderPayDao, OrderPay> implements OrderPayService {
    @Autowired
    private OrderPayDao orderPayDao;
    @Autowired
    private OrderInfoDao orderInfoDao;
    @Autowired
    private OrderDiscountDao orderDiscountDao;
    @Autowired
    private MerchantDiscountDao merchantDiscountDao;
    @Autowired
    private MerchantUserService merchantUserService;
    @Autowired
    private ParkService parkService;
    @Autowired
    private ParkDao parkDao;
    @Resource
    private OrderCarInfoDao orderCarInfoDao;
    @Autowired
    private OssService ossService;
    @Autowired
    private InvoiceMerchantParkDao invoiceMerchantParkDao;
    @Autowired
    private ParkMerchantDao parkMerchantDao;
    @Autowired
    private StoreCardDao storeCardDao;
    @Resource
    private MqPushService pushService;
    @Resource
    private TeldService teldService;
    @Autowired
    private OrderPayDetailServiceImpl orderPayDetailService;
    @Resource
    private CacheHandle cacheHandle;
    @Autowired
    private ThreadPoolExecutor asyncExecutor;
    @Autowired
    private RedisUtils redisUtils;
    @Autowired
    private RedissonDistributedLock redissonDistributedLock;
    @Autowired
    private OrderNotpayService orderNotpayService;
    @Autowired
    private DownSendServiceImpl downSendService;
    @Autowired
    private ThreadPoolExecutor asyncMethodExecutor;
    @Autowired
    private DeviceDownServiceFactory deviceDownServiceFactory;
    @Autowired
    private CarEnterHandler carEnterHandler;
    @Autowired
    private DownShowSayHandle downShowSayHandle;
    @Autowired
    private ParkDeviceService parkDeviceService;
    @Autowired
    private P2cRemoteSwitchServiceImpl remoteSwitchService;
    @Autowired
    private ManageService manageService;
    @Autowired
    private NotifyPayApi roadNotifyPayApi;

    @Override
    public ObjectResponse selectOrderPayByOnum(String ordeNum) {
        OrderPay orderPay = orderPayDao.selectByOrdernum(ordeNum, 5);
        if (orderPay != null) {
            return ObjectResponse.success(orderPay);
        } else {
            return ObjectResponse.failed(CodeConstants.ERROR_404);
        }
    }

    @Override
    public ObjectResponse<List<OrderPay>> selectByOrderNum(String orderNum) {
        List<OrderPay> payList = orderPayDao.selectByOrderNum(orderNum);
        if(!CollectionUtils.isEmpty(payList)){
            return ObjectResponse.success(payList);
        }else{
            return ObjectResponse.failed(CodeConstants.ERROR_404);
        }
    }

    @Override
    public ObjectResponse<Long> addOrderPay(OrderPay orderPay) {
        String orderNum = orderPay.getOrderNum();
        if (StringUtils.isBlank(orderNum)) {
            return ObjectResponse.failed(CodeConstants.ERROR_400);
        }
        if (orderPay.getParkId() == null) {
            OrderInfo orderInfo = new OrderInfo();
            orderInfo.setParkId(orderPay.getParkId());
            orderInfo.setOrderNum(orderNum);
            orderInfo = orderInfoDao.selectLimitOneOrderByEnterDesc(orderInfo);
            orderPay.setParkId(orderInfo.getParkId());
        }
        if (CollectionUtils.isNotEmpty(orderPay.getOrderPayDetails())) {
            orderPay.setIsSonOrderpay(1);
            orderPayDetailService.saveBatch(orderPay.getOrderPayDetails());
        }
        orderPayDao.insert(orderPay);
        if (orderPay.getId() == null) {
            return ObjectResponse.failed(CodeConstants.ERROR);
        }
        if (orderPay.getPayStatus() != null && orderPay.getPayStatus() == PayStatusConstants.PAID) {
            lockAfterPay(orderPay.getParkId(), orderNum, orderPay.getTradeNo());
            pushService.pushOrderPay(orderPay);
            pushService.pushOrderPaySync(orderPay);
        }
        return ObjectResponse.success(orderPay.getId());
    }

    private void lockAfterPay(Long parkId, String orderNum, String tradeNo) {
        ObjectResponse<ParkConfig> objectResponse = parkService.getParkConfig(parkId);
        if (ObjectResponse.isSuccess(objectResponse)) {
            long afterPayFreeTime = NumberUtils.toPrimitive(objectResponse.getData().getIsfreeAfterpay(15));
            if (afterPayFreeTime > 15) {
                afterPayFreeTime = 15;
            } else if (afterPayFreeTime < 3) {
                afterPayFreeTime = 3;
            }
            redisUtils.set(RedisConstants.PAY_AFTER_LOCK_KEY + orderNum, tradeNo,
                    afterPayFreeTime - 2, TimeUnit.MINUTES);
        }
    }

    @Override
    public ObjectResponse<OrderPay> findOne(OrderPay orderPay) {
        OrderPay orderPay_res = orderPayDao.selectLimitOne(orderPay);
        if (orderPay_res != null) {
            return ObjectResponse.success(orderPay_res);
        } else {
            return ObjectResponse.failed(CodeConstants.ERROR_404);
        }
    }

    @Override
    public ObjectResponse<Integer> modifyOrderPay(OrderPay orderPay) {
        int n = orderPayDao.updateByEntity(orderPay);
        if (orderPay.getPayStatus() != null && NumberUtils.toPrimitive(orderPay.getIsSonOrderpay()) == 1) {
            OrderPayDetail updateDetail = new OrderPayDetail();
            updateDetail.setPayStatus(orderPay.getPayStatus());
            OrderPayDetail detailParam = new OrderPayDetail();
            detailParam.setParkId(orderPay.getParkId());
            detailParam.setTradeNo(orderPay.getTradeNo());
            orderPayDetailService.update(updateDetail, Wrappers.lambdaQuery(detailParam));
        }
        if (n > 0) {
            log.info("[交易记录服务] 更新交易记录成功，参数：{}", orderPay);
            return ObjectResponse.success(n);
        } else {
            log.info("[交易记录服务] 更新交易记录影响行数：{}行，参数：{}", n, orderPay);
            return ObjectResponse.failed(CodeConstants.ERROR_402);
        }
    }

    @Override
    @Transactional
    public ObjectResponse<Integer> finishPayAndDiscount(OrderPay orderPay) {
        String tradeNo = orderPay.getTradeNo();
        String orderNum = orderPay.getOrderNum();
        if (tradeNo == null || orderNum == null) {
            log.info("[完成支付] 参数缺失，tradeNo:{}, orderNum:{}", tradeNo, orderNum);
            return ObjectResponse.failed(CodeConstants.ERROR_400);
        }
        orderPay.setTradeNo(tradeNo);
        orderPay.setOrderNum(orderNum);
        orderPay.setPayStatus(PayStatusConstants.PAID);
        ObjectResponse<Integer> result = updateOrderPayWithPush(orderPay);
        log.info("[完成支付] 更新交易记录状态成功，影响行数：{}行，参数：{}", result.getData(), orderPay);
        return result;
    }

    @Override
    public ObjectResponse<Integer> updateOrderPayWithPush(OrderPay orderPay) {
        ObjectResponse<Integer> result = modifyOrderPay(orderPay);
        if (ObjectResponse.isSuccess(result) && orderPay.getPayStatus() != null
                && orderPay.getId() != null && orderPay.getPayStatus() == PayStatusConstants.PAID) {
            lockAfterPay(orderPay.getParkId(), orderPay.getOrderNum(), orderPay.getTradeNo());
            pushService.pushOrderPay(orderPay);
            pushService.pushOrderPaySync(orderPay);
        }

        return result;
    }

    @Override
    public ObjectResponse<Integer> finishPayAndDiscount(OrderPay orderPay, String parkCode, String channelCode) {
        ObjectResponse<Integer> objectResponse = finishPayAndDiscount(orderPay);
        if (parkCode != null && channelCode != null) {
            QueryOrderFeeResponse channelFee = cacheHandle.getChannelFee(parkCode, channelCode);
            if (channelFee != null) {
                String orderNum = channelFee.getOrderNum();
                if (orderNum != null && orderNum.equals(orderPay.getOrderNum())) {
                    cacheHandle.removeChannelFee(parkCode, channelCode);
                }
            }
        }
        return objectResponse;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public ObjectResponse<Void> finishPayNotPay(MiniOrdersDTO dto,String bankOrderId) {
        Map<String, String> tradeNoMap = dto.getTradeNoMap();
        List<String> tradeNos = tradeNoMap.values().stream().filter(Objects::nonNull).collect(Collectors.toList());
        log.info("[欠费追缴补缴订单] orderNums: {},tradeNos:{}",dto.getOrderNums(), tradeNos);
        List<OrderPay> orderPays = orderPayDao.selectList(Wrappers.lambdaQuery(OrderPay.class)
                .in(OrderPay::getTradeNo, tradeNos)
                .eq(OrderPay::getPayStatus, PayStatusConstants.PAYING));
        if (CollectionUtils.isEmpty(orderPays)) {
            log.info("[欠费追缴补缴订单] 交易流水号不存在, [{}]", tradeNos);
            return ObjectResponse.success();
        }
        Long current = DateUtil.currentSeconds();
        orderPays.forEach(orderPay -> {
            orderPay.setPayTime(current);
            orderPay.setThirdTradeNo(dto.getOutTradeNo());
            orderPay.setPayStatus(2);
            orderPay.setBankOrderId(bankOrderId);
            finishPayAndDiscount(orderPay);
        });
        List<OrderNotpay> notPays = orderNotpayService.getListByOrderNums(dto.getOrderNums());
        if (CollectionUtils.isNotEmpty(notPays)) {
            List<NotPayDetailVo> notPayDetailVos = notPays.stream().map(p -> {
                NotPayDetailVo notPayDetailVo = new NotPayDetailVo();
                BeanUtils.copyProperties(p, notPayDetailVo);
                notPayDetailVo.setUnPayPrice(p.getTotalPrice().toString());
                return notPayDetailVo;
            }).collect(Collectors.toList());
            //更新欠费追缴记录
            orderNotpayService.updatePaidByOrderNums(notPayDetailVos, null,null);
        }
        return ObjectResponse.success();
    }

    @Override
    public ObjectResponse<Void> finishPayNotPay(PayTo payTo) {
        log.info("[欠费追缴补缴订单] payTo {}",payTo);
        List<NotPayDetailVo> notPayDetails = payTo.getNotPayDetails();
        List<OrderPay> orderPays = orderPayDao.selectListByTradeNos(notPayDetails.stream().filter(NotPayDetailVo::isParkOrder).map(NotPayDetailVo::getTradeNo).collect(Collectors.toList()));
        if (CollectionUtils.isEmpty(orderPays)) {
            log.info("[欠费追缴补缴订单] 交易流水号不存在, payTo[{}]", payTo);
            return ObjectResponse.success();
        }
        if (Integer.valueOf(2).equals(orderPays.get(0).getPayStatus())) {
            log.info("[欠费追缴补缴订单] 支付结果重复通知[{}]", orderPays.get(0).getTradeNo());
            return ObjectResponse.success();
        }
        //更新欠费追缴记录
        orderNotpayService.updatePaidByOrderNums(notPayDetails,payTo.getChannelId(),null);
        Long current = DateUtil.currentSeconds();
        orderPays.forEach(orderPay -> {
            orderPay.setPayTime(current);
            orderPay.setThirdTradeNo(payTo.getOutTradeNo());
            orderPay.setBankOrderId(payTo.getBankOrderId());
            finishPayAndDiscount(orderPay);
        });
        ObjectResponse<ParkConfig> configObjectResponse = parkService.getParkConfig(payTo.getParkCode());
        ParkConfig parkConfig = configObjectResponse.getData();
        if (DataCollectionEnum.端网云.getType().equals(parkConfig.getDataCollection())) {
            //下发缴费
            orderPays.forEach(orderPay -> {
                SendRequest sendRequest = new SendRequest();
                sendRequest.setParkId(orderPay.getParkId());
                sendRequest.setServiceId(orderPay.getId());
                sendRequest.setServiceType(DownServiceEnum.预缴费.getServiceType());
                sendRequest.setTopic(AsyncNotifyInterface.getTopic());
                downSendService.send(sendRequest);
            });
        } else {
            if (StringUtils.isNotBlank(payTo.getChannelId())) {
                asyncMethodExecutor.execute(ThreadUtils.wrapTrace(() -> {
                    ParkInoutdevice parkInoutdevice = parkService.getChannelByCodeAndParkId(parkConfig.getParkId(), payTo.getChannelId());
                    if (Integer.valueOf(2).equals(parkInoutdevice.getInandoutType())) {
                        return;
                    }
                    if (payTo.getPlateNum().startsWith("临")) {
                        //无牌车申请入场
                        ApplyNoPlateEnterRequest applyNoPlateEnterRequest = new ApplyNoPlateEnterRequest();
                        applyNoPlateEnterRequest.setParkCode(payTo.getParkCode());
                        applyNoPlateEnterRequest.setChannelCode(payTo.getChannelId());
                        applyNoPlateEnterRequest.setPlateNum(payTo.getPlateNum());
                        applyNoPlateEnterRequest.setUnionId(payTo.getUnionId());
                        applyNoPlateEnterRequest.setOrderNum(payTo.getOrderNum());
                        applyNoPlateEnterRequest.setParkId(parkConfig.getParkId());
                        manageService.applyNoPlateEnter(applyNoPlateEnterRequest);
                        return;
                    }
                    CarEnterRequest entrance = cacheHandle.getEntrance(payTo.getParkCode(), payTo.getChannelId());
                    if (entrance != null && !entrance.getPlateNum().equals(payTo.getPlateNum())) {
                        log.warn("[入口补缴] 当前车辆已不在该通道[{}], 原车牌号[{}], 当前通道车牌[{}]",
                                payTo.getChannelId(), payTo.getPlateNum(), entrance.getPlateNum());
                        return;
                    }
                    ObjectResponse<List<ParkDevice>> listObjectResponse = parkDeviceService.getDeviceByChannel(parkConfig.getParkId(), payTo.getChannelId(), 1);
                    if (!ObjectResponse.isSuccess(listObjectResponse)) {
                        log.warn("[入口补缴] 当前通道[{}]没有识别相机", payTo.getChannelId());
                        return;
                    }
                    ParkDevice parkDevice = listObjectResponse.getData().get(0);
                    if (entrance == null) {
                        downShowSayHandle.fixShowSayExec(parkConfig.getParkId(), payTo.getParkCode(),
                                parkDevice.getChannelId().longValue(), payTo.getPlateNum(), "停留时间过长/请重新识别", "请重新识别",
                                null, parkDevice.getSerialNumber(), false);
                    } else {
                        //防止其他方式识别
                        entrance.setTriggerType(TriggerTypeEnum.视频.getVal());
                        entrance.setEnterTime(DateTools.unixTimestamp());
                        CarEnexResponse carEnexResponse = carEnterHandler.execute(entrance, parkDevice.getSerialNumber(), parkDevice.getProtocolVer());
                        HintRequest hintRequest = new HintRequest();
                        BeanUtils.copyProperties(carEnexResponse, hintRequest);
                        if (Integer.valueOf(1).equals(carEnexResponse.getOpenFlag())) {
                            deviceDownServiceFactory.buildRemoteOperaService(payTo.getParkCode()).open(
                                    SwitchTypeEnum.开闸.getType(), parkConfig.getParkId(), payTo.getParkCode(),
                                    parkDevice.getSerialNumber(), payTo.getPlateNum());
                        }
                        deviceDownServiceFactory.buildExHintService(payTo.getParkCode()).showAndSay(
                                parkConfig.getParkId(), payTo.getParkCode(), parkDevice.getSerialNumber(), hintRequest);
                    }
                }));
            }
        }

        List<NotPayDetailVo> roadNotPayDetails = notPayDetails.stream().filter(NotPayDetailVo::isRoadOrder).collect(Collectors.toList());
        OrderPay currentPay = null;
        if (CollectionUtils.isNotEmpty(roadNotPayDetails)) {
            currentPay = lambdaQuery().eq(OrderPay::getOrderNum, payTo.getOrderNum()).eq(OrderPay::getTradeNo, payTo.getTradeNo()).one();
        }
        if (currentPay == null) {
            log.warn("欠费追缴路内订单处理|无法找到场库主订单支付记录|{}|{}", payTo.getOrderNum(), payTo.getTradeNo());
        } else {
            BigDecimal roadTotalPaid = roadNotPayDetails.stream().map(detail -> new BigDecimal(detail.getUnPayPrice())).reduce(BigDecimal.ZERO, BigDecimal::add);
            com.icetech.city.road.app.undefined.dto.PayTo roadPay = new com.icetech.city.road.app.undefined.dto.PayTo();
            roadPay.setOutTradeNo(payTo.getOutTradeNo());
            roadPay.setOrderTime(currentPay.getOrderTime());

            roadPay.setPayWay(convertRoadPayWay(currentPay.getPayWay()));
            roadPay.setPayChannel(convertRoadPayChannel(currentPay.getPayChannel()));
            roadPay.setPayAisle(convertRoadPayAlias(currentPay.getPayAisle()));
            roadPay.setPaidPrice(roadTotalPaid);
            roadPay.setBankOrderId(currentPay.getBankOrderId());
            List<PayToItem> roadPayItems = roadNotPayDetails.stream().map(detail -> {
                PayToItem item = new PayToItem();
                item.setOrderNum(detail.getOrderNum());
                item.setTradeNo(payTo.getTradeNo());
                item.setTotalPrice(new BigDecimal(detail.getUnPayPrice()));
                item.setDiscountPrice(BigDecimal.ZERO);
                item.setPaidPrice(new BigDecimal(detail.getUnPayPrice()));
                return item;
            }).collect(Collectors.toList());
            roadPay.setPayToItems(roadPayItems);
            com.icetech.city.road.component.bean.ObjectResponse<Void> roadResp = roadNotifyPayApi.notifyPayTo(roadPay);
            log.info("欠费追缴路内通知处理结果|{}", roadResp);
        }
        return ObjectResponse.success();
    }


    @Override
    public ObjectResponse<Void> finishPayNotPay(PayCashNotPay payCashNotPay, Integer payChannel) {
        log.info("[欠费追缴补缴订单] payCashNotPay {}",payCashNotPay);
        //修改欠费记录状态
        List<OrderPay> orderPays = Lists.newArrayList();
        if (Objects.nonNull(payCashNotPay)){
            // 增加订单的orderPay
            List<NotPayDetailVo> vos = Lists.newArrayList();
            for (String orderNum : payCashNotPay.getOrderNums()) {
                OrderNotpay orderNotpay = orderNotpayService.getOrderNotpayByOrderNum(orderNum);
                //增加欠费追缴 orderPay
                if (Objects.nonNull(orderNotpay)){
                    OrderPay orderPay = new OrderPay();
                    orderPay.setParkId(orderNotpay.getParkId());
                    orderPay.setPayStatus(PayStatusConstants.PAID);
                    orderPay.setOrderNum(orderNotpay.getOrderNum());
                    orderPay.setChannelId(payCashNotPay.getChannelCode());
                    orderPay.setPayWay(payCashNotPay.getPayWay());
                    orderPay.setTradeNo(CodeTools.GenerateTradeNo());
                    orderPay.setLastPayTime(orderNotpay.getLastPayTime());
                    orderPay.setTotalPrice(orderNotpay.getTotalPrice().setScale(2, RoundingMode.HALF_UP).toString());
                    orderPay.setDiscountPrice(orderNotpay.getDiscountPrice().setScale(2, RoundingMode.HALF_UP).toString());
                    orderPay.setPaidPrice(orderNotpay.getTotalPrice().subtract(orderNotpay.getDiscountPrice()).setScale(2, RoundingMode.HALF_UP).toString());
                    orderPay.setOrderTime(DateUtil.currentSeconds());
                    orderPay.setPayTime(DateUtil.currentSeconds());
                    orderPay.setPayChannel(payChannel);
                    orderPay.setUserAccount(payCashNotPay.getAccountName());
                    orderPay.setPayType(1);
                    orderPay.setPayTerminal(payCashNotPay.getChannelCode());
                    addOrderPay(orderPay);
                    orderPays.add(orderPay);
                    vos.add(NotPayDetailVo.builder()
                            .orderNum(orderPay.getOrderNum())
                            .unPayPrice(orderPay.getPaidPrice())
                            .build());
                }
            }
            //更新欠费追缴记录
            orderNotpayService.updatePaidByOrderNums(vos,payCashNotPay.getChannelCode(),payCashNotPay.getAccountName());
            orderPays.forEach(orderPay -> {
                ObjectResponse<Integer> objectResponse = finishPayAndDiscount(orderPay);

                // 下发预交费信息
                SendRequest sendRequest = new SendRequest();
                sendRequest.setParkId(orderPay.getParkId());
                sendRequest.setServiceId(orderPay.getId());
                sendRequest.setServiceType(DownServiceEnum.预缴费.getServiceType());
                ObjectResponse<?> send = downSendService.send(sendRequest);
            });
        }

        return ObjectResponse.success();
    }

    @Override
    public boolean useDiscount(OrderPay orderPay) {
        String orderNum = orderPay.getOrderNum();
        // 判断优惠类型是否是全免或折扣并且选择按实际优惠扣除商户余额
        List<OrderDiscount> orderDiscounts = orderDiscountDao.selectByOrderNum(orderNum, 0);
        if (orderDiscounts != null && orderDiscounts.size() > 0) {
            for (OrderDiscount orderDiscount : orderDiscounts) {
                //如果操作失败
                if (!useDiscount(Double.parseDouble(orderPay.getDiscountPrice()),
                        orderPay.getParkId(), orderPay.getTradeNo(), orderPay.getPayTime(), orderNum, orderDiscount)) {
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public boolean useDiscount(Long parkId, String orderNum, Double discountPrice,String tradeNo,
                               Long payTime,List<String> discountNos, OrderPay orderPay) {
        if (discountPrice == null || discountPrice == 0) {
            return false;
        }
        try {
            //单独处理优惠信息
            if (orderPay == null) {
                orderPay = orderPayDao.selectByTradeNo(tradeNo);
            }
            if (Objects.nonNull(orderPay)){
                List<OrderDiscount> orderDiscounts = orderDiscountDao.selectList(
                        Wrappers.lambdaQuery(OrderDiscount.class)
                                .eq(OrderDiscount::getParkId, parkId)
                                .eq(OrderDiscount::getDelFlag, 0)
                                .in(OrderDiscount::getDiscountNo, discountNos));
                Set<String> discountNames = orderDiscounts.stream().map(s->StringUtils.isNotBlank(s.getDiscountName())?s.getDiscountName():"").collect(Collectors.toSet());
                String join = StrUtil.join("-", discountNames);
                if (join.length() < 512){
                    orderPay.setRemark(join);
                }
                if (NumberUtils.toDouble(orderPay.getPaidPrice()) == 0 && NumberUtils.toDouble(orderPay.getTotalPrice()) > 0) {
                    orderPay.setPayWay(10);
                }
                orderPayDao.updateById(orderPay);
            }
        }catch (Exception e){
            log.error("更新优惠抵扣失败 tradeNo {}",tradeNo,e);
        }

        try {
            return redissonDistributedLock.locked(() -> {
                //查询当前订单的所有第三方优惠券
                List<OrderDiscount> orderDiscountsThirdList = orderDiscountDao.selectList(
                        Wrappers.lambdaQuery(OrderDiscount.class)
                                .eq(OrderDiscount::getOrderNum, orderNum)
                                .eq(OrderDiscount::getFrom, 2));
                if (CollectionUtil.isNotEmpty(orderDiscountsThirdList)){
                    //补充第三发优惠信息
                    List<String> discountThirdNos = orderDiscountsThirdList.stream().map(OrderDiscount::getDiscountNo).collect(Collectors.toList());
                    CollectionUtil.addAll(discountNos, discountThirdNos);
                    CollectionUtil.distinct(discountNos);
                }
                List<OrderDiscount> orderDiscounts = orderDiscountDao.selectList(
                        Wrappers.lambdaQuery(OrderDiscount.class)
                                .eq(OrderDiscount::getParkId, parkId)
                                .eq(OrderDiscount::getDelFlag,0)
                                .in(OrderDiscount::getDiscountNo, discountNos));
                List<OrderDiscount> disDayList = orderDiscounts.stream().filter(orderDiscount ->
                        Integer.valueOf(5).equals(orderDiscount.getType())).collect(Collectors.toList());
                if (CollectionUtils.isNotEmpty(disDayList)) {
                    Optional<OrderDiscount> first = disDayList.stream()
                            .filter(orderDiscount -> orderDiscount.getOrderNum().equals(orderNum))
                            .filter(orderDiscount -> orderDiscount.getStatus() == 0 || orderDiscount.getStatus() == 3).findFirst();
                    if (first.isPresent()) {
                        updateDiscountUsed(discountPrice, tradeNo, payTime, 0, first.get());
                    } else {
                        OrderDiscount orderDiscount = disDayList.get(0);
                        orderDiscount.setId(null);
                        orderDiscount.setOrderNum(orderNum);
                        orderDiscount.setTradeNo(tradeNo);
                        orderDiscount.setAmount(String.valueOf(discountPrice));
                        orderDiscount.setStatus(1);
                        orderDiscount.setGetAmount(discountPrice);
                        orderDiscount.setUseTime(new Date());
                        orderDiscount.setCarStatus(2);
                        orderDiscount.setDeductMoney(null);
                        orderDiscount.setReduceBalance(null);
                        orderDiscountDao.insert(orderDiscount);
                    }
                }
                if (disDayList.size() == orderDiscounts.size()) {
                    return true;
                }
                ForEachUtils.forEach(0,orderDiscounts,(index,orderDiscount)->{
                    if (orderDiscount.getStatus() == 0 || orderDiscount.getStatus() == 3) {
                        if (orderDiscount.getType() == 1 || orderDiscount.getType() == 4) {
                            if(Objects.nonNull(orderDiscount.getMerchantDisId())) {
                                Long merchantDisId =orderDiscount.getMerchantDisId();
                                MerchantDiscount merchantDiscount = merchantDiscountDao.findById(merchantDisId);
                                //按实际优惠扣除商户余额
                                if (merchantDiscount != null && merchantDiscount.getDeductType() == 1) {
                                    orderDiscount.setDeductMoney(discountPrice);
                                    orderDiscount.setGetAmount(discountPrice);
                                    BigDecimal mchDeductAmount = new BigDecimal(discountPrice);
                                    // 全免优惠商家计费扣除折扣计算
                                    if (merchantDiscount.getType() == 1 && merchantDiscount.getDisDeductValue() != null
                                            && merchantDiscount.getDisDeductValue() > 0 && merchantDiscount.getDisDeductValue() < 10) {
                                        mchDeductAmount = mchDeductAmount.multiply(BigDecimal.valueOf(merchantDiscount.getDisDeductValue(), 1));
                                    }
                                    ObjectResponse<Void> objectResponse = merchantUserService.subMerchantMoney(orderDiscount.getMerchantId().intValue(), mchDeductAmount);
                                    if (!CodeConstants.SUCCESS.equals(objectResponse.getCode())) {
                                        log.error("[紧急错误]优惠延迟扣除商户余额操作失败，请尽快处理,orderNum：{}，discountNo：{}", orderDiscount.getOrderNum(), orderDiscount.getDiscountNo());
                                        return;
                                    }
                                }
                            }
                        }
                        updateDiscountUsed(discountPrice, tradeNo, payTime, index, orderDiscount);
                    }
                });
                return true;
            }, "LOCK:DISCOUNT:"+tradeNo);
        }catch (Exception e){
            log.error("[分布式锁执行异常], {}", "参数信息", e);
        }
        return false;
    }

    private void updateDiscountUsed(Double discountPrice, String tradeNo, Long payTime, Integer index, OrderDiscount orderDiscount) {
        // 更新优惠记录
        orderDiscount.setTradeNo(tradeNo);
        orderDiscount.setStatus(1);
        if (index == 0){
            orderDiscount.setGetAmount(discountPrice);
        } else {
            orderDiscount.setGetAmount(BigDecimal.ZERO.doubleValue());
        }
        orderDiscount.setUseTime(new Date(payTime * 1000L));
        int n2 = orderDiscountDao.updateById(orderDiscount);
        log.info("[交易记录服务] 修改优惠已使用状态，影响{}条记录，orderNum：{}, from: {}", n2, orderDiscount.getOrderNum(), orderDiscount.getFrom());
        //释放优惠车位数
        addDiscountSpaceNum(orderDiscount);
        // 如果为特来电则调用特来电优惠使用通知接口
        if ("特来电互联互通停车票".equals(orderDiscount.getDiscountName())) {
            asyncExecutor.execute(ThreadUtils.wrapTrace(() -> teldService.consumed(orderDiscount.getId())));
        }
    }

    @Override
    @DS_SLAVE
    public ObjectResponse<com.icetech.common.domain.Page<OrderPay>> getOrderPayList(Long parkId, BaseQueryRequest request) {
        Page<OrderPay> orderPayPage = PageHelper.startPage(request.getPageNo(), request.getPageSize()).doSelectPage(() -> {
            orderPayDao.getOrderPayList(request.getStartTime().getTime()/1000,request.getEndTime().getTime()/1000,parkId);
        });
        return ObjectResponse.success(com.icetech.common.domain.Page
                .instance(orderPayPage.getPages()
                        ,orderPayPage.getTotal()
                        ,orderPayPage.getResult()));
    }

    @Override
    public ObjectResponse<BigDecimal> getTempPayAmount(Long parkId, Long startTime, Long endTime, List<Integer> payType, String plateNumber, Integer paymentType) {
        return ObjectResponse.success(orderPayDao.selectTempPayAmount(parkId, startTime, endTime, payType, plateNumber, paymentType));
    }

    @Override
    public ObjectResponse<Integer> getPayAisle(Long startTime, Long endTime) {
        return  ObjectResponse.success(orderPayDao.selectPayAisleCount(startTime, endTime));
    }

    @Override
    @DS_SLAVE
    public ObjectResponse<List<ParkPayReportVo>> getMonthPayList(String startTime, String endTime) {
        List<ParkPayReportVo> lists = orderPayDao.selectMonthPayList(startTime, endTime);
        if (CollectionUtils.isEmpty(lists)) {
            return ObjectResponse.failed(CodeConstants.ERROR_404);
        }
        return ObjectResponse.success(lists);
    }

    @Override
    @DS_SLAVE
    public ObjectResponse<List<ParkPayReportVo>> getYearPayList(String startTime, String endTime) {
        List<ParkPayReportVo> lists = orderPayDao.selectYearPayList(startTime, endTime);
        if (CollectionUtils.isEmpty(lists)) {
            return ObjectResponse.failed(CodeConstants.ERROR_404);
        }
        return ObjectResponse.success(lists);
    }

    public boolean useDiscount(Double discountPrice, Long parkId, String tradeNo, Long payTime,
                               String orderNum, OrderDiscount orderDiscount) {
        OrderDiscount orderDiscountUpdate = new OrderDiscount();
        if (orderDiscount.getType() == 1 || orderDiscount.getType() == 4) {
            Long merchantDisId = orderDiscount.getMerchantDisId();
            MerchantDiscount merchantDiscount = merchantDiscountDao.findById(merchantDisId);
            //按实际优惠扣除商户余额
            if (merchantDiscount != null && merchantDiscount.getDeductType() == 1) {
                orderDiscountUpdate.setDeductMoney(discountPrice);
                orderDiscountUpdate.setGetAmount(discountPrice);
                BigDecimal mchDeductAmount = new BigDecimal(discountPrice);
                // 全免优惠商家计费扣除折扣计算
                if (merchantDiscount.getType() == 1 && merchantDiscount.getDisDeductValue() != null
                    && merchantDiscount.getDisDeductValue() > 0 && merchantDiscount.getDisDeductValue() < 10) {
                    mchDeductAmount = mchDeductAmount.multiply(BigDecimal.valueOf(merchantDiscount.getDisDeductValue(), 1));
                }
                ObjectResponse objectResponse = merchantUserService.subMerchantMoney(orderDiscount.getMerchantId().intValue(), mchDeductAmount);
                if (!CodeConstants.SUCCESS.equals(objectResponse.getCode())) {
                    log.error("[紧急错误]优惠延迟扣除商户余额操作失败，请尽快处理,orderNum：{}，discountNo：{}", orderNum, orderDiscount.getDiscountNo());
                    return false;
                }
            }
        }
        // 更新优惠记录
        orderDiscountUpdate.setId(orderDiscount.getId());
        orderDiscountUpdate.setParkId(parkId);
        orderDiscountUpdate.setOrderNum(orderNum);
        orderDiscountUpdate.setDiscountNo(orderDiscount.getDiscountNo());
        orderDiscountUpdate.setGetAmount(discountPrice);
        //修改参数
        orderDiscountUpdate.setTradeNo(tradeNo);
        orderDiscountUpdate.setStatus(1);
        orderDiscountUpdate.setUseTime(new Date(payTime * 1000));
        int n2 = orderDiscountDao.updateById(orderDiscountUpdate);
        log.info("[交易记录服务] 修改优惠已使用状态，影响{}条记录，orderNum：{}, from: {}", n2, orderNum, orderDiscount.getFrom());
        //释放优惠车位数
        addDiscountSpaceNum(orderDiscount);

        // 如果为特来电则调用特来电优惠使用通知接口
        if ("特来电互联互通停车票".equals(orderDiscount.getDiscountName())) {
            asyncExecutor.execute(ThreadUtils.wrapTrace(() -> teldService.consumed(orderDiscount.getId())));
        }
        return true;
    }

    @Override
    public ObjectResponse<List<OrderPay>> findList(PageQuery<OrderPay> payPageQuery) {
        if (payPageQuery.getParam() == null) {
            return ObjectResponse.failed(CodeConstants.ERROR_400);
        } else {
            List<OrderPay> orderPays = orderPayDao.selectListByPage(payPageQuery);
            return ObjectResponse.success(orderPays);
        }
    }

    @Override
    @DS_SLAVE
    @SentinelResource(value = "OrderPayService.incomeCount", defaultFallback = "defaultFallbackHandle", fallbackClass = {ExceptionUtils.class})
    public ObjectResponse<IncomeCountDto> incomeCount(FlowRequest flowRequest) {
        IncomeCountDto incomeCountDto = orderPayDao.incomeCount(flowRequest);
        if (incomeCountDto != null) {
            return ObjectResponse.success(incomeCountDto);
        } else {
            return ObjectResponse.failed(CodeConstants.ERROR_404);
        }
    }

    @Override
    @DS_SLAVE
    @SentinelResource(value = "OrderPayService.incomeDetail", defaultFallback = "defaultFallbackHandle", fallbackClass = {ExceptionUtils.class})
    public ObjectResponse<List<IncomeDetailDto>> incomeDetail(FlowRequest flowRequest) {
        List<IncomeDetailDto> incomeDetailDtos = orderPayDao.incomeDetail(flowRequest);
        if (incomeDetailDtos != null) {
            return ObjectResponse.success(incomeDetailDtos);
        } else {
            return ObjectResponse.failed(CodeConstants.ERROR_404);
        }
    }

    @Override
    @DS_SLAVE
    @SentinelResource(value = "OrderPayService.payWayCount", defaultFallback = "defaultFallbackHandle", fallbackClass = {ExceptionUtils.class})
    public ObjectResponse<List<PayWayCountDto>> payWayCount(FlowRequest flowRequest) {
        return payWayCount(flowRequest, 3, null);
    }

    @Override
    @DS_SLAVE
    @SentinelResource(value = "OrderPayService.payWayCount2", defaultFallback = "defaultFallbackHandle", fallbackClass = {ExceptionUtils.class})
    public ObjectResponse<List<PayWayCountDto>> payWayCount(FlowRequest flowRequest, int day, String month) {
        try {
            flowRequest.setStartTime((DateTools.phpCurrentDate(new Date())) * 1L);
            if (day == 2) {//昨天
                flowRequest.setStartTime(getYesterdayHourTime(24 + getHour(new Date())));
                flowRequest.setEndTime(getYesterdayHourTime(getHour(new Date())) - 1);
            }
            if (day == 7 || day == 30) {//7天 30天
                flowRequest.setStartTime(getDayTime(day));
                flowRequest.setEndTime(getTodayTime() - 1);
            }
            if (day == 0) {//指定月份
                SimpleDateFormat f = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                Date st = f.parse(month + "-01 00:00:00");
                Date en = f.parse(month + "-31 23:59:59");
                flowRequest.setStartTime(st.getTime() / 1000);
                flowRequest.setEndTime(en.getTime() / 1000);
            }
            IncomeCountDto incomeCountDto = orderPayDao.incomeCount(flowRequest);
            if (incomeCountDto == null || incomeCountDto.getTotalIncome() == 0) {
                return ObjectResponse.failed(CodeConstants.ERROR_404);
            }
            DecimalFormat df = new DecimalFormat("###0.00");
            List<PayWayCountDto> list = orderPayDao.payWayCount(flowRequest);
            Double totalIncome = incomeCountDto.getTotalIncome();
            for (PayWayCountDto payWayCountDto : list) {
                payWayCountDto.setRatio(df.format(payWayCountDto.getTotalPayCount() / totalIncome * 100) + "%");
            }
            if(list.size() > 0){
                list = sort(list);
            }
            return ObjectResponse.success(list);
        } catch (Exception e) {
            log.error("处理失败: {}. flowRequest[{}], day[{}], month[{}]", e.getMessage(), flowRequest, day, month, e);
        }
        return ObjectResponse.success();
    }
    /**
     * 将微信支付宝顺序提前,解决前端显示颜色显示问题
     * @param list
     * @return
     */
    private static   List<PayWayCountDto> sort(List<PayWayCountDto> list){
        List<PayWayCountDto> reulst = new ArrayList<>();
        for (int i = 0; i < list.size(); i++) {
            PayWayCountDto payWayCountDto = list.get(i);
            if(payWayCountDto.getPayWayName().contains("支付宝")){
                payWayCountDto.setOrder(0);
            }else if(payWayCountDto.getPayWayName().contains("微信")){
                payWayCountDto.setOrder(1);
            }else{
                payWayCountDto.setOrder(i+2);
            }
            reulst.add(payWayCountDto);
        }
        Collections.sort(reulst);
        return reulst;
    }
    @Override
    @DS_SLAVE
    @SentinelResource(value = "OrderPayService.countReportPay", defaultFallback = "defaultFallbackHandle", fallbackClass = {ExceptionUtils.class})
    public ObjectResponse<List<PayWayCountDto>> countReportPay(String parkIds, String startTime, String endTime) {
        try {
            List<PayWayCountDto> payWayCountDtos = orderPayDao.countReportPay(parkIds, startTime, endTime);
            return ObjectResponse.success(payWayCountDtos);
        } catch (Exception e) {
            log.error("处理失败: {}. parkIds[{}], startTime[{}], endTime[{}]", e.getMessage(), parkIds, startTime, endTime, e);
        }
        return null;
    }

    @Override
    public ObjectResponse<StoreCardCountDto> countStoreCardReport(List<Long> parkIds, String startTime, String endTime) {
        StoreCardCountDto storeCardCountDto = storeCardDao.countStoreCarReport(parkIds, startTime, endTime);
        storeCardCountDto.setStoreCardTotalCount(storeCardCountDto.getRenewstoreCardMoney()+storeCardCountDto.getAddstoreCardMoney());
        return ObjectResponse.success(storeCardCountDto);
    }

    @Override
    @DS_SLAVE
    @SentinelResource(value = "OrderPayService.parkIncomeTop", defaultFallback = "defaultFallbackHandle", fallbackClass = {ExceptionUtils.class})
    public ObjectResponse<List<ParkIncomeTopDto>> parkIncomeTop(ParkIncomeTopRequest parkIncomeTopRequest) {
        List<ParkIncomeTopDto> list = orderPayDao.parkIncomeTop(parkIncomeTopRequest);
        if (list != null && list.size() > 0) {
            return ObjectResponse.success(list);
        } else {
            return ObjectResponse.failed(CodeConstants.ERROR_404);
        }
    }

    @Override
    @DS_SLAVE
    @SentinelResource(value = "OrderPayService.paywayTop", defaultFallback = "defaultFallbackHandle", fallbackClass = {ExceptionUtils.class})
    public ObjectResponse<List<PaywayTopDto>> paywayTop(PaywayTopRequest paywayTopRequest) {
        List<PaywayTopDto> list = orderPayDao.paywayTop(paywayTopRequest);
        if (list != null && list.size() > 0) {
            return ObjectResponse.success(list);
        } else {
            return ObjectResponse.failed(CodeConstants.ERROR_404);
        }
    }

    @Override
    @DS_SLAVE
    @SentinelResource(value = "OrderPayService.countTodayIncome", defaultFallback = "defaultFallbackHandle", fallbackClass = {ExceptionUtils.class})
    public ObjectResponse<List<IncomeCountHourDto>> countTodayIncome(String parkIdList) {
        //获取今天凌晨0点的时间戳
        List<IncomeCountHourDto> incomeCountHourDtos = orderPayDao.countTodayIncome(parkIdList, DateRangeUtils.getTodayTime());
        //拼装返回数据进行处理由于一天是从凌晨开始,获取的时间段是连续的从凌晨到当前的时间段
        List<Integer> currentHours = DateRangeUtils.getCurrentHours();

        List<IncomeCountHourDto> resDtos = Lists.newArrayList();

        currentHours.forEach(s -> {
            IncomeCountHourDto resDto = new IncomeCountHourDto();
            resDto.setTimeRange(s + ":00-" + (s + 1) + ":00");
            if (CollectionUtils.isEmpty(incomeCountHourDtos)) {
                resDto.setTotalPaidPrice(BigDecimal.ZERO);
            } else {
                //查看查询结果中有没有对应的时间段
                IncomeCountHourDto findDto = incomeCountHourDtos.stream()
                        .filter(incomeCountHourDto -> Integer.valueOf(incomeCountHourDto.getTimeRange()).equals(s))
                        .findFirst()
                        .orElse(null);
                if (Objects.nonNull(findDto)) {
                    resDto.setTotalPaidPrice(findDto.getTotalPaidPrice());
                } else {
                    resDto.setTotalPaidPrice(BigDecimal.ZERO);
                }
            }
            resDtos.add(resDto);

        });
        return ObjectResponse.success(resDtos);

    }

    @Override
    @DS_SLAVE
    @SentinelResource(value = "OrderPayService.count24HoursIncome", defaultFallback = "defaultFallbackHandle", fallbackClass = {ExceptionUtils.class})
    public ObjectResponse<List<IncomeCountHourDto>> count24HoursIncome(String parkIdList) {
        //获取24小时之前的时间戳
        List<IncomeCountHourDto> incomeCountHourDtos = orderPayDao.countTodayIncome(parkIdList, DateRangeUtils.get24HourTime());
        //拼装返回数据进行处理由于一天是从凌晨开始,获取的时间段是连续的从凌晨到当前的时间段
        List<Integer> hours = DateRangeUtils.get24Hours();
        List<IncomeCountHourDto> resDtos = Lists.newArrayList();
        hours.forEach(s -> {
            IncomeCountHourDto resDto = new IncomeCountHourDto();
            resDto.setTimeRange(s + ":00-" + (s + 1) + ":00");
            if (CollectionUtils.isEmpty(incomeCountHourDtos)) {
                resDto.setTotalPaidPrice(BigDecimal.ZERO);
            } else {
                //查看查询结果中有没有对应的时间段getChannelInfo
                IncomeCountHourDto findDto = incomeCountHourDtos.stream()
                        .filter(incomeCountHourDto -> Integer.valueOf(incomeCountHourDto.getTimeRange()).equals(s))
                        .findFirst()
                        .orElse(null);
                if (Objects.nonNull(findDto)) {
                    resDto.setTotalPaidPrice(findDto.getTotalPaidPrice());
                } else {
                    resDto.setTotalPaidPrice(BigDecimal.ZERO);
                }
            }
            resDtos.add(resDto);

        });
        return ObjectResponse.success(resDtos);
    }

    @Override
    @DS_SLAVE
    @SentinelResource(value = "OrderPayService.countTemPayType", defaultFallback = "defaultFallbackHandle", fallbackClass = {ExceptionUtils.class})
    public ObjectResponse<List<OrderPayWayDto>> countTemPayType(String parkIds, Integer day, String pointMonth) {
        List<OrderPayWayDto> list = new ArrayList<>();
        try {
            SimpleDateFormat sf = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
            Date startTime = new Date();
            Date endTime = new Date();
            if (day != 0) {
                List<String> daysMultiformat = new ArrayList<>();
                if (day == 2) {
                    daysMultiformat = DateRangeUtils.getDaysMultiformat(1, 1);
                    startTime = sf.parse(daysMultiformat.get(0) + " 00:00:00");
                    endTime = sf.parse(daysMultiformat.get(daysMultiformat.size() - 1) + " 23:59:59");
                } else if (day == 3) {
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy/MM/dd");
                    String format = simpleDateFormat.format(new Date());
                    daysMultiformat.add(format);
                    startTime = sf.parse(format + " 00:00:00");
                } else {
                    daysMultiformat = DateRangeUtils.getDaysMultiformat(day, 1);
                    startTime = sf.parse(daysMultiformat.get(0) + " 00:00:00");
                    endTime = sf.parse(daysMultiformat.get(daysMultiformat.size() - 1) + " 23:59:59");
                }
                for (int i = 0; i < daysMultiformat.size(); i++) {
                    String date = daysMultiformat.get(i);
                    OrderPayWayDto orderPayWayDto = new OrderPayWayDto();
                    orderPayWayDto.setPayTime(date);
                    list.add(orderPayWayDto);
                }
            } else {
                String month = pointMonth;
                String[] split = pointMonth.split("-");
                int integer = Integer.valueOf(split[1]);
                Calendar cal = Calendar.getInstance();
                int nowmonth = cal.get(Calendar.MONTH) + 1;
                int days = cal.get(Calendar.DAY_OF_MONTH);
                if (integer != nowmonth) {
                    SimpleDateFormat sdf1 = new SimpleDateFormat("yyyy-MM-dd");
                    days = getDaysOfMonth(sdf1.parse(month + "-01"));
                }
                for (int i = 1; i < days; i++) {
                    OrderPayWayDto orderPayWayDto = new OrderPayWayDto();
                    if (i < 10) {
                        orderPayWayDto.setPayTime(split[0] + "/" + split[1] + "/0" + i);
                    } else {
                        orderPayWayDto.setPayTime(split[0] + "/" + split[1] + "/" + i);
                    }
                    list.add(orderPayWayDto);
                }
                startTime = sf.parse(split[0] + "/" + split[1] + "/01 00:00:00");
                endTime = sf.parse(split[0] + "/" + split[1] + "/31 23:59:59");
            }

            List<Integer> type = new ArrayList<>();
            type.add(1);
            List<OrderPayDto> orderPayDtos = orderPayDao.selectOrderPayList(parkIds,
                    Objects.isNull(startTime) ? null : startTime.getTime() / 1000, Objects.isNull(endTime) ? null : endTime.getTime() / 1000, null, null, null, null,
                    type, null, null);
            orderPayDtos.forEach(orderPayDto -> {
                Date payTime = orderPayDto.getPayTime();
                Integer payWay = orderPayDto.getPayWay();
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");
                String format = sdf.format(payTime);
                DecimalFormat df = new DecimalFormat("#.00");
                for (int i = 0; i < list.size(); i++) {
                    OrderPayWayDto orderPayWayDto = list.get(i);
                    if (orderPayWayDto.getPayTime().equals(format)) {
                        if (payWay == 1) {
                            orderPayWayDto.setCashPrice(NumberUtils.decimalAdd(orderPayWayDto.getCashPrice(), orderPayDto.getPaidPrice()).doubleValue());
                        } else if (payWay == 2) {
                            orderPayWayDto.setWxPrice(NumberUtils.decimalAdd(orderPayWayDto.getWxPrice(), orderPayDto.getPaidPrice()).doubleValue());
                        } else if (payWay == 3) {
                            orderPayWayDto.setAliPrice(NumberUtils.decimalAdd(orderPayWayDto.getAliPrice(), orderPayDto.getPaidPrice()).doubleValue());
                        } else if (payWay == 4) {
                            orderPayWayDto.setBankPrice(NumberUtils.decimalAdd(orderPayWayDto.getBankPrice(), orderPayDto.getPaidPrice()).doubleValue());
                        } else {
                            orderPayWayDto.setOtherPrice(NumberUtils.decimalAdd(orderPayWayDto.getOtherPrice(), orderPayDto.getPaidPrice()).doubleValue());
                        }
                    }
                }

            });
            return ObjectResponse.success(list);
        } catch (Exception e) {
            log.error("处理失败: {}. parkIds[{}], day[{}], pointMonth[{}]", e.getMessage(), parkIds, day, pointMonth, e);
        }
        return null;
    }

    @Override
    @DS_SLAVE
    @SentinelResource(value = "OrderPayService.getOrderPayList", defaultFallback = "defaultFallbackHandle", fallbackClass = {ExceptionUtils.class})
    public ObjectResponse<List<OrderPayDto>> getOrderPayList(OrderPayQueryRequest orderPayQueryRequest) {

        try {
            String parkCode = orderPayQueryRequest.getParkCode();
            Date startTime = orderPayQueryRequest.getStartTime();
            Date endTime = orderPayQueryRequest.getEndTime();
            String plateNumber = orderPayQueryRequest.getPlateNumber();
            List<Integer> payWay = orderPayQueryRequest.getPayWay();
            String userName = orderPayQueryRequest.getUserName();
            List<Integer> payChannel = orderPayQueryRequest.getPayChannel();
            List<Integer> type = orderPayQueryRequest.getType();
            String orderNum = orderPayQueryRequest.getOrderNum();
            Integer payType = orderPayQueryRequest.getPayType();
            String[] split = parkCode.split(",");
            String parkid = parkDao.selectByCodes(split);
            if(parkid.endsWith(",")){
                parkid = parkid.substring(0,parkid.length()-1);
            }
            PageHelper.startPage(orderPayQueryRequest.getPageNo(), orderPayQueryRequest.getPageSize());
            List<OrderPayDto> records = orderPayDao.selectOrderPayList(parkid,
                    Objects.isNull(startTime) ? null : startTime.getTime() / 1000, Objects.isNull(endTime) ? null : endTime.getTime() / 1000, plateNumber, payWay,
                    userName, payChannel, type, orderNum, payType);
            if (CollectionUtils.isEmpty(records)) {
                //暂无记录
                return ObjectResponse.failed(CodeConstantsEnum.ERROR_404);
            }
            records.forEach(orderPayDto -> {
                if (orderPayDto.getEnterTimeLong() != null && orderPayDto.getPayTime() != null) {
                    long payTime = orderPayDto.getPayTime().getTime() / 1000;
                    long parkTime;
                    if (orderPayDto.getLastPayTime() != null) {
                        parkTime = payTime - orderPayDto.getLastPayTime();
                    } else {
                        if (Integer.valueOf(1).equals(orderPayDto.getPayType())) {
                            parkTime = orderPayDto.getExitTimeLong() - orderPayDto.getEnterTimeLong();
                        } else {
                            parkTime = payTime - orderPayDto.getEnterTimeLong();
                        }
                    }
                    orderPayDto.setParkTime(parkTime);
                    orderPayDto.setParkTimeStr(DateTools.secondToSecondsTime((int) parkTime));
                }
            });

            //根据 orderNums 获取 url
            List<String> orderNums = records.stream().map(OrderPayDto::getOrderNum).collect(Collectors.toList());
            List<OrderCarInfo> carInfos = orderCarInfoDao.selectList(Wrappers.lambdaQuery(OrderCarInfo.class)
                    .select(OrderCarInfo::getOrderNum, OrderCarInfo::getEnterImage, OrderCarInfo::getEnterNo)
                    .in(OrderCarInfo::getOrderNum, orderNums));
            if (org.springframework.util.CollectionUtils.isEmpty(carInfos)) {
                return ObjectResponse.failed(CodeConstantsEnum.ERROR_404);
            }
            Map<String, OrderCarInfo> orderCarInfoMap = carInfos.stream().collect(Collectors.toMap(OrderCarInfo::getOrderNum, Function.identity()));
            records.forEach(record -> {
                OrderCarInfo orderCarInfo = orderCarInfoMap.get(record.getOrderNum());
                if (orderCarInfo != null) {
                    if (StringUtils.isNotBlank(orderCarInfo.getEnterImage())) {
                        record.setImgUrl(ossService.getImageUrl(orderCarInfo.getEnterImage()));
                    }
                    record.setEnterName(orderCarInfo.getEnterNo());
                }
            });
            return ObjectResponse.success(records);
        } catch (Exception e) {
            log.error("[车场管家获取订单接口]处理失败: {}. orderPayQueryRequest[{}]", e.getMessage(), orderPayQueryRequest, e);
            return ObjectResponse.failed(CodeConstantsEnum.ERROR);
        }
    }


    @Override
    @DS_SLAVE
    @SentinelResource(value = "OrderPayService.countOrderPayList", defaultFallback = "defaultFallbackHandle", fallbackClass = {ExceptionUtils.class})
    public ObjectResponse<Map<String, Object>> countOrderPayList(OrderPayQueryRequest orderPayQueryRequest) {
        try {
            String parkCode = orderPayQueryRequest.getParkCode();
            Date startTime = orderPayQueryRequest.getStartTime();
            Date endTime = orderPayQueryRequest.getEndTime();
            String plateNumber = orderPayQueryRequest.getPlateNumber();
            List<Integer> payWay = orderPayQueryRequest.getPayWay();
            String userName = orderPayQueryRequest.getUserName();
            List<Integer> payChannel = orderPayQueryRequest.getPayChannel();
            List<Integer> type = orderPayQueryRequest.getType();
            String[] split = parkCode.split(",");
            String parkid = parkDao.selectByCodes(split);
            //获取总条数
            int records = orderPayDao.countOrderPayList(parkid,
                    Objects.isNull(startTime) ? null : startTime.getTime() / 1000, Objects.isNull(endTime) ? null : endTime.getTime() / 1000, plateNumber, payWay,
                    userName, type, payChannel, orderPayQueryRequest.getPayType());
            //获取总金额
            BigDecimal paidPrice = orderPayDao.sumOrderPayList(parkid,
                    Objects.isNull(startTime) ? null : startTime.getTime() / 1000, Objects.isNull(endTime) ? null : endTime.getTime() / 1000, plateNumber, payWay,
                    userName, type, payChannel, orderPayQueryRequest.getPayType());
            Map<String, Object> map = new HashMap<>();
            map.put("count", records);
            map.put("paidPrice", paidPrice);
            return ObjectResponse.success(map);
        } catch (Exception e) {
            log.error("[车场管家获取订单]处理失败: {}. parkCode[{}]", e.getMessage(), orderPayQueryRequest, e);
            return ObjectResponse.failed(CodeConstantsEnum.ERROR);
        }

    }

    @Override
    public ObjectResponse<OrderPayDto> getOrderPayDetail(String parkCode, Integer recordId, String tradeNo) {
        try {
            if (recordId == null && StringUtils.isBlank(tradeNo)) {
                return ObjectResponse.failed(CodeConstantsEnum.ERROR_400);
            }
            //获取交易信息
            OrderPay orderPay = new OrderPay();
            orderPay.setId(recordId == null ? null : Long.valueOf(recordId));
            orderPay.setTradeNo(StringUtils.isBlank(tradeNo) ? null : tradeNo);
            orderPay = orderPayDao.selectLimitOne(orderPay);

            //获取车牌信息
            OrderInfo orderInfo = orderInfoDao.selectByOrderNum(orderPay.getOrderNum());
            if (orderInfo == null) {
                return ObjectResponse.failed(CodeConstants.ERROR_404, "未查询到订单");
            }
            //封装信息
            OrderPayDto orderPayDto = new OrderPayDto();
            orderPayDto.setId(Math.toIntExact(orderPay.getId()));
            orderPayDto.setPlateNumber(orderInfo.getPlateNum());
            orderPayDto.setType(orderInfo.getType());
            orderPayDto.setCarType(orderInfo.getCarType());
            orderPayDto.setPayTime(new Date(orderPay.getPayTime() * 1000));
            orderPayDto.setOrderNum(orderPay.getOrderNum());
            orderPayDto.setTradeNo(orderPay.getTradeNo());
            orderPayDto.setPayWay(orderPay.getPayWay());
            orderPayDto.setPayChannel(orderPay.getPayChannel());
            orderPayDto.setTotalPrice(orderPay.getTotalPrice());
            orderPayDto.setPaidPrice(orderPay.getPaidPrice());
            orderPayDto.setDiscountPrice(orderPay.getDiscountPrice());
            orderPayDto.setUserAccount(orderPay.getUserAccount());
            orderPayDto.setPayTerminal(orderPay.getPayTerminal());
            orderPayDto.setRedPackage(Double.valueOf(orderPay.getRedpackRet()));
            orderPayDto.setPayType(orderPay.getPayType());
            if (Objects.nonNull(orderPay.getBalancePrice())){
                orderPayDto.setStoreCardPrice(orderPay.getBalancePrice().doubleValue());
            }
            orderPayDto.setEnterTime(DateTools.getFormat(orderInfo.getEnterTime() * 1000));
            if (orderInfo.getExitTime() != null){
                orderPayDto.setExitTime(DateTools.getFormat(orderInfo.getExitTime() * 1000));
            }
            Long parkTime = 0L;
            // 补交订单 计费时长
            if (orderPayDto.getPayType() != null && orderPay.getPayType() ==1 ) {
                parkTime = orderInfo.getExitTime() - orderInfo.getEnterTime();
            }else {
                // 正常订单计费时长处理
                if (Objects.nonNull(orderPay.getPayTime()) && Objects.nonNull(orderInfo.getEnterTime())) {
                    Long payTime = orderPay.getPayTime();
                    if (Objects.nonNull(orderPay.getLastPayTime())) {
                        parkTime = payTime - orderPay.getLastPayTime();
                    } else {
                        parkTime = payTime - orderInfo.getEnterTime();
                    }
                }
            }
            orderPayDto.setParkTime(parkTime);
            orderPayDto.setParkTimeStr(DateTools.secondToSecondsTime(Math.toIntExact(parkTime)));
            //获取车场名称
            Park park = parkService.findByParkId(orderInfo.getParkId()).getData();
            orderPayDto.setParkName(park.getParkName());
            OrderCarInfo carInfo = orderCarInfoDao.selectByOrderNum(orderInfo.getOrderNum());
            if (carInfo != null) {
                orderPayDto.setEnterName(carInfo.getEnterNo());
                orderPayDto.setExitName(carInfo.getExitNo());
                orderPayDto.setImgUrl(ossService.getImageUrl(carInfo.getEnterImage()));
            }
            return ObjectResponse.success(orderPayDto);
        } catch (Exception e) {
            log.error("[车场管家获取订单详情]处理失败: {}. parkCode[{}], recordId[{}], tradeNo[{}]", e.getMessage(), parkCode, recordId, tradeNo, e);
            return ObjectResponse.failed(CodeConstantsEnum.ERROR);
        }
    }

    @Override
    public ObjectResponse<OrderSumFeeDto> getSumFee(String parkCode, String orderNum) {
        Park park = parkService.findByParkCode(parkCode).getData();
        OrderPay orderPay = new OrderPay();
        orderPay.setOrderNum(orderNum);
        orderPay.setParkId(park.getId());
        OrderSumFeeDto orderSumFeeDto = orderPayDao.sumFee(orderPay);
        if (Objects.isNull(orderSumFeeDto)) {
            return ObjectResponse.failed(CodeConstantsEnum.ERROR_404);
        }

        return ObjectResponse.success(orderSumFeeDto);
    }

    @Override
    public ObjectResponse<OrderSumFeeDto> getSumPay(OrderPayCondition orderPayCondition) {
        OrderSumFeeDto orderSumFeeDto = orderPayDao.sumPay(orderPayCondition);
        if (orderSumFeeDto != null) {
            return ObjectResponse.success(orderSumFeeDto);
        }
        return ObjectResponse.failed(CodeConstants.ERROR_404);
    }

    @Override
    @DS_SLAVE
    @SentinelResource(value = "OrderPayService.sumOrderPay", defaultFallback = "defaultFallbackHandle", fallbackClass = {ExceptionUtils.class})
    public ObjectResponse<SumOrderPayDto> sumOrderPay(SumOrderPayRequest sumOrderPayRequest) {
        SumOrderPayDto sumOrderPayDto = orderPayDao.sumOrderPay(sumOrderPayRequest);
        if (sumOrderPayDto != null) {
            return ObjectResponse.success(sumOrderPayDto);
        }
        return ObjectResponse.failed(CodeConstants.ERROR_404);
    }

    @Override
    @DS_SLAVE
    @SentinelResource(value = "OrderPayService.summaryReportPay", defaultFallback = "defaultFallbackHandle", fallbackClass = {ExceptionUtils.class})
    public ObjectResponse<SumOrderPayDto> summaryReportPay(String parkIds ,String startTime,String endTime) {
        SumOrderPayDto sumOrderPayDto = orderPayDao.summaryReportPay(parkIds, startTime, endTime);
        if (sumOrderPayDto != null) {
            BigDecimal totalPrice = sumOrderPayDto.getPaidPrice().add(sumOrderPayDto.getDiscountPrice());
            sumOrderPayDto.setTotalPrice(totalPrice);
            return ObjectResponse.success(sumOrderPayDto);
        }
        return ObjectResponse.failed(CodeConstants.ERROR_404);
    }

    @Override
    @DS_SLAVE
    @SentinelResource(value = "OrderPayService.sumOrderPayMtype", defaultFallback = "defaultFallbackHandle", fallbackClass = {ExceptionUtils.class})
    public ObjectResponse<List<SumOrderDatePayDto>> sumOrderPayMtype(BossOrderPayRequest bossOrderPayRequest) {
        List<SumOrderDatePayDto> list = new ArrayList<>();
        try {
            if (bossOrderPayRequest.getDay() != 0) {
                List<String> daysMultiformat = DateRangeUtils.getDaysMultiformat(bossOrderPayRequest.getDay(), 1);
                for (int i = 0; i < daysMultiformat.size(); i++) {
                    String date = daysMultiformat.get(i);
                    SumOrderDatePayDto sumOrderDatePayDto = new SumOrderDatePayDto();
                    sumOrderDatePayDto.setPayTime(date);
                    list.add(sumOrderDatePayDto);
                }
                SimpleDateFormat sf = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
                bossOrderPayRequest.setPayTimeStart(list.get(0).getPayTime());
                bossOrderPayRequest.setPayTimeEnd(list.get(list.size() - 1).getPayTime());
            } else if ((!Objects.isNull(bossOrderPayRequest.getStartYear()))) {//指定年
                Integer startYear = bossOrderPayRequest.getStartYear();
                Integer endYear = bossOrderPayRequest.getEndYear();
                List<String> year = new ArrayList<>();
                for (int i = startYear; i <= endYear; i++) {
                    List<String> months = getMonths(i);
                    year.addAll(months);
                }
                for (int i = 0; i < year.size(); i++) {
                    String date = year.get(i);
                    SumOrderDatePayDto sumOrderDatePayDto = new SumOrderDatePayDto();
                    sumOrderDatePayDto.setPayTime(date);
                    list.add(sumOrderDatePayDto);
                }
                bossOrderPayRequest.setPayTimeStart(list.get(0).getPayTime()+"/01");
                bossOrderPayRequest.setPayTimeEnd(list.get(list.size() - 1).getPayTime()+"/31");

            } else {//指定年指定月份
                String month = bossOrderPayRequest.getMonth();
                String[] split = month.split("-");
                int integer = Integer.valueOf(split[1]);
                Calendar cal = Calendar.getInstance();
                int nowmonth = cal.get(Calendar.MONTH) + 1;
                int day = cal.get(Calendar.DAY_OF_MONTH);
                if (integer != nowmonth) {
                    SimpleDateFormat sdf1 = new SimpleDateFormat("yyyy-MM-dd");
                    day = getDaysOfMonth(sdf1.parse(month + "-01"));
                }
                for (int i = 1; i < day; i++) {
                    SumOrderDatePayDto sumOrderDatePayDto = new SumOrderDatePayDto();
                    if (i < 10) {
                        sumOrderDatePayDto.setPayTime(split[0] + "/" + split[1] + "/0" + i);
                    } else {
                        sumOrderDatePayDto.setPayTime(split[0] + "/" + split[1] + "/" + i);
                    }
                    list.add(sumOrderDatePayDto);
                }
                bossOrderPayRequest.setPayTimeStart(list.get(0).getPayTime());
                bossOrderPayRequest.setPayTimeEnd(list.get(list.size() - 1).getPayTime());
                bossOrderPayRequest.setDay(1);
            }

            List<SumOrderDatePayDto> sumOrderDatePayDtos = orderPayDao.sumOrderPayListCount(bossOrderPayRequest);
            for (int i = 0; i < list.size(); i++) {
                SumOrderDatePayDto sumOrderDatePayDto = list.get(i);
                String time = sumOrderDatePayDto.getPayTime();
                for (int j = 0; j < sumOrderDatePayDtos.size(); j++) {
                    SumOrderDatePayDto sumOrderDatePayDto1 = sumOrderDatePayDtos.get(j);
                    String time1 = sumOrderDatePayDto1.getPayTime();
                    if (time1.equals(time)) {
                        sumOrderDatePayDto.setTotalPrice(sumOrderDatePayDto1.getTotalPrice());
                        sumOrderDatePayDto.setPaidPrice(sumOrderDatePayDto1.getPaidPrice());
                        sumOrderDatePayDto.setDiscountPrice(sumOrderDatePayDto1.getDiscountPrice());
                    }
                }
            }
        } catch (Exception e) {
            log.error("处理失败: {}. bossOrderPayRequest[{}]", e.getMessage(), bossOrderPayRequest, e);
        }


        return ObjectResponse.success(list);
    }


    @Override
    @DS_SLAVE
    @SentinelResource(value = "OrderPayService.getInvoiceList", defaultFallback = "defaultFallbackHandle", fallbackClass = {ExceptionUtils.class})
    public ObjectResponse<List<InvoiceResponse>> getInvoiceList(InvoiceRequest invoiceRequest) {
        if (invoiceRequest.getParkCode() == null) {
            return ObjectResponse.failed(CodeConstants.ERROR_400, "车场编号必传");
        }
        ObjectResponse<Park> parkObjectResponse = parkService.findByParkCode(invoiceRequest.getParkCode());
        if (!ObjectResponse.isSuccess(parkObjectResponse)) {
            return ObjectResponse.failed(CodeConstants.ERROR_400);
        }
        ObjectResponse<ParkConfig> parkConfigObjectResponse = parkService.getParkConfig(invoiceRequest.getParkCode());
        if (!ObjectResponse.isSuccess(parkConfigObjectResponse)) {
            return ObjectResponse.failed(CodeConstants.ERROR_400);
        }
        PageHelper.startPage(invoiceRequest.getPageNo(), invoiceRequest.getPageSize());
        ParkConfig parkConfig = parkConfigObjectResponse.getData();
        Integer parkingInvoiceDays = parkConfig.getParkingInvoiceDays();
        if (parkingInvoiceDays == null) {
            parkingInvoiceDays = 365;
        }
        Date startDate = DateUtil.offsetDay(DateUtil.date(), -parkingInvoiceDays);
        Long startTime =  startDate.getTime() / 1000;
        Long endTime = DateTools.unixTimestamp();
        List<InvoiceResponse> responseList = orderPayDao.selectNoInvoiceListByPlateNum(DateRangeUtils.getYearQuarterRangeTableName(startDate), invoiceRequest.getPlateNums(), null, parkObjectResponse.getData().getId(), null, startTime, endTime);
        if (CollectionUtils.isEmpty(responseList)) {
            return ObjectResponse.failed(CodeConstantsEnum.ERROR_404.getCode(), "暂时未找到开票记录");
        }
        return ObjectResponse.success(responseList);
    }

    @Override
    @DS_SLAVE
    @SentinelResource(value = "OrderPayService.getInvoiceList", defaultFallback = "defaultFallbackHandle", fallbackClass = {ExceptionUtils.class})
    public ObjectResponse<List<InvoiceResponse>> getMpInvoiceList(InvoiceRequest invoiceRequest) {
        //获取所有的能开票的车场信息
        List<InvoiceMerchantPark> invoiceMerchantParks = invoiceMerchantParkDao.selectAll();
        if (CollectionUtils.isEmpty(invoiceMerchantParks)) {
            return ObjectResponse.failed(CodeConstantsEnum.ERROR_404.getCode(), "当前没有可以开发票的车场");
        }
        Set<Long> parkIds = invoiceMerchantParks.stream().map(merchantPark -> Long.valueOf(merchantPark.getParkId())).collect(Collectors.toSet());
        try (Page<InvoiceResponse> page = PageHelper.startPage(invoiceRequest.getPageNo(), invoiceRequest.getPageSize())) {
            Date startDate = DateUtil.offsetDay(DateUtil.date(), -365);
            Long startTime = startDate.getTime() / 1000;
            Long endTime = DateTools.unixTimestamp();
            List<InvoiceResponse> responseList = orderPayDao.selectNoInvoiceListByPlateNum(DateRangeUtils.getYearQuarterRangeTableName(startDate), invoiceRequest.getPlateNums(), null, null, parkIds, startTime, endTime);
            if (CollectionUtils.isEmpty(responseList)) {
                return ObjectResponse.failed(CodeConstantsEnum.ERROR_404.getCode(), "暂时未找到开票记录");
            }
            return ObjectResponse.success(responseList);
        }
    }


    @Override
    @DS_SLAVE
    @SentinelResource(value = "OrderPayService.getInvoiceList", defaultFallback = "defaultFallbackHandle", fallbackClass = {ExceptionUtils.class})
    public ObjectResponse<List<InvoiceResponse>> getInvoiceListV2(InvoiceRequest invoiceRequest) {
        Long parkId = null;
        if (org.apache.commons.lang3.StringUtils.isNotEmpty(invoiceRequest.getParkCode())) {
            parkId = parkService.findByParkCode(invoiceRequest.getParkCode()).getData().getId();
        }
        PageHelper.startPage(invoiceRequest.getPageNo(), invoiceRequest.getPageSize());
        List<InvoiceResponse> responseList = orderPayDao.selectNoInvoiceListByPlateNum(DateRangeUtils.getYearQuarterRangeTableName(invoiceRequest.getStartTime()), null, invoiceRequest.getAccountId(), parkId, null, DateUtil.beginOfDay(invoiceRequest.getStartTime()).getTime() / 1000, DateUtil.beginOfDay(invoiceRequest.getEndTime()).getTime() / 1000);
        if (CollectionUtil.isNotEmpty(responseList)) {
            responseList.forEach(item -> {
                ParkConfig parkConfig = parkService.getParkConfig(item.getParkId()).getData();
                if (parkConfig.getIsInvoice() == 2) {
                    item.setInvoice(Boolean.FALSE);
                    item.setReason("车场管理方未开通线上开票服务，无法开票");
                } else {
                    Integer parkingInvoiceDays = parkConfig.getParkingInvoiceDays();
                    if (parkingInvoiceDays != null) {
                        Date startDate = DateUtil.offsetDay(DateUtil.date(), -parkingInvoiceDays);
                        if (item.getPayTime() < startDate.getTime() / 1000) {
                            item.setInvoice(Boolean.FALSE);
                            item.setReason(String.format("该车场管理设置了，临停支付支持开具%s天内的支付记录",parkingInvoiceDays));
                        }
                    }
                }
            });
        }
        return ObjectResponse.success(responseList);
    }

    @Override
    @DS_SLAVE
    @SentinelResource(value = "OrderPayService.getInvoiceParkList", defaultFallback = "defaultFallbackHandle", fallbackClass = {ExceptionUtils.class})
    public ObjectResponse<List<InvoiceParksDto>> getInvoiceParkList(InvoiceRequest invoiceRequest) {
        //获取所有的能开票的车场信息
        List<InvoiceMerchantPark> invoiceMerchantParks = invoiceMerchantParkDao.selectAll();
        if (CollectionUtils.isEmpty(invoiceMerchantParks)) {
            return ObjectResponse.failed(CodeConstantsEnum.ERROR_404.getCode(), "当前没有可以开发票的车场");
        }
        List<Integer> parkIds = invoiceMerchantParks.stream().map(InvoiceMerchantPark::getParkId).collect(Collectors.toList());
        Long startTime = null;
        Long endTime = null;
        if (Objects.nonNull(invoiceRequest.getStartTime())) startTime = invoiceRequest.getStartTime().getTime() / 1000;
        if (Objects.nonNull(invoiceRequest.getEndTime())) endTime = invoiceRequest.getEndTime().getTime() / 1000;
        List<InvoiceParksDto> responseList = orderPayDao.selectNoInvoiceParkListByPlateNum(DateRangeUtils.getYearQuarterRangeTableName(invoiceRequest.getStartTime()), invoiceRequest.getPlateNums(), invoiceRequest.getAccountId(), null, parkIds, startTime, endTime);
        if (CollectionUtils.isEmpty(responseList)) {
            return ObjectResponse.failed(CodeConstantsEnum.ERROR_404.getCode(), "暂时未找到可开票车场");
        }
        return ObjectResponse.success(responseList);
    }

    @Override
    @DS_SLAVE
    @SentinelResource(value = "OrderPayService.getInvoiceParkList", defaultFallback = "defaultFallbackHandle", fallbackClass = {ExceptionUtils.class})
    public ObjectResponse<List<InvoiceParksDto>> getInvoiceParkListV2(InvoiceRequest invoiceRequest) {
        Long startTime = null;
        Long endTime = null;
        if (Objects.nonNull(invoiceRequest.getStartTime())) startTime = invoiceRequest.getStartTime().getTime() / 1000;
        if (Objects.nonNull(invoiceRequest.getEndTime())) endTime = invoiceRequest.getEndTime().getTime() / 1000;
        List<InvoiceParksDto> responseList = orderPayDao.selectNoInvoiceParkListByPlateNum(DateRangeUtils.getYearQuarterRangeTableName(invoiceRequest.getStartTime()), null, invoiceRequest.getAccountId(), null, Collections.emptyList(), startTime, endTime);
        if (CollectionUtils.isEmpty(responseList)) {
            return ObjectResponse.failed(CodeConstantsEnum.ERROR_404.getCode(), "暂时未找到可开票车场");
        }
        return ObjectResponse.success(responseList);
    }

    @Override
    public ObjectResponse<OrderPay> getByTradeNo(String tradeNo) {
        OrderPay orderPay = orderPayDao.selectLimitOne(getLambdaQueryWrapper().eq(OrderPay::getTradeNo, tradeNo));
        return ObjectResponse.returnNotFoundIfNull(orderPay);
    }

    @Override
    public ObjectResponse<List<OrderPay>> getListByTradeNos(List<String> tradeNos) {
        List<OrderPay> payList = orderPayDao.selectListByTradeNos(tradeNos);
        return ObjectResponse.success(payList);
    }

    @Override
    public ObjectResponse<List<OrderPay>> getListWithHistoryByTradeNos(List<String> tradeNos) {
        Date startDate = DateUtil.offsetDay(DateUtil.date(), -365);
        List<OrderPay> payList = orderPayDao.selectListWithHistoryByTradeNos(
                DateRangeUtils.getYearQuarterRangeTableName(startDate), tradeNos);
        return ObjectResponse.returnNotFoundIfEmpty(payList);
    }

    @Override
    public ObjectResponse<Void> batchUpdateInvoiceStatus(List<String> tradeNos) {
        int count = orderPayDao.updateInvoiceStatus(tradeNos);
        if (tradeNos.size() != count) {
            log.info("准备更新历史表开票状态, tradeNos[{}]", tradeNos);
            Date startDate = DateUtil.offsetDay(DateUtil.date(), -365);
            List<String> list = DateRangeUtils.getYearQuarterRangeTableName(startDate);
            for (String table : list) {
                count = count + orderPayDao.updateHistoryInvoiceStatus(table, tradeNos);
                if (count >= tradeNos.size()) {
                    break;
                }
            }
        }
        return ObjectResponse.success();
    }

    @Override
    @DS_SLAVE
    @SentinelResource(value = "OrderPayService.getInvoiceList2", defaultFallback = "defaultFallbackHandle", fallbackClass = {ExceptionUtils.class})
    public ObjectResponse<PageResult<List<InvoiceQueryResponse>>> getInvoiceList(InvoiceQueryRequest invoiceRequest) {
        Page<List<InvoiceQueryResponse>> page = PageHelper.startPage(invoiceRequest.getPageNo(), invoiceRequest.getPageSize());
        //查询路内开票记录
        List<InvoiceQueryResponse> responseList = orderPayDao.selectInvoiceListByPlateNum(3, invoiceRequest.getPlateNum(), invoiceRequest.getStartTime(), invoiceRequest.getEndTime(), invoiceRequest.getTicketStatuses());
        if (CollectionUtils.isEmpty(responseList)) {
            return ObjectResponse.failed(CodeConstantsEnum.ERROR_404.getCode(), "暂时未找到开票记录");
        }
        return ObjectResponse.success( new PageResult(page, responseList));
    }

    /**
     * 释放车位数
     * @param orderDiscount
     * @return
     */
    public boolean addDiscountSpaceNum(OrderDiscount orderDiscount) {
        try {
            if (orderDiscount.getMerchantId()==null || orderDiscount.getFrom().equals(2)){
                return Boolean.TRUE;
            }
            //查询车辆的优惠类型
            Integer type = orderDiscount.getType();
            if (DiscountTypeEnum.按天优免.getType().equals(type)){
                return Boolean.TRUE;
            }

            ParkMerchant parkMerchant = new ParkMerchant();
            parkMerchant.setId(Math.toIntExact(orderDiscount.getMerchantId()));
            parkMerchant = parkMerchantDao.selectById(parkMerchant);
            Integer spaceNum = parkMerchant.getSpaceNum();
            if (Objects.isNull(spaceNum)){
                return true;
            }
            spaceNum++;
            parkMerchant.setSpaceNum(spaceNum);
            log.info("当前商户[{}]释放后车位数[{}]", parkMerchant.getName(), parkMerchant.getSpaceNum());
            parkMerchantDao.update(parkMerchant);

            return true;
        }catch (Exception e){
            log.error("[释放空车位]处理失败: {}. orderDiscount[{}]", e.getMessage(), orderDiscount, e);
            return false;
        }

    }

    @Override
    public ObjectResponse<List<OrderPay>> getOrderPayListBy(Long parkId, List<String> orderNums, Integer payStatus) {
        LambdaQueryWrapper<OrderPay> queryWrapper = Wrappers.lambdaQuery(OrderPay.class);
        if (Objects.nonNull(parkId)) {
            queryWrapper.eq(OrderPay::getParkId, parkId);
        }
        if (CollectionUtils.isNotEmpty(orderNums)) {
            queryWrapper.in(OrderPay::getOrderNum, orderNums);
        }
        if (Objects.nonNull(payStatus)) {
            queryWrapper.eq(OrderPay::getPayStatus, payStatus);
        }else {
            queryWrapper.eq(OrderPay::getPayStatus, 2);
        }
        List<OrderPay> orderPays = orderPayDao.selectList(queryWrapper);
        if (CollectionUtil.isEmpty(orderPays)) {
            return ObjectResponse.failed(CodeConstants.ERROR_404);
        }
        return ObjectResponse.success(orderPays);
    }

    public int updateStatus(OrderPayQuery orderPayQuery) {
        return orderPayDao.updateStatus(orderPayQuery);
    }

    private int convertRoadPayWay(Integer parkPayWay) {
        if (PayWayContants.CASH.equals(parkPayWay))
            return PayWayConstant.CASH;
        if (PayWayContants.WECHAT.equals(parkPayWay))
            return PayWayConstant.WECHAT;
        if (PayWayContants.ALIPAY.equals(parkPayWay))
            return PayWayConstant.ALIPAY;
        if (PayWayContants.UNIONPAY.equals(parkPayWay))
            return PayWayConstant.UNION_PAY;
        if (PayWayContants.ETC.equals(parkPayWay))
            return PayWayConstant.ETC_PAY;

        return PayWayConstant.OTHER;
    }

    /**
     * 缴费渠道1本地出口支付,2 H5扫码支付,3自助缴费机,4中央收费站,5第三方,6运维管理APP,7免密支付,8停车机器人,9公众号缴费,10遥控器 12.同程小程序
     * @see OrderPay#getPayChannel()
     */
    private int convertRoadPayChannel(Integer parkPayChannel) {
        if (parkPayChannel == null)
            return PayChannelConstant.OTHER;
        if (parkPayChannel == 2)
            return PayChannelConstant.H5_QRCODE;
        if (parkPayChannel == 9)
            return PayChannelConstant.WECHAT_OFFICIAL_ACCOUNT;
        return PayChannelConstant.OTHER;
    }

    private int convertRoadPayAlias(Integer parkPayAlias) {
        if (PayAisleEnum.WX.getType().equals(parkPayAlias))
            return PayAisleConstant.WECHAT;
        if (PayAisleEnum.ALI.getType().equals(parkPayAlias))
            return PayAisleConstant.ALIPAY;
//        if (PayAisleEnum.WX.getType().equals(parkPayWay))
//            return PayAisleConstant.INDUSTRIAL_BANK;
        return PayAisleConstant.OTHER;
    }
}
