package com.icetech.park.service.order.impl;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.google.common.collect.Lists;
import com.icetech.basics.dao.VipTypeDao;
import com.icetech.basics.dao.park.ParkRegionDao;
import com.icetech.basics.domain.entity.park.ParkInoutdevice;
import com.icetech.basics.domain.entity.park.ParkRegion;
import com.icetech.basics.service.park.impl.ParkServiceImpl;
import com.icetech.cloudcenter.api.constants.MqConstants;
import com.icetech.cloudcenter.api.store.StoreCardService;
import com.icetech.cloudcenter.domain.charge.dto.OrderSumFeeDto;
import com.icetech.cloudcenter.domain.order.query.OrderPayCondition;
import com.icetech.cloudcenter.domain.order.query.OrderPayQuery;
import com.icetech.cloudcenter.domain.request.ExitCommonRequest;
import com.icetech.cloudcenter.domain.request.ExitRequest;
import com.icetech.cloudcenter.domain.response.QueryFeeRegionDetail;
import com.icetech.cloudcenter.domain.response.VipTypeDto;
import com.icetech.cloudcenter.domain.vo.ApplyCarVideoVo;
import com.icetech.cloudcenter.domain.vo.NotPayDetailVo;
import com.icetech.common.constants.DiscountTypeEnum;
import com.icetech.common.constants.OrderCarInfoConstant;
import com.icetech.common.constants.PayChannelConstants;
import com.icetech.common.constants.PayStatusConstants;
import com.icetech.common.constants.SqlConstant;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.utils.CodeTools;
import com.icetech.common.utils.JsonUtils;
import com.icetech.common.utils.NumberUtils;
import com.icetech.common.utils.StringUtils;
import com.icetech.fee.domain.entity.storecard.StoreCard;
import com.icetech.mq.sender.RabbitSender;
import com.icetech.order.dao.OrderInfoDao;
import com.icetech.order.domain.entity.OrderDiscount;
import com.icetech.order.domain.entity.OrderInfo;
import com.icetech.order.domain.entity.OrderNotpay;
import com.icetech.order.domain.entity.OrderPay;
import com.icetech.order.domain.entity.OrderPayDetail;
import com.icetech.order.domain.entity.OrderPayDiscount;
import com.icetech.order.domain.entity.OrderSonInfo;
import com.icetech.order.service.OrderNotpayService;
import com.icetech.order.service.OrderPayDiscountService;
import com.icetech.order.service.impl.OrderDiscountServiceImpl;
import com.icetech.order.service.impl.OrderPayDetailServiceImpl;
import com.icetech.park.domain.entity.park.Park;
import com.icetech.park.service.handle.MorCacheHandle;
import com.icetech.paycenter.domain.PlatformPayType;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * Description : 离场时支付记录的处理业务
 *
 * @author fangct
 */
@Slf4j
@Service
public class ExitPayDealServiceImpl {
    @Autowired
    private OrderPayServiceImpl orderPayService;
    @Autowired
    private OrderPayDetailServiceImpl orderPayDetailService;
    @Autowired
    private OrderDiscountServiceImpl orderDiscountService;
    @Autowired
    private ParkServiceImpl parkService;
    @Autowired
    private ParkRegionDao parkRegionDao;
    @Resource
    private StoreCardService storeCardService;

    @Autowired
    private OrderNotpayService orderNotpayService;
    @Autowired
    private OrderInfoDao orderInfoDao;
    @Autowired
    private VipTypeDao vipTypeDao;
    @Autowired
    private OrderPayDiscountService orderPayDiscountService;
    @Autowired
    private MorCacheHandle morCacheHandle;
    @Autowired
    private RabbitSender rabbitSender;
    @Value("${aisle.applyCarVideo.time:30}")
    private Integer aisleApplyCarVideoTime;

    public void handleNotPayOrder(ExitCommonRequest exitRequest, OrderInfo orderInfo, ParkInoutdevice channel, String parkCode) {
        if (parkCode == null) {
            ObjectResponse<Park> parkObjectResponse = parkService.findByParkId(orderInfo.getParkId());
            if (parkObjectResponse.getData() != null) {
                parkCode = parkObjectResponse.getData().getParkCode();
            }
        }

        // 欠费记录订单处理
        Integer notPayStatus = exitRequest.getNotPayStatus();

        OrderNotpay orderNotpay = orderNotpayService.getOne(Wrappers.lambdaQuery(OrderNotpay.class)
                .eq(OrderNotpay::getOrderNum, orderInfo.getOrderNum())
                .eq(OrderNotpay::getStatus, 1));
        boolean otherChannelNotPay = orderNotpay != null && !channel.getId().equals(orderNotpay.getChannelId());
        if (otherChannelNotPay || Integer.valueOf(1).equals(notPayStatus)) {
            log.info("[欠费追缴]订单上报,车牌号[{}],订单号[{}],上报的欠费订单应收金额[{}], 上报欠费订单优惠金额[{}],上报的欠费订单需支付金额[{}];订单应收金额[{}],订单的优惠金额[{}],订单需支付金额[{}]",
                    exitRequest.getPlateNum(), orderInfo.getOrderNum(), exitRequest.getNotPayTotalPrice(),
                    exitRequest.getNotPayDiscountPrice(), exitRequest.getNotPayUnpayPrice(), orderInfo.getTotalPrice(), orderInfo.getDiscountPrice(), orderInfo.getPaidPrice());
            String serialNumber = morCacheHandle.getSerialNumber(parkCode, channel.getInandoutCode());
            String videoId = CodeTools.getCharAndNumr(16);
            if (serialNumber == null) {
                if (Objects.isNull(orderNotpay)) {
                    OrderNotpay notPay = new OrderNotpay();
                    notPay.setOrderNum(orderInfo.getOrderNum());
                    notPay.setParkId(exitRequest.getParkId());
                    notPay.setPlateNum(exitRequest.getPlateNum());
                    notPay.setType(exitRequest.getType());
                    notPay.setEnterTime(NumberUtils.toPrimitive(orderInfo.getNoneEnterFlag()) == 0
                            ? orderInfo.getEnterTime() : null);
                    notPay.setExitTime(exitRequest.getExitTime());
                    notPay.setCarType(exitRequest.getCarType());
                    notPay.setTotalPrice(new BigDecimal(orderInfo.getTotalPrice()).subtract(new BigDecimal(orderInfo.getPaidPrice()))
                            .setScale(2, BigDecimal.ROUND_HALF_UP));
                    notPay.setPaidPrice(BigDecimal.ZERO);
                    notPay.setDiscountPrice(BigDecimal.ZERO);
                    notPay.setStatus(1);
                    // 获取 lastPayTime
                    ObjectResponse<List<OrderPay>> paysObj = orderPayService.selectByOrderNum(orderInfo.getOrderNum());
                    if (ObjectResponse.isSuccess(paysObj)) {
                        List<OrderPay> pays = paysObj.getData();
                        if (CollectionUtils.isNotEmpty(pays)) {
                            Optional<Long> maxPayTime = pays.stream()
                                    .map(OrderPay::getPayTime)
                                    .filter(Objects::nonNull)
                                    .max(Long::compareTo);
                            maxPayTime.ifPresent(notPay::setLastPayTime);
                        }
                    }
                    notPay.setVideoId(videoId);
                    notPay.setChannelId(channel.getId());
                    //更新大额欠费订单状态
                    orderNotpayService.largeOrder(notPay);
                    orderNotpayService.addOrderNotpay(notPay);
                } else {
                    // 修改欠费记录
                    OrderNotpay updatePay = new OrderNotpay();
                    updatePay.setId(orderNotpay.getId());
                    updatePay.setTotalPrice(new BigDecimal(orderInfo.getTotalPrice()).subtract(new BigDecimal(orderInfo.getPaidPrice()))
                            .setScale(2, BigDecimal.ROUND_HALF_UP));
                    updatePay.setPaidPrice(BigDecimal.ZERO);
                    updatePay.setDiscountPrice(BigDecimal.ZERO);
                    updatePay.setVideoId(videoId);
                    updatePay.setChannelId(channel.getId());
                    //更新大额欠费订单状态
                    orderNotpayService.largeOrder(updatePay);
                    orderNotpayService.updateById(updatePay);
                    log.info("[端网云-离场服务] 更新欠费订单, 订单[{}], 原欠费金额[{}], 最新欠费[{}]",
                            orderNotpay.getOrderNum(),
                            orderNotpay.getPaidPrice(),
                            exitRequest.getNotPayUnpayPrice());
                }
            } else {
                ApplyCarVideoVo vo = new ApplyCarVideoVo();
                vo.setVideoType(1);
                vo.setSn(serialNumber);
                vo.setChannelId(channel.getId());
                vo.setOrderNum(orderInfo.getOrderNum());
                vo.setParkId(orderInfo.getParkId());
                vo.setPlateNum(orderInfo.getPlateNum());
                vo.setVideoId(videoId);
                vo.setRecTime(exitRequest.getExitTime());
                vo.setNotPayPrice(new BigDecimal(orderInfo.getTotalPrice()).subtract(new BigDecimal(orderInfo.getPaidPrice()))
                        .setScale(2, BigDecimal.ROUND_HALF_UP));
                vo.setLastPayTime(null);
                vo.setType(exitRequest.getType());
                vo.setCarType(exitRequest.getCarType());
                rabbitSender.sendMessage(MqConstants.Exchange.AISLE_DELAYED_EXCHANGE,
                        MqConstants.Routing.APPLY_CAR_VIDEO_ROUTING, vo, aisleApplyCarVideoTime * 1000L);
                log.info("[端网云-出口] 请求视频延迟消息发送, [{}]", vo);
            }
        } else {
            // 异常订单处理
            if (Objects.nonNull(orderNotpay)) {
                if (exitRequest.getExceptionReason() != null && OrderCarInfoConstant.IN_OUT_WAY_SOFTWARE_MANUAL == exitRequest.getExceptionReason()) {
                    OrderNotpay update = new OrderNotpay();
                    update.setId(orderNotpay.getId());
                    update.setStatus(3);
                    update.setOperAccount(exitRequest.getOperAccount());
                    update.setOperTime(new Date());
                    orderNotpayService.updateById(update);
                } else {
                    // 删除欠费订单
                    orderNotpayService.deleteByOrderNum(orderInfo.getOrderNum());
                }
            }
        }
    }

    @Transactional
    public OrderInfo exitPayDeal(ExitCommonRequest exitRequest, OrderInfo orderInfo, List<OrderSonInfo> orderSonInfos) {
        int paySize = exitRequest.getPaidInfo().size();
        // 添加子订单
        if (paySize > 0) {
            Long lastPayTime = null;
            //支付记录有多条时，按支付时间正排序
            if (paySize > 1) {
                exitRequest.getPaidInfo().sort(Comparator.comparingLong(ExitCommonRequest.PaidInfo::getPayTime));
            }
            Set<String> tradeNos = new HashSet<>(exitRequest.getPaidInfo().size());
            Set<String> discountNos = new HashSet<>(exitRequest.getPaidInfo().size());
            Set<String> regionCodes = new HashSet<>(exitRequest.getPaidInfo().size());
            AmountInfo totalAmount = new AmountInfo();
            Map<Long, OrderSonInfo> orderSonInfoMap = null;     // RegionId :: OrderSonInfo
            Map<Long, AmountInfo> orderSonAmountMap = null;     // RegionId :: AmountInfo
            if (CollectionUtils.isEmpty(orderSonInfos)) {
                orderSonInfoMap = Collections.emptyMap();
                orderSonAmountMap = Collections.emptyMap();
            } else {
                orderSonInfoMap = new HashMap<>(orderSonInfos.size());
                orderSonAmountMap = new HashMap<>(orderSonInfos.size());
                for (OrderSonInfo orderSonInfo : orderSonInfos) {
                    orderSonInfoMap.put(orderSonInfo.getRegionId(), orderSonInfo);
                    orderSonAmountMap.put(orderSonInfo.getRegionId(), new AmountInfo());
                }
            }
            for (ExitCommonRequest.PaidInfo paidInfo : exitRequest.getPaidInfo()) {
                tradeNos.add(paidInfo.getTradeNo());
                if (CollectionUtils.isNotEmpty(paidInfo.getDiscountInfo())) {
                    for (ExitCommonRequest.DiscountInfo discountInfo : paidInfo.getDiscountInfo()) {
                        discountNos.add(discountInfo.getDiscountNo());
                    }
                }
                if (CollectionUtils.isNotEmpty(paidInfo.getRegionDetails())) {
                    paidInfo.getRegionDetails().stream().map(QueryFeeRegionDetail::getRegionCode).collect(Collectors.toCollection(() -> regionCodes));
                }
            }
            // TradeNo :: List<OrderPayDetail>
            Map<String, Map<Long, OrderPayDetail>> orderPayDetailMap = Collections.emptyMap();
            if (!regionCodes.isEmpty()) {
                orderPayDetailMap = orderPayDetailService.list(orderPayDetailService.getLambdaQueryWrapper()
                                .eq(OrderPayDetail::getParkId, orderInfo.getParkId())
                                .eq(OrderPayDetail::getOrderNum, orderInfo.getOrderNum()))
                        .stream().collect(Collectors.groupingBy(OrderPayDetail::getTradeNo, Collectors.toMap(OrderPayDetail::getRegionId, Function.identity(), (older, newer) -> newer, HashMap::new)));
            }
            List<OrderPay> orderPays = orderPayService.list(orderPayService.getLambdaQueryWrapper()
                    .eq(OrderPay::getParkId, orderInfo.getParkId())
                    .in(OrderPay::getTradeNo, tradeNos));
            // TradeNo :: OrderPay
            Map<String, OrderPay> orderPayMap = orderPays.stream().collect(Collectors.toMap(OrderPay::getTradeNo, Function.identity(), (older, newer) -> newer, HashMap::new));
            // DiscountNo :: OrderDiscount
            Map<String, OrderDiscount> orderDiscountMap = discountNos.isEmpty() ? Collections.emptyMap() :
                    orderDiscountService.list(orderDiscountService.getLambdaQueryWrapper()
                                    .eq(OrderDiscount::getParkId, orderInfo.getParkId())
                                    .eq(OrderDiscount::getOrderNum, orderInfo.getOrderNum())
                                    .eq(OrderDiscount::getDelFlag,0)
                                    .in(OrderDiscount::getDiscountNo, discountNos))
                            .stream().collect(Collectors.toMap(OrderDiscount::getDiscountNo, Function.identity(), (older, newer) -> newer, HashMap::new));
            //  // RegionCode :: RegionId
            Map<String, Long> parkRegionMap = regionCodes.isEmpty() ? Collections.emptyMap() :
                    parkRegionDao.selectList(Wrappers.lambdaQuery(ParkRegion.class)
                                    .eq(ParkRegion::getParkId, orderInfo.getParkId())
                                    .in(ParkRegion::getRegionCode, regionCodes))
                            .stream().collect(Collectors.toMap(ParkRegion::getRegionCode, ParkRegion::getId, (older, newer) -> newer, HashMap::new));
            List<OrderPay> addOrderPays = new LinkedList<>();
            List<OrderPay> updateOrderPays = new LinkedList<>();
            List<OrderPayDetail> addOrderPayDetails = new LinkedList<>();
            List<OrderPayDetail> updateOrderPayDetails = new LinkedList<>();
            List<OrderDiscount> addDiscounts = new LinkedList<>();
            boolean calcRegionAmount = false;
            // 定义补缴内容
            List<NotPayDetailVo> nendPayList = new ArrayList<>();
            for (ExitCommonRequest.PaidInfo paidInfo : exitRequest.getPaidInfo()) {
                String tradeNo = paidInfo.getTradeNo();
                OrderPay existsOrderPay = orderPayMap.get(tradeNo);
                if (existsOrderPay == null) {
                    //处理优惠信息
                    List<ExitRequest.DiscountInfo> discountInfos = paidInfo.getDiscountInfo();
                    List<String> discountList = Lists.newArrayList();
                    if (discountInfos != null && discountInfos.size() > 0) {
                        for (ExitRequest.DiscountInfo discountInfo : discountInfos) {
                            OrderDiscount existsDiscount = orderDiscountMap.get(discountInfo.getDiscountNo());
                            if (existsDiscount == null) {
                                // 添加优惠记录
                                OrderDiscount orderDiscount = buildOrderDiscount(tradeNo, orderInfo, discountInfo);
                                if (orderDiscount != null) {
                                    addDiscounts.add(orderDiscount);
                                }
                            } else if (existsDiscount.getStatus().equals(0) || existsDiscount.getStatus().equals(3)) {
//                            orderPayService.useDiscount(discountPrice, orderInfo.getParkId(), tradeNo, paidInfo.getPayTime(), orderInfo.getOrderNum(), existsDiscount);
                                discountList.add(existsDiscount.getDiscountNo());
                            }
                        }
                        if (CollectionUtils.isNotEmpty(discountList)){
                            BigDecimal discountPrice = NumberUtils.parseDecimal(paidInfo.getDiscountPrice());
                            if (NumberUtils.parseDouble(paidInfo.getVipDiscountPrice()) > 0) {
                                discountPrice = discountPrice.subtract(new BigDecimal(paidInfo.getVipDiscountPrice()))
                                        .setScale(2, BigDecimal.ROUND_HALF_UP);
                            }
                            if (Integer.valueOf(9).equals(exitRequest.getExceptionReason())
                                    && NumberUtils.parseDouble(paidInfo.getTollDiscountPrice()) > 0) {
                                discountPrice = discountPrice.subtract(new BigDecimal(paidInfo.getTollDiscountPrice()))
                                        .setScale(2, BigDecimal.ROUND_HALF_UP);
                            }
                            orderPayService.useDiscount(orderInfo.getParkId(), orderInfo.getOrderNum(), discountPrice.doubleValue(),
                                    paidInfo.getTradeNo(),paidInfo.getPayTime(),discountList, null);
                        }
                    }
                    OrderPay orderPay = buildOrderPay(tradeNo, orderInfo, paidInfo,discountList);
                    //保存支付明细的优惠记录
                    addOrderPayDiscount(orderPay, orderInfo, paidInfo,discountList, exitRequest);
                    //lastPayTime参数的设置
                    orderPay.setLastPayTime(lastPayTime);
                    if (NumberUtils.parseDouble(paidInfo.getBalancePrice()) > 0) {
                        orderPay.setBalancePrice(BigDecimal.valueOf(paidInfo.getBalancePrice()));
                        ObjectResponse<StoreCard> storeCardResp = storeCardService.deductStoreCard(exitRequest, paidInfo, orderInfo);
                        if (ObjectResponse.isSuccess(storeCardResp)) {
                            orderPay.setCardNum(storeCardResp.getData().getCardsNum());
                        } else {
                            log.warn("储值卡余额扣除失败: {}, {}", storeCardResp.getCode(), storeCardResp.getMsg());
                        }
                    }
                    // 设置补缴
                    if (paidInfo.getPayType() != null && paidInfo.getPayType() == 1) {
                        orderPay.setPayType(1);
                        nendPayList.add(NotPayDetailVo.builder()
                                .orderNum(orderInfo.getOrderNum())
                                .totalPrice(paidInfo.getTotalPrice())
                                .unPayPrice(paidInfo.getPaidPrice())
                                .discountPrice(paidInfo.getDiscountPrice())
                                .build());
                    }
                    //是否先离场后付费
                    boolean isCityAutoPay = false;
                    if (PayChannelConstants.AUTO_PAY.equals(paidInfo.getPayChannel())) {
                        if (orderInfo instanceof OrderSonInfo) {
                            OrderInfo orderInfoMain = orderInfoDao.selectByOrderNum(orderInfo.getOrderNum());
                            if (orderInfoMain != null) {
                                if (Integer.valueOf(1).equals(orderInfoMain.getCityAutopay())) {
                                    isCityAutoPay = true;
                                }
                            }
                        } else {
                            if (Integer.valueOf(1).equals(orderInfo.getCityAutopay())) {
                                isCityAutoPay = true;
                            }
                        }
                    }
                    if (!isCityAutoPay) {
                        addOrderPays.add(orderPay);
                    }
                    existsOrderPay = orderPay;
                }
                //上次支付时间
                lastPayTime = paidInfo.getPayTime();
                if (CollectionUtils.isEmpty(paidInfo.getRegionDetails())    // 分账信息为空
                        && NumberUtils.toPrimitive(orderInfo.getHasSon()) == 1  // 含有子订单
                        && orderSonInfoMap.size() == 2) {   // 子订单数量为2
                    if (paySize == 1) { // 支付笔数为1, 模拟分账
                        OrderPay orderPay = existsOrderPay;
                        List<QueryFeeRegionDetail> virtualRegionDetails = orderSonInfoMap.values().stream().map(orderSonInfo -> {
                            QueryFeeRegionDetail regionDetail = new QueryFeeRegionDetail()
                                    .setRegionId(orderSonInfo.getRegionId())
                                    .setOrderSonId(orderSonInfo.getId())
                                    .setEnterTime(orderSonInfo.getEnterTime())
                                    .setPlateType(orderSonInfo.getType());
                            if (orderSonInfo.getRegionId().equals(orderInfo.getRegionId())) {   // 主订单对应的子订单
                                regionDetail.setTotalAmount(exitRequest.getTotalAmount())
                                        .setDiscountPrice(exitRequest.getDiscountAmount())
                                        .setPaidPrice(exitRequest.getPaidAmount());
                            } else {
                                regionDetail.setTotalAmount(NumberUtils.decimalSubtract(orderPay.getTotalPrice(), exitRequest.getTotalAmount()).toString())
                                        .setDiscountPrice(NumberUtils.decimalSubtract(orderPay.getDiscountPrice(), exitRequest.getDiscountAmount()).toString())
                                        .setPaidPrice(NumberUtils.decimalSubtract(orderPay.getPaidPrice(), exitRequest.getPaidAmount()).toString());
                            }
                            return regionDetail;
                        }).collect(Collectors.toList());
                        paidInfo.setRegionDetails(virtualRegionDetails);
                    } else {    // 多笔支付，仅计算区域订单金额
                        calcRegionAmount = true;
                    }
                }

                // 添加分账信息
                if (CollectionUtils.isNotEmpty(paidInfo.getRegionDetails())) {
                    Map<Long, OrderPayDetail> payDetailMap = orderPayDetailMap.get(paidInfo.getTradeNo());
                    if (payDetailMap == null) payDetailMap = Collections.emptyMap();
                    List<OrderPayDetail> newOrderPayDetails = handleOrderPayDetails(existsOrderPay, orderSonInfoMap, parkRegionMap, payDetailMap,
                            paidInfo.getRegionDetails(), orderSonAmountMap, orderInfo, updateOrderPayDetails);
                    if (!newOrderPayDetails.isEmpty()) {
                        if (existsOrderPay.getId() == null) {
                            existsOrderPay.setIsSonOrderpay(1);
                        } else {
                            updateOrderPays.add(new OrderPay().setId(existsOrderPay.getId()).setIsSonOrderpay(1));
                        }
                    }
                    addOrderPayDetails.addAll(newOrderPayDetails);
                }

                totalAmount.totalPrice = NumberUtils.decimalAdd(totalAmount.totalPrice, paidInfo.getTotalPrice());
                if (!(
                        Integer.valueOf(1).equals(orderInfo.getCityAutopay())
                        && PayChannelConstants.AUTO_PAY.equals(paidInfo.getPayChannel())
                    )
                ) {
                    totalAmount.paidPrice = NumberUtils.decimalAdd(totalAmount.paidPrice, paidInfo.getPaidPrice());
                } else {
                    OrderPayCondition orderPayCondition = new OrderPayCondition();
                    orderPayCondition.setParkId(orderInfo.getParkId());
                    orderPayCondition.setPayStatus(2);
                    orderPayCondition.setOrderNum(orderInfo.getOrderNum());
                    ObjectResponse<OrderSumFeeDto> objectResponse = orderPayService.getSumPay(orderPayCondition);
                    if (ObjectResponse.isSuccess(objectResponse)) {
                        BigDecimal sumPaidPrice = new BigDecimal(String.valueOf(objectResponse.getData().getPaidPrice()));
                        log.info("[无感支付]先离场后付费,离场上报金额:{},订单支付金额:{}",exitRequest.getPaidAmount(), sumPaidPrice);
                        if (new BigDecimal(exitRequest.getPaidAmount()).compareTo(sumPaidPrice) == 0) {
                            totalAmount.paidPrice = NumberUtils.decimalAdd(totalAmount.paidPrice, paidInfo.getPaidPrice());
                            log.info("[无感支付]金额相同最后金额为:{}",totalAmount.paidPrice);
                        }
                    }
                }
                totalAmount.discountPrice = NumberUtils.decimalAdd(totalAmount.discountPrice, paidInfo.getDiscountPrice());
                totalAmount.balancePrice = NumberUtils.decimalAdd(totalAmount.balancePrice, paidInfo.getBalancePrice());
            }

            if (!addOrderPays.isEmpty()) {
                orderPayService.saveBatch(addOrderPays);
                log.info("[离场服务] 插入订单交易记录完成，orderNum：{}", orderInfo.getOrderNum());
            }
            if (!updateOrderPays.isEmpty()) {
                orderPayService.updateBatchById(updateOrderPays);
                log.info("[离场服务] 更新订单交易记录完成，orderNum：{}", orderInfo.getOrderNum());
            }
            if (!addOrderPayDetails.isEmpty()) {
                orderPayDetailService.saveBatch(addOrderPayDetails);
                log.info("[离场服务] 插入订单交易分账记录完成，orderNum：{}", orderInfo.getOrderNum());
            }
            if (!updateOrderPayDetails.isEmpty()) {
                orderPayDetailService.updateBatchById(updateOrderPayDetails);
                log.info("[离场服务] 插入订单交易分账记录完成，orderNum：{}", orderInfo.getOrderNum());
            }
            if (!addDiscounts.isEmpty()) {
                orderDiscountService.saveBatch(addDiscounts);
                log.info("[离场服务] 插入订单优惠记录完成，orderNum：{}", orderInfo.getOrderNum());
            }
            // 补缴记录处理
            if (CollectionUtils.isNotEmpty(nendPayList)) {
                orderNotpayService.updatePaidByOrderNums(nendPayList, exitRequest.getPayChannelId(), exitRequest.getOperAccount());
            }
            fillAmount(orderInfo, totalAmount); // 填充回填总金额信息
            if (calcRegionAmount) { // 计算区域订单金额
                for (OrderSonInfo orderSonInfo : orderSonInfoMap.values()) {
                    AmountInfo amountInfo = orderSonAmountMap.get(orderSonInfo.getRegionId());
                    if (orderSonInfo.getRegionId().equals(orderInfo.getRegionId())) {   // 主订单对应的子订单
                        amountInfo.totalPrice = NumberUtils.parseDecimal(exitRequest.getTotalAmount());
                        amountInfo.discountPrice = NumberUtils.parseDecimal(exitRequest.getDiscountAmount());
                        amountInfo.paidPrice = NumberUtils.parseDecimal(exitRequest.getPaidAmount());
                        amountInfo.balancePrice = NumberUtils.parseDecimal(exitRequest.getBalancePrice());
                    } else {
                        amountInfo.totalPrice = NumberUtils.decimalSubtract(totalAmount.totalPrice, exitRequest.getTotalAmount());
                        amountInfo.discountPrice = NumberUtils.decimalSubtract(totalAmount.discountPrice, exitRequest.getDiscountAmount());
                        amountInfo.paidPrice = NumberUtils.decimalSubtract(totalAmount.paidPrice, exitRequest.getPaidAmount());
                        amountInfo.balancePrice = NumberUtils.decimalSubtract(totalAmount.balancePrice, exitRequest.getBalancePrice());
                    }
                }
            }
            for (Map.Entry<Long, OrderSonInfo> orderSonInfoEntry : orderSonInfoMap.entrySet()) {    // 回填分账后的金额信息
                OrderSonInfo orderSonInfo = orderSonInfoEntry.getValue();
                AmountInfo amountInfo = orderSonAmountMap.get(orderSonInfoEntry.getKey());
                fillAmount(orderSonInfo, amountInfo);
            }
        }

        // 修改无效交易记录状态
        OrderPayQuery orderPayQuery = new OrderPayQuery();
        orderPayQuery.setOrderNum(orderInfo.getOrderNum());
        orderPayQuery.setOldPayStatus(PayStatusConstants.PAYING);
        orderPayQuery.setNewPayStatus(PayStatusConstants.CANCEL);
        int i = orderPayService.updateStatus(orderPayQuery);
        // 修改无效交易记录分账状态
        OrderPayDetail updateDetail = new OrderPayDetail();
        updateDetail.setOrderNum(orderInfo.getOrderNum());
        updateDetail.setPayStatus(PayStatusConstants.CANCEL);
        orderPayDetailService.update(updateDetail, orderPayDetailService.getLambdaQueryWrapper()
                .eq(OrderPayDetail::getOrderNum, orderInfo.getOrderNum())
                .eq(OrderPayDetail::getPayStatus, PayStatusConstants.PAYING));
        log.info("[离场服务] 修改无效交易记录状态，影响{}条记录，orderNum：{}", i, orderInfo.getOrderNum());

        return orderInfo;
    }

    private List<OrderPayDetail> handleOrderPayDetails(OrderPay orderPay, Map<Long, OrderSonInfo> orderSonInfoMap,
                                                       Map<String, Long> parkRegionMap, Map<Long, OrderPayDetail> orderPayDetailMap,
                                                       List<QueryFeeRegionDetail> regionDetails, Map<Long, AmountInfo> orderSonAmountMap,
                                                       OrderInfo orderInfo, List<OrderPayDetail> updateOrderPayDetails) {
        List<OrderPayDetail> addOrderPayDetails = new LinkedList<>();
        for (QueryFeeRegionDetail regionDetail : regionDetails) {
            Long regionId = regionDetail.getRegionId() == null ? parkRegionMap.get(regionDetail.getRegionCode()) : regionDetail.getRegionId();
            if (regionId == null) {
                log.info("无法找到对应区域信息|{}|{}", orderPay.getOrderNum(), regionDetail.getRegionCode());
                continue;
            }
            OrderSonInfo orderSonInfo = orderSonInfoMap.get(regionId);
            if (orderPayDetailMap.containsKey(regionId)) {
                OrderPayDetail orderPayDetail = new OrderPayDetail();
                OrderPayDetail dbDetail = orderPayDetailMap.get(regionId);
                orderPayDetail.setId(dbDetail.getId());
                if (orderSonInfo == null) {
                    orderPayDetail.setExitTime(orderInfo.getExitTime());
                } else {
                    orderPayDetail.setExitTime(orderSonInfo.getExitTime());
                }
                updateOrderPayDetails.add(orderPayDetail);
            } else {
                regionDetail.setRegionId(regionId);
                regionDetail.setPlateNum(orderInfo.getPlateNum());
                if (orderSonInfo == null) {
                    regionDetail.setEnterTime(orderInfo.getEnterTime());
                    regionDetail.setExitTime(orderInfo.getExitTime());
                    regionDetail.setPlateType(orderInfo.getType());
                } else {
                    regionDetail.setOrderSonId(orderSonInfo.getId());
                    regionDetail.setEnterTime(orderSonInfo.getEnterTime());
                    regionDetail.setExitTime(orderSonInfo.getExitTime());
                    regionDetail.setPlateType(orderSonInfo.getType());
                }
                OrderPayDetail detail = buildOrderPayDetail(orderPay, regionDetail);
                addOrderPayDetails.add(detail);
            }
            AmountInfo amountInfo = orderSonAmountMap.get(regionId);
            if (amountInfo != null) {
                amountInfo.totalPrice = NumberUtils.decimalAdd(amountInfo.totalPrice, regionDetail.getTotalAmount());
                amountInfo.discountPrice = NumberUtils.decimalAdd(amountInfo.discountPrice, regionDetail.getDiscountPrice());
                amountInfo.paidPrice = NumberUtils.decimalAdd(amountInfo.paidPrice, regionDetail.getPaidPrice());
                amountInfo.balancePrice = NumberUtils.decimalAdd(amountInfo.balancePrice, regionDetail.getBalancePrice());
            }
        }
        return addOrderPayDetails;
    }

    private void fillAmount(OrderInfo orderInfo, AmountInfo amountInfo) {
        if (amountInfo.totalPrice.compareTo(BigDecimal.ZERO) > 0) {
            orderInfo.setTotalPrice(amountInfo.totalPrice.toString());
            orderInfo.setDiscountPrice(amountInfo.discountPrice.toString());
            orderInfo.setPaidPrice(amountInfo.paidPrice.toString());
            orderInfo.setBalancePrice(amountInfo.balancePrice);
            orderInfo.setNeedPrice(NumberUtils.decimalSubtract(amountInfo.totalPrice, amountInfo.discountPrice, amountInfo.paidPrice, amountInfo.balancePrice).toString());
        }
    }

    private OrderPay buildOrderPay(String tradeNo, OrderInfo orderInfo, ExitCommonRequest.PaidInfo paidInfo,List<String> discountList) {
        OrderPay orderPay = new OrderPay();
        orderPay.setParkId(orderInfo.getParkId());
        orderPay.setOrderNum(orderInfo.getOrderNum());
        orderPay.setTradeNo(tradeNo);
        orderPay.setPayStatus(PayStatusConstants.PAID);
        orderPay.setPayTime(paidInfo.getPayTime());
        orderPay.setOrderTime(paidInfo.getPayTime());
        orderPay.setTotalPrice(paidInfo.getTotalPrice());
        orderPay.setBankOrderId(paidInfo.getBankOrderId());
        orderPay.setThirdTradeNo(paidInfo.getThirdTradeNo());
        orderPay.setPaidPrice(paidInfo.getPaidPrice());
        orderPay.setDiscountPrice(paidInfo.getDiscountPrice());
        orderPay.setPayChannel(paidInfo.getPayChannel());
        orderPay.setPayWay(paidInfo.getPayWay());
        orderPay.setPayTerminal(paidInfo.getPayTerminal());
        orderPay.setUserAccount(paidInfo.getUserAccount());
        orderPay.setActualCash(paidInfo.getActualCash());
        orderPay.setRedpackRet(paidInfo.getRedpackRet());
        orderPay.setIsSync(0);
        //如果是现金缴费，支付通道为空
        if (orderPay.getPayWay() != 1) {
            ObjectResponse<String> response= parkService.selectGroupPayType(parkService.findByParkId(orderInfo.getParkId()).getData().getParkCode());
            if (ObjectResponse.isSuccess(response) && StringUtils.isNotBlank(response.getData())) {
                //设置支付通道
                orderPay.setPayAisle(PlatformPayType.getPayAisle(response.getData(),paidInfo.getPayWay()));
            }
        }
        //处理优惠抵扣
        if (CollectionUtils.isNotEmpty(discountList)) {
            List<OrderDiscount> orderDiscounts = orderDiscountService.list(
                    Wrappers.lambdaQuery(OrderDiscount.class)
                            .eq(OrderDiscount::getParkId, orderInfo.getParkId())
                            .eq(OrderDiscount::getDelFlag, 0)
                            .in(OrderDiscount::getDiscountNo, discountList));
            Set<String> discountNames = orderDiscounts.stream().map(s->StringUtils.isNotBlank(s.getDiscountName())?s.getDiscountName():"").collect(Collectors.toSet());
            String join = StrUtil.join("-", discountNames);
            if (join.length() < 512){
                orderPay.setRemark(join);
            }
            if (NumberUtils.toDouble(orderPay.getPaidPrice()) == 0 && NumberUtils.toDouble(orderPay.getTotalPrice()) > 0) {
                orderPay.setPayWay(10);
            }
        }
        return orderPay;
    }
    private void addOrderPayDiscount(OrderPay orderPay, OrderInfo orderInfo, ExitCommonRequest.PaidInfo paidInfo, List<String> discountList,
                                   ExitCommonRequest exitRequest) {
        if (NumberUtils.parseDouble(paidInfo.getDiscountPrice()) == 0) {
            return;
        }
        String channelId = exitRequest.getChannelId() == null ? exitRequest.getOutChannelId() : exitRequest.getChannelId();
        Integer exceptionReason = exitRequest.getExceptionReason();

        OrderPayDiscount orderPayDiscount = new OrderPayDiscount();
        BeanUtils.copyProperties(orderPay, orderPayDiscount);
        orderPayDiscount.setCarType(orderInfo.getCarType());
        orderPayDiscount.setEnterTime(NumberUtils.toPrimitive(orderInfo.getNoneEnterFlag()) == 1 ? null : orderInfo.getEnterTime());
        orderPayDiscount.setExitChannelId(channelId);
        orderPayDiscount.setExitTime(orderInfo.getEnterTime().equals(orderInfo.getExitTime())
                && Integer.valueOf(6).equals(orderInfo.getOddStatus()) ? null : orderInfo.getExitTime());
        orderPayDiscount.setPlateNum(orderInfo.getPlateNum());
        orderPayDiscount.setType(orderInfo.getType());
        orderPayDiscount.setTotalPrice(NumberUtils.parseDecimal(orderPay.getTotalPrice()));
        orderPayDiscount.setDiscountPrice(NumberUtils.parseDecimal(orderPay.getDiscountPrice()));
        orderPayDiscount.setPaidPrice(NumberUtils.parseDecimal(orderPay.getPaidPrice()));

        //处理优惠抵扣
        if (CollectionUtils.isNotEmpty(discountList)) {
            List<OrderDiscount> orderDiscounts = orderDiscountService.list(
                    Wrappers.lambdaQuery(OrderDiscount.class)
                            .eq(OrderDiscount::getParkId, orderInfo.getParkId())
                            .eq(OrderDiscount::getDelFlag, 0)
                            .in(OrderDiscount::getDiscountNo, discountList));

            if (NumberUtils.parseDouble(paidInfo.getMerchantDiscountPrice()) > 0) {
                OrderPayDiscount.MerchantCouponsInfo merchantCouponsInfo = OrderPayDiscount.getMerchantCouponsInfo(orderDiscounts,
                        NumberUtils.parseDecimal(paidInfo.getMerchantDiscountPrice()));
                orderPayDiscount.addDiscountSource(Integer.valueOf(OrderPayDiscount.DiscountSourceEnum.MERCHANT_COUPONS.getDesc()));
                orderPayDiscount.setMerchantDiscountPrice(new BigDecimal(paidInfo.getMerchantDiscountPrice()));
                orderPayDiscount.setMerchantCouponsInfo(JsonUtils.toString(merchantCouponsInfo));
            }
            if (NumberUtils.parseDouble(paidInfo.getThirdDiscountPrice()) > 0) {
                OrderPayDiscount.ThirdCouponsInfo thirdCouponsInfo = OrderPayDiscount.getThirdCouponsInfo(orderDiscounts,
                        NumberUtils.parseDecimal(paidInfo.getThirdDiscountPrice()));
                orderPayDiscount.addDiscountSource(Integer.valueOf(OrderPayDiscount.DiscountSourceEnum.THIRD_COUPONS.getDesc()));
                orderPayDiscount.setThirdDiscountPrice(new BigDecimal(paidInfo.getThirdDiscountPrice()));
                orderPayDiscount.setThirdCouponsInfo(JsonUtils.toString(thirdCouponsInfo));
            }
        }
        if (NumberUtils.parseDouble(paidInfo.getVipDiscountPrice()) > 0) {
            List<Integer> vipTypeId = paidInfo.getVipTypeId();
            if (vipTypeId != null && vipTypeId.size() > 0) {
                OrderPayDiscount.VipCouponsInfo vipCouponsInfo = new OrderPayDiscount.VipCouponsInfo();
                for (Integer typeId : vipTypeId) {
                    VipTypeDto vipTypeDto = vipTypeDao.selectById(typeId);
                    if (vipTypeDto == null) {
                        continue;
                    }
                    vipCouponsInfo.addTypeId(typeId);
                    vipCouponsInfo.addDiscountType(vipTypeDto.getType());
                }
                orderPayDiscount.addDiscountSource(Integer.valueOf(OrderPayDiscount.DiscountSourceEnum.VIP_COUPONS.getDesc()));
                vipCouponsInfo.setDiscountPrice(NumberUtils.parseDecimal(paidInfo.getVipDiscountPrice()));
                orderPayDiscount.setVipDiscountPrice(new BigDecimal(paidInfo.getVipDiscountPrice()));
                orderPayDiscount.setVipCouponsInfo(JsonUtils.toString(vipCouponsInfo));
            }
        }
        if (Integer.valueOf(9).equals(exceptionReason) && NumberUtils.parseDouble(paidInfo.getTollDiscountPrice()) > 0) {
            OrderPayDiscount.TollCouponsInfo tollCouponsInfo = new OrderPayDiscount.TollCouponsInfo();
            tollCouponsInfo.setDiscountPrice(new BigDecimal(paidInfo.getTollDiscountPrice()));
            tollCouponsInfo.setExitOperaAccount(exitRequest.getOperAccount());
            tollCouponsInfo.setExitTerminal(exitRequest.getExTerminal());

            orderPayDiscount.addDiscountSource(Integer.valueOf(OrderPayDiscount.DiscountSourceEnum.TOLL_COUPONS.getDesc()));
            orderPayDiscount.setTollDiscountPrice(new BigDecimal(paidInfo.getTollDiscountPrice()));
            orderPayDiscount.setTollCouponsInfo(JsonUtils.toString(tollCouponsInfo));
        }
        if (orderPayDiscount.getTradeNo() != null) {
            log.info("记录支付明细优惠记录, {}", orderPayDiscount);
            orderPayDiscountService.addOrderPayDiscount(orderPayDiscount);
        }
    }

    private OrderPayDetail buildOrderPayDetail(OrderPay orderPay, QueryFeeRegionDetail regionDetail) {
        return new OrderPayDetail()
                .setParkId(orderPay.getParkId())
                .setRegionId(regionDetail.getRegionId())
                .setOrderSonId(regionDetail.getOrderSonId())
                .setOrderNum(orderPay.getOrderNum())
                .setPlateType(regionDetail.getPlateType())
                .setTradeNo(orderPay.getTradeNo())
                .setPayStatus(orderPay.getPayStatus())
                .setRefundStatus(-1)
                .setPayWay(orderPay.getPayWay())
                .setEnterTime(regionDetail.getEnterTime())
                .setExitTime(regionDetail.getExitTime())
                .setPlateNum(regionDetail.getPlateNum())
                .setPayTime(orderPay.getPayTime())
                .setTotalPrice(NumberUtils.parseDouble(regionDetail.getTotalAmount()))
                .setPaidPrice(NumberUtils.toDouble(regionDetail.getPaidPrice()))
                .setDiscountPrice(NumberUtils.parseDouble(regionDetail.getDiscountPrice()));
    }

    private OrderDiscount buildOrderDiscount(String tradeNo, OrderInfo orderInfo, ExitCommonRequest.DiscountInfo discountInfo) {
        if (DiscountTypeEnum.按天优免.getType().equals(discountInfo.getDiscountType())) {
            OrderDiscount orderDiscount = orderDiscountService.getOne(orderDiscountService.getLambdaQueryWrapper()
                    .eq(OrderDiscount::getParkId, orderInfo.getParkId())
                    .eq(OrderDiscount::getDiscountNo, discountInfo.getDiscountNo())
                    .eq(OrderDiscount::getDelFlag,0)
                    .orderByAsc(OrderDiscount::getId).last(SqlConstant.LIMIT_ONE));
            if (orderDiscount != null) {
                if (!orderInfo.getOrderNum().equals(orderDiscount.getOrderNum())) {
                    orderDiscount.setId(null);
                    orderDiscount.setOrderNum(orderInfo.getOrderNum());
                    orderDiscount.setTradeNo(tradeNo);
                    orderDiscount.setAmount(discountInfo.getDiscountNumber());
                    orderDiscount.setStatus(1);
                    orderDiscount.setGetAmount(Double.valueOf(discountInfo.getDiscountNumber()));
                    log.debug("优惠时间[{}]ms", discountInfo.getDiscountTime() * 1000L);
                    orderDiscount.setUseTime(new Date());
                    orderDiscount.setCarStatus(2);
                    orderDiscount.setDeductMoney(null);
                    orderDiscount.setReduceBalance(null);
                    orderDiscount.setUpdateTime(null);
                    return orderDiscount;
                } else {
                    log.debug("按天优惠平台已处理, 无需处理本地优惠编号[{}]", discountInfo.getDiscountNo());
                    return null;
                }
            }
        }
        // 添加优惠记录
        OrderDiscount orderDiscount = new OrderDiscount();
        orderDiscount.setParkId(orderInfo.getParkId());
        orderDiscount.setOrderNum(orderInfo.getOrderNum());
        orderDiscount.setPlateNum(orderInfo.getPlateNum());
        orderDiscount.setTradeNo(tradeNo);
        //本地优惠
        orderDiscount.setFrom(0);
        orderDiscount.setDiscountNo(discountInfo.getDiscountNo());
        orderDiscount.setType(discountInfo.getDiscountType());
        orderDiscount.setAmount(discountInfo.getDiscountNumber());
        orderDiscount.setStatus(1);
        orderDiscount.setDeductMoney(Double.valueOf(discountInfo.getDiscountNumber()));
        orderDiscount.setGetAmount(Double.valueOf(discountInfo.getDiscountNumber()));
        orderDiscount.setSendTime(new Date(discountInfo.getDiscountTime() * 1000));
        orderDiscount.setUseTime(new Date());
        return orderDiscount;
    }

    private static class AmountInfo {
        BigDecimal totalPrice = BigDecimal.ZERO;
        BigDecimal paidPrice = BigDecimal.ZERO;
        BigDecimal discountPrice = BigDecimal.ZERO;
        BigDecimal balancePrice = BigDecimal.ZERO;
    }
}
