package com.icetech.park.service.order.impl;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.icetech.basics.dao.park.ParkRegionDao;
import com.icetech.basics.domain.entity.park.ParkInoutdevice;
import com.icetech.basics.domain.entity.park.ParkRegion;
import com.icetech.cloudcenter.api.order.ComplateOrderService;
import com.icetech.cloudcenter.api.order.OrderService;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.cloudcenter.domain.constants.RedisConstants;
import com.icetech.cloudcenter.domain.enumeration.PncVersionEnum;
import com.icetech.cloudcenter.domain.request.ComplateOrderRequest;
import com.icetech.cloudcenter.domain.request.ExitCommonRequest;
import com.icetech.common.constants.CodeConstants;
import com.icetech.common.constants.OrderStatusConstants;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.utils.CodeTools;
import com.icetech.common.utils.NumberUtils;
import com.icetech.common.utils.StringUtils;
import com.icetech.order.dao.OrderCarInfoDao;
import com.icetech.order.dao.OrderInfoDao;
import com.icetech.order.dao.OrderSonCarInfoDao;
import com.icetech.order.dao.OrderSonInfoDao;
import com.icetech.order.domain.entity.OrderCarInfo;
import com.icetech.order.domain.entity.OrderInfo;
import com.icetech.order.domain.entity.OrderSonCarInfo;
import com.icetech.order.domain.entity.OrderSonInfo;
import com.icetech.order.domain.entity.OrderTrack;
import com.icetech.order.service.impl.OrderTrackServiceImpl;
import com.icetech.park.domain.entity.park.Park;
import com.icetech.third.utils.RedisUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

/**
 * @author wzwzc
 */
@Slf4j
@Service("complateOrderService")
public class ComplateOrderServiceImpl implements ComplateOrderService {
    @Autowired
    private OrderInfoDao orderInfoDao;
    @Resource
    private OrderService orderService;
    @Autowired
    private ParkService parkService;
    @Autowired
    private OrderCarInfoDao orderCarInfoDao;
    @Autowired
    private ExitPayDealServiceImpl exitPayDealServiceImpl;
    @Autowired
    private ParkRegionDao parkRegionDao;
    @Autowired
    private OrderSonInfoDao orderSonInfoDao;
    @Resource
    private OrderSonCarInfoDao orderSonCarInfoDao;
    @Autowired
    private OrderTrackServiceImpl orderTrackService;
    @Autowired
    private RedisUtils redisUtils;

    @Override
    public ObjectResponse complateOrder(ComplateOrderRequest complateOrderRequest) {
        ParkInoutdevice[] channels = new ParkInoutdevice[2];
        if (StringUtils.isBlank(complateOrderRequest.getOutChannelId())) {
            return ObjectResponse.failed(CodeConstants.ERROR_400, "无出口通道编号");
        }
        ObjectResponse<ParkInoutdevice> parkChannelResp = parkService.getInoutDeviceByCode(complateOrderRequest.getOutChannelId());
        if ((!ObjectResponse.isSuccess(parkChannelResp)) || parkChannelResp.getData() == null) {
            log.warn("[完整订单上报服务] 出口通道编号无效|{}|{}", complateOrderRequest.getOutChannelId(), complateOrderRequest.getOrderId());
            return ObjectResponse.failed(CodeConstants.ERROR_402, "出口通道编号无效");
        }
        channels[1] = parkChannelResp.getData();
        if (StringUtils.isNotBlank(complateOrderRequest.getInChannelId())) {
            parkChannelResp = parkService.getInoutDeviceByCode(complateOrderRequest.getInChannelId());
            if ((!ObjectResponse.isSuccess(parkChannelResp)) || parkChannelResp.getData() == null) {
                log.warn("[完整订单上报服务] 入口通道编号无效|{}|{}", complateOrderRequest.getInChannelId(), complateOrderRequest.getOrderId());
                return ObjectResponse.failed(CodeConstants.ERROR_402, "入口通道编号无效");
            }
        }
        channels[0] = parkChannelResp.getData();
        // 以离场通道确定区域
        ParkRegion parkRegion = NumberUtils.toPrimitive(channels[1].getRegionId()) > 0 ? parkRegionDao.selectById(channels[1].getRegionId()) : null;
        if (parkRegion == null) {
            return saveMasterOrder(complateOrderRequest, channels, parkRegion);
        } else if (NumberUtils.toPrimitive(parkRegion.getFatherRelationId()) == 0) {
            return saveMasterOrder(complateOrderRequest, channels, parkRegion);
        } else {
            return saveSonOrder(complateOrderRequest, channels, parkRegion);
        }
    }

    /**
     * 保存子订单
     *
     * @param complateOrderRequest
     * @param channels
     * @param parkRegion
     * @return
     */
    private ObjectResponse saveSonOrder(ComplateOrderRequest complateOrderRequest, ParkInoutdevice[] channels, ParkRegion parkRegion) {
        //是否异常离场
        boolean isExceptionExit = complateOrderRequest.getIsExceptionExit() != null && complateOrderRequest.getIsExceptionExit() == 1;
        Long parkId = complateOrderRequest.getParkId();
        String orderId = complateOrderRequest.getOrderId();
        String orderNum = CodeTools.GenerateOrderNum();
        OrderSonInfo orderInfoSearch = new OrderSonInfo();
        orderInfoSearch.setLocalOrderNum(orderId);
        orderInfoSearch.setParkId(parkId);
        orderInfoSearch.setRegionId(parkRegion.getId());
        OrderSonInfo orderSonInfo = orderSonInfoDao.selectOneByEntity(orderInfoSearch);
        boolean hasEnter = orderSonInfo != null;

        OrderInfo orderInfo = new OrderInfo();
        orderInfo.setParkId(parkId);
        orderInfo.setLocalOrderNum(orderId);
        OrderInfo mainOrder = orderInfoDao.selectLimitOneOrderByEnterDesc(orderInfo);

        if (hasEnter) {
            orderSonInfo.setType(complateOrderRequest.getType());
            orderSonInfo.setCarType(complateOrderRequest.getCarType());
            orderSonInfo.setServiceStatus(isExceptionExit ? OrderStatusConstants.EXCEPTION : OrderStatusConstants.LEAVED_PARK);
            orderSonInfo.setOperAccount(complateOrderRequest.getUserAccount());
            orderSonInfo.setTotalPrice(complateOrderRequest.getTotalAmount());
            orderSonInfo.setDiscountPrice(complateOrderRequest.getDiscountAmount());
            orderSonInfo.setPaidPrice(complateOrderRequest.getPaidAmount());
            //异常原因
            orderSonInfo.setOddStatus(complateOrderRequest.getExceptionReason());
            orderSonInfo.setExitTime(complateOrderRequest.getExitTime());
            if (complateOrderRequest.getBalancePrice() != null) {
                orderSonInfo.setBalancePrice(BigDecimal.valueOf(complateOrderRequest.getBalancePrice()));
            }
            orderSonInfoDao.updateById(orderSonInfo);
        } else {
            orderSonInfo = new OrderSonInfo();
            BeanUtils.copyProperties(complateOrderRequest, orderSonInfo);
            orderSonInfo.setLocalOrderNum(orderId);
            orderSonInfo.setOrderNum(orderNum);
            orderSonInfo.setServiceStatus(isExceptionExit ? OrderStatusConstants.EXCEPTION : OrderStatusConstants.LEAVED_PARK);
            orderSonInfo.setOperAccount(complateOrderRequest.getUserAccount());
            orderSonInfo.setTotalPrice(complateOrderRequest.getTotalAmount());
            orderSonInfo.setDiscountPrice(complateOrderRequest.getDiscountAmount());
            orderSonInfo.setPaidPrice(complateOrderRequest.getPaidAmount());
            // 异常原因
            orderSonInfo.setOddStatus(complateOrderRequest.getExceptionReason());
            orderSonInfo.setRegionId(parkRegion.getId());
            if (StringUtils.isBlank(complateOrderRequest.getInChannelId()) && complateOrderRequest.getEnterTime().equals(complateOrderRequest.getExitTime())) {
                orderSonInfo.setNoneEnterFlag(1);
            }
            // 上报子订单需要查询是否存在主订单
            if (mainOrder != null) {
                if (mainOrder.getRegionId() == null) {
                    mainOrder.setRegionId(parkRegion.getId());
                }
                mainOrder.setHasSon(1);
                orderInfoDao.updateByOrderNum(mainOrder);
                log.info("[完整订单记录上报服务--子订单] 更新主订单表完成，orderNum：{}", orderNum);
                // 判断主订单是否复制至子订单
                copyMainOrderToSon(mainOrder, null);
                // 重置子订单号为主订单号
                orderSonInfo.setOrderNum(mainOrder.getOrderNum());
            }
            if (complateOrderRequest.getBalancePrice() != null) {
                orderSonInfo.setBalancePrice(BigDecimal.valueOf(complateOrderRequest.getBalancePrice()));
            }
            orderSonInfoDao.insertWithPlateNum2(orderSonInfo);
            log.info("[完整订单记录上报服务--子订单] 插入订单信息表完成，orderNum：{}", orderNum);
        }

        OrderSonCarInfo sonCarInfo = orderSonCarInfoDao.selectByOrderSonId(orderSonInfo.getId());
        if (sonCarInfo == null) {
            sonCarInfo = new OrderSonCarInfo();
        }
        BeanUtils.copyProperties(complateOrderRequest, sonCarInfo, "id");
        if (NumberUtils.toPrimitive(orderSonInfo.getNoneEnterFlag()) == 0) {
            sonCarInfo.setEnterNo(channels[0].getInandoutName());
            sonCarInfo.setEnterChannelId(StringUtils.isBlank(complateOrderRequest.getInChannelId()) ? channels[0].getInandoutCode() : complateOrderRequest.getInChannelId());
            sonCarInfo.setEnterImage(complateOrderRequest.getEnterImage());
            sonCarInfo.setSmallEnterImage(complateOrderRequest.getEnterSmallImage());
            sonCarInfo.setEnterReliability(complateOrderRequest.getEnterReliability());
        }
        sonCarInfo.setOrderSonId(orderSonInfo.getId());
        sonCarInfo.setOrderNum(orderNum);
        sonCarInfo.setExitNo(channels[1].getInandoutName());
        sonCarInfo.setExitChannelId(complateOrderRequest.getOutChannelId());
        sonCarInfo.setExitImage(complateOrderRequest.getExitImage());
        sonCarInfo.setSmallExitImage(complateOrderRequest.getExitSmallImage());
        sonCarInfo.setExitReliability(complateOrderRequest.getExitReliability());
        if (sonCarInfo.getId() == null) {
            orderSonCarInfoDao.insert(sonCarInfo);
            log.info("[离场服务] 插入订单出入表入场部分完成，orderNum：{}", orderNum);
        } else {
            orderSonCarInfoDao.updateById(sonCarInfo);
            log.info("[离场服务] 插入订单出入表离场部分完成，orderNum：{}", orderNum);
        }

        if (mainOrder == null) {    // 预补充主订单信息
            mainOrder = new OrderInfo();
            BeanUtils.copyProperties(orderSonInfo, mainOrder);
            mainOrder.setId(null)
                    .setServiceStatus(OrderStatusConstants.IN_PARK)
                    .setExitTime(null)
                    .setOddStatus(null)
                    .setNoneEnterFlag(1)
                    .setHasSon(1)
                    .setCreateTime(null);
            ParkRegion parentRegion = parkRegionDao.selectById(parkRegion.getFatherRelationId());
            mainOrder.setRegionId(parentRegion.getId());
            orderInfoDao.insertWithPlateNum2(mainOrder);
            OrderCarInfo mainCarInfo = new OrderCarInfo();
            BeanUtils.copyProperties(sonCarInfo, mainCarInfo);
            mainCarInfo.setId(null)
                    .setExitChannelId(null)
                    .setEnterWay(null)
                    .setEnterNo(null)
                    .setEnterChannelId(null)
                    .setEnterImage(null)
                    .setExitNo(null)
                    .setExitImage(null)
                    .setSmallExitImage(null)
                    .setExitReliability(null);
            orderCarInfoDao.insert(mainCarInfo);
            // 判断主订单是否复制至子订单
            copyMainOrderToSon(mainOrder, mainCarInfo);
        }

        if (!hasEnter) {
            // 补充订单轨迹
            String version = redisUtils.hGet(RedisConstants.PNC_VERSION, String.valueOf(parkId), String.class);
            if (version != null && PncVersionEnum.getIndex(version) < PncVersionEnum.版本7.getIndex()) {
                ObjectResponse<Park> parkResp = parkService.findByParkId(parkId);
                if (ObjectResponse.isSuccess(parkResp) && NumberUtils.toPrimitive(parkResp.getData().getIsInterior()) == 1
                        && NumberUtils.toPrimitive(parkResp.getData().getNestType()) != 0) {
                    orderTrackService.saveBatch(buildTrack(orderSonInfo, sonCarInfo));
                }
            }
        }

        Map<String, String> map = new HashMap<>();
        map.put("orderId", orderId);
        map.put("orderNum", orderNum);
        List<ExitCommonRequest.PaidInfo> paidInfo = complateOrderRequest.getPaidInfo();
        if (paidInfo != null) {
            exitPayDealServiceImpl.exitPayDeal(complateOrderRequest, orderSonInfo, null);
        }
        // 欠费订单处理
        exitPayDealServiceImpl.handleNotPayOrder(complateOrderRequest,orderSonInfo, channels[1], null);
        return ObjectResponse.success(map);
    }

    private OrderSonInfo copyMainOrderToSon(OrderInfo mainOrder, OrderCarInfo orderCarInfo) {
        List<OrderSonInfo> existsSonInfos = orderSonInfoDao.selectList(Wrappers.lambdaQuery(OrderSonInfo.class)
                .eq(OrderSonInfo::getParkId, mainOrder.getParkId())
                .eq(OrderSonInfo::getOrderNum, mainOrder.getOrderNum())
                .eq(OrderSonInfo::getRegionId, mainOrder.getRegionId()));
        if (!existsSonInfos.isEmpty()) return existsSonInfos.get(0);

        OrderSonInfo sonInfo = new OrderSonInfo();
        BeanUtils.copyProperties(mainOrder, sonInfo);
        sonInfo.setId(null);
        sonInfo.setCreateTime(new Date());
        orderSonInfoDao.insertWithPlateNum2(sonInfo);

        if (orderCarInfo == null) {
            orderCarInfo = orderCarInfoDao.selectByOrderNum(mainOrder.getOrderNum());
        }
        if (orderCarInfo != null) {
            OrderSonCarInfo sonCarInfo = new OrderSonCarInfo();
            BeanUtils.copyProperties(orderCarInfo, sonCarInfo, "id");
            sonCarInfo.setOrderSonId(sonInfo.getId());
            orderSonCarInfoDao.insert(sonCarInfo);
        }

        return sonInfo;
    }

    private List<OrderTrack> buildTrack(OrderInfo orderInfo, OrderCarInfo orderCarInfo) {
        OrderTrack enterTrack = null;
        if (NumberUtils.toPrimitive(orderInfo.getNoneEnterFlag()) == 0) {
            enterTrack = new OrderTrack()
                    .setRecordType(1)
                    .setParkId(orderInfo.getParkId())
                    .setRegionId(orderInfo.getRegionId())
                    .setOrderNum(orderInfo.getOrderNum())
                    .setPlateNum(orderInfo.getPlateNum())
                    .setEnexTime(orderInfo.getEnterTime())
                    .setType(orderInfo.getType())
                    .setInoutEvent(0);
//                .setOperAccount("");
        }
        OrderTrack exitTrack = new OrderTrack()
                .setRecordType(2)
                .setParkId(orderInfo.getParkId())
                .setRegionId(orderInfo.getRegionId())
                .setOrderNum(orderInfo.getOrderNum())
                .setPlateNum(orderInfo.getPlateNum())
                .setEnexTime(orderInfo.getEnterTime())
                .setType(orderInfo.getType())
                .setInoutEvent(0);
//                .setOperAccount("");
        if (orderCarInfo != null) {
            if (enterTrack != null) {
                enterTrack.setImage(orderCarInfo.getEnterImage())
                        .setChannelName(orderCarInfo.getEnterNo());
            }
            exitTrack.setImage(orderCarInfo.getExitImage())
                    .setChannelName(orderCarInfo.getExitNo());
        }
        return enterTrack == null ? Collections.singletonList(exitTrack) : Arrays.asList(enterTrack, exitTrack);
    }

    /**
     * 保存主订单
     *
     * @param complateOrderRequest
     * @param channels
     * @param parkRegion
     * @return
     */
    private ObjectResponse saveMasterOrder(ComplateOrderRequest complateOrderRequest, ParkInoutdevice[] channels, ParkRegion parkRegion) {
        // 是否异常离场
        boolean isExceptionExit = complateOrderRequest.getIsExceptionExit() != null && complateOrderRequest.getIsExceptionExit() == 1;
        Long parkId = complateOrderRequest.getParkId();
        String orderId = complateOrderRequest.getOrderId();
        OrderInfo orderInfoSearch = new OrderInfo();
        orderInfoSearch.setLocalOrderNum(orderId);
        orderInfoSearch.setParkId(parkId);
        OrderInfo orderInfoResult = orderInfoDao.selectLimitOneOrderByEnterDesc(orderInfoSearch);
        boolean hasOrder = orderInfoResult != null;
        List<OrderSonInfo> orderSonInfos = orderSonInfoDao.selectList(Wrappers.lambdaQuery(OrderSonInfo.class)
                .eq(OrderSonInfo::getParkId, parkId)
                .eq(OrderSonInfo::getLocalOrderNum, orderId)
                .in(OrderSonInfo::getServiceStatus, OrderStatusConstants.IN_PARK, OrderStatusConstants.LEAVED_PARK, OrderStatusConstants.EXCEPTION));
        if (hasOrder) {
            orderInfoResult.setType(complateOrderRequest.getType());
            orderInfoResult.setCarType(complateOrderRequest.getCarType());
            orderInfoResult.setServiceStatus(isExceptionExit ? OrderStatusConstants.EXCEPTION : OrderStatusConstants.LEAVED_PARK);
            orderInfoResult.setOperAccount(complateOrderRequest.getUserAccount());
            orderInfoResult.setTotalPrice(complateOrderRequest.getTotalAmount());
            orderInfoResult.setDiscountPrice(complateOrderRequest.getDiscountAmount());
            orderInfoResult.setPaidPrice(complateOrderRequest.getPaidAmount());
            //异常原因
            orderInfoResult.setOddStatus(complateOrderRequest.getExceptionReason());
            orderInfoResult.setExitTime(complateOrderRequest.getExitTime());
            if (parkRegion != null) {
                orderInfoResult.setRegionId(parkRegion.getId());
            }
            if (complateOrderRequest.getBalancePrice() != null) {
                orderInfoResult.setBalancePrice(BigDecimal.valueOf(complateOrderRequest.getBalancePrice()));
            }
            if (StringUtils.isBlank(complateOrderRequest.getInChannelId()) && complateOrderRequest.getEnterTime().equals(complateOrderRequest.getExitTime())) {
                orderInfoResult.setNoneEnterFlag(1);
            } else {
                orderInfoResult.setNoneEnterFlag(0);
            }
        } else {
            OrderInfo orderInfo = new OrderInfo();
            BeanUtils.copyProperties(complateOrderRequest, orderInfo);
            orderInfo.setLocalOrderNum(orderId);
            orderInfo.setOrderNum(CodeTools.GenerateOrderNum());
            orderInfo.setServiceStatus(isExceptionExit ? OrderStatusConstants.EXCEPTION : OrderStatusConstants.LEAVED_PARK);
            orderInfo.setOperAccount(complateOrderRequest.getUserAccount());
            orderInfo.setTotalPrice(complateOrderRequest.getTotalAmount());
            orderInfo.setDiscountPrice(complateOrderRequest.getDiscountAmount());
            orderInfo.setPaidPrice(complateOrderRequest.getPaidAmount());
            //异常原因
            orderInfo.setOddStatus(complateOrderRequest.getExceptionReason());
            if (StringUtils.isBlank(complateOrderRequest.getInChannelId()) && complateOrderRequest.getEnterTime().equals(complateOrderRequest.getExitTime())) {
                orderInfo.setNoneEnterFlag(1);
            }
            if (Objects.equals(orderInfo.getEnterTime(), orderInfo.getExitTime())) {
                orderInfo.setNoneEnterFlag(1);
            }
            if (parkRegion != null) {
                orderInfo.setRegionId(parkRegion.getId());
//                orderInfo.setHasSon(1);
            }
            if (complateOrderRequest.getBalancePrice() != null) {
                orderInfo.setBalancePrice(BigDecimal.valueOf(complateOrderRequest.getBalancePrice()));
            }
            orderInfoResult = orderInfo;
        }
        OrderCarInfo orderCarInfo = orderCarInfoDao.selectByOrderNum(orderInfoResult.getOrderNum());
        if (orderCarInfo == null) {
            orderCarInfo = new OrderCarInfo();
        }
        BeanUtils.copyProperties(complateOrderRequest, orderCarInfo, "id");
        orderCarInfo.setOrderNum(orderInfoResult.getOrderNum());
        // 填充离场信息
        orderCarInfo.setExitNo(channels[1].getInandoutName());
        orderCarInfo.setExitChannelId(complateOrderRequest.getOutChannelId());
        orderCarInfo.setExitImage(complateOrderRequest.getExitImage());
        orderCarInfo.setSmallExitImage(complateOrderRequest.getExitSmallImage());
        orderCarInfo.setEnterReliability(complateOrderRequest.getEnterReliability());
        orderCarInfo.setExitReliability(complateOrderRequest.getExitReliability());
        orderCarInfo.setExitOperAccount(complateOrderRequest.getOperAccount());
        if (org.apache.commons.lang3.StringUtils.isNotEmpty(complateOrderRequest.getPlateColor())) {
            orderCarInfo.setPlateColor(complateOrderRequest.getPlateColor());
        }
        if (NumberUtils.toPrimitive(orderInfoResult.getNoneEnterFlag()) == 0) {
            // 更新入场信息
            orderCarInfo.setEnterNo(channels[0].getInandoutName());
            orderCarInfo.setEnterChannelId(StringUtils.isBlank(complateOrderRequest.getInChannelId()) ? channels[0].getInandoutCode() : complateOrderRequest.getInChannelId());
            orderCarInfo.setEnterImage(complateOrderRequest.getEnterImage());
            orderCarInfo.setSmallEnterImage(complateOrderRequest.getEnterSmallImage());

            orderInfoResult.setEnterChannelId(orderCarInfo.getEnterChannelId());
        }
        handleOrderSon(orderInfoResult, orderCarInfo, orderSonInfos);
        if (orderInfoResult.getId() == null) {
            try {
                orderService.addOrderInfo(orderInfoResult);
            } catch (DuplicateKeyException e) {
                orderInfoResult.setOrderNum(CodeTools.GenerateOrderNum());
                orderService.addOrderInfo(orderInfoResult);
            }
            log.info("[完整订单记录上报服务] 插入订单信息表完成，orderNum：{}", orderInfoResult.getOrderNum());
        } else {
            orderService.updateOrderWithPush(orderInfoResult);
        }
        if (orderCarInfo.getId() == null) {
            orderCarInfoDao.insert(orderCarInfo);
            log.info("[离场服务] 插入订单出入表入场部分完成，orderNum：{}", orderInfoResult.getOrderNum());
        } else {
            orderCarInfoDao.updateById(orderCarInfo);
            log.info("[离场服务] 插入订单出入表离场部分完成，orderNum：{}", orderInfoResult.getOrderNum());
        }

        // 补充订单轨迹
        String version = redisUtils.hGet(RedisConstants.PNC_VERSION,
                String.valueOf(parkId), String.class);
        if (version != null && PncVersionEnum.getIndex(version) < PncVersionEnum.版本7.getIndex()) {
            ObjectResponse<Park> parkResp = parkService.findByParkId(parkId);
            if (ObjectResponse.isSuccess(parkResp) && NumberUtils.toPrimitive(parkResp.getData().getIsInterior()) == 1
                    && NumberUtils.toPrimitive(parkResp.getData().getNestType()) != 0) {
                OrderTrack trackParam = new OrderTrack()
                        .setType(2).setParkId(parkId).setOrderNum(orderInfoResult.getOrderNum()).setRegionId(orderInfoResult.getRegionId());
                int count = orderTrackService.count(orderTrackService.getLambdaQueryWrapper(trackParam));
                if (!hasOrder || count == 0) {
                    orderTrackService.saveBatch(buildTrack(orderInfoResult, orderCarInfo));
                }
            }
        }

        Map<String, String> map = new HashMap<>();
        map.put("orderId", orderId);
        map.put("orderNum", orderInfoResult.getOrderNum());
        List<ExitCommonRequest.PaidInfo> paidInfo = complateOrderRequest.getPaidInfo();
        if (paidInfo != null) {
            exitPayDealServiceImpl.exitPayDeal(complateOrderRequest, orderInfoResult, orderSonInfos);
        }
        // 欠费订单处理
        exitPayDealServiceImpl.handleNotPayOrder(complateOrderRequest, orderInfoResult, channels[1], null);
        return ObjectResponse.success(map);
    }

    private OrderInfo handleOrderSon(OrderInfo mainOrder, OrderCarInfo mainOrderCarInfo, List<OrderSonInfo> orderSonInfos) {
        if (CollectionUtils.isEmpty(orderSonInfos)) return mainOrder;
        BigDecimal totalAmount = BigDecimal.ZERO, paidAmount = BigDecimal.ZERO, discountAmount = BigDecimal.ZERO, balancePrice = BigDecimal.ZERO;
        for (OrderSonInfo orderSonInfo : orderSonInfos) {
            if (orderSonInfo.getRegionId().equals(mainOrder.getRegionId())) { // 主订单所属子订单
                BeanUtils.copyProperties(mainOrder, orderSonInfo, "id");
                OrderSonCarInfo orderSonCarInfo = orderSonCarInfoDao.selectByOrderSonId(orderSonInfo.getId());
                BeanUtils.copyProperties(mainOrderCarInfo, orderSonCarInfo, "id");
                orderSonInfoDao.updateById(orderSonInfo);
                orderSonCarInfoDao.updateById(orderSonCarInfo);
            }
            totalAmount = NumberUtils.decimalAdd(totalAmount, orderSonInfo.getTotalPrice());
            paidAmount = NumberUtils.decimalAdd(paidAmount, orderSonInfo.getPaidPrice());
            discountAmount = NumberUtils.decimalAdd(discountAmount, orderSonInfo.getDiscountPrice());
            balancePrice = NumberUtils.decimalAdd(balancePrice, orderSonInfo.getBalancePrice());
        }
        mainOrder.setHasSon(1)
                .setTotalPrice(totalAmount.toString()).setPaidPrice(paidAmount.toString()).setDiscountPrice(discountAmount.toString()).setBalancePrice(balancePrice);
        return mainOrder;
    }
}
