package com.icetech.park.service.ops;

import com.alibaba.csp.sentinel.annotation.SentinelResource;
import com.icetech.third.anno.DS_SLAVE;
import com.icetech.cloudcenter.api.ops.OpsService;
import com.icetech.park.dao.ops.OpsUserDao;
import com.icetech.user.domain.entity.ops.OpsUser;
import com.icetech.basics.sentinel.ExceptionUtils;
import com.icetech.common.constants.CodeConstants;
import com.icetech.common.domain.response.ObjectResponse;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * 运维操作
 * @author fangct
 */
@Slf4j
@Service
public class OpsServiceImpl implements OpsService {

    @Autowired
    private OpsUserDao opsUserDao;

    @Override
    @DS_SLAVE
    @SentinelResource(value = "OpsService.getPermissionUserByParkId", defaultFallback = "defaultFallbackHandle", fallbackClass = {ExceptionUtils.class})
    public ObjectResponse<OpsUser> getPermissionUserByParkId(Long parkId) {
        OpsUser opsUser = opsUserDao.selectPermissionUserByParkId(parkId);
        if (opsUser != null){
            return ObjectResponse.success(opsUser);
        }else{
            return ObjectResponse.failed(CodeConstants.ERROR_404);
        }

    }
}
