package com.icetech.park.service.more.impl;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.icetech.db.mybatis.base.service.impl.BaseServiceImpl;
import com.icetech.park.dao.more.MoreMonthPlateMapper;
import com.icetech.park.domain.entity.more.MoreMonthPlate;
import com.icetech.park.service.more.MoreMonthParkService;
import com.icetech.park.service.more.MoreMonthPlateService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 多车场月卡关联车牌号表 服务实现类
 * <p>
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wanggang
 * @version 1.0 @date 2024-05-07
 */
@Service
public class MoreMonthPlateServiceImpl extends BaseServiceImpl<MoreMonthPlateMapper, MoreMonthPlate> implements MoreMonthPlateService {

    @Autowired
    private MoreMonthParkService moreMonthParkService;
    /**
     * Description: 根据ID查询 多车场月卡关联车牌号表对象信息 <br>
     * Version1.0 2024-05-07 by wanggang创建
     *
     * @param id 对象id
     * @return MoreMonthPlate
     */
    @Override
    public MoreMonthPlate getMoreMonthPlateById(Long id) {
        return getById(id);
    }

    /**
     * Description: 新增  多车场月卡关联车牌号表对象信息 <br>
     * Version1.0 2024-05-07 by wanggang创建
     *
     * @param entity 对象信息
     * @return Boolean 返回新增后主键
     */
    @Override
    public Boolean addMoreMonthPlate(MoreMonthPlate entity) {
        return save(entity);
    }

    /**
     * Description: 修改 多车场月卡关联车牌号表对象信息 <br>
     * Version1.0 2024-05-07 by wanggang创建
     *
     * @param entity 对象信息
     * @return Boolean 返回更新后的结果
     */
    @Override
    public Boolean modifyMoreMonthPlate(MoreMonthPlate entity) {
        return updateById(entity);
    }

    /**
     * Description: 删除  多车场月卡关联车牌号表对象信息 <br>
     * Version1.0 2024-05-07 by wanggang创建
     *
     * @param id 对象id
     * @return Boolean 返回更新后的结果
     */
    @Override
    public Boolean removeMoreMonthPlateById(Long id) {
        return removeById(id);
    }

    @Override
    public List<MoreMonthPlate> getMoreMonthPlateByMoreMonthId(Long moreMonthId) {
        return list(Wrappers.lambdaQuery(MoreMonthPlate.builder().monthId(moreMonthId).build()));
    }
}
