package com.icetech.park.service.more.impl;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.icetech.park.dao.more.MoreMonthParkMapper;
import com.icetech.park.domain.entity.more.MoreMonthPark;
import com.icetech.db.mybatis.base.service.impl.BaseServiceImpl;
import com.icetech.park.service.more.MoreMonthParkService;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 多车场月卡关联车场表 服务实现类
 * <p>
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wanggang
 * @version 1.0 @date 2024-05-07
 */
@Service
public class MoreMonthParkServiceImpl extends BaseServiceImpl<MoreMonthParkMapper, MoreMonthPark> implements MoreMonthParkService {

    /**
     * Description: 根据ID查询 多车场月卡关联车场表对象信息 <br>
     * Version1.0 2024-05-07 by wanggang创建
     *
     * @param id 对象id
     * @return MoreMonthPark
     */
    @Override
    public MoreMonthPark getMoreMonthParkById(Long id) {
        return getById(id);
    }

    /**
     * Description: 新增  多车场月卡关联车场表对象信息 <br>
     * Version1.0 2024-05-07 by wanggang创建
     *
     * @param entity 对象信息
     * @return Boolean 返回新增后主键
     */
    @Override
    public Boolean addMoreMonthPark(MoreMonthPark entity) {
        return save(entity);
    }

    /**
     * Description: 修改 多车场月卡关联车场表对象信息 <br>
     * Version1.0 2024-05-07 by wanggang创建
     *
     * @param entity 对象信息
     * @return Boolean 返回更新后的结果
     */
    @Override
    public Boolean modifyMoreMonthPark(MoreMonthPark entity) {
        return updateById(entity);
    }

    /**
     * Description: 删除  多车场月卡关联车场表对象信息 <br>
     * Version1.0 2024-05-07 by wanggang创建
     *
     * @param id 对象id
     * @return Boolean 返回更新后的结果
     */
    @Override
    public Boolean removeMoreMonthParkById(Long id) {
        return removeById(id);
    }

    @Override
    public List<MoreMonthPark> getMonthParkByMoreMonthId(Long moreMonthId) {
        return list(Wrappers.lambdaQuery(MoreMonthPark.builder().monthId(moreMonthId).build()));
    }

}
