package com.icetech.park.service.more.impl;

import com.icetech.db.mybatis.base.service.impl.BaseServiceImpl;
import com.icetech.park.dao.more.MoreMonthInfoMapper;
import com.icetech.park.domain.entity.more.MoreMonthInfo;
import com.icetech.park.service.more.MoreMonthInfoService;
import org.springframework.stereotype.Service;

/**
 * 多车场月卡信息表 服务实现类
 * <p>
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wanggang
 * @version 1.0 @date 2024-05-07
 */
@Service
public class MoreMonthInfoServiceImpl extends BaseServiceImpl<MoreMonthInfoMapper, MoreMonthInfo> implements MoreMonthInfoService {

    /**
     * Description: 根据ID查询 多车场月卡信息表对象信息 <br>
     * Version1.0 2024-05-07 by wanggang创建
     *
     * @param id 对象id
     * @return MoreMonthInfo
     */
    @Override
    public MoreMonthInfo getMoreMonthInfoById(Long id) {
        return getById(id);
    }

    /**
     * Description: 新增  多车场月卡信息表对象信息 <br>
     * Version1.0 2024-05-07 by wanggang创建
     *
     * @param entity 对象信息
     * @return Boolean 返回新增后主键
     */
    @Override
    public Boolean addMoreMonthInfo(MoreMonthInfo entity) {
        return save(entity);
    }

    /**
     * Description: 修改 多车场月卡信息表对象信息 <br>
     * Version1.0 2024-05-07 by wanggang创建
     *
     * @param entity 对象信息
     * @return Boolean 返回更新后的结果
     */
    @Override
    public Boolean modifyMoreMonthInfo(MoreMonthInfo entity) {
        return updateById(entity);
    }

    /**
     * Description: 删除  多车场月卡信息表对象信息 <br>
     * Version1.0 2024-05-07 by wanggang创建
     *
     * @param id 对象id
     * @return Boolean 返回更新后的结果
     */
    @Override
    public Boolean removeMoreMonthInfoById(Long id) {
        return removeById(id);
    }

    @Override
    public MoreMonthInfo findById(Long id) {
        return selectLimitOne(MoreMonthInfo.builder().id(id).deleteStatus(0).build());
    }

}
