package com.icetech.park.service.more;

import com.icetech.db.mybatis.base.service.IBaseService;
import com.icetech.park.domain.entity.more.MoreMonthPark;
import com.icetech.park.domain.entity.more.MoreMonthPlate;

import java.util.List;

/**
 * 多车场月卡关联车牌号表 服务类
 * <p>
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wanggang
 * @version 1.0 @date 2024-05-07
 */
public interface MoreMonthPlateService extends IBaseService<MoreMonthPlate> {

    /**
     * Description: 根据ID查询 多车场月卡关联车牌号表对象信息 <br>
     * Version1.0 2024-05-07 by wanggang创建
     *
     * @param id 对象id
     * @return MoreMonthPlate
     */
    MoreMonthPlate getMoreMonthPlateById(Long id);

    /**
     * Description: 新增  多车场月卡关联车牌号表对象信息 <br>
     * Version1.0 2024-05-07 by wanggang创建
     *
     * @param entity 对象信息
     * @return Boolean 返回新增后主键
     */
    Boolean addMoreMonthPlate(MoreMonthPlate entity);

    /**
     * Description: 修改 多车场月卡关联车牌号表对象信息 <br>
     * Version1.0 2024-05-07 by wanggang创建
     *
     * @param entity 对象信息
     * @return Boolean 返回更新后的结果
     */
    Boolean modifyMoreMonthPlate(MoreMonthPlate entity);

    /**
     * Description: 删除  多车场月卡关联车牌号表对象信息 <br>
     * Version1.0 2024-05-07 by wanggang创建
     *
     * @param id 对象id
     * @return Boolean 返回更新后的结果
     */
    Boolean removeMoreMonthPlateById(Long id);

    /**
     * 获取多车场月卡关联车牌号
     *
     * @param moreMonthId
     * @return
     */
    List<MoreMonthPlate> getMoreMonthPlateByMoreMonthId(Long moreMonthId);


}
