package com.icetech.park.service.more;

import com.icetech.db.mybatis.base.service.IBaseService;
import com.icetech.park.domain.entity.more.MoreMonthInfo;

/**
 * 多车场月卡信息表 服务类
 * <p>
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wanggang
 * @version 1.0 @date 2024-05-07
 */
public interface MoreMonthInfoService extends IBaseService<MoreMonthInfo> {

    /**
     * Description: 根据ID查询 多车场月卡信息表对象信息 <br>
     * Version1.0 2024-05-07 by wanggang创建
     *
     * @param id 对象id
     * @return MoreMonthInfo
     */
    MoreMonthInfo getMoreMonthInfoById(Long id);

    /**
     * Description: 新增  多车场月卡信息表对象信息 <br>
     * Version1.0 2024-05-07 by wanggang创建
     *
     * @param entity 对象信息
     * @return Boolean 返回新增后主键
     */
    Boolean addMoreMonthInfo(MoreMonthInfo entity);

    /**
     * Description: 修改 多车场月卡信息表对象信息 <br>
     * Version1.0 2024-05-07 by wanggang创建
     *
     * @param entity 对象信息
     * @return Boolean 返回更新后的结果
     */
    Boolean modifyMoreMonthInfo(MoreMonthInfo entity);

    /**
     * Description: 删除  多车场月卡信息表对象信息 <br>
     * Version1.0 2024-05-07 by wanggang创建
     *
     * @param id 对象id
     * @return Boolean 返回更新后的结果
     */
    Boolean removeMoreMonthInfoById(Long id);

    /**
     * 通过id获取
     *
     * @param id
     * @return
     */
    MoreMonthInfo findById(Long id);
}
