package com.icetech.park.service.monthcar.impl;

import cn.hutool.core.date.DatePattern;
import cn.hutool.core.date.DateUtil;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import com.icetech.cloudcenter.domain.pay.MonthOpenCardDto;
import com.icetech.cloudcenter.domain.pay.MonthRenewCardDto;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.utils.HttpTools;
import com.icetech.common.utils.JsonUtils;
import com.icetech.common.utils.SignTools;
import com.icetech.open.domain.ApiBaseRequest;
import com.icetech.partner.domain.response.PHPResponse;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.Map;

@Service
@Slf4j
public class PhpOpenCarServiceImpl {

    @Value(value = "${third.php.pid}")
    private String pid;
    @Value(value = "${third.php.key}")
    private String key;
    @Value(value = "${third.php.url}")
    private String url;

    private static String serviceName = "openMonthCard";

    public ObjectResponse<Object> openAndCheckMonthCard(MonthOpenCardDto dto,Boolean isCheck){
        Map<String,Object> requestMap = Maps.newLinkedHashMap();
        if (isCheck){
            requestMap.put("monthCheck",1);
        }
        requestMap.put("parkCode",dto.getParkCode());
        requestMap.put("orderId",dto.getOrderId());
        requestMap.put("productId",dto.getProductId());
        requestMap.put("buyNum",dto.getBuyNum());
        requestMap.put("phone",dto.getPhone());
        requestMap.put("cardProperty",dto.getCardProperty());
        requestMap.put("cardOwner",dto.getCardOwner());
        requestMap.put("startDate", DateUtil.format(dto.getStartDate(), DatePattern.NORM_DATE_FORMAT));
        //获取开卡结束时间

        requestMap.put("endDate",getEndDate(dto));
        requestMap.put("mainAddress",dto.getMainAddress());
        requestMap.put("payMoney",dto.getPayMoney().setScale(2, BigDecimal.ROUND_HALF_DOWN).toString());
        requestMap.put("payMethod",dto.getPayMethod());
        requestMap.put("payChannel",dto.getPayChannel());
        requestMap.put("plateNumData",dto.getPlateNumData());
        requestMap.put("picData", dto.getPicData());
        //php公众号开卡必须有公众号三个字
        requestMap.put("operator", StringUtils.isEmpty(dto.getUserName())?"公众号":"公众号"+dto.getUserName());
        ApiBaseRequest apiBaseRequest = new ApiBaseRequest();
        apiBaseRequest.setPid(pid);
        apiBaseRequest.setServiceName(serviceName);
        apiBaseRequest.setTimestamp(DateUtil.currentSeconds());
        apiBaseRequest.setBizContent(requestMap);
        try {
            apiBaseRequest.setSign(SignTools.sign(apiBaseRequest,key));
        } catch (Exception e) {
            e.printStackTrace();
        }
        String req = JsonUtils.toString(apiBaseRequest);
        String resultString = HttpTools.postJson(url+"/month/monthAdd",req );
        log.info("[php开卡接口] uir {} request {} response {}", url+"/month/monthAdd", req,resultString);
        PHPResponse resultMap = JSON.parseObject(resultString, PHPResponse.class);
        return ObjectResponse.instance(String.valueOf(resultMap.getCode()), resultMap.getMsg(), resultMap.getData());
    }

    /**
     * 续费
     * @param dto
     * @param isCheck
     * @return
     */
    public ObjectResponse<Object> renewAndCheckMonthCard(MonthRenewCardDto dto, Boolean isCheck){
        Map<String,Object> requestMap = Maps.newLinkedHashMap();
        if (isCheck){
            requestMap.put("monthCheck",1);
        }
        requestMap.put("parkCode",dto.getParkCode());
        requestMap.put("productId",dto.getProductId());
        requestMap.put("cardId",dto.getMonthId());
        requestMap.put("plotCount",dto.getPlotCount());
        requestMap.put("startDate", DateUtil.format(dto.getStartDate(), DatePattern.NORM_DATE_FORMAT));
        requestMap.put("endDate",DateUtil.format(dto.getEndDate(),DatePattern.NORM_DATE_FORMAT));
        requestMap.put("payMoney",dto.getPayMoney().setScale(2, BigDecimal.ROUND_HALF_DOWN).toString());
        requestMap.put("payMethod",dto.getPayMethod());
        requestMap.put("buyNum",dto.getBuyNum());
        requestMap.put("remark",dto.getRemark());
        requestMap.put("operator", "公众号");
        ApiBaseRequest apiBaseRequest = new ApiBaseRequest();
        apiBaseRequest.setPid(pid);
        apiBaseRequest.setServiceName(serviceName);
        apiBaseRequest.setTimestamp(DateUtil.currentSeconds());
        apiBaseRequest.setBizContent(requestMap);
        try {
            apiBaseRequest.setSign(SignTools.sign(apiBaseRequest,key));
        } catch (Exception e) {
            e.printStackTrace();
        }
        String req = JsonUtils.toString(apiBaseRequest);
        String resultString = HttpTools.postJson(url+"/month/monthRenew",req );
        log.info("[php续费接口] uir {} request {} response {}", url+"/month/monthRenew", req,resultString);
        PHPResponse resultMap = JSON.parseObject(resultString, PHPResponse.class);
        return ObjectResponse.instance(String.valueOf(resultMap.getCode()), resultMap.getMsg(), resultMap.getData());
    }

    private String getEndDate(MonthOpenCardDto dto){
        try {
            Map<String,Object> requestMap = Maps.newLinkedHashMap();
            requestMap.put("startTime", DateUtil.format(dto.getStartDate(), DatePattern.NORM_DATE_FORMAT));
            requestMap.put("addDay",dto.getDiftDays());
            requestMap.put("buyNum",dto.getBuyNum());
            requestMap.put("duration", dto.getDuration());
            ApiBaseRequest apiBaseRequest = new ApiBaseRequest();
            apiBaseRequest.setPid(pid);
            apiBaseRequest.setServiceName(serviceName);
            apiBaseRequest.setTimestamp(DateUtil.currentSeconds());
            apiBaseRequest.setBizContent(requestMap);
            apiBaseRequest.setSign(SignTools.sign(apiBaseRequest,key));
            String req = JsonUtils.toString(apiBaseRequest);
            String resultString = HttpTools.postJson(url+"/publicfun/getCardTime",req );
            log.info("[php获取日期接口] uir {} request {} response {}", url+"/publicfun/getCardTime", req,resultString);
            PHPResponse resultMap = JSON.parseObject(resultString, PHPResponse.class);
            if (resultMap.getCode() == 200){
                JSONObject res = JSONObject.parseObject(JSONUtil.toJsonStr(resultMap.getData()));
                return res.getString("date");
            }

        }catch (Exception e){
            log.error("[php获取日期接口失败]",e);
            return DateUtil.formatDate(dto.getEndDate());
        }

        return DateUtil.formatDate(dto.getEndDate());
    }
}
